/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.symbols.pointers;

import java.lang.ref.SoftReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiElementPointer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u0010\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00060\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/SoftSmartPsiElementPointer;", "T", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/com/intellij/psi/SmartPsiElementPointer;", "element", "containingFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiFile;)V", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "elementRef", "Ljava/lang/ref/SoftReference;", "kotlin.jvm.PlatformType", "containingFileRef", "getElement", "()Lcom/intellij/psi/PsiElement;", "getContainingFile", "getVirtualFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "getProject", "getPsiRange", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/Segment;", "getRange", "analysis-api"})
final class SoftSmartPsiElementPointer<T extends PsiElement>
implements SmartPsiElementPointer<T> {
    @NotNull
    private final Project project;
    @NotNull
    private final SoftReference<T> elementRef;
    @NotNull
    private final SoftReference<PsiFile> containingFileRef;

    public SoftSmartPsiElementPointer(@NotNull T element, @NotNull PsiFile containingFile) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Project project = containingFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.elementRef = new SoftReference<T>(element);
        this.containingFileRef = new SoftReference<PsiFile>(containingFile);
    }

    @Nullable
    public T getElement() {
        return (T)((PsiElement)this.elementRef.get());
    }

    @Nullable
    public PsiFile getContainingFile() {
        return this.containingFileRef.get();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        PsiFile psiFile = this.getContainingFile();
        return psiFile != null ? psiFile.getVirtualFile() : null;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Nullable
    public Segment getPsiRange() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Nullable
    public Segment getRange() {
        throw new UnsupportedOperationException("Not supported");
    }
}

