/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.KaSignatureSubstitutor;
import org.jetbrains.kotlin.analysis.api.signatures.KaCallableSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KaFunctionLikeSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KaVariableLikeSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaVariableLikeSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaSubstitutor;
import org.jetbrains.kotlin.analysis.utils.errors.UnexpectedElementErrorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u0002H\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ-\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\f\"\b\b\u0000\u0010\u0006*\u00020\r2\u0006\u0010\b\u001a\u0002H\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0010\"\b\b\u0000\u0010\u0006*\u00020\u00112\u0006\u0010\b\u001a\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/components/KaAbstractSignatureSubstitutor;", "Lorg/jetbrains/kotlin/analysis/api/components/KaSignatureSubstitutor;", "<init>", "()V", "substitute", "Lorg/jetbrains/kotlin/analysis/api/signatures/KaFunctionLikeSignature;", "S", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionLikeSymbol;", "symbol", "substitutor", "Lorg/jetbrains/kotlin/analysis/api/types/KaSubstitutor;", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionLikeSymbol;Lorg/jetbrains/kotlin/analysis/api/types/KaSubstitutor;)Lorg/jetbrains/kotlin/analysis/api/signatures/KaFunctionLikeSignature;", "Lorg/jetbrains/kotlin/analysis/api/signatures/KaVariableLikeSignature;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaVariableLikeSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KaVariableLikeSymbol;Lorg/jetbrains/kotlin/analysis/api/types/KaSubstitutor;)Lorg/jetbrains/kotlin/analysis/api/signatures/KaVariableLikeSignature;", "asSignature", "Lorg/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;)Lorg/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature;", "analysis-api-impl-base"})
public abstract class KaAbstractSignatureSubstitutor
extends KaSignatureSubstitutor {
    @Override
    @NotNull
    public <S extends KaFunctionLikeSymbol> KaFunctionLikeSignature<S> substitute(@NotNull S symbol, @NotNull KaSubstitutor substitutor) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        if (substitutor instanceof KaSubstitutor.Empty) {
            return ((KaSignatureSubstitutor)this).asSignature(symbol);
        }
        return ((KaSignatureSubstitutor)this).asSignature(symbol).substitute(substitutor);
    }

    @Override
    @NotNull
    public <S extends KaVariableLikeSymbol> KaVariableLikeSignature<S> substitute(@NotNull S symbol, @NotNull KaSubstitutor substitutor) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        if (substitutor instanceof KaSubstitutor.Empty) {
            return ((KaSignatureSubstitutor)this).asSignature(symbol);
        }
        return ((KaSignatureSubstitutor)this).asSignature(symbol).substitute(substitutor);
    }

    @Override
    @NotNull
    public <S extends KaCallableSymbol> KaCallableSignature<S> asSignature(@NotNull S symbol) {
        KaCallableSignature kaCallableSignature;
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        S s = symbol;
        if (s instanceof KaFunctionLikeSymbol) {
            kaCallableSignature = ((KaSignatureSubstitutor)this).asSignature((KaFunctionLikeSymbol)symbol);
        } else if (s instanceof KaVariableLikeSymbol) {
            kaCallableSignature = ((KaSignatureSubstitutor)this).asSignature((KaVariableLikeSymbol)symbol);
        } else {
            UnexpectedElementErrorKt.unexpectedElementError("symbol", symbol);
            throw null;
        }
        return kaCallableSignature;
    }
}

