/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KaSymbolInfoProvider;
import org.jetbrains.kotlin.analysis.api.fir.FirUtilsKt;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirNamedClassOrObjectSymbolBase;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirPackageSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirPsiJavaClassSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirSyntheticJavaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaReceiverParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.SimpleDeprecationInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\f\u0010\u001b\u001a\u00020\u0010*\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0018\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!2\u0006\u0010\u0011\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirSymbolInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KaSymbolInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getDeprecation", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "mayHaveDeprecation", "", "Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KaFirPsiJavaClassSymbol;", "annotationUseSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "getGetterDeprecation", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol;", "getSetterDeprecation", "toDeprecationInfo", "Lorg/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;", "getJavaGetterName", "Lorg/jetbrains/kotlin/name/Name;", "getJavaSetterName", "getAnnotationApplicableTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassOrObjectSymbol;", "getJvmName", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isSetter", "getJvmNameAsString", "", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirSymbolInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirSymbolInfoProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirSymbolInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 checks.kt\norg/jetbrains/kotlin/analysis/utils/errors/ChecksKt\n*L\n1#1,162:1\n1#2:163\n1#2:168\n1#2:171\n1#2:174\n1755#3,3:164\n16#4:167\n17#4:169\n16#4:170\n17#4:172\n16#4:173\n17#4:175\n*S KotlinDebug\n*F\n+ 1 KtFirSymbolInfoProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirSymbolInfoProvider\n*L\n112#1:168\n124#1:171\n132#1:174\n67#1:164,3\n112#1:167\n112#1:169\n124#1:170\n124#1:172\n132#1:173\n132#1:175\n*E\n"})
public final class KaFirSymbolInfoProvider
extends KaSymbolInfoProvider
implements KaFirSessionComponent {
    @NotNull
    private final KaFirSession analysisSession;
    @NotNull
    private final KaLifetimeToken token;
    @NotNull
    private final ApiVersion apiVersion;

    public KaFirSymbolInfoProvider(@NotNull KaFirSession analysisSession, @NotNull KaLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
        this.apiVersion = FirLanguageSettingsComponentKt.getLanguageVersionSettings((FirSession)this.getAnalysisSession().getUseSiteSession$analysis_api_fir()).getApiVersion();
    }

    @Override
    @NotNull
    public KaFirSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KaLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public DeprecationInfo getDeprecation(@NotNull KaSymbol symbol) {
        FirDeprecationInfo firDeprecationInfo;
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (symbol instanceof KaFirPackageSymbol || symbol instanceof KaReceiverParameterSymbol) {
            return null;
        }
        if (!(symbol instanceof KaFirSymbol)) {
            boolean $i$a$-require-KaFirSymbolInfoProvider$getDeprecation$22 = false;
            String $i$a$-require-KaFirSymbolInfoProvider$getDeprecation$22 = String.valueOf(Reflection.getOrCreateKotlinClass(this.getClass()));
            throw new IllegalArgumentException($i$a$-require-KaFirSymbolInfoProvider$getDeprecation$22.toString());
        }
        if (symbol instanceof KaFirPsiJavaClassSymbol && !this.mayHaveDeprecation((KaFirPsiJavaClassSymbol)symbol)) {
            return null;
        }
        Object firSymbol = ((KaFirSymbol)symbol).getFirSymbol();
        if (firSymbol instanceof FirPropertySymbol) {
            annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY};
            firDeprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(firSymbol, (FirSession)this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), (AnnotationUseSiteTarget[])annotationUseSiteTargetArray);
        } else if (firSymbol instanceof FirBackingFieldSymbol) {
            annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.FIELD};
            firDeprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(firSymbol, (FirSession)this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), (AnnotationUseSiteTarget[])annotationUseSiteTargetArray);
        } else {
            firDeprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(firSymbol, (FirSession)this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), (AnnotationUseSiteTarget[])new AnnotationUseSiteTarget[0]);
        }
        FirDeprecationInfo firDeprecationInfo2 = firDeprecationInfo;
        return firDeprecationInfo2 != null ? this.toDeprecationInfo(firDeprecationInfo2) : null;
    }

    private final boolean mayHaveDeprecation(KaFirPsiJavaClassSymbol $this$mayHaveDeprecation) {
        boolean bl;
        block4: {
            if (!$this$mayHaveDeprecation.getHasAnnotations()) {
                return false;
            }
            Set deprecationAnnotationSimpleNames = FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport((FirSession)$this$mayHaveDeprecation.getAnalysisSession().getUseSiteSession$analysis_api_fir()).getDeprecationAnnotationsSimpleNames();
            Iterable $this$any$iv = $this$mayHaveDeprecation.getAnnotationSimpleNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(it != null && deprecationAnnotationSimpleNames.contains(it))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public DeprecationInfo getDeprecation(@NotNull KaSymbol symbol, @Nullable AnnotationUseSiteTarget annotationUseSiteTarget) {
        FirDeprecationInfo firDeprecationInfo;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!(symbol instanceof KaFirSymbol)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (annotationUseSiteTarget != null) {
            AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{annotationUseSiteTarget};
            firDeprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(((KaFirSymbol)symbol).getFirSymbol(), (FirSession)this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), (AnnotationUseSiteTarget[])annotationUseSiteTargetArray);
        } else {
            firDeprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(((KaFirSymbol)symbol).getFirSymbol(), (FirSession)this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), (AnnotationUseSiteTarget[])new AnnotationUseSiteTarget[0]);
        }
        FirDeprecationInfo firDeprecationInfo2 = firDeprecationInfo;
        return firDeprecationInfo2 != null ? this.toDeprecationInfo(firDeprecationInfo2) : null;
    }

    @Override
    @Nullable
    public DeprecationInfo getGetterDeprecation(@NotNull KaPropertySymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!(symbol instanceof KaFirSymbol)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_GETTER, AnnotationUseSiteTarget.PROPERTY};
        FirDeprecationInfo firDeprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(((KaFirSymbol)((Object)symbol)).getFirSymbol(), (FirSession)this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), (AnnotationUseSiteTarget[])annotationUseSiteTargetArray);
        return firDeprecationInfo != null ? this.toDeprecationInfo(firDeprecationInfo) : null;
    }

    @Override
    @Nullable
    public DeprecationInfo getSetterDeprecation(@NotNull KaPropertySymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!(symbol instanceof KaFirSymbol)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_SETTER, AnnotationUseSiteTarget.PROPERTY};
        FirDeprecationInfo firDeprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(((KaFirSymbol)((Object)symbol)).getFirSymbol(), (FirSession)this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), (AnnotationUseSiteTarget[])annotationUseSiteTargetArray);
        return firDeprecationInfo != null ? this.toDeprecationInfo(firDeprecationInfo) : null;
    }

    private final DeprecationInfo toDeprecationInfo(FirDeprecationInfo $this$toDeprecationInfo) {
        return (DeprecationInfo)new SimpleDeprecationInfo($this$toDeprecationInfo.getDeprecationLevel(), $this$toDeprecationInfo.getPropagatesToOverrides(), null);
    }

    @Override
    @NotNull
    public Name getJavaGetterName(@NotNull KaPropertySymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!(symbol instanceof KaFirSymbol)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (symbol instanceof KaFirSyntheticJavaPropertySymbol) {
            return ((KaFirSyntheticJavaPropertySymbol)symbol).getJavaGetterSymbol().getName();
        }
        FirDeclaration firProperty = ((KaFirSymbol)((Object)symbol)).getFirSymbol().getFir();
        boolean $i$f$requireIsInstance = false;
        if (!(firProperty instanceof FirProperty)) {
            boolean bl = false;
            String string = "Expected " + Reflection.getOrCreateKotlinClass(FirProperty.class) + " instead of " + Reflection.getOrCreateKotlinClass(firProperty.getClass()) + " for " + firProperty;
            throw new IllegalArgumentException(string.toString());
        }
        return this.getJvmName((FirProperty)firProperty, false);
    }

    @Override
    @Nullable
    public Name getJavaSetterName(@NotNull KaPropertySymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!(symbol instanceof KaFirSymbol)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (symbol instanceof KaFirSyntheticJavaPropertySymbol) {
            KaFunctionSymbol kaFunctionSymbol = ((KaFirSyntheticJavaPropertySymbol)symbol).getJavaSetterSymbol();
            return kaFunctionSymbol != null ? kaFunctionSymbol.getName() : null;
        }
        FirDeclaration firProperty = ((KaFirSymbol)((Object)symbol)).getFirSymbol().getFir();
        boolean $i$f$requireIsInstance = false;
        if (!(firProperty instanceof FirProperty)) {
            boolean bl = false;
            String string = "Expected " + Reflection.getOrCreateKotlinClass(FirProperty.class) + " instead of " + Reflection.getOrCreateKotlinClass(firProperty.getClass()) + " for " + firProperty;
            throw new IllegalArgumentException(string.toString());
        }
        if (((FirProperty)firProperty).isVal()) {
            return null;
        }
        return this.getJvmName((FirProperty)firProperty, true);
    }

    @Override
    @Nullable
    public Set<KotlinTarget> getAnnotationApplicableTargets(@NotNull KaClassOrObjectSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        boolean $i$f$requireIsInstance = false;
        if (!(symbol instanceof KaFirSymbol)) {
            boolean bl = false;
            String string = "Expected " + Reflection.getOrCreateKotlinClass(KaFirSymbol.class) + " instead of " + Reflection.getOrCreateKotlinClass(symbol.getClass()) + " for " + symbol;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(symbol instanceof KaFirNamedClassOrObjectSymbolBase)) {
            return null;
        }
        if (((FirRegularClassSymbol)((KaFirNamedClassOrObjectSymbolBase)symbol).getFirSymbol()).getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return null;
        }
        return FirAnnotationHelpersKt.getAllowedAnnotationTargets((FirClassLikeSymbol)((FirClassLikeSymbol)((KaFirNamedClassOrObjectSymbolBase)symbol).getFirSymbol()), (FirSession)this.getAnalysisSession().getUseSiteSession$analysis_api_fir());
    }

    private final Name getJvmName(FirProperty property, boolean isSetter) {
        FirBackingField firBackingField = property.getBackingField();
        boolean bl = firBackingField != null && (firBackingField = firBackingField.getSymbol()) != null ? FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)((FirBasedSymbol)firBackingField), (ClassId)JvmStandardClassIds.Annotations.INSTANCE.getJvmField(), (FirSession)this.getAnalysisSession().getUseSiteSession$analysis_api_fir()) : false;
        if (bl) {
            return property.getName();
        }
        Name name = Name.identifier((String)this.getJvmNameAsString(property, isSetter));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return name;
    }

    private final String getJvmNameAsString(FirProperty property, boolean isSetter) {
        String jvmNameFromAccessor;
        FirPropertyAccessor accessor;
        AnnotationUseSiteTarget useSiteTarget = isSetter ? AnnotationUseSiteTarget.PROPERTY_SETTER : AnnotationUseSiteTarget.PROPERTY_GETTER;
        String jvmNameFromProperty = FirUtilsKt.getJvmNameFromAnnotation((FirAnnotationContainer)property, this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), useSiteTarget);
        if (jvmNameFromProperty != null) {
            return jvmNameFromProperty;
        }
        FirPropertyAccessor firPropertyAccessor = accessor = isSetter ? property.getSetter() : property.getGetter();
        String string = jvmNameFromAccessor = firPropertyAccessor != null ? FirUtilsKt.getJvmNameFromAnnotation$default((FirAnnotationContainer)firPropertyAccessor, this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), null, 2, null) : null;
        if (jvmNameFromAccessor != null) {
            return jvmNameFromAccessor;
        }
        String string2 = property.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
        String identifier = string2;
        return isSetter ? JvmAbi.setterName((String)identifier) : JvmAbi.getterName((String)identifier);
    }
}

