/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KaImportOptimizer;
import org.jetbrains.kotlin.analysis.api.components.KaImportOptimizerResult;
import org.jetbrains.kotlin.analysis.api.fir.FirUtilsKt;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirImportOptimizer;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirImportOptimizerKt;
import org.jetbrains.kotlin.analysis.api.fir.components.TypeQualifier;
import org.jetbrains.kotlin.analysis.api.fir.references.KDocReferenceResolver;
import org.jetbrains.kotlin.analysis.api.fir.utils.KtSymbolUtilsKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaReceiverParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaNonErrorClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedError;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirImportOptimizer;", "Lorg/jetbrains/kotlin/analysis/api/components/KaImportOptimizer;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "firResolveSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;)V", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "getFirSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "analyseImports", "Lorg/jetbrains/kotlin/analysis/api/components/KaImportOptimizerResult;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getImportableName", "Lorg/jetbrains/kotlin/name/FqName;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "collectReferencedEntities", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirImportOptimizer$ReferencedEntitiesResult;", "ReferencedEntitiesResult", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirImportOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirImportOptimizer.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirImportOptimizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,586:1\n1#2:587\n381#3,7:588\n*S KotlinDebug\n*F\n+ 1 KtFirImportOptimizer.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirImportOptimizer\n*L\n94#1:588,7\n*E\n"})
public final class KaFirImportOptimizer
extends KaImportOptimizer {
    @NotNull
    private final KaFirSession analysisSession;
    @NotNull
    private final KaLifetimeToken token;
    @NotNull
    private final LLFirResolveSession firResolveSession;

    public KaFirImportOptimizer(@NotNull KaFirSession analysisSession, @NotNull KaLifetimeToken token, @NotNull LLFirResolveSession firResolveSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)firResolveSession, (String)"firResolveSession");
        this.analysisSession = analysisSession;
        this.token = token;
        this.firResolveSession = firResolveSession;
    }

    @Override
    @NotNull
    public KaLifetimeToken getToken() {
        return this.token;
    }

    private final FirSession getFirSession() {
        return this.firResolveSession.getUseSiteFirSession();
    }

    @Override
    @NotNull
    public KaImportOptimizerResult analyseImports(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List existingImports = file.getImportDirectives();
        if (existingImports.isEmpty()) {
            return new KaImportOptimizerResult(null, null, 3, null);
        }
        ReferencedEntitiesResult referencedEntitiesResult = this.collectReferencedEntities(file);
        Map<FqName, Set<Name>> usedDeclarations = referencedEntitiesResult.component1();
        Set<Name> unresolvedNames = referencedEntitiesResult.component2();
        return new KaImportOptimizerResult(usedDeclarations, unresolvedNames);
    }

    @Override
    @Nullable
    public FqName getImportableName(@NotNull KaSymbol symbol) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        KaSymbol kaSymbol = symbol;
        if (kaSymbol instanceof KaClassLikeSymbol) {
            ClassId classId = ((KaClassLikeSymbol)symbol).getClassId();
            object = classId != null ? classId.asSingleFqName() : null;
        } else {
            object = kaSymbol instanceof KaCallableSymbol ? org.jetbrains.kotlin.analysis.api.fir.utils.FirUtilsKt.computeImportableName(KtSymbolUtilsKt.getFirSymbol((KaCallableSymbol)symbol), this.getFirSession()) : null;
        }
        return object;
    }

    private final ReferencedEntitiesResult collectReferencedEntities(KtFile file) {
        FirFile firFile;
        FirFile $this$collectReferencedEntities_u24lambda_u240 = firFile = LowLevelFirApiFacadeKt.getOrBuildFirFile(file, this.firResolveSession);
        boolean bl = false;
        FirLazyDeclarationResolverKt.lazyResolveToPhaseRecursively((FirElementWithResolveState)((FirElementWithResolveState)$this$collectReferencedEntities_u24lambda_u240), (FirResolvePhase)FirResolvePhase.BODY_RESOLVE);
        FirFile firFile2 = firFile;
        Map usedImports = new LinkedHashMap();
        Set unresolvedNames = new LinkedHashSet();
        firFile2.accept(new FirVisitorVoid(unresolvedNames, usedImports, this){
            final /* synthetic */ Set<Name> $unresolvedNames;
            final /* synthetic */ Map<FqName, Set<Name>> $usedImports;
            final /* synthetic */ KaFirImportOptimizer this$0;
            {
                this.$unresolvedNames = $unresolvedNames;
                this.$usedImports = $usedImports;
                this.this$0 = $receiver;
            }

            public void visitElement(FirElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren((FirVisitorVoid)this);
            }

            public void visitFunctionCall(FirFunctionCall functionCall) {
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                this.processFunctionCall(functionCall);
                super.visitFunctionCall(functionCall);
            }

            public void visitImplicitInvokeCall(FirImplicitInvokeCall implicitInvokeCall) {
                Intrinsics.checkNotNullParameter((Object)implicitInvokeCall, (String)"implicitInvokeCall");
                this.processImplicitFunctionCall(implicitInvokeCall);
                super.visitImplicitInvokeCall(implicitInvokeCall);
            }

            public void visitComponentCall(FirComponentCall componentCall) {
                Intrinsics.checkNotNullParameter((Object)componentCall, (String)"componentCall");
                this.processFunctionCall((FirFunctionCall)componentCall);
                super.visitComponentCall(componentCall);
            }

            public void visitPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
                this.processPropertyAccessExpression(propertyAccessExpression);
                super.visitPropertyAccessExpression(propertyAccessExpression);
            }

            public void visitResolvedTypeRef(FirResolvedTypeRef resolvedTypeRef) {
                Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
                this.processTypeRef(resolvedTypeRef);
                FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
                if (firTypeRef != null) {
                    firTypeRef.accept((FirVisitorVoid)this);
                }
                super.visitTypeRef((FirTypeRef)resolvedTypeRef);
            }

            public void visitErrorTypeRef(FirErrorTypeRef errorTypeRef) {
                Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
                this.processTypeRef((FirResolvedTypeRef)errorTypeRef);
                this.processErrorTypeRef(errorTypeRef);
                FirTypeRef firTypeRef = errorTypeRef.getDelegatedTypeRef();
                if (firTypeRef != null) {
                    firTypeRef.accept((FirVisitorVoid)this);
                }
                super.visitErrorTypeRef(errorTypeRef);
            }

            public void visitCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess) {
                Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
                this.processCallableReferenceAccess(callableReferenceAccess);
                super.visitCallableReferenceAccess(callableReferenceAccess);
            }

            public void visitResolvedQualifier(FirResolvedQualifier resolvedQualifier) {
                Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
                this.processResolvedQualifier(resolvedQualifier);
                super.visitResolvedQualifier(resolvedQualifier);
            }

            public void visitErrorResolvedQualifier(FirErrorResolvedQualifier errorResolvedQualifier) {
                Intrinsics.checkNotNullParameter((Object)errorResolvedQualifier, (String)"errorResolvedQualifier");
                this.processResolvedQualifier((FirResolvedQualifier)errorResolvedQualifier);
                super.visitErrorResolvedQualifier(errorResolvedQualifier);
            }

            private final void processErrorNameReference(FirResolvable resolvable) {
                FirReference firReference = resolvable.getCalleeReference();
                FirErrorNamedReference firErrorNamedReference = firReference instanceof FirErrorNamedReference ? (FirErrorNamedReference)firReference : null;
                if (firErrorNamedReference == null) {
                    return;
                }
                FirErrorNamedReference nameReference = firErrorNamedReference;
                Name name = KtFirImportOptimizerKt.access$getUnresolvedName(nameReference);
                if (name == null) {
                    return;
                }
                Name name2 = name;
                ((Collection)this.$unresolvedNames).add(name2);
            }

            private final void processErrorTypeRef(FirErrorTypeRef typeRef) {
                ConeDiagnostic coneDiagnostic = typeRef.getDiagnostic();
                ConeUnresolvedError coneUnresolvedError = coneDiagnostic instanceof ConeUnresolvedError ? (ConeUnresolvedError)coneDiagnostic : null;
                if (coneUnresolvedError == null) {
                    return;
                }
                ConeUnresolvedError diagnostic = coneUnresolvedError;
                Name name = KtFirImportOptimizerKt.access$getUnresolvedName(diagnostic);
                if (name == null) {
                    return;
                }
                Name name2 = name;
                ((Collection)this.$unresolvedNames).add(name2);
            }

            private final void processFunctionCall(FirFunctionCall functionCall) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport((FirQualifiedAccessExpression)functionCall)) {
                    return;
                }
                this.processErrorNameReference((FirResolvable)functionCall);
                Name name = KtFirImportOptimizerKt.access$getFunctionReferenceName(functionCall);
                if (name == null) {
                    return;
                }
                Name referencesByName = name;
                this.saveCallable((FirQualifiedAccessExpression)functionCall, referencesByName);
            }

            private final void processImplicitFunctionCall(FirImplicitInvokeCall implicitInvokeCall) {
                this.processErrorNameReference((FirResolvable)implicitInvokeCall);
                this.saveCallable((FirQualifiedAccessExpression)implicitInvokeCall, OperatorNameConventions.INVOKE);
            }

            private final void processPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport((FirQualifiedAccessExpression)propertyAccessExpression)) {
                    return;
                }
                this.processErrorNameReference((FirResolvable)propertyAccessExpression);
                Name name = KtFirImportOptimizerKt.access$getPropertyReferenceName(propertyAccessExpression);
                if (name == null) {
                    return;
                }
                Name referencedByName = name;
                this.saveCallable((FirQualifiedAccessExpression)propertyAccessExpression, referencedByName);
            }

            private final void processTypeRef(FirResolvedTypeRef resolvedTypeRef) {
                TypeQualifier typeQualifier = TypeQualifier.Companion.createFor(resolvedTypeRef);
                if (typeQualifier == null) {
                    return;
                }
                TypeQualifier wholeQualifier = typeQualifier;
                this.processTypeQualifier(wholeQualifier);
            }

            private final void processCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport((FirQualifiedAccessExpression)callableReferenceAccess)) {
                    return;
                }
                this.processErrorNameReference((FirResolvable)callableReferenceAccess);
                Name name = KtFirImportOptimizerKt.access$getCallableReferenceName(callableReferenceAccess);
                if (name == null) {
                    return;
                }
                Name referencedByName = name;
                this.saveCallable((FirQualifiedAccessExpression)callableReferenceAccess, referencedByName);
            }

            private final void processResolvedQualifier(FirResolvedQualifier resolvedQualifier) {
                TypeQualifier typeQualifier = TypeQualifier.Companion.createFor(resolvedQualifier);
                if (typeQualifier == null) {
                    return;
                }
                TypeQualifier wholeQualifier = typeQualifier;
                this.processTypeQualifier(wholeQualifier);
            }

            private final void processTypeQualifier(TypeQualifier qualifier) {
                TypeQualifier mostOuterTypeQualifier = (TypeQualifier)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)qualifier, collectReferencedEntities.1::processTypeQualifier$lambda$0));
                if (mostOuterTypeQualifier.isQualified()) {
                    return;
                }
                this.saveType(mostOuterTypeQualifier);
            }

            private final void saveType(TypeQualifier qualifier) {
                FqName importableName = qualifier.getReferencedClassId().asSingleFqName();
                Name referencedByName = qualifier.getReferencedByName();
                KaFirImportOptimizer.access$collectReferencedEntities$saveReferencedItem(this.$usedImports, importableName, referencedByName);
            }

            private final void saveCallable(FirQualifiedAccessExpression qualifiedCall, Name referencedByName) {
                FqName fqName = this.importableNameForReferencedSymbol(qualifiedCall);
                if (fqName == null) {
                    return;
                }
                FqName importableName = fqName;
                KaFirImportOptimizer.access$collectReferencedEntities$saveReferencedItem(this.$usedImports, importableName, referencedByName);
            }

            private final FqName importableNameForReferencedSymbol(FirQualifiedAccessExpression qualifiedCall) {
                Object object = this.importableNameForImplicitlyDispatchedCallable(qualifiedCall);
                if (object == null) {
                    FirCallableSymbol firCallableSymbol = KtFirImportOptimizerKt.access$getReferencedCallableSymbol(qualifiedCall);
                    object = firCallableSymbol != null ? org.jetbrains.kotlin.analysis.api.fir.utils.FirUtilsKt.computeImportableName(firCallableSymbol, KaFirImportOptimizer.access$getFirSession(this.this$0)) : null;
                }
                return object;
            }

            private final FqName importableNameForImplicitlyDispatchedCallable(FirQualifiedAccessExpression $this$importableNameForImplicitlyDispatchedCallable) {
                FirExpression dispatchReceiver = $this$importableNameForImplicitlyDispatchedCallable.getDispatchReceiver();
                if (!(dispatchReceiver instanceof FirResolvedQualifier) || !FirUtilsKt.isImplicitDispatchReceiver((FirResolvedQualifier)dispatchReceiver)) {
                    return null;
                }
                ClassId classId = ((FirResolvedQualifier)dispatchReceiver).getClassId();
                if (classId == null) {
                    return null;
                }
                ClassId dispatcherClass = classId;
                FirCallableSymbol firCallableSymbol = KtFirImportOptimizerKt.access$getReferencedCallableSymbol($this$importableNameForImplicitlyDispatchedCallable);
                if (firCallableSymbol == null || (firCallableSymbol = firCallableSymbol.getName()) == null) {
                    return null;
                }
                FirCallableSymbol referencedSymbolName = firCallableSymbol;
                return new CallableId(dispatcherClass, (Name)referencedSymbolName).asSingleFqName();
            }

            private static final TypeQualifier processTypeQualifier$lambda$0(TypeQualifier it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getOuterTypeQualifier();
            }
        });
        file.accept((PsiElementVisitor)new KtTreeVisitorVoid(this, unresolvedNames, usedImports){
            final /* synthetic */ KaFirImportOptimizer this$0;
            final /* synthetic */ Set<Name> $unresolvedNames;
            final /* synthetic */ Map<FqName, Set<Name>> $usedImports;
            {
                this.this$0 = $receiver;
                this.$unresolvedNames = $unresolvedNames;
                this.$usedImports = $usedImports;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitElement(element);
                if (element instanceof KDocLink) {
                    this.visitKDocLink((KDocLink)element);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void visitKDocLink(KDocLink docLink) {
                void $this$forEach$iv;
                List list;
                PsiElement $this$getChildOfType$iv = (PsiElement)docLink;
                boolean $i$f$getChildOfType22 = false;
                KDocName kDocName = (KDocName)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KDocName.class);
                if (kDocName == null) {
                    return;
                }
                KDocName docName = kDocName;
                FqName qualifiedNameAsFqName = docName.getQualifiedNameAsFqName();
                Object $i$f$getChildOfType22 = KaFirImportOptimizer.access$getAnalysisSession$p(this.this$0);
                Object object = this.$unresolvedNames;
                KaFirSession $this$visitKDocLink_u24lambda_u241 = $i$f$getChildOfType22;
                boolean bl = false;
                Collection<KaSymbol> resolvedSymbols = KDocReferenceResolver.INSTANCE.resolveKdocFqName$analysis_api_fir($this$visitKDocLink_u24lambda_u241.getAnalysisSession(), qualifiedNameAsFqName, qualifiedNameAsFqName, (KtElement)docLink);
                if (resolvedSymbols.isEmpty()) {
                    ((Collection)object).add(qualifiedNameAsFqName.shortName());
                    list = CollectionsKt.emptyList();
                } else {
                    void $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv = resolvedSymbols;
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        KaSymbol it = (KaSymbol)element$iv$iv;
                        boolean bl2 = false;
                        Iterable list$iv$iv = this.toImportableFqNames(it, qualifiedNameAsFqName);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
                List importableNames = list;
                $i$f$getChildOfType22 = importableNames;
                object = this.$usedImports;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    FqName importableName = (FqName)element$iv;
                    boolean bl3 = false;
                    Name name = importableName.shortName();
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"shortName(...)");
                    KaFirImportOptimizer.access$collectReferencedEntities$saveReferencedItem((Map)object, importableName, name);
                }
            }

            private final List<FqName> toImportableFqNames(KaSymbol symbol, FqName qualifiedNameAsFqName) {
                List list;
                List $this$toImportableFqNames_u24lambda_u243 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                KaSymbol kaSymbol = symbol;
                if (kaSymbol instanceof KaCallableSymbol) {
                    FqName classFqName;
                    CallableId callableId = ((KaCallableSymbol)symbol).getCallableId();
                    if (callableId == null) {
                        return CollectionsKt.emptyList();
                    }
                    CallableId callableId2 = callableId;
                    FqName fqName = callableId2.asSingleFqName();
                    ClassId classId = callableId2.getClassId();
                    Object object = classFqName = classId != null ? classId.asSingleFqName() : null;
                    if (classFqName != null) {
                        if (!Intrinsics.areEqual((Object)classFqName, (Object)qualifiedNameAsFqName)) {
                            ((Collection)$this$toImportableFqNames_u24lambda_u243).add(classFqName);
                        }
                    } else if (!Intrinsics.areEqual((Object)fqName, (Object)qualifiedNameAsFqName)) {
                        FqName receiverFqName;
                        ((Collection)$this$toImportableFqNames_u24lambda_u243).add(fqName);
                        KaReceiverParameterSymbol kaReceiverParameterSymbol = ((KaCallableSymbol)symbol).getReceiverParameter();
                        KaType kaType = kaReceiverParameterSymbol != null ? kaReceiverParameterSymbol.getType() : null;
                        KaNonErrorClassType receiverClassType = kaType instanceof KaNonErrorClassType ? (KaNonErrorClassType)kaType : null;
                        KaNonErrorClassType kaNonErrorClassType = receiverClassType;
                        FqName fqName2 = kaNonErrorClassType != null && (kaNonErrorClassType = kaNonErrorClassType.getClassId()) != null ? kaNonErrorClassType.asSingleFqName() : (receiverFqName = null);
                        if (receiverFqName != null && qualifiedNameAsFqName.pathSegments().size() > 1) {
                            ((Collection)$this$toImportableFqNames_u24lambda_u243).add(receiverFqName);
                        }
                    }
                } else if (kaSymbol instanceof KaClassLikeSymbol) {
                    FqName fqName;
                    ClassId classId = ((KaClassLikeSymbol)symbol).getClassId();
                    Object object = fqName = classId != null ? classId.asSingleFqName() : null;
                    if (fqName != null && !Intrinsics.areEqual((Object)fqName, (Object)qualifiedNameAsFqName)) {
                        ((Collection)$this$toImportableFqNames_u24lambda_u243).add(fqName);
                    }
                }
                return CollectionsKt.build((List)list);
            }
        });
        return new ReferencedEntitiesResult(usedImports, unresolvedNames);
    }

    private static final void collectReferencedEntities$saveReferencedItem(Map<FqName, Set<Name>> usedImports, FqName importableName, Name referencedByName) {
        Set set;
        Map<FqName, Set<Name>> $this$getOrPut$iv = usedImports;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(importableName);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new HashSet();
            $this$getOrPut$iv.put(importableName, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        ((Collection)set).add(referencedByName);
    }

    public static final /* synthetic */ void access$collectReferencedEntities$saveReferencedItem(Map usedImports, FqName importableName, Name referencedByName) {
        KaFirImportOptimizer.collectReferencedEntities$saveReferencedItem(usedImports, importableName, referencedByName);
    }

    public static final /* synthetic */ FirSession access$getFirSession(KaFirImportOptimizer $this) {
        return $this.getFirSession();
    }

    public static final /* synthetic */ KaFirSession access$getAnalysisSession$p(KaFirImportOptimizer $this) {
        return $this.analysisSession;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J5\u0010\u0010\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirImportOptimizer$ReferencedEntitiesResult;", "", "usedImports", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "unresolvedNames", "<init>", "(Ljava/util/Map;Ljava/util/Set;)V", "getUsedImports", "()Ljava/util/Map;", "getUnresolvedNames", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "analysis-api-fir"})
    private static final class ReferencedEntitiesResult {
        @NotNull
        private final Map<FqName, Set<Name>> usedImports;
        @NotNull
        private final Set<Name> unresolvedNames;

        public ReferencedEntitiesResult(@NotNull Map<FqName, ? extends Set<Name>> usedImports, @NotNull Set<Name> unresolvedNames) {
            Intrinsics.checkNotNullParameter(usedImports, (String)"usedImports");
            Intrinsics.checkNotNullParameter(unresolvedNames, (String)"unresolvedNames");
            this.usedImports = usedImports;
            this.unresolvedNames = unresolvedNames;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getUsedImports() {
            return this.usedImports;
        }

        @NotNull
        public final Set<Name> getUnresolvedNames() {
            return this.unresolvedNames;
        }

        @NotNull
        public final Map<FqName, Set<Name>> component1() {
            return this.usedImports;
        }

        @NotNull
        public final Set<Name> component2() {
            return this.unresolvedNames;
        }

        @NotNull
        public final ReferencedEntitiesResult copy(@NotNull Map<FqName, ? extends Set<Name>> usedImports, @NotNull Set<Name> unresolvedNames) {
            Intrinsics.checkNotNullParameter(usedImports, (String)"usedImports");
            Intrinsics.checkNotNullParameter(unresolvedNames, (String)"unresolvedNames");
            return new ReferencedEntitiesResult(usedImports, unresolvedNames);
        }

        public static /* synthetic */ ReferencedEntitiesResult copy$default(ReferencedEntitiesResult referencedEntitiesResult, Map map, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                map = referencedEntitiesResult.usedImports;
            }
            if ((n & 2) != 0) {
                set = referencedEntitiesResult.unresolvedNames;
            }
            return referencedEntitiesResult.copy(map, set);
        }

        @NotNull
        public String toString() {
            return "ReferencedEntitiesResult(usedImports=" + this.usedImports + ", unresolvedNames=" + this.unresolvedNames + ')';
        }

        public int hashCode() {
            int result = ((Object)this.usedImports).hashCode();
            result = result * 31 + ((Object)this.unresolvedNames).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReferencedEntitiesResult)) {
                return false;
            }
            ReferencedEntitiesResult referencedEntitiesResult = (ReferencedEntitiesResult)other;
            if (!Intrinsics.areEqual(this.usedImports, referencedEntitiesResult.usedImports)) {
                return false;
            }
            return Intrinsics.areEqual(this.unresolvedNames, referencedEntitiesResult.unresolvedNames);
        }
    }
}

