/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLDanglingFileResolutionStrategyProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirResolveSessionService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLLibraryModuleResolutionStrategyProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLScriptModuleResolutionStrategyProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLSourceModuleResolutionStrategyProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.state.LLDiagnosticProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.state.LLEmptyDiagnosticProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.state.LLFirResolvableResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.state.LLModuleProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.state.LLModuleResolutionStrategyProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.state.LLSessionProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.state.LLSimpleResolutionStrategyProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.state.LLSourceDiagnosticProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.analysis.project.structure.KtDanglingFileModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirResolveSessionService;", "", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "getFirResolveSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;", "module", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getFirResolveSessionForBinaryModule", "getFirResolveSessionNoCaching", "create", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/state/LLFirResolvableResolveSession;", "factory", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "createResolutionStrategyProvider", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/state/LLModuleResolutionStrategyProvider;", "moduleProvider", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/state/LLModuleProvider;", "createDiagnosticProvider", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/state/LLDiagnosticProvider;", "sessionProvider", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/state/LLSessionProvider;", "Companion", "low-level-api-fir"})
public final class LLFirResolveSessionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LLFirSessionCache cache;

    public LLFirResolveSessionService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.cache = LLFirSessionCache.Companion.getInstance(project);
    }

    @NotNull
    public final LLFirResolveSession getFirResolveSession(@NotNull KtModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.create(module, (Function1<? super KtModule, ? extends LLFirSession>)((Function1)new Function1<KtModule, LLFirSession>((Object)this.cache){

            public final LLFirSession invoke(KtModule p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return LLFirSessionCache.getSession$default((LLFirSessionCache)this.receiver, p0, false, 2, null);
            }

            public final String getSignature() {
                return "getFirResolveSession$getSession(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;";
            }

            public final String getName() {
                return "getSession";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Intrinsics.Kotlin.class);
            }
        }));
    }

    @NotNull
    public final LLFirResolveSession getFirResolveSessionForBinaryModule(@NotNull KtModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.create(module, (Function1<? super KtModule, ? extends LLFirSession>)((Function1)new Function1<KtModule, LLFirSession>(this){
            final /* synthetic */ LLFirResolveSessionService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final LLFirSession invoke(KtModule it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LLFirResolveSessionService.access$getCache$p(this.this$0).getSession(it, true);
            }
        }));
    }

    @NotNull
    public final LLFirResolveSession getFirResolveSessionNoCaching(@NotNull KtModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.create(module, (Function1<? super KtModule, ? extends LLFirSession>)((Function1)new Function1<KtModule, LLFirSession>((Object)this.cache){

            public final LLFirSession invoke(KtModule p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LLFirSessionCache)this.receiver).getSessionNoCaching$low_level_api_fir(p0);
            }

            public final String getSignature() {
                return "getSessionNoCaching$low_level_api_fir(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;";
            }

            public final String getName() {
                return "getSessionNoCaching";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(LLFirSessionCache.class);
            }
        }));
    }

    private final LLFirResolvableResolveSession create(KtModule module, Function1<? super KtModule, ? extends LLFirSession> factory) {
        LLModuleProvider moduleProvider = new LLModuleProvider(module);
        LLSessionProvider sessionProvider = new LLSessionProvider(module, factory);
        LLModuleResolutionStrategyProvider resolutionStrategyProvider = this.createResolutionStrategyProvider(module, moduleProvider);
        LLDiagnosticProvider diagnosticProvider = this.createDiagnosticProvider(moduleProvider, sessionProvider);
        return new LLFirResolvableResolveSession(moduleProvider, resolutionStrategyProvider, sessionProvider, diagnosticProvider);
    }

    private final LLModuleResolutionStrategyProvider createResolutionStrategyProvider(KtModule module, LLModuleProvider moduleProvider) {
        LLModuleResolutionStrategyProvider lLModuleResolutionStrategyProvider;
        KtModule ktModule2 = module;
        if (ktModule2 instanceof KtSourceModule) {
            lLModuleResolutionStrategyProvider = LLSourceModuleResolutionStrategyProvider.INSTANCE;
        } else if (ktModule2 instanceof KtLibraryModule || ktModule2 instanceof KtLibrarySourceModule) {
            lLModuleResolutionStrategyProvider = new LLLibraryModuleResolutionStrategyProvider(module);
        } else if (ktModule2 instanceof KtScriptModule) {
            lLModuleResolutionStrategyProvider = new LLScriptModuleResolutionStrategyProvider(module);
        } else if (ktModule2 instanceof KtDanglingFileModule) {
            KtModule contextModule = ((KtDanglingFileModule)module).getContextModule();
            LLModuleResolutionStrategyProvider contextResolutionStrategyProvider = this.createResolutionStrategyProvider(contextModule, moduleProvider);
            lLModuleResolutionStrategyProvider = new LLDanglingFileResolutionStrategyProvider(contextResolutionStrategyProvider);
        } else if (ktModule2 instanceof KtNotUnderContentRootModule) {
            lLModuleResolutionStrategyProvider = new LLSimpleResolutionStrategyProvider(module);
        } else {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("Unexpected " + module.getClass(), null, null, null, null, (Function1)new Function1<ExceptionAttachmentBuilder, Unit>(module){
                final /* synthetic */ KtModule $module;
                {
                    this.$module = $module;
                    super(1);
                }

                public final void invoke(ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
                    Intrinsics.checkNotNullParameter((Object)$this$errorWithFirSpecificEntries, (String)"$this$errorWithFirSpecificEntries");
                    $this$errorWithFirSpecificEntries.withEntry("module", (Object)this.$module, (Function1)createResolutionStrategyProvider.1.INSTANCE);
                }
            }, 30, null);
            throw null;
        }
        return lLModuleResolutionStrategyProvider;
    }

    private final LLDiagnosticProvider createDiagnosticProvider(LLModuleProvider moduleProvider, LLSessionProvider sessionProvider) {
        KtModule ktModule2 = moduleProvider.getUseSiteModule();
        return ktModule2 instanceof KtSourceModule || ktModule2 instanceof KtScriptModule || ktModule2 instanceof KtDanglingFileModule ? (LLDiagnosticProvider)new LLSourceDiagnosticProvider(moduleProvider, sessionProvider) : (LLDiagnosticProvider)LLEmptyDiagnosticProvider.INSTANCE;
    }

    public static final /* synthetic */ LLFirSessionCache access$getCache$p(LLFirResolveSessionService $this) {
        return $this.cache;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirResolveSessionService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirResolveSessionService;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirResolveSessionService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LLFirResolveSessionService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LLFirResolveSessionService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

