/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtPsiTypeProviderMixIn;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.api.types.KtTypeMappingMode;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\r\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0002J8\u0010\u000f\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0005H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/PsiDeclarationAndKtSymbolEqualityChecker;", "", "<init>", "()V", "representsTheSameDeclaration", "", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "psi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiMethod;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;", "returnTypesMatch", "typeParametersMatch", "valueParametersMatch", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;", "isTheSameTypes", "context", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiType;", "ktType", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "mode", "Lorg/jetbrains/kotlin/analysis/api/types/KtTypeMappingMode;", "isVararg", "symbol-light-classes"})
@SourceDebugExtension(value={"SMAP\nPsiDeclarationAndKtSymbolEqualityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiDeclarationAndKtSymbolEqualityChecker.kt\norg/jetbrains/kotlin/analysis/providers/PsiDeclarationAndKtSymbolEqualityChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n23214#2,8:88\n1#3:96\n1862#4,3:97\n*S KotlinDebug\n*F\n+ 1 PsiDeclarationAndKtSymbolEqualityChecker.kt\norg/jetbrains/kotlin/analysis/providers/PsiDeclarationAndKtSymbolEqualityChecker\n*L\n43#1:88,8\n58#1:97,3\n*E\n"})
public final class PsiDeclarationAndKtSymbolEqualityChecker {
    @NotNull
    public static final PsiDeclarationAndKtSymbolEqualityChecker INSTANCE = new PsiDeclarationAndKtSymbolEqualityChecker();

    private PsiDeclarationAndKtSymbolEqualityChecker() {
    }

    public final boolean representsTheSameDeclaration(@NotNull KtAnalysisSession $this$representsTheSameDeclaration, @NotNull PsiMethod psi2, @NotNull KtCallableSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)$this$representsTheSameDeclaration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)psi2, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!this.returnTypesMatch($this$representsTheSameDeclaration, psi2, symbol2)) {
            return false;
        }
        if (!this.typeParametersMatch(psi2, symbol2)) {
            return false;
        }
        return !(symbol2 instanceof KtFunctionLikeSymbol) || this.valueParametersMatch($this$representsTheSameDeclaration, psi2, (KtFunctionLikeSymbol)symbol2);
    }

    private final boolean returnTypesMatch(KtAnalysisSession $this$returnTypesMatch, PsiMethod psi2, KtCallableSymbol symbol2) {
        boolean bl;
        if (symbol2 instanceof KtConstructorSymbol) {
            return true;
        }
        PsiType psiType = psi2.getReturnType();
        if (psiType != null) {
            PsiType it = psiType;
            boolean bl2 = false;
            bl = INSTANCE.isTheSameTypes($this$returnTypesMatch, psi2, it, symbol2.getReturnType(), KtTypeMappingMode.RETURN_TYPE, false);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean typeParametersMatch(PsiMethod psi2, KtCallableSymbol symbol2) {
        void $this$zip$iv;
        if (psi2.getTypeParameters().length != symbol2.getTypeParameters().size()) {
            return false;
        }
        PsiTypeParameter[] psiTypeParameterArray = psi2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
        Object[] objectArray = psiTypeParameterArray;
        Iterable other$iv = symbol2.getTypeParameters();
        boolean $i$f$zip = false;
        int arraySize$iv = ((void)$this$zip$iv).length;
        ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10), arraySize$iv));
        int i$iv = 0;
        for (Object element$iv : other$iv) {
            void typeParameterSymbol;
            void psiTypeParameter;
            if (i$iv >= arraySize$iv) break;
            int n = i$iv++;
            KtTypeParameterSymbol ktTypeParameterSymbol = (KtTypeParameterSymbol)element$iv;
            PsiTypeParameter psiTypeParameter2 = (PsiTypeParameter)$this$zip$iv[n];
            ArrayList<Unit> arrayList = list$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)psiTypeParameter.getName(), (Object)typeParameterSymbol.getName().asString())) {
                return false;
            }
            arrayList.add(Unit.INSTANCE);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean valueParametersMatch(KtAnalysisSession $this$valueParametersMatch, PsiMethod psi2, KtFunctionLikeSymbol symbol2) {
        int valueParameterCount;
        int n = valueParameterCount = symbol2.isExtension() ? symbol2.getValueParameters().size() + 1 : symbol2.getValueParameters().size();
        if (psi2.getParameterList().getParametersCount() != valueParameterCount) {
            return false;
        }
        if (symbol2.isExtension()) {
            boolean bl;
            PsiParameter psiParameter = psi2.getParameterList().getParameters()[0];
            KtType ktType = KtCallableSymbolKt.getReceiverType(symbol2);
            if (ktType != null) {
                KtType it = ktType;
                boolean bl2 = false;
                PsiType psiType = psiParameter.getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
                bl = PsiDeclarationAndKtSymbolEqualityChecker.isTheSameTypes$default(INSTANCE, $this$valueParametersMatch, psi2, psiType, it, null, false, 8, null);
            } else {
                bl = false;
            }
            if (!bl) {
                return false;
            }
        }
        int offset = symbol2.isExtension() ? 1 : 0;
        Iterable $this$forEachIndexed$iv = symbol2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void valueParameterSymbol;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtValueParameterSymbol ktValueParameterSymbol = (KtValueParameterSymbol)item$iv;
            int index = n2;
            boolean bl = false;
            PsiParameter psiParameter = psi2.getParameterList().getParameters()[index + offset];
            if (valueParameterSymbol.isVararg() != psiParameter.isVarArgs()) {
                return false;
            }
            PsiType psiType = psiParameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            if (INSTANCE.isTheSameTypes($this$valueParametersMatch, psi2, psiType, valueParameterSymbol.getReturnType(), KtTypeMappingMode.VALUE_PARAMETER, valueParameterSymbol.isVararg())) continue;
            return false;
        }
        return true;
    }

    private final boolean isTheSameTypes(KtAnalysisSession $this$isTheSameTypes, PsiMethod context, PsiType psi2, KtType ktType, KtTypeMappingMode mode, boolean isVararg) {
        PsiType psiType;
        if (Intrinsics.areEqual((Object)psi2, (Object)PsiType.VOID) && $this$isTheSameTypes.isUnit(ktType)) {
            return true;
        }
        PsiType psiType2 = KtPsiTypeProviderMixIn.asPsiType$default($this$isTheSameTypes, ktType, (PsiElement)context, true, mode, false, 8, null);
        if (psiType2 == null) {
            return false;
        }
        PsiType ktTypeRendered = psiType2;
        if (isVararg) {
            PsiArrayType psiArrayType = ktTypeRendered.createArrayType();
            Intrinsics.checkNotNullExpressionValue((Object)psiArrayType, (String)"createArrayType(...)");
            psiType = (PsiType)psiArrayType;
        } else {
            psiType = ktTypeRendered;
        }
        PsiType rendered = psiType;
        return Intrinsics.areEqual((Object)rendered, (Object)psi2);
    }

    static /* synthetic */ boolean isTheSameTypes$default(PsiDeclarationAndKtSymbolEqualityChecker psiDeclarationAndKtSymbolEqualityChecker, KtAnalysisSession ktAnalysisSession, PsiMethod psiMethod, PsiType psiType, KtType ktType, KtTypeMappingMode ktTypeMappingMode, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            ktTypeMappingMode = KtTypeMappingMode.DEFAULT;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return psiDeclarationAndKtSymbolEqualityChecker.isTheSameTypes(ktAnalysisSession, psiMethod, psiType, ktType, ktTypeMappingMode, bl);
    }
}

