/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.stubs;

import com.sun.tools.javac.tree.JCTree;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.base.stubs.KotlinPosition;
import org.jetbrains.kotlin.kapt3.stubs.MemberData;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0003j\b\u0012\u0004\u0012\u00020\u0002`\u0001B%\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/kapt3/stubs/MembersPositionComparator;", "Lkotlin/Comparator;", "Lcom/sun/tools/javac/tree/JCTree;", "Ljava/util/Comparator;", "classSource", "Lorg/jetbrains/kotlin/kapt3/base/stubs/KotlinPosition;", "memberData", "", "Lorg/jetbrains/kotlin/kapt3/stubs/MemberData;", "<init>", "(Lorg/jetbrains/kotlin/kapt3/base/stubs/KotlinPosition;Ljava/util/Map;)V", "getClassSource", "()Lorg/jetbrains/kotlin/kapt3/base/stubs/KotlinPosition;", "getMemberData", "()Ljava/util/Map;", "compare", "", "o1", "o2", "compareDescriptors", "m1", "m2", "kotlin-annotation-processing-compiler"})
public final class MembersPositionComparator
implements Comparator<JCTree> {
    @Nullable
    private final KotlinPosition classSource;
    @NotNull
    private final Map<JCTree, MemberData> memberData;

    public MembersPositionComparator(@Nullable KotlinPosition classSource, @NotNull Map<JCTree, MemberData> memberData) {
        Intrinsics.checkNotNullParameter(memberData, (String)"memberData");
        this.classSource = classSource;
        this.memberData = memberData;
    }

    @Nullable
    public final KotlinPosition getClassSource() {
        return this.classSource;
    }

    @NotNull
    public final Map<JCTree, MemberData> getMemberData() {
        return this.memberData;
    }

    @Override
    public int compare(@NotNull JCTree o1, @NotNull JCTree o2) {
        int positionCompare;
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        MemberData data1 = (MemberData)MapsKt.getValue(this.memberData, (Object)o1);
        MemberData data2 = (MemberData)MapsKt.getValue(this.memberData, (Object)o2);
        if (this.classSource == null) {
            return this.compareDescriptors(data1, data2);
        }
        KotlinPosition position1 = data1.getPosition();
        KotlinPosition position2 = data2.getPosition();
        int n = position1 != null && Intrinsics.areEqual((Object)position1.getPath(), (Object)this.classSource.getPath()) ? (position2 != null && Intrinsics.areEqual((Object)position2.getPath(), (Object)this.classSource.getPath()) ? ((positionCompare = Intrinsics.compare((int)position1.getPos(), (int)position2.getPos())) != 0 ? positionCompare : this.compareDescriptors(data1, data2)) : -1) : (position2 != null && Intrinsics.areEqual((Object)position2.getPath(), (Object)this.classSource.getPath()) ? 1 : this.compareDescriptors(data1, data2));
        return n;
    }

    private final int compareDescriptors(MemberData m1, MemberData m2) {
        int nameComparison = m1.getName().compareTo(m2.getName());
        if (nameComparison != 0) {
            return nameComparison;
        }
        return m1.getDescriptor().compareTo(m2.getDescriptor());
    }
}

