/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.evaluate;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005*\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005*\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0005*\u0006\u0012\u0002\b\u00030\u0005H\u0002J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0005*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f\"\u0004\b\u0000\u0010 *\b\u0012\u0004\u0012\u0002H 0!H\u0002J\u001e\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005*\u0006\u0012\u0002\b\u00030\u0005H\u0002J*\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\"\u001a\u00020#2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0012\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010!*\u00020\u001dH\u0002J\u0012\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010!*\u00020\u0015H\u0002J\u001b\u0010(\u001a\u0006\u0012\u0002\b\u00030!\"\u0004\b\u0000\u0010 *\u0002H H\u0002\u00a2\u0006\u0002\u0010)J\u001c\u0010*\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030!2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002J2\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H 0\u0005\"\u0004\b\u0000\u0010 *\b\u0012\u0004\u0012\u0002H 0!2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0002J\u000e\u0010/\u001a\u0004\u0018\u000100*\u00020\u001aH\u0002R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\rR\u0018\u0010&\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\rR\u0018\u0010'\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\r\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator;", "", "<init>", "()V", "evaluate", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "mode", "Lorg/jetbrains/kotlin/analysis/api/components/KtConstantEvaluationMode;", "isStringLength", "", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "toConstExpression", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;", "evaluateAsKtConstantValue", "Lorg/jetbrains/kotlin/analysis/api/base/KtConstantValue;", "adaptToConstKind", "evaluateStringConcatenationCall", "", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "evaluateFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "adjustType", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "toCompileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "T", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "evaluateStringLength", "other", "isStringEquals", "isStringPlus", "toConstantValueKind", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/types/ConstantValueKind;", "convertToNumber", "value", "", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "getOriginalFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirCompileTimeConstantEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,384:1\n32#2:385\n24#2:386\n16#2:387\n44#3:388\n44#3:389\n*S KotlinDebug\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator\n*L\n86#1:385\n100#1:386\n100#1:387\n164#1:388\n184#1:389\n*E\n"})
public final class FirCompileTimeConstantEvaluator {
    @NotNull
    public static final FirCompileTimeConstantEvaluator INSTANCE = new FirCompileTimeConstantEvaluator();

    private FirCompileTimeConstantEvaluator() {
    }

    @Nullable
    public final FirConstExpression<?> evaluate(@Nullable FirElement fir, @NotNull KtConstantEvaluationMode mode) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        FirElement firElement = fir;
        if (firElement instanceof FirPropertyAccessExpression) {
            FirVariableSymbol referredVariable = FirReferenceUtilsKt.toResolvedVariableSymbol$default((FirReference)((FirPropertyAccessExpression)fir).getCalleeReference(), (boolean)false, (int)1, null);
            if (referredVariable instanceof FirPropertySymbol) {
                if (this.isStringLength(((FirPropertySymbol)referredVariable).getCallableId())) {
                    FirConstExpression<?> firConstExpression = this.evaluate((FirElement)((FirPropertyAccessExpression)fir).getExplicitReceiver(), mode);
                    object = firConstExpression != null ? this.evaluateStringLength(firConstExpression) : null;
                } else {
                    object = this.toConstExpression((FirPropertySymbol)referredVariable, mode);
                }
            } else {
                object = referredVariable instanceof FirFieldSymbol ? this.toConstExpression((FirFieldSymbol)referredVariable, mode) : null;
            }
        } else if (firElement instanceof FirConstExpression) {
            object = this.adaptToConstKind((FirConstExpression)fir);
        } else if (firElement instanceof FirFunctionCall) {
            object = this.evaluateFunctionCall((FirFunctionCall)fir, mode);
        } else if (firElement instanceof FirStringConcatenationCall) {
            object = this.evaluateStringConcatenationCall((FirStringConcatenationCall)fir, mode);
        } else if (firElement instanceof FirNamedReference) {
            FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)((FirReference)fir), (boolean)false, (int)1, null);
            object = firPropertySymbol != null ? this.toConstExpression(firPropertySymbol, mode) : null;
        } else {
            object = null;
        }
        return object;
    }

    private final boolean isStringLength(CallableId $this$isStringLength) {
        return Intrinsics.areEqual((Object)$this$isStringLength.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringLength.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"length");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FirConstExpression<?> toConstExpression(FirPropertySymbol $this$toConstExpression, KtConstantEvaluationMode mode) {
        if (mode == KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION) {
            FirCallableSymbol $this$isConst$iv = (FirCallableSymbol)$this$toConstExpression;
            boolean $i$f$isConst = false;
            if (!$this$isConst$iv.getRawStatus().isConst()) {
                return null;
            }
        }
        if (!$this$toConstExpression.isVal()) return null;
        if (!$this$toConstExpression.getHasInitializer()) return null;
        FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)((FirBasedSymbol)$this$toConstExpression), (FirResolvePhase)FirResolvePhase.BODY_RESOLVE);
        FirConstExpression<?> firConstExpression = this.evaluate((FirElement)((FirProperty)$this$toConstExpression.getFir()).getInitializer(), mode);
        return firConstExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FirConstExpression<?> toConstExpression(FirFieldSymbol $this$toConstExpression, KtConstantEvaluationMode mode) {
        if (mode == KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION) {
            FirCallableSymbol $this$isStatic$iv = (FirCallableSymbol)$this$toConstExpression;
            boolean $i$f$isStatic = false;
            if (!$this$isStatic$iv.getRawStatus().isStatic()) return null;
            FirCallableSymbol $this$isFinal$iv = (FirCallableSymbol)$this$toConstExpression;
            boolean $i$f$isFinal = false;
            if ($this$isFinal$iv.getResolvedStatus().getModality() != Modality.FINAL) return null;
            boolean bl = true;
            if (!bl) {
                return null;
            }
        }
        if (!$this$toConstExpression.isVal()) return null;
        if (!$this$toConstExpression.getHasInitializer()) return null;
        FirConstExpression<?> firConstExpression = this.evaluate((FirElement)((FirField)$this$toConstExpression.getFir()).getInitializer(), mode);
        return firConstExpression;
    }

    @Nullable
    public final KtConstantValue evaluateAsKtConstantValue(@NotNull FirElement fir, @NotNull KtConstantEvaluationMode mode) {
        KtConstantValue ktConstantValue;
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        FirConstExpression<?> firConstExpression = this.evaluate(fir, mode);
        if (firConstExpression == null) {
            return null;
        }
        FirConstExpression<?> evaluated = firConstExpression;
        Object value = evaluated.getValue();
        PsiElement psiElement = UtilsKt.getPsi((FirElement)((FirElement)evaluated));
        KtElement psi2 = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        psiElement = evaluated.getKind();
        if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Byte.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Byte");
            ktConstantValue = new KtConstantValue.KtByteConstantValue((Byte)value, psi2);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Int.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
            ktConstantValue = new KtConstantValue.KtIntConstantValue((Integer)value, psi2);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Long.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Long");
            ktConstantValue = new KtConstantValue.KtLongConstantValue((Long)value, psi2);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Short.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Short");
            ktConstantValue = new KtConstantValue.KtShortConstantValue((Short)value, psi2);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.UByte");
            ktConstantValue = new KtConstantValue.KtUnsignedByteConstantValue(((UByte)value).unbox-impl(), psi2, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.UInt");
            ktConstantValue = new KtConstantValue.KtUnsignedIntConstantValue(((UInt)value).unbox-impl(), psi2, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.ULong");
            ktConstantValue = new KtConstantValue.KtUnsignedLongConstantValue(((ULong)value).unbox-impl(), psi2, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.UShort");
            ktConstantValue = new KtConstantValue.KtUnsignedShortConstantValue(((UShort)value).unbox-impl(), psi2, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Double.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Double");
            ktConstantValue = new KtConstantValue.KtDoubleConstantValue((Double)value, psi2);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Float.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Float");
            ktConstantValue = new KtConstantValue.KtFloatConstantValue(((Float)value).floatValue(), psi2);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            ktConstantValue = new KtConstantValue.KtBooleanConstantValue((Boolean)value, psi2);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Char.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Char");
            ktConstantValue = new KtConstantValue.KtCharConstantValue(((Character)value).charValue(), psi2);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.String.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            ktConstantValue = new KtConstantValue.KtStringConstantValue((String)value, psi2);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Null.INSTANCE)) {
            ktConstantValue = new KtConstantValue.KtNullConstantValue(psi2);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.IntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Long");
            long l = (Long)value;
            ktConstantValue = Integer.MIN_VALUE < l && l < Integer.MAX_VALUE ? (KtConstantValue)new KtConstantValue.KtIntConstantValue((int)l, psi2) : (KtConstantValue)new KtConstantValue.KtLongConstantValue(l, psi2);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.ULong");
            long l = ((ULong)value).unbox-impl();
            ktConstantValue = Long.compareUnsigned(ULong.constructor-impl((long)(0L & 0xFFFFFFFFL)), l) < 0 && Long.compareUnsigned(l, ULong.constructor-impl((long)((long)-1 & 0xFFFFFFFFL))) < 0 ? (KtConstantValue)new KtConstantValue.KtUnsignedIntConstantValue(UInt.constructor-impl((int)((int)l)), psi2, null) : (KtConstantValue)new KtConstantValue.KtUnsignedLongConstantValue(l, psi2, null);
        } else {
            if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Error.INSTANCE)) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Should not be possible to get from FIR tree", null, fir, null, null, null, 58, null);
                throw null;
            }
            throw new NoWhenBranchMatchedException();
        }
        return ktConstantValue;
    }

    private final FirConstExpression<?> adaptToConstKind(FirConstExpression<?> $this$adaptToConstKind) {
        Object object;
        ConstantValueKind constantValueKind = $this$adaptToConstKind.getKind();
        KtSourceElement ktSourceElement = $this$adaptToConstKind.getSource();
        Object object2 = this.convertToNumber($this$adaptToConstKind.getKind(), (object = $this$adaptToConstKind.getValue()) instanceof Number ? (Number)((Number)object) : (Number)null);
        if (object2 == null) {
            object2 = $this$adaptToConstKind.getValue();
        }
        return this.toConstExpression(constantValueKind, ktSourceElement, object2);
    }

    private final FirConstExpression<String> evaluateStringConcatenationCall(FirStringConcatenationCall stringConcatenationCall, KtConstantEvaluationMode mode) {
        StringBuilder stringBuilder;
        StringBuilder $this$evaluateStringConcatenationCall_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        FirCall $this$arguments$iv = (FirCall)stringConcatenationCall;
        boolean $i$f$getArguments = false;
        for (FirExpression arg : $this$arguments$iv.getArgumentList().getArguments()) {
            FirConstExpression<?> evaluated;
            if (INSTANCE.evaluate((FirElement)arg, mode) == null) {
                return null;
            }
            $this$evaluateStringConcatenationCall_u24lambda_u240.append(String.valueOf(evaluated.getValue()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String concatenated = string;
        return this.toConstExpression((ConstantValueKind)ConstantValueKind.String.INSTANCE, stringConcatenationCall.getSource(), concatenated);
    }

    private final FirConstExpression<?> evaluateFunctionCall(FirFunctionCall functionCall, KtConstantEvaluationMode mode) {
        FirConstExpression<?> firConstExpression = this.getOriginalFunction(functionCall);
        FirSimpleFunction firSimpleFunction = firConstExpression instanceof FirSimpleFunction ? (FirSimpleFunction)firConstExpression : null;
        if (firSimpleFunction == null) {
            return null;
        }
        FirSimpleFunction function = firSimpleFunction;
        FirConstExpression<?> firConstExpression2 = this.evaluate((FirElement)functionCall.getExplicitReceiver(), mode);
        if (firConstExpression2 == null) {
            return null;
        }
        FirConstExpression<?> opr1 = firConstExpression2;
        firConstExpression = this.evaluate(opr1, function);
        if (firConstExpression != null) {
            FirConstExpression<?> it = firConstExpression;
            boolean bl = false;
            return INSTANCE.adjustType(it, FirTypeUtilsKt.getResolvedType((FirExpression)((FirExpression)functionCall)));
        }
        FirCall $this$arguments$iv = (FirCall)functionCall;
        boolean $i$f$getArguments = false;
        FirExpression firExpression = (FirExpression)CollectionsKt.firstOrNull((List)$this$arguments$iv.getArgumentList().getArguments());
        if (firExpression == null) {
            return null;
        }
        FirExpression argument = firExpression;
        FirConstExpression<?> firConstExpression3 = this.evaluate((FirElement)argument, mode);
        if (firConstExpression3 == null) {
            return null;
        }
        FirConstExpression<?> opr2 = firConstExpression3;
        FirConstExpression<?> firConstExpression4 = this.evaluate(opr1, function, opr2);
        if (firConstExpression4 != null) {
            FirConstExpression<?> it = firConstExpression4;
            boolean bl = false;
            return INSTANCE.adjustType(it, FirTypeUtilsKt.getResolvedType((FirExpression)((FirExpression)functionCall)));
        }
        return null;
    }

    private final FirConstExpression<?> adjustType(FirConstExpression<?> $this$adjustType, ConeKotlinType expectedType) {
        FirConstExpression<?> expression;
        FirConstExpression<?> firConstExpression;
        FirConstExpression<?> firConstExpression2;
        ConstantValueKind<?> expectedKind = this.toConstantValueKind((Object)expectedType);
        if (expectedKind != null && !Intrinsics.areEqual(expectedKind, (Object)$this$adjustType.getKind()) && $this$adjustType.getValue() instanceof Number) {
            Object object = $this$adjustType.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            Object object2 = this.convertToNumber(expectedKind, (Number)object);
            Intrinsics.checkNotNull((Object)object2);
            Object typeAdjustedValue = object2;
            firConstExpression2 = this.toConstExpression(expectedKind, $this$adjustType.getSource(), typeAdjustedValue);
        } else {
            firConstExpression2 = $this$adjustType;
        }
        FirConstExpression<?> $this$adjustType_u24lambda_u243 = firConstExpression = (expression = firConstExpression2);
        boolean bl = false;
        $this$adjustType_u24lambda_u243.replaceConeTypeOrNull(expectedType);
        return firConstExpression;
    }

    private final <T> CompileTimeType toCompileTimeType(ConstantValueKind<T> $this$toCompileTimeType) {
        ConstantValueKind<T> constantValueKind = $this$toCompileTimeType;
        return Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE) ? CompileTimeType.BYTE : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE) ? CompileTimeType.SHORT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE) ? CompileTimeType.INT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE) ? CompileTimeType.LONG : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE) ? CompileTimeType.DOUBLE : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE) ? CompileTimeType.FLOAT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE) ? CompileTimeType.CHAR : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE) ? CompileTimeType.BOOLEAN : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE) ? CompileTimeType.STRING : CompileTimeType.ANY))))))));
    }

    private final FirConstExpression<?> evaluate(FirConstExpression<?> $this$evaluate, FirSimpleFunction function) {
        FirConstExpression<?> firConstExpression;
        Object object;
        Object opr;
        if ($this$evaluate.getValue() == null) {
            return null;
        }
        Object object2 = $this$evaluate.getValue();
        String string = object2 instanceof String ? (String)object2 : null;
        if (string != null) {
            opr = string;
            boolean bl = false;
            String string2 = function.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            object = OperationsMapGeneratedKt.evalUnaryOp((String)string2, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr);
            if (object != null) {
                Object it = object;
                boolean bl2 = false;
                return INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
            }
        }
        Object object3 = this.convertToNumber($this$evaluate.getKind(), (object2 = $this$evaluate.getValue()) instanceof Number ? (Number)((Number)object2) : (Number)null);
        if (object3 != null) {
            opr = object3;
            boolean bl = false;
            String string3 = function.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            object = OperationsMapGeneratedKt.evalUnaryOp((String)string3, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr);
            if (object != null) {
                Object it = object;
                boolean bl3 = false;
                firConstExpression = INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
            } else {
                firConstExpression = null;
            }
        } else {
            firConstExpression = null;
        }
        return firConstExpression;
    }

    private final FirConstExpression<?> evaluateStringLength(FirConstExpression<?> $this$evaluateStringLength) {
        FirConstExpression<?> firConstExpression;
        Object object = $this$evaluateStringLength.getValue();
        String string = object instanceof String ? (String)object : null;
        if (string != null) {
            int it = string.length();
            boolean bl = false;
            firConstExpression = INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluateStringLength.getSource(), it);
        } else {
            firConstExpression = null;
        }
        return firConstExpression;
    }

    private final FirConstExpression<?> evaluate(FirConstExpression<?> $this$evaluate, FirSimpleFunction function, FirConstExpression<?> other) {
        FirConstExpression<?> firConstExpression;
        Object opr1;
        if ($this$evaluate.getValue() == null || other.getValue() == null) {
            return null;
        }
        CompileTimeType rightType = this.isStringEquals(function.getSymbol().getCallableId()) ? CompileTimeType.ANY : (this.isStringPlus(function.getSymbol().getCallableId()) ? CompileTimeType.ANY : this.toCompileTimeType(other.getKind()));
        Object object = $this$evaluate.getValue();
        String string = object instanceof String ? (String)object : null;
        if (string != null) {
            opr1 = string;
            boolean bl = false;
            Object object2 = other.getValue();
            if (object2 != null) {
                Object opr2 = object2;
                boolean bl2 = false;
                String string2 = function.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                Object object3 = OperationsMapGeneratedKt.evalBinaryOp((String)string2, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr1, (CompileTimeType)rightType, (Object)opr2);
                if (object3 != null) {
                    Object it = object3;
                    boolean bl3 = false;
                    return INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
                }
            }
        }
        object = $this$evaluate.getValue();
        Object object4 = this.convertToNumber($this$evaluate.getKind(), object instanceof Number ? (Number)((Number)object) : (Number)null);
        if (object4 != null) {
            Object object5;
            opr1 = object4;
            boolean bl = false;
            Object object6 = INSTANCE.convertToNumber(other.getKind(), (object5 = other.getValue()) instanceof Number ? (Number)((Number)object5) : (Number)null);
            if (object6 != null) {
                Object opr2 = object6;
                boolean bl4 = false;
                String string3 = function.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                Object object7 = OperationsMapGeneratedKt.evalBinaryOp((String)string3, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr1, (CompileTimeType)INSTANCE.toCompileTimeType(other.getKind()), (Object)opr2);
                if (object7 != null) {
                    Object it = object7;
                    boolean bl5 = false;
                    firConstExpression = INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
                } else {
                    firConstExpression = null;
                }
            } else {
                firConstExpression = null;
            }
        } else {
            firConstExpression = null;
        }
        return firConstExpression;
    }

    private final boolean isStringEquals(CallableId $this$isStringEquals) {
        return Intrinsics.areEqual((Object)$this$isStringEquals.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringEquals.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"equals");
    }

    private final boolean isStringPlus(CallableId $this$isStringPlus) {
        return Intrinsics.areEqual((Object)$this$isStringPlus.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringPlus.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"plus");
    }

    private final ConstantValueKind<?> toConstantValueKind(ConeKotlinType $this$toConstantValueKind) {
        ConstantValueKind<?> constantValueKind;
        ConeKotlinType coneKotlinType = $this$toConstantValueKind;
        if (coneKotlinType instanceof ConeErrorType) {
            constantValueKind = null;
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            String string = ((ConeLookupTagBasedType)$this$toConstantValueKind).getLookupTag().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            constantValueKind = this.toConstantValueKind((Object)string);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            constantValueKind = this.toConstantValueKind((Object)((ConeKotlinType)((ConeFlexibleType)$this$toConstantValueKind).getUpperBound()));
        } else if (coneKotlinType instanceof ConeCapturedType) {
            constantValueKind = ((ConeCapturedType)$this$toConstantValueKind).getLowerType();
            if (constantValueKind == null || (constantValueKind = this.toConstantValueKind(constantValueKind)) == null) {
                List list = ((ConeCapturedType)$this$toConstantValueKind).getConstructor().getSupertypes();
                Intrinsics.checkNotNull((Object)list);
                constantValueKind = this.toConstantValueKind((Object)((ConeKotlinType)CollectionsKt.first((List)list)));
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            constantValueKind = this.toConstantValueKind((Object)((ConeKotlinType)((ConeDefinitelyNotNullType)$this$toConstantValueKind).getOriginal()));
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            constantValueKind = this.toConstantValueKind((Object)((ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)$this$toConstantValueKind).getIntersectedTypes())));
        } else if (coneKotlinType instanceof ConeStubType) {
            constantValueKind = null;
        } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
            constantValueKind = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return constantValueKind;
    }

    private final ConstantValueKind<?> toConstantValueKind(String $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        switch ($this$toConstantValueKind) {
            case "Byte": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Byte.INSTANCE;
                break;
            }
            case "Double": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Double.INSTANCE;
                break;
            }
            case "Float": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Float.INSTANCE;
                break;
            }
            case "Int": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Int.INSTANCE;
                break;
            }
            case "Long": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Long.INSTANCE;
                break;
            }
            case "Short": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Short.INSTANCE;
                break;
            }
            case "Char": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Char.INSTANCE;
                break;
            }
            case "String": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.String.INSTANCE;
                break;
            }
            case "Boolean": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Boolean.INSTANCE;
                break;
            }
            default: {
                constantValueKind = null;
            }
        }
        return constantValueKind;
    }

    private final <T> ConstantValueKind<?> toConstantValueKind(T $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        T t = $this$toConstantValueKind;
        if (t instanceof Byte) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Byte.INSTANCE;
        } else if (t instanceof Double) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Double.INSTANCE;
        } else if (t instanceof Float) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Float.INSTANCE;
        } else if (t instanceof Integer) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Int.INSTANCE;
        } else if (t instanceof Long) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Long.INSTANCE;
        } else if (t instanceof Short) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Short.INSTANCE;
        } else if (t instanceof Character) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Char.INSTANCE;
        } else if (t instanceof String) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.String.INSTANCE;
        } else if (t instanceof Boolean) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Boolean.INSTANCE;
        } else if (t == null) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Null.INSTANCE;
        } else {
            throw new IllegalStateException("Unknown constant value".toString());
        }
        return constantValueKind;
    }

    private final Object convertToNumber(ConstantValueKind<?> $this$convertToNumber, Number value) {
        if (value == null) {
            return null;
        }
        ConstantValueKind<?> constantValueKind = $this$convertToNumber;
        return Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE) ? (Comparable)Byte.valueOf(value.byteValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE) ? (Comparable)Double.valueOf(value.doubleValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE) ? (Comparable)Float.valueOf(value.floatValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE) ? (Comparable)Integer.valueOf(value.intValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE) ? (Comparable)Long.valueOf(value.longValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE) ? (Comparable)Short.valueOf(value.shortValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE) ? UByte.box-impl((byte)UByte.constructor-impl((byte)((byte)value.longValue()))) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE) ? UShort.box-impl((short)UShort.constructor-impl((short)((short)value.longValue()))) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE) ? UInt.box-impl((int)UInt.constructor-impl((int)((int)value.longValue()))) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE) ? ULong.box-impl((long)ULong.constructor-impl((long)value.longValue())) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE) ? ULong.box-impl((long)ULong.constructor-impl((long)value.longValue())) : null))))))))));
    }

    private final <T> FirConstExpression<T> toConstExpression(ConstantValueKind<T> $this$toConstExpression, KtSourceElement source, Object value) {
        return FirConstExpressionBuilderKt.buildConstExpression$default((KtSourceElement)source, $this$toConstExpression, (Object)value, null, (boolean)false, (int)8, null);
    }

    private final FirCallableDeclaration getOriginalFunction(FirFunctionCall $this$getOriginalFunction) {
        FirBasedSymbol symbol2;
        FirNamedReference reference = $this$getOriginalFunction.getCalleeReference();
        FirBasedSymbol firBasedSymbol = symbol2 = reference instanceof FirResolvedNamedReference ? ((FirResolvedNamedReference)reference).getResolvedSymbol() : null;
        FirDeclaration firDeclaration = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        return firDeclaration instanceof FirCallableDeclaration ? (FirCallableDeclaration)firDeclaration : null;
    }
}

