/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.processing.Processor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.base.kapt3.KaptFlag;
import org.jetbrains.kotlin.base.kapt3.KaptOptions;
import org.jetbrains.kotlin.kapt3.base.LoadedProcessors;
import org.jetbrains.kotlin.kapt3.base.ProcessorLoader;
import org.jetbrains.kotlin.kapt3.base.incremental.DeclaredProcType;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessor;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessorDiscoveryKt;
import org.jetbrains.kotlin.kapt3.base.util.KaptLogger;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0016H\u0002J*\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/ProcessorLoader;", "Ljava/io/Closeable;", "options", "Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;", "logger", "Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;", "(Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;)V", "annotationProcessingClassLoader", "Ljava/net/URLClassLoader;", "close", "", "doLoadProcessors", "", "Ljavax/annotation/processing/Processor;", "classpath", "Ljava/util/LinkedHashSet;", "Ljava/io/File;", "Lkotlin/collections/LinkedHashSet;", "classLoader", "loadProcessors", "Lorg/jetbrains/kotlin/kapt3/base/LoadedProcessors;", "parentClassLoader", "Ljava/lang/ClassLoader;", "tryLoadProcessor", "fqName", "", "wrapInIncrementalProcessor", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor;", "processors", "", "kotlin-annotation-processing-base"})
public class ProcessorLoader
implements Closeable {
    @NotNull
    private final KaptOptions options;
    @NotNull
    private final KaptLogger logger;
    @Nullable
    private URLClassLoader annotationProcessingClassLoader;

    public ProcessorLoader(@NotNull KaptOptions options, @NotNull KaptLogger logger) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.options = options;
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LoadedProcessors loadProcessors(@NotNull ClassLoader parentClassLoader) {
        List processors;
        List list;
        URLClassLoader classLoader;
        void $this$toTypedArray$iv;
        Collection<URL> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parentClassLoader, (String)"parentClassLoader");
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        boolean bl = false;
        boolean bl2 = false;
        Iterable<File> $this$loadProcessors_u24lambda_u2d0 = linkedHashSet;
        boolean bl3 = false;
        $this$loadProcessors_u24lambda_u2d0.addAll(this.options.getProcessingClasspath());
        if (this.options.get(KaptFlag.INCLUDE_COMPILE_CLASSPATH)) {
            $this$loadProcessors_u24lambda_u2d0.addAll(this.options.getCompileClasspath());
        }
        LinkedHashSet<File> classpath = linkedHashSet;
        Iterable $this$map$iv = classpath;
        boolean $i$f$map = false;
        $this$loadProcessors_u24lambda_u2d0 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            URL uRL = it.toURI().toURL();
            collection.add(uRL);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray22 = false;
        void thisCollection$iv22 = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv22.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ClassLoader classLoader2 = parentClassLoader;
        URL[] uRLArray2 = uRLArray;
        this.annotationProcessingClassLoader = classLoader = new URLClassLoader(uRLArray2, classLoader2);
        Collection $i$f$toTypedArray22 = this.options.getProcessors();
        boolean thisCollection$iv22 = false;
        if (!$i$f$toTypedArray22.isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            this.logger.info("Annotation processor class names are set, skip AP discovery");
            Iterable $this$mapNotNull$iv = this.options.getProcessors();
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Processor processor;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                String it = (String)element$iv$iv;
                boolean bl6 = false;
                if (this.tryLoadProcessor(it, classLoader) == null) continue;
                boolean bl7 = false;
                boolean bl8 = false;
                Processor it$iv$iv = processor;
                boolean bl9 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            this.logger.info("Need to discovery annotation processors in the AP classpath");
            list = processors = this.doLoadProcessors(classpath, classLoader);
        }
        if (processors.isEmpty()) {
            this.logger.info("No annotation processors available, aborting");
        } else {
            KaptLogger $this$info$iv = this.logger;
            boolean $i$f$info = false;
            if ($this$info$iv.isVerbose()) {
                KaptLogger kaptLogger = $this$info$iv;
                boolean bl10 = false;
                String string = Intrinsics.stringPlus((String)"Annotation processors: ", (Object)CollectionsKt.joinToString$default((Iterable)processors, null, null, null, (int)0, null, (Function1)loadProcessors.1.1.INSTANCE, (int)31, null));
                kaptLogger.info(string);
            }
        }
        return new LoadedProcessors(this.wrapInIncrementalProcessor(processors, (Iterable<? extends File>)classpath), classLoader);
    }

    public static /* synthetic */ LoadedProcessors loadProcessors$default(ProcessorLoader processorLoader, ClassLoader classLoader, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadProcessors");
        }
        if ((n & 1) != 0) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getSystemClassLoader()");
            classLoader = classLoader2;
        }
        return processorLoader.loadProcessors(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IncrementalProcessor> wrapInIncrementalProcessor(List<? extends Processor> processors, Iterable<? extends File> classpath) {
        void $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (this.options.getIncrementalCache() == null) {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv = processors;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it2;
                Processor processor = (Processor)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                IncrementalProcessor incrementalProcessor = new IncrementalProcessor((Processor)it2, DeclaredProcType.NON_INCREMENTAL, this.logger);
                collection2.add(incrementalProcessor);
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$map$iv = processors;
        boolean $i$f$map = false;
        Iterable destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            Processor bl = (Processor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object = it3.getClass().getName();
            collection.add(object);
        }
        Set processorNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Map<String, DeclaredProcType> processorsInfo = IncrementalProcessorDiscoveryKt.getIncrementalProcessorsFromClasspath(processorNames, classpath);
        Iterable $this$filter$iv = processorNames;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!processorsInfo.containsKey(it))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List nonIncremental = (List)destination$iv$iv3;
        Iterable $this$map$iv2 = processors;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DeclaredProcType declaredProcType;
            it = (Processor)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            DeclaredProcType declaredProcType2 = processorsInfo.get(it.getClass().getName());
            if (declaredProcType2 == null) {
                declaredProcType = null;
            } else {
                DeclaredProcType declaredProcType3 = declaredProcType2;
                boolean bl3 = false;
                boolean bl4 = false;
                DeclaredProcType it4 = declaredProcType3;
                boolean bl5 = false;
                declaredProcType = nonIncremental.isEmpty() ? it4 : DeclaredProcType.INCREMENTAL_BUT_OTHER_APS_ARE_NOT;
            }
            DeclaredProcType declaredProcType4 = declaredProcType;
            DeclaredProcType procType = declaredProcType4 == null ? DeclaredProcType.NON_INCREMENTAL : declaredProcType4;
            object = new IncrementalProcessor((Processor)it, procType, this.logger);
            collection.add(object);
        }
        return (List)destination$iv$iv3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<Processor> doLoadProcessors(@NotNull LinkedHashSet<File> classpath, @NotNull URLClassLoader classLoader) {
        void $this$mapNotNullTo$iv$iv;
        boolean bl;
        Closeable closeable;
        Object object;
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        boolean bl2 = false;
        Set processorNames = new LinkedHashSet();
        String serviceFile = "META-INF/services/javax.annotation.processing.Processor";
        for (File file : classpath) {
            boolean bl3;
            Object object2;
            boolean bl4;
            if (file.isDirectory()) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                Object object3 = FilesKt.resolve((File)file, (String)serviceFile);
                bl4 = false;
                boolean bl5 = false;
                Object it = object3;
                boolean bl6 = false;
                Object object4 = object = ((File)it).isFile() ? object3 : null;
                if (object == null) continue;
                object3 = object;
                bl4 = false;
                bl5 = false;
                it = object3;
                boolean bl7 = false;
                object2 = it;
                bl3 = false;
                ProcessorLoader.doLoadProcessors$processSingleInput(processorNames, new FileInputStream((File)object2));
                continue;
            }
            if (file.isFile()) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                if (StringsKt.equals((String)FilesKt.getExtension((File)file), (String)"jar", (boolean)true)) {
                    object = new ZipFile(file);
                    boolean bl8 = false;
                    bl4 = false;
                    Throwable throwable = null;
                    try {
                        Unit unit;
                        ZipFile zipFile = (ZipFile)object;
                        boolean bl9 = false;
                        ZipEntry zipEntry = zipFile.getEntry(serviceFile);
                        if (zipEntry == null) {
                            unit = null;
                        } else {
                            object2 = zipEntry;
                            bl3 = false;
                            boolean bl10 = false;
                            Object zipEntry2 = object2;
                            boolean bl11 = false;
                            closeable = zipFile.getInputStream((ZipEntry)zipEntry2);
                            bl = false;
                            boolean bl12 = false;
                            Throwable throwable2 = null;
                            try {
                                InputStream it = (InputStream)closeable;
                                boolean bl13 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                ProcessorLoader.doLoadProcessors$processSingleInput(processorNames, it);
                                it = Unit.INSTANCE;
                            }
                            catch (Throwable it) {
                                throwable2 = it;
                                throw it;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                            }
                            unit = Unit.INSTANCE;
                        }
                        zipFile = unit;
                        continue;
                    }
                    catch (Throwable zipFile) {
                        throwable = zipFile;
                        throw zipFile;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        continue;
                    }
                }
            }
            this.logger.info(file + " cannot be used to locate " + serviceFile + " file.");
        }
        Iterable $this$mapNotNull$iv = processorNames;
        boolean $i$f$mapNotNull = false;
        object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl14 = false;
            String it = (String)element$iv$iv;
            boolean bl15 = false;
            if (this.tryLoadProcessor(it, classLoader) == null) continue;
            bl = false;
            boolean bl16 = false;
            Processor it$iv$iv = closeable;
            boolean bl17 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Processor tryLoadProcessor(String fqName, ClassLoader classLoader) {
        Class<?> clazz;
        try {
            clazz = Class.forName(fqName, true, classLoader);
        }
        catch (Throwable e) {
            this.logger.warn("Can't find annotation processor class " + fqName + ": " + e.getMessage());
            return null;
        }
        Class<?> annotationProcessorClass = clazz;
        try {
            Object annotationProcessorInstance = annotationProcessorClass.newInstance();
            if (!(annotationProcessorInstance instanceof Processor)) {
                this.logger.warn(Intrinsics.stringPlus((String)fqName, (Object)" is not an instance of 'Processor'"));
                return null;
            }
            return (Processor)annotationProcessorInstance;
        }
        catch (Throwable e) {
            this.logger.warn("Can't load annotation processor class " + fqName + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    public void close() {
        URLClassLoader uRLClassLoader = this.annotationProcessingClassLoader;
        if (uRLClassLoader != null) {
            uRLClassLoader.close();
        }
    }

    private static final void doLoadProcessors$processSingleInput(Set<String> processorNames, InputStream input) {
        Sequence lines;
        InputStream inputStream = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Closeable closeable = inputStream;
        int n = 0;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        boolean bl2 = false;
        Sequence $this$forEach$iv = lines = TextStreamsKt.lineSequence((BufferedReader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl3 = false;
            CharSequence charSequence = StringsKt.substringBefore$default((String)line, (String)"#", null, (int)2, null);
            boolean bl4 = false;
            String string = charSequence;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String processedLine = ((Object)StringsKt.trim((CharSequence)string)).toString();
            charSequence = processedLine;
            bl4 = false;
            if (!(charSequence.length() > 0)) continue;
            processorNames.add(processedLine);
        }
    }
}

