/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.File;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessorsKt;
import org.jetbrains.kotlin.kapt3.base.incremental.RuntimeProcType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ)\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\r\u0010\u0019\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u001aR\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/AnnotationProcessorDependencyCollector;", "", "runtimeProcType", "Lorg/jetbrains/kotlin/kapt3/base/incremental/RuntimeProcType;", "warningCollector", "Lkotlin/Function1;", "", "", "(Lorg/jetbrains/kotlin/kapt3/base/incremental/RuntimeProcType;Lkotlin/jvm/functions/Function1;)V", "generatedToSource", "", "Ljava/io/File;", "isFullRebuild", "", "add", "createdFile", "Ljava/net/URI;", "originatingElements", "", "Ljavax/lang/model/element/Element;", "add$kotlin_annotation_processing_base", "(Ljava/net/URI;[Ljavax/lang/model/element/Element;)V", "getGeneratedToSources", "", "getGeneratedToSources$kotlin_annotation_processing_base", "getRuntimeType", "getRuntimeType$kotlin_annotation_processing_base", "kotlin-annotation-processing-base"})
public final class AnnotationProcessorDependencyCollector {
    private final Map<File, File> generatedToSource;
    private boolean isFullRebuild;
    private final RuntimeProcType runtimeProcType;
    private final Function1<String, Unit> warningCollector;

    public final void add$kotlin_annotation_processing_base(@NotNull URI createdFile, @NotNull Element[] originatingElements) {
        Intrinsics.checkParameterIsNotNull((Object)createdFile, (String)"createdFile");
        Intrinsics.checkParameterIsNotNull((Object)originatingElements, (String)"originatingElements");
        if (this.isFullRebuild) {
            return;
        }
        File generatedFile = new File(createdFile);
        if (this.runtimeProcType == RuntimeProcType.AGGREGATING) {
            this.generatedToSource.put(generatedFile, null);
        } else {
            Set srcFiles = IncrementalProcessorsKt.access$getSrcFiles(originatingElements);
            if (srcFiles.size() != 1) {
                this.isFullRebuild = true;
                this.warningCollector.invoke((Object)("Expected 1 originating source file when generating " + generatedFile + ", " + "but detected " + srcFiles.size() + ": [" + CollectionsKt.joinToString$default((Iterable)srcFiles, null, null, null, (int)0, null, null, (int)63, null) + "]."));
            } else {
                this.generatedToSource.put(generatedFile, (File)CollectionsKt.single((Iterable)srcFiles));
            }
        }
    }

    @NotNull
    public final Map<File, File> getGeneratedToSources$kotlin_annotation_processing_base() {
        return this.isFullRebuild ? MapsKt.emptyMap() : this.generatedToSource;
    }

    @NotNull
    public final RuntimeProcType getRuntimeType$kotlin_annotation_processing_base() {
        return this.isFullRebuild ? RuntimeProcType.NON_INCREMENTAL : this.runtimeProcType;
    }

    public AnnotationProcessorDependencyCollector(@NotNull RuntimeProcType runtimeProcType, @NotNull Function1<? super String, Unit> warningCollector) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)((Object)runtimeProcType), (String)"runtimeProcType");
        Intrinsics.checkParameterIsNotNull(warningCollector, (String)"warningCollector");
        this.runtimeProcType = runtimeProcType;
        this.warningCollector = warningCollector;
        AnnotationProcessorDependencyCollector annotationProcessorDependencyCollector = this;
        boolean bl = false;
        annotationProcessorDependencyCollector.generatedToSource = map = (Map)new LinkedHashMap();
        this.isFullRebuild = !this.runtimeProcType.isIncremental();
    }
}

