/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.incremental.AnnotationProcessorDependencyCollector;
import org.jetbrains.kotlin.kapt3.base.incremental.DeclaredProcType;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalFiler;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessingEnvironment;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessorsKt;
import org.jetbrains.kotlin.kapt3.base.incremental.RuntimeProcType;
import org.jetbrains.kotlin.kapt3.base.util.KaptLogger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001bJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001eJ\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\r0\u001bJ\u0006\u0010 \u001a\u00020!J\u001e\u0010\"\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001e2\u0006\u0010%\u001a\u00020&H\u0016Jv\u0010'\u001a*\u0012\u000e\b\u0001\u0012\n **\u0004\u0018\u00010)0) **\u0014\u0012\u000e\b\u0001\u0012\n **\u0004\u0018\u00010)0)\u0018\u00010+0(2\u000e\u0010,\u001a\n **\u0004\u0018\u00010-0-2\u000e\u0010.\u001a\n **\u0004\u0018\u00010/0/2\u000e\u00100\u001a\n **\u0004\u0018\u000101012\u000e\u00102\u001a\n **\u0004\u0018\u00010\r0\rH\u0096\u0001\u00a2\u0006\u0002\u00103J2\u00104\u001a&\u0012\f\u0012\n **\u0004\u0018\u00010\r0\r **\u0012\u0012\f\u0012\n **\u0004\u0018\u00010\r0\r\u0018\u00010\u001e05H\u0096\u0001\u00a2\u0006\u0002\u00106J2\u00107\u001a&\u0012\f\u0012\n **\u0004\u0018\u00010\r0\r **\u0012\u0012\f\u0012\n **\u0004\u0018\u00010\r0\r\u0018\u00010\u001e05H\u0096\u0001\u00a2\u0006\u0002\u00106J\u0016\u00108\u001a\n **\u0004\u0018\u00010909H\u0096\u0001\u00a2\u0006\u0002\u0010:R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor;", "Ljavax/annotation/processing/Processor;", "processor", "kind", "Lorg/jetbrains/kotlin/kapt3/base/incremental/DeclaredProcType;", "logger", "Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;", "<init>", "(Ljavax/annotation/processing/Processor;Lorg/jetbrains/kotlin/kapt3/base/incremental/DeclaredProcType;Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;)V", "dependencyCollector", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/kapt3/base/incremental/AnnotationProcessorDependencyCollector;", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "incrementalSupportType", "getIncrementalSupportType", "init", "", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "createDependencyCollector", "isMissingIncrementalSupport", "", "isUnableToRunIncrementally", "getGeneratedToSources", "", "Ljava/io/File;", "getAggregatedTypes", "", "getGeneratedClassFilesToTypes", "getRuntimeType", "Lorg/jetbrains/kotlin/kapt3/base/incremental/RuntimeProcType;", "process", "annotations", "Ljavax/lang/model/element/TypeElement;", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "getCompletions", "", "Ljavax/annotation/processing/Completion;", "kotlin.jvm.PlatformType", "", "p0", "Ljavax/lang/model/element/Element;", "p1", "Ljavax/lang/model/element/AnnotationMirror;", "p2", "Ljavax/lang/model/element/ExecutableElement;", "p3", "(Ljavax/lang/model/element/Element;Ljavax/lang/model/element/AnnotationMirror;Ljavax/lang/model/element/ExecutableElement;Ljava/lang/String;)Ljava/lang/Iterable;", "getSupportedAnnotationTypes", "", "()Ljava/util/Set;", "getSupportedOptions", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "()Ljavax/lang/model/SourceVersion;", "kotlin-annotation-processing-base"})
@SourceDebugExtension(value={"SMAP\nincrementalProcessors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 incrementalProcessors.kt\norg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n669#2,11:257\n*S KotlinDebug\n*F\n+ 1 incrementalProcessors.kt\norg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor\n*L\n49#1:257,11\n*E\n"})
public final class IncrementalProcessor
implements Processor {
    @NotNull
    private final Processor processor;
    @NotNull
    private final DeclaredProcType kind;
    @NotNull
    private final KaptLogger logger;
    @NotNull
    private Lazy<AnnotationProcessorDependencyCollector> dependencyCollector;
    @NotNull
    private final String processorName;
    @NotNull
    private final String incrementalSupportType;

    public IncrementalProcessor(@NotNull Processor processor, @NotNull DeclaredProcType kind, @NotNull KaptLogger logger) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.processor = processor;
        this.kind = kind;
        this.logger = logger;
        this.dependencyCollector = LazyKt.lazy(() -> IncrementalProcessor.dependencyCollector$lambda$0(this));
        String string = this.processor.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.processorName = string;
        this.incrementalSupportType = this.kind.name();
    }

    @NotNull
    public final String getProcessorName() {
        return this.processorName;
    }

    @NotNull
    public final String getIncrementalSupportType() {
        return this.incrementalSupportType;
    }

    @Override
    public void init(@NotNull ProcessingEnvironment processingEnv) {
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        if (!this.kind.getCanRunIncrementally()) {
            this.processor.init(processingEnv);
        } else {
            Filer originalFiler = processingEnv.getFiler();
            Intrinsics.checkNotNull((Object)originalFiler);
            IncrementalFiler incrementalFiler = new IncrementalFiler(originalFiler);
            IncrementalProcessingEnvironment incProcEnvironment = new IncrementalProcessingEnvironment(processingEnv, incrementalFiler);
            this.processor.init(incProcEnvironment);
            incrementalFiler.setDependencyCollector$kotlin_annotation_processing_base((AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue());
        }
    }

    private final AnnotationProcessorDependencyCollector createDependencyCollector() {
        RuntimeProcType runtimeProcType;
        if (this.kind == DeclaredProcType.DYNAMIC) {
            Object v1;
            block6: {
                Set<String> set = this.getSupportedOptions();
                Intrinsics.checkNotNullExpressionValue(set, (String)"getSupportedOptions(...)");
                Iterable $this$singleOrNull$iv = set;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!StringsKt.startsWith$default((String)it, (String)"org.gradle.annotation.processing.", (boolean)false, (int)2, null)) continue;
                    if (found$iv) {
                        v1 = null;
                        break block6;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            String fromOptions = v1;
            if (fromOptions == null) {
                runtimeProcType = RuntimeProcType.NON_INCREMENTAL;
            } else {
                String string = StringsKt.drop((String)fromOptions, (int)33).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                String declaredType = string;
                runtimeProcType = IncrementalProcessorsKt.access$getALLOWED_RUNTIME_TYPES$p().contains(declaredType) ? RuntimeProcType.valueOf(declaredType) : RuntimeProcType.NON_INCREMENTAL;
            }
        } else {
            runtimeProcType = this.kind.toRuntimeType();
        }
        RuntimeProcType type = runtimeProcType;
        return new AnnotationProcessorDependencyCollector(type, (Function1<? super String, Unit>)((Function1)arg_0 -> IncrementalProcessor.createDependencyCollector$lambda$2(this, arg_0)));
    }

    public final boolean isMissingIncrementalSupport() {
        if (this.kind == DeclaredProcType.NON_INCREMENTAL) {
            return true;
        }
        return this.kind == DeclaredProcType.DYNAMIC && this.getRuntimeType() == RuntimeProcType.NON_INCREMENTAL;
    }

    public final boolean isUnableToRunIncrementally() {
        return !this.kind.getCanRunIncrementally();
    }

    @NotNull
    public final Map<File, String> getGeneratedToSources() {
        return ((AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue()).getGeneratedToSources$kotlin_annotation_processing_base();
    }

    @NotNull
    public final Set<String> getAggregatedTypes() {
        return ((AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue()).getAggregatedTypes$kotlin_annotation_processing_base();
    }

    @NotNull
    public final Map<File, String> getGeneratedClassFilesToTypes() {
        return ((AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue()).getGeneratedClassFilesToTypes$kotlin_annotation_processing_base();
    }

    @NotNull
    public final RuntimeProcType getRuntimeType() {
        return ((AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue()).getRuntimeType$kotlin_annotation_processing_base();
    }

    @Override
    public boolean process(@NotNull Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        if (this.getRuntimeType() == RuntimeProcType.AGGREGATING) {
            AnnotationProcessorDependencyCollector annotationProcessorDependencyCollector = (AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue();
            Set<String> set = this.processor.getSupportedAnnotationTypes();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getSupportedAnnotationTypes(...)");
            annotationProcessorDependencyCollector.recordProcessingInputs$kotlin_annotation_processing_base(set, annotations, roundEnv);
        }
        return this.processor.process(annotations, roundEnv);
    }

    @Override
    public Set<String> getSupportedOptions() {
        return this.processor.getSupportedOptions();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.processor.getSupportedAnnotationTypes();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return this.processor.getSupportedSourceVersion();
    }

    public Iterable<Completion> getCompletions(Element p0, AnnotationMirror p1, ExecutableElement p2, String p3) {
        return this.processor.getCompletions(p0, p1, p2, p3);
    }

    private static final AnnotationProcessorDependencyCollector dependencyCollector$lambda$0(IncrementalProcessor this$0) {
        return this$0.createDependencyCollector();
    }

    private static final Unit createDependencyCollector$lambda$2(IncrementalProcessor this$0, String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this$0.logger.warn("Issue detected with " + this$0.processorName + ". " + s);
        return Unit.INSTANCE;
    }
}

