/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.parcel.serializers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.parcel.serializers.Method;
import org.jetbrains.kotlin.android.parcel.serializers.ParcelSerializer;
import org.jetbrains.kotlin.android.parcel.serializers.ParcelSerializersKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/android/parcel/serializers/PrimitiveArrayParcelSerializer;", "Lorg/jetbrains/kotlin/android/parcel/serializers/ParcelSerializer;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "getAsmType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "createArrayMethod", "Lorg/jetbrains/kotlin/android/parcel/serializers/Method;", "", "methodNameBase", "writeMethod", "readValue", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "writeValue", "android-extensions-compiler"})
public final class PrimitiveArrayParcelSerializer
implements ParcelSerializer {
    @NotNull
    private final Type asmType;
    @NotNull
    private final String methodNameBase;
    @NotNull
    private final Method<String> writeMethod;
    @NotNull
    private final Method<String> createArrayMethod;

    public PrimitiveArrayParcelSerializer(@NotNull Type asmType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
        this.asmType = asmType;
        Type type = this.getAsmType().getElementType();
        if (Intrinsics.areEqual((Object)type, (Object)Type.INT_TYPE)) {
            string = "Int";
        } else if (Intrinsics.areEqual((Object)type, (Object)Type.BOOLEAN_TYPE)) {
            string = "Boolean";
        } else if (Intrinsics.areEqual((Object)type, (Object)Type.BYTE_TYPE)) {
            string = "Byte";
        } else if (Intrinsics.areEqual((Object)type, (Object)Type.CHAR_TYPE)) {
            string = "Char";
        } else if (Intrinsics.areEqual((Object)type, (Object)Type.DOUBLE_TYPE)) {
            string = "Double";
        } else if (Intrinsics.areEqual((Object)type, (Object)Type.FLOAT_TYPE)) {
            string = "Float";
        } else if (Intrinsics.areEqual((Object)type, (Object)Type.LONG_TYPE)) {
            string = "Long";
        } else {
            throw new IllegalStateException(("Unsupported type " + this.getAsmType().getElementType().getDescriptor()).toString());
        }
        this.methodNameBase = string;
        this.writeMethod = new Method<String>("write" + this.methodNameBase + "Array", '(' + this.getAsmType().getDescriptor() + ")V");
        this.createArrayMethod = new Method<String>("create" + this.methodNameBase + "Array", "()" + this.getAsmType().getDescriptor());
    }

    @Override
    @NotNull
    public Type getAsmType() {
        return this.asmType;
    }

    @Override
    public void writeValue(@NotNull InstructionAdapter v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v.invokevirtual(ParcelSerializersKt.getPARCEL_TYPE().getInternalName(), this.writeMethod.getName(), this.writeMethod.getSignature(), false);
    }

    @Override
    public void readValue(@NotNull InstructionAdapter v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v.invokevirtual(ParcelSerializersKt.getPARCEL_TYPE().getInternalName(), this.createArrayMethod.getName(), this.createArrayMethod.getSignature(), false);
    }
}

