/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.parcel.serializers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.parcel.serializers.ParcelSerializer;
import org.jetbrains.kotlin.android.parcel.serializers.ParcelSerializersKt;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/android/parcel/serializers/ArrayParcelSerializer;", "Lorg/jetbrains/kotlin/android/parcel/serializers/ParcelSerializer;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "elementSerializer", "(Lorg/jetbrains/org/objectweb/asm/Type;Lorg/jetbrains/kotlin/android/parcel/serializers/ParcelSerializer;)V", "getAsmType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "readValue", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "writeValue", "android-extensions-compiler"})
public final class ArrayParcelSerializer
implements ParcelSerializer {
    @NotNull
    private final Type asmType;
    @NotNull
    private final ParcelSerializer elementSerializer;

    public ArrayParcelSerializer(@NotNull Type asmType, @NotNull ParcelSerializer elementSerializer) {
        Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
        Intrinsics.checkNotNullParameter((Object)elementSerializer, (String)"elementSerializer");
        this.asmType = asmType;
        this.elementSerializer = elementSerializer;
    }

    @Override
    @NotNull
    public Type getAsmType() {
        return this.asmType;
    }

    @Override
    public void writeValue(@NotNull InstructionAdapter v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v.dupX1();
        v.arraylength();
        v.dupX2();
        v.invokevirtual(ParcelSerializersKt.getPARCEL_TYPE().getInternalName(), "writeInt", "(I)V", false);
        v.swap();
        v.aconst((Object)0);
        Label nextLoopIteration = new Label();
        Label loopIsOver = new Label();
        v.visitLabel(nextLoopIteration);
        v.dup2();
        v.ificmple(loopIsOver);
        v.swap();
        v.dupX2();
        v.pop();
        v.dup2();
        v.load(1, ParcelSerializersKt.getPARCEL_TYPE());
        v.dupX2();
        v.pop();
        v.aload(this.elementSerializer.getAsmType());
        ParcelSerializersKt.castIfNeeded(v, this.elementSerializer.getAsmType());
        this.elementSerializer.writeValue(v);
        v.aconst((Object)1);
        v.add(Type.INT_TYPE);
        v.swap();
        v.dupX2();
        v.pop();
        v.goTo(nextLoopIteration);
        v.visitLabel(loopIsOver);
        v.pop2();
        v.pop();
    }

    @Override
    public void readValue(@NotNull InstructionAdapter v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v.invokevirtual(ParcelSerializersKt.getPARCEL_TYPE().getInternalName(), "readInt", "()I", false);
        v.dup();
        v.newarray(this.elementSerializer.getAsmType());
        v.swap();
        v.aconst((Object)0);
        Label nextLoopIteration = new Label();
        Label loopIsOver = new Label();
        v.visitLabel(nextLoopIteration);
        v.dup2();
        v.ificmple(loopIsOver);
        v.swap();
        v.dupX2();
        v.pop();
        v.dup2();
        v.load(1, ParcelSerializersKt.getPARCEL_TYPE());
        this.elementSerializer.readValue(v);
        ParcelSerializersKt.castIfNeeded(v, this.elementSerializer.getAsmType());
        v.astore(this.elementSerializer.getAsmType());
        v.aconst((Object)1);
        v.add(Type.INT_TYPE);
        v.swap();
        v.dupX2();
        v.pop();
        v.goTo(nextLoopIteration);
        v.visitLabel(loopIsOver);
        v.pop2();
    }
}

