/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.CharIterator;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.io.IoPackage;
import kotlin.jvm.internal.FunctionImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.kotlin.doc.DocPackage$collections$b8ec3894;
import org.jetbrains.kotlin.doc.KDocConfig;
import org.jetbrains.kotlin.doc.highlighter.SyntaxHighlighter;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel$sourceInfoByFile$1;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KParameter;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.model.KTypeParameter;
import org.jetbrains.kotlin.doc.model.ModelPackage$KotlinModel$508284e7;
import org.jetbrains.kotlin.doc.model.SourceInfo;
import org.pegdown.Extensions;
import org.pegdown.LinkRenderer;
import org.pegdown.PegDownProcessor;

@KotlinClass(abiVersion=19, data={"\u0014\u001e)11*T8eK2T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004I>\u001c'\"B7pI\u0016d'bA!os*1A(\u001b8jizRqaY8oi\u0016DHO\u0003\bCS:$\u0017N\\4D_:$X\r\u001f;\u000b\u0007),GO\u0003\u0003mC:<'b\u0002:fg>dg/\u001a\u0006\u0007G>tg-[4\u000b\u0015-#unY\"p]\u001aLwM\u0003\u0006t_V\u00148-\u001a#jeNTA\u0001T5ti*!a)\u001b7f\u0015\u0011Q\u0017M^1\u000b\u0005%|'bB:pkJ\u001cWm\u001d\u0006\b\u0015\u0016$h)\u001b7f\u0015\r\u00018/\u001b\u0006\u0005kRLGNC\b`aJ|'.Z2u%>|G\u000fR5s\u0015\u0019\u0019FO]5oO*Y\u0011\r\u001c7QC\u000e\\\u0017mZ3t\u0015)\u0019u\u000e\u001c7fGRLwN\u001c\u0006\t\u0017B\u000b7m[1hK*qq-\u001a;BY2\u0004\u0016mY6bO\u0016\u001c(bB2mCN\u001cXm\u001d\u0006\u0007\u0017\u000ec\u0017m]:\u000b\u0015\u001d,Go\u00117bgN,7OC\u0005hKR\u001cuN\u001c4jO*Qq-\u001a;D_:$X\r\u001f;\u000b\u0017!Lw\r\u001b7jO\"$XM\u001d\u0006\u0012'ftG/\u0019=IS\u001eDG.[4ii\u0016\u0014(BD4fi\"Kw\r\u001b7jO\"$XM\u001d\u0006\u000fg\u0016$\b*[4iY&<\u0007\u000e^3s\u0015Ei\u0017M]6e_^t\u0007K]8dKN\u001cxN\u001d\u0006\u0011!\u0016<Gi\\<o!J|7-Z:t_JTq\u0001]3hI><hN\u0003\u000bhKRl\u0015M]6e_^t\u0007K]8dKN\u001cxN\u001d\u0006\u0015g\u0016$X*\u0019:lI><h\u000e\u0015:pG\u0016\u001c8o\u001c:\u000b/A\f7m[1hK\u0012+7o\u0019:jaRLwN\u001c$jY\u0016\u001c(BG4fiB\u000b7m[1hK\u0012+7o\u0019:jaRLwN\u001c$jY\u0016\u001c(B\u00039bG.\fw-Z'ba*I1k\u001c:uK\u0012l\u0015\r\u001d\u0006\u000eO\u0016$\b+Y2lC\u001e,W*\u00199\u000b\u0011A\f7m[1hKNT1bZ3u!\u0006\u001c7.Y4fg*\t\"/Z1e\u001b\u0016$\u0015N]:TG\u0006tg.\u001a3\u000b\u000f!\u000b7\u000f[*fi*iq-\u001a;T_V\u00148-\u001a#jeNT\u0001c]8ve\u000e,\u0017J\u001c4p\u0005f4\u0015\u000e\\3\u000b\u00075\u000b\u0007O\u0003\u0006T_V\u00148-Z%oM>T!bZ3u'>,(oY3t\u0015-\u0019x.\u001e:dKNLeNZ8\u000b\u001d\u001d,GoU8ve\u000e,7/\u00138g_*)A/\u001b;mK*Aq-\u001a;USRdWMC\u0004wKJ\u001c\u0018n\u001c8\u000b\u0015\u001d,GOV3sg&|gN\u0003\u0007bI\u00124UO\\2uS>t7OC\u0003po:,'OC\bL\u00072\f7o](s!\u0006\u001c7.Y4f\u0015\u0015\u00198m\u001c9f\u0015!QU\r^*d_B,'BB:d_B,7O\u0003\u0003V]&$(\"E1eIRK\b/\u001a)be\u0006lW\r^3sg*1\u0011M\\:xKJT1\"T;uC\ndW\rT5ti*q1\nV=qKB\u000b'/Y7fi\u0016\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTq\u0003V=qKB\u000b'/Y7fi\u0016\u0014H)Z:de&\u0004Ho\u001c:\u000b\u0017\r|W.\\3oiN4uN\u001d\u0006\u000bI\u0016\u001c8M]5qi>\u0014(\"\u0006#fG2\f'/\u0019;j_:$Um]2sSB$xN\u001d\u0006\u0012G>tg-[4ve\u0016\u001cu.\\7f]R\u001c(\"C1o]>$\u0018\r^3e\u0015)Y\u0015I\u001c8pi\u0006$X\r\u001a\u0006\u000fGJ,\u0017\r^3Gk:\u001cG/[8o\u0015I\u0019\u0015\r\u001c7bE2,G)Z:de&\u0004Ho\u001c:\u000b\u0013-3UO\\2uS>t'\"D2sK\u0006$X\rU1dW\u0006<WMC\rQC\u000e\\\u0017mZ3Ge\u0006<W.\u001a8u\t\u0016\u001c8M]5qi>\u0014(\u0002\u00028b[\u0016Tqb\u0019:fCR,\u0007+\u0019:b[\u0016$XM\u001d\u0006\u0019-\u0006dW/\u001a)be\u0006lW\r^3s\t\u0016\u001c8M]5qi>\u0014(BC&QCJ\fW.\u001a;fe*\u00192M]3bi\u0016$\u0016\u0010]3QCJ\fW.\u001a;fe*aQ\r\u001f;sC\u000e$(\t\\8dW*!A/\u001a=u\u0015\u001d1\u0017\u000e\\3G_JT\u0001BZ5mKB\u000bG\u000f\u001b\u0006\u0005M&dWMC\tQg&4\u0015\u000e\\3TsN$X-\\%uK6T1aY8n\u0015!Ig\u000e^3mY&T'b\u00054j]\u00124UO\\2uS>t\u0017J\\2mk\u0012,'B\u00039tS\u0016cW-\\3oi*Q\u0001k]5FY\u0016lWM\u001c;\u000b\u0017%t7\r\\;eK\u001aKG.\u001a\u0006\rMVt7\r^5p]:\u000bW.\u001a\u0006\tO\u0016$8\t\\1tg*i\u0011/^1mS\u001aLW\r\u001a(b[\u0016TAb\u00197bgN,E.Z7f]RTqb\u00117bgN$Um]2sSB$xN\u001d\u0006\u0013O\u0016$xJ]\"sK\u0006$X\rU1dW\u0006<WM\u0003\u0006hKR\u0004\u0016mY6bO\u0016TQbZ3u!NLW\t\\3nK:$(bB4fiRK\b/\u001a\u0006\u0006CRK\b/\u001a\u0006\b\u0015\u0016$H+\u001f9f\u0015\u0015!\u0018\u0010]3t\u0015\u0015YE+\u001f9f\u0015Maw.\u00193XS.LG)Z:de&\u0004H/[8o\u0015\r\u00018n\u001a\u0006\fY>\u001c\u0017\r^5p]\u001a{'OC\u0007MS:,\u0017I\u001c3D_2,XN\u001c\u0006\u0010\t&\fwM\\8ti&\u001cW\u000b^5mg*YA-[1h]>\u001cH/[2t\u0015u!\u0015.Y4o_N$\u0018nY+uS2\u001cH\u0005T5oK\u0006sGmQ8mk6t'\u0002\u00028fqRT\u0001\u0002\u001d:fm&|Wo\u001d\u0006\u000eaJ|7-Z:t\u001b\u0006\u001c'o\\:\u000b%Q,\u0007\u0010^,ji\"<\u0006.\u001b;fgB\f7-\u001a\u0006\u000faJ|'.Z2u%>|G\u000fR5s\u00151\u0011X\r\\1uSZ,g)\u001b7f\u0015%!\u0017N]3di>\u0014\u0018P\u0003\u0007Qg&$\u0015N]3di>\u0014\u0018P\u0003\u0007sK2\fG/\u001b<f\u001d\u0006lWMC\u0004Qg&4\u0015\u000e\\3\u000b\u001bM|WO]2f\u0019&t7NR8s\u0015)\u0019x.\u001e:dK2Kg.\u001a\u0006\u0004\u0013:$(\u0002\u00047j]\u0016d\u0015N\\6UKb$(\"\u0004;ss2{\u0017\r\u001a*fC\u0012lUMC\u0006xS.L7i\u001c8wKJ$(\u0002\u00047j].\u0014VM\u001c3fe\u0016\u0014(\u0002\u0004'j].\u0014VM\u001c3fe\u0016\u0014(\u0002\u00034jY\u0016t\u0015-\\3\u001e\f)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0002\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0011A\u0011\u0001\u0005\u0006\u000b\t!A\u0001c\u0003\u0006\u0005\u0011%\u0001BB\u0003\u0004\t\u0015AI\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001b\u0002\u0007\u0001\u000b\r!1\u0001\u0003\u0005\r\u0001\u0015\t\u0001\"C\u0003\u0003\t\u001dA\u0019\"B\u0002\u0005\u0010!EA\u0002A\u0003\u0003\t\u0013A1\"B\u0002\u0005\u0012!UA\u0002A\u0003\u0003\t\u0015AI!\u0002\u0002\u0005\u0004!9QA\u0001\u0003\b\u0011/)!\u0001\"\u0006\t\u0011\u0015\u0019Aa\u0001E\r\u0019\u0001)!\u0001B\u0004\t\f\u0015\u0011A\u0001\u0004E\r\u000b\r!1\u0001c\u0007\r\u0001\u0015\u0019AA\u0001\u0005\u000f\u0019\u0001)!\u0001\"\u0006\t\u001c\u0015\u0019AA\u0001E\u0010\u0019\u0001)!\u0001b\u0001\t$\u0015\u0019Aa\u0004\u0005\u0013\u0019\u0001)!\u0001B\b\t%\u0015\u0011A\u0001\u0001E\u0015\u000b\r!\t\u0003\u0003\u000b\r\u0001\u0015\u0011A\u0011\u0005\u0005\u0015\u000b\r!)\u0002c\f\r\u0001\u0015\u0011AQ\u0003E\u0018\u000b\r!)\u0002\u0003\u000e\r\u0001\u0015\u0011AQ\u0003\u0005\u001b\u000b\r!1\u0001c\u000e\r\u0001\u0015\u0019AA\u0001\u0005\u001d\u0019\u0001)!\u0001\"\u0006\t8\u0015\u0019AA\u0001\u0005\"\u0019\u0001)!\u0001B\u0003\tF\u0015\u0019AA\u0006\u0005#\u0019\u0001)1\u0001B\u0002\tG1\u0001QA\u0001\u0003\u0003\u0011\u0005*!\u0001\u0002\f\tE\u0015\u0019Aa\u0001E%\u0019\u0001)1\u0001\u0002\u0002\tK1\u0001QA\u0001C\u0005\u0011\u0017*1\u0001b\r\tM1\u0001Qa\u0001C\u001a\u0011\u001fb\u0001!\u0002\u0002\u00054!=Sa\u0001\u0003\u0003\u0011%b\u0001!\u0002\u0002\u0005\u0005!ISa\u0001C\u001a\u0011)b\u0001!B\u0002\u0005\u0005!UC\u0002A\u0003\u0003\t\tA)&\u0002\u0002\u00054!QSa\u0001C\u001a\u0011/b\u0001!\u0002\u0002\u0005\u0005!qQa\u0001C\u001a\u00115b\u0001!B\u0002\u0005\u0005!mC\u0002A\u0003\u0003\t\tAY&\u0002\u0002\u00054!iSA\u0001\u0003\u0003\u0011\u0015*!\u0001b\r\tM\u0015\t\u00012M\u0003\u0003\t\u000bB!'\u0002\u0002\u0005G!YQa\u0001C$\u0011Eb\u0001!\u0002\u0002\u0005H!\tTa\u0001C$\u0011Ob\u0001!\u0002\u0002\u0005H!\u001dTA\u0001\u0003\u0003\u0011?)1\u0001b\r\tn1\u0001QA\u0001C\u001a\u0011[*!\u0001b\r\tX\u0015\u0011A\u0011\u0002\u0005;\u000b\r!\u0001\u0006c\u001d\r\u0001\u0015\u0019AA\u0001E;\u0019\u0001)!\u0001\u0002\u0002\tv\u0015\u0011A\u0001\u000bE:\u000b\t!I\u0001c\u001f\u0006\u0007\u0011U\u0003\"\u0010\u0007\u0001\u000b\r!1\u0006#\u001f\r\u0001\u0015\u0011AQ\u000b\u0005?\u000b\u000f!9\u0005\u0003b\u0001\u0019\u0001)9\u0001b\u0012\t\u0007\u0004a\u0001!\"\u0002\u0005H!\u0019\r!\"\u0002\u0005H!\u0011\r!\u0002\u0002\u0005\u0005!aRA\u0001C\t\u0011+)9\u0001B\u0002\t\n\u0004a\u0001!b\u0002\u0005\"!9\r\u0001\u0004\u0001\u0006\u0006\u0011\u0005\u0002b2\u0001\u0005\u00011\u0015\u0011DA\u0003\u0002\u0011\u000fiC\u0002Ba\r11\t3!B\u0001\t\u00181\u0005Qk\u0001\u0003\u0006\u0007\u0011a\u0011\"\u0001E\r[A!\u0001\r\u0002\r\u000eC\u0019)\u0011\u0001C\u0007\n\u0007%\u0011Q!\u0001E\u000eI\u0001*6\u0001B\u0007\u0004\t;I\u0011\u0001\u0003\b.!\u0011\u0001G\u0001G\b\"\r\u0015\t\u0001\"D\u0005\u0004\u0013\t)\u0011\u0001#\b%AU\u001bA!D\u0002\u0005!%\t\u0001BD\u0017\u0010\t\u0001$\u0001TB\u0011\u0003\u000b\u0005Aa!V\u0002\t\u000b\r!i!C\u0001\t\u00155\u0019A\u0011E\u0005\u0002\u0011)is\u0002\u00021\u00051\u0011\t#!B\u0001\t\fU\u001b\u0001\"B\u0002\u0005\t%\t\u00012C\u0007\u0004\tEI\u0011\u0001c\u0005.+\u0011\u0001M\u0002g\t\"\u0005\u0015\t\u0001rD+\u0004\u001d\u0015\u0019A1E\u0005\u0002\u0011Ai1\u0001\"\n\n\u0003!\u0001\u0012#\u0002\u0003\u0014\u0013\u0005!\u0001!D\u0001\t!5*B\u00011\u0007\u0019(\u0005\u0012Q!\u0001\u0005\u0012+\u000eqQa\u0001C\u0014\u0013\u0005A\u0019#D\u0002\u0005+%\t\u00012E\t\u0006\tWI\u0011\u0001\u0002\u0001\u000e\u0003!\rRf\u0005\u0003a\ta1\u0012EB\u0003\u0002\u0011\u001bI1!\u0003\u0002\u0006\u0003!]Qk\u0001\u0005\u0006\u0007\u00111\u0012\"\u0001\u0005\f\u001b\r!i#C\u0001\t\u00175:B\u0001\u0019\u0003\u0019/\u0005RQ!\u0001\u0005\u0013\u0013\rI!!B\u0001\t\u0018%\u0019\u0011BA\u0003\u0002\u00117)6\u0001C\u0003\u0004\t]I\u0011\u0001#\n\u000e\u0007\u0011A\u0012\"\u0001E\u0013[A!\u0001\r\u0002M\u0019C\u0019)\u0011\u0001C\u0007\n\u0007%\u0011Q!\u0001E\u000eI\u0001*6\u0001B\u0007\u0004\teI\u0011\u0001\u0003\b.\u001f\u0011\tG\u0001g\r\"\r\u0015\t\u0001bE\u0005\u0004\u0013\t)\u0011\u0001c\u0006V\u0007\u0011)1\u0001b\r\n\u0003!\u001dRf\u0005\u0003a\ta=\u0011EB\u0003\u0002\u0011\u001bI1!\u0003\u0002\u0006\u0003!AQk\u0001\u0005\u0006\u0007\u0011=\u0011\"\u0001\u0005\f\u001b\r!)$C\u0001\t\u00175\u001aB!\u0019\u0003\u00197\u0005RQ!\u0001\u0005\u0015\u0013\rI!!B\u0001\t\u0013%\u0019\u0011BA\u0003\u0002\u0011S)6\u0001B\u0003\u0004\tmI\u0011\u0001C\u000b.'\u0011\u0001G\u0001\u0007\u0006\"\r\u0015\t\u0001RB\u0005\u0004\u0013\t)\u0011\u0001C\u0005V\u0007!)1\u0001\u0002\u0006\n\u0003!YQb\u0001C\u001d\u0013\u0005A1\"L\n\u0005A\u0012AR$\t\u0004\u0006\u0003!5\u0011bA\u0005\u0003\u000b\u0005AI#V\u0002\t\u000b\r!Q$C\u0001\t\u00175\u0019A1H\u0005\u0002\u0011-iC\u0002\u00021\u00051y\t#!B\u0001\t\u0018\u0011\u0002Sk\u0001\u0003\u000e\u0007\u0011u\u0012\"\u0001E\r[1!\u0001\r\u0002\r C\t)\u0011\u0001c\u0006%AU\u001bA!D\u0002\u0005@%\t\u0001\u0012DW\u001d\t\u0001A\u0002%(\u0004\u0005\u0001!\u0005SBA\u0003\u0002\u0011W\u00016\u0001AO\u0007\t\u0001A\u0019%\u0004\u0002\u0006\u0003!5\u0002k!\u0001\"\u0005\u0015\t\u0001bF)\u0004\u000f\u0011\u0001\u0013\"\u0001\u0003\u0001\u001b\u0005Ay#D\u0001\t15.C\u0001\u0001M$;+!\u0001\u0001\u0003\u0013\u000e\r\u0015\t\u0001\u0012G\u0005\u0004\u0013\t)\u0011\u0001C\rQ\u0007\u0001i:\u0002\u0002\u0001\tL59Q!\u0001E\u0007\u0013\u0011I1!B\u0001\t51\u0005\u0001k!\u0001\"\u0005\u0015\t\u0001bF)\u0004\u000f\u0011\u001d\u0013\"\u0001\u0003\u0001\u001b\u0005A1\"D\u0001\t\u00175\u001aBA\u0001M';\u001b!\u0001\u0001C\u0014\u000e\u0005\u0015\t\u0001R\u0007)\u0004\u0001\u0005\u0012Q!\u0001E\f#\u000e)AQJ\u0005\u0002\u00113i\u0011\u0001C\u000e.:\u0011\u0001\u0001\u0004KO\u0007\t\u0001A\t&\u0004\u0002\u0006\u0003!]\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001bJ\u0007\u0003\u000b\u0005A)\u0004UB\u0001C\t)\u0011\u0001C\fR\u0007\u001d!\u0001&C\u0001\u0005\u00015\t\u0001\u0002H\u0007\u0002\u0011mi[\u0004\u0002\u0002\u0019Tu5A\u0001\u0001E!\u001b\t)\u0011\u0001c\u000bQ\u0007\u0001ij\u0001\u0002\u0001\tO5\u0011Q!\u0001E\u001d!\u000e\u0005\u0011eA\u0003\u0002\u0011ua\t!U\u0002\b\t'J\u0011\u0001c\u000f\u000e\u0003!=R\"\u0001\u0005\u001f[\u0003\"\u0011\u0001G\u0016\u001e\u0016\u0011\u0001\u00012J\u0007\u0007\u000b\u0005Ai!C\u0002\n\u0005\u0015\t\u0001R\b)\u0004\u0001u5A\u0001\u0001\u0005-\u001b\t)\u0011\u0001c\u0006Q\u0007\u0003\t#!B\u0001\t\u001cE\u001bq\u0001B\u0016\n\u0003!yR\"\u0001\u0005\f\u001b\u0005AI\"\f\u000b\u0005\u0005aeST\u0002\u0003\u0001\u0011\u001dj!!B\u0001\t@A\u001b\u0001!I\u0002\u0006\u0003!\u0001C\u0012A)\u0004\u000b\u0011e\u0013\"\u0001E!\u001b\u0005A\u0011%\f\u000b\u0005\u0005aqST\u0002\u0003\u0001\u0011\u001dj!!B\u0001\t5A\u001b\u0001!I\u0002\u0006\u0003!IB\u0012A)\u0004\u000b\u0011q\u0013\"\u0001E\"\u001b\u0005A!%\f\u000b\u0005\u0005auST\u0002\u0003\u0001\u0011=j!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!]A\u0012A)\u0004\u000b\u0011u\u0013\"\u0001E\r\u001b\u0005AI\"\f\u000b\u0005\u0001a}ST\u0002\u0003\u0001\u0011\u001dj!!B\u0001\t6A\u001b\u0001!I\u0002\u0006\u0003!]A\u0012A)\u0004\u000b\u0011}\u0013\"\u0001E\r\u001b\u0005A1$L\u000b\u0005\u0005a\u0001Tt\u0002\u0003\u0001\u0011Cj1!B\u0001\tI1\u0005\u0001k\u0001\u0001\"\u0007\u0015\t\u0001r\u0003G\u0001#\u000e)A\u0001M\u0005\u0002\u00113i\u0011\u0001#\u0013.)\u0011\u0001\u0001\u0004MO\u0007\t\u0001Aq%\u0004\u0002\u0006\u0003!U\u0002k\u0001\u0001\"\u0007\u0015\t\u0001r\u0003G\u0001#\u000e)A\u0001M\u0005\u0002\u00113i\u0011\u0001C\u000e.O\u0011\u0011\u0001TMO\u0007\t\u0001A1'\u0004\u0002\u0006\u0003!)\u0003k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0002N\u0007\u0003\u000b\u0005A9\u0002UB\u0001;\u001b!\u0001\u0001#\u001b\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0003\u0005\u001aQ!\u0001E\f\u0019\u0003\t6!\u0003C3\u0013\u0005AI\"D\u0001\tL5\t\u0001\u0012D\u0007\u0002\u00113iC\u0003\u0002\u0001\u0019ku5A\u0001\u0001E6\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001\t3!B\u0001\t\u001e1\u0005\u0011kA\u0003\u0005k%\t\u0001BJ\u0007\u0002\u00113iC\u0003\u0002\u0001\u0019ku5A\u0001\u0001\u00057\u001b\t)\u0011\u0001#\u0014Q\u0007\u0001\t3!B\u0001\t\u001e1\u0005\u0011kA\u0003\u0005k%\t\u0001BJ\u0007\u0002\u0011\u001dj3\u0003\u0002\u0001\u0019ou5A\u0001\u0001\u0005(\u001b\t)\u0011\u0001#\u0010Q\u0007\u0001\t#!B\u0001\t\u001cE\u001bQ\u0001B\u001c\n\u0003!yR\"\u0001E([Q!\u0001\u0001g\u001c\u001e\u000e\u0011\u0001\u0001\u0002L\u0007\u0003\u000b\u0005A9\u0002U\u0002\u0001C\r)\u0011\u0001c\u0007\r\u0002E\u001bQ\u0001b\u001c\n\u0003!yR\"\u0001E\r[Q!\u0001\u0001\u0007\u001d\u001e\u000e\u0011\u0001\u0001bJ\u0007\u0003\u000b\u0005A)\u0004U\u0002\u0001C\r)\u0011\u0001C\u0013\r\u0002E\u001bQ\u0001\u0002\u001d\n\u0003!-S\"\u0001\u0005\u001c[U!\u0001\u0001'\u001d\u001e\u0010\u0011\u0001\u0001\"O\u0007\u0004\u000b\u0005A\t\u0006$\u0001Q\u0007\u0001\t3!B\u0001\tS1\u0005\u0011kA\u0003\u0005r%\t\u00012K\u0007\u0002\u0011)j[\u0004\u0002\u0002\u0019wu5A\u0001\u0001E<\u001b\t)\u0011\u0001c\u0007Q\u0007\u0001iz\u0001\u0002\u0001\tb5\u0019Q!\u0001E\f\u0019\u0003\u00016\u0011A\u0011\u0003\u000b\u0005Aq#U\u0002\b\tmJ\u0011\u0001\u0002\u0001\u000e\u0003!yR\"\u0001E\r[Q!\u0001\u0001\u0007\u001f\u001e\u000e\u0011\u0001\u0001bJ\u0007\u0003\u000b\u0005A)\u0004U\u0002\u0001C\r)\u0011\u0001c\u0016\r\u0002E\u001bQ\u0001\u0002\u001f\n\u0003!aS\"\u0001\u0005\u001c[Q!\u0001\u0001' \u001e\u000e\u0011\u0001\u0001rO\u0007\u0003\u000b\u0005AY\u0002U\u0002\u0001C\r)\u0011\u0001c\u0007\r\u0002E\u001bQ\u0001\" \n\u0003!yR\"\u0001\u0005 [Q!\u0001\u0001G \u001e\u000e\u0011\u0001\u0001rO\u0007\u0003\u000b\u0005AY\u0002U\u0002\u0001C\r)\u0011\u0001c\u0007\r\u0002E\u001bQ\u0001B \n\u0003!yR\"\u0001\u0005 [u!!\u0001g \u001e\u000f\u0011\u0001\u0001\u00021\u0001\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0001u5A\u0001\u0001\u00054\u001b\t)\u0011\u0001C\u0013Q\u0007\u0003\t#!B\u0001\t\u0018E\u001bq\u0001b \n\u0003!eQ\"\u0001E\r\u001b\u0005AY%,\u0006\u0005\u0001a\u0005\r!\t\u0002\u0006\u0003!]\u0011ka\u0002\u0005\u0002\u0004I\u0011\u0001#\u0007.@\u0011\u0011\u0001$1\u0001\u001e\u000f\u0011\u0001\u000121\u0001\u000e\u0005\u0015\t\u0001\u0012\f)\u0004\u0001u9A\u0001\u0001EC\u00025\u0011Q!\u0001E\f!\u000e\u0005\u0011eA\u0003\u0002\u00115b\t!UB\b\t\u0005\u0007\u0011\"\u0001E.\u001b\u0005Aa&D\u0001\t\u001a5\u001aB\u0001\u0001\r\u001c;\u001b!\u0001\u0001#\u0019\u000e\u0005\u0015\t\u0001\"\u0003)\u0004\u0001\u0005\u0012Q!\u0001E\u0015#\u000e)AaG\u0005\u0002\u0011;j\u0011\u0001C\u0018.S\u0011\u0001\u0001t1\u0001\u001e\u000e\u0011\u0001\u0001\u0002M\u0007\u0003\u000b\u0005A9\u0002U\u0002\u0001;\u001d!\u0001\u0001\u0003c\u0001\u001b\t)\u0011\u0001c\u0018Q\u0007\u0003ir\u0001B\u0001\t\u000b\u0004i!!B\u0001\t\u0018A\u001b\u0011!I\u0002\u0006\u0003!]A\u0012A)\u0004\u0014\u0011\u001d\r!C\u0001\t\u001a5\t\u0001\u0012D\u0007\u0002\t\u000bi\u0011\u0001#\u0007.<\u0011\u0001\u000142\u0001\u001e\u000e\u0011\u0001\u0001rO\u0007\u0003\u000b\u0005AY\u0002U\u0002\u0001;\u001b!\u0001\u0001C\u0014\u000e\u0005\u0015\t\u0001R\u0007)\u0004\u0002\u0005\u0012Q!\u0001\u0005\u0018#\u000e=A12\u0001\n\u0003\u0011\u0001Q\"\u0001\u0005 \u001b\u0005A1$L\u0015\u0005\u0001a1\r!(\u0004\u0005\u0001!ySBA\u0003\u0002\u0011/\u00016\u0001A\u000f\b\t\u0001Ai\u0019A\u0007\u0003\u000b\u0005A\u0001\u0007UB\u0001;!!\u0001\u0001cd\u0001\u001b\r)\u0011\u0001c\u0006\r\u0002A\u001b\u0011!\t\u0002\u0006\u0003!]\u0011ka\u0005\u0005\r\u0004I\u0011\u0001#\u0007\u000e\u0003!eQ\"\u0001E1\u001b\u0005AI\"N\u001d\u0006q\u0011\u0019\u000f\u0001g\u0002\u001e\u000e\u0011\u0001\u0001\u0002B\u0007\u0003\u000b\u0005AY\u0001U\u0002\u0001;\u001b!\u0001\u0001#\u0004\u000e\u0005\u0015\t\u0001B\u0002)\u0004\u0002uUA\u0001\u0001E\b\u001b\u0019)\u0011\u0001#\u0004\n\u0007%\u0011Q!\u0001\u0005\t!\u000e\tQT\u0003\u0003\u0001\u0011)ia!B\u0001\t\u000e%\u0019\u0011BA\u0003\u0002\u0011%\u000161A\u0011\u0003\u000b\u0005A)!U\u0002\f\t\u000fI\u0011\u0001\u0002\u0001\u000e\u0003!MQ\"\u0001\u0005\u000b\u001b\u0005A1\"D\u0001\t\u0017\u0001"})
public final class KModel
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private final SortedMap<String, KPackage> packageMap;
    @NotNull
    private PegDownProcessor markdownProcessor;
    @NotNull
    private SyntaxHighlighter highlighter;
    private String _projectRootDir;
    @NotNull
    private final List<? extends String> packageDescriptionFiles;
    private final HashSet<String> readMeDirsScanned;
    @NotNull
    private final List<? extends SourceInfo> sourcesInfo;
    private final Map<JetFile, ? extends SourceInfo> sourceInfoByFile;
    @NotNull
    private final BindingContext context;
    @NotNull
    private final KDocConfig config;
    @NotNull
    private final List<? extends File> sourceDirs;
    @NotNull
    private final List<? extends JetFile> sources;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(KModel.class);
    }

    @NotNull
    public final SortedMap<String, KPackage> getPackageMap() {
        return this.packageMap;
    }

    @NotNull
    public final Collection<KPackage> getAllPackages() {
        Collection<KPackage> collection = this.packageMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"packageMap.values()");
        return collection;
    }

    @NotNull
    public final Collection<KPackage> getPackages() {
        Iterable iterable;
        Iterable iterable2 = iterable = (Iterable)this.getAllPackages();
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            KPackage it = (KPackage)t;
            if (!this.getConfig().includePackage(it)) continue;
            collection.add(t);
        }
        return (ArrayList)collection;
    }

    @NotNull
    public final Collection<KClass> getClasses() {
        Iterable iterable;
        Iterable iterable2 = iterable = (Iterable)this.getPackages();
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            KPackage it = (KPackage)t;
            Iterable iterable3 = it.getClasses();
            KotlinPackage.addAll((Collection)collection, (Iterable)iterable3);
        }
        return (ArrayList)collection;
    }

    @NotNull
    public final PegDownProcessor getMarkdownProcessor() {
        return this.markdownProcessor;
    }

    public final void setMarkdownProcessor(@JetValueParameter(name="<set-?>") @NotNull PegDownProcessor pegDownProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)pegDownProcessor, (String)"<set-?>");
        this.markdownProcessor = pegDownProcessor;
    }

    @NotNull
    public final SyntaxHighlighter getHighlighter() {
        return this.highlighter;
    }

    public final void setHighlighter(@JetValueParameter(name="<set-?>") @NotNull SyntaxHighlighter syntaxHighlighter) {
        Intrinsics.checkParameterIsNotNull((Object)syntaxHighlighter, (String)"<set-?>");
        this.highlighter = syntaxHighlighter;
    }

    @NotNull
    public final String getTitle() {
        return this.config.getTitle();
    }

    @NotNull
    public final String getVersion() {
        return this.config.getVersion();
    }

    @NotNull
    public final List<String> getPackageDescriptionFiles() {
        return this.packageDescriptionFiles;
    }

    @NotNull
    public final List<SourceInfo> getSourcesInfo() {
        return this.sourcesInfo;
    }

    @NotNull
    public final SourceInfo sourceInfoByFile(@JetValueParameter(name="file") @NotNull JetFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        SourceInfo sourceInfo = this.sourceInfoByFile.get(file);
        if (sourceInfo == null) {
            Intrinsics.throwNpe();
        }
        return sourceInfo;
    }

    @NotNull
    public final String projectRootDir() {
        String string;
        if (this._projectRootDir == null) {
            String string2;
            String rootDir = this.config.getProjectRootDir();
            if (rootDir == null) {
                ModelPackage$KotlinModel$508284e7.warning("KDocConfig does not have a projectRootDir defined so we cannot generate relative source Hrefs");
                string2 = "";
            } else {
                string2 = this._projectRootDir = new File(rootDir).getCanonicalPath();
            }
        }
        if ((string = this._projectRootDir) == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final KPackage getPackage(@JetValueParameter(name="name") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (KPackage)this.packageMap.get(name);
    }

    @NotNull
    public final KPackage getOrCreatePackage(@JetValueParameter(name="descriptor") @NotNull PackageFragmentDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        String name = ModelPackage$KotlinModel$508284e7.qualifiedName((DeclarationDescriptor)descriptor);
        KPackage pkg = (KPackage)this.packageMap.get(name);
        if (pkg != null) {
            return pkg;
        }
        return this.createPackage(KotlinPackage.listOf((Object[])new PackageFragmentDescriptor[]{descriptor}), name);
    }

    private final KPackage createPackage(@JetValueParameter(name="descriptors") List<? extends PackageFragmentDescriptor> descriptors, @JetValueParameter(name="name") String name) {
        boolean bl;
        KPackage pkg = new KPackage(this, descriptors, name, KotlinPackage.isNotEmpty((String)this.config.resolveLink(name, false)));
        boolean bl2 = bl = !this.packageMap.containsKey(name);
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String string = "packageMap entry created earlier for package " + name + ": old=" + (KPackage)this.getPackageMap().get(name) + ", new=" + pkg;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinPackage.set((Map)this.packageMap, (Object)name, (Object)pkg);
        for (PackageFragmentDescriptor packageFragmentDescriptor : descriptors) {
            this.addFunctions(pkg, packageFragmentDescriptor.getMemberScope());
        }
        String string = this.config.getPackageDescriptionFiles().get(name);
        this.loadWikiDescription(pkg, string);
        return pkg;
    }

    protected final void loadWikiDescription(@JetValueParameter(name="pkg") @NotNull KPackage pkg, @JetValueParameter(name="file", type="?") @Nullable String file) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        if (file != null) {
            try {
                ((KAnnotated)pkg).setWikiDescription(IoPackage.readText$default((File)new File(file), null, (int)1));
            }
            catch (Throwable e) {
                ModelPackage$KotlinModel$508284e7.warning("Failed to load package " + pkg.getName() + " documentation file " + file + ". Reason " + e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void tryLoadReadMe(@JetValueParameter(name="pkg") @NotNull KPackage pkg, @JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        File srcFile;
        File dir;
        String srcPath;
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        if (KotlinPackage.isEmpty((String)((KAnnotated)pkg).getWikiDescription()) && (srcPath = ((KAnnotated)pkg).getModel().filePath(descriptor)) != null && ((dir = (srcFile = new File(srcPath)).isDirectory() ? srcFile : srcFile.getParentFile()) != null ? this.readMeDirsScanned.add(dir.getPath()) : false)) {
            Iterator<Object> iterator;
            block5: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)this.packageDescriptionFiles;
                Collection collection = new ArrayList();
                for (Object t : iterable2) {
                    void it;
                    String string = (String)t;
                    Collection collection2 = collection;
                    File file = new File(dir, (String)it);
                    collection2.add(file);
                }
                iterable2 = iterable = (Iterable)((ArrayList)collection);
                for (Iterator<Object> iterator2 : iterable2) {
                    File it = (File)((Object)iterator2);
                    if (!it.exists()) continue;
                    iterator = iterator2;
                    break block5;
                }
                iterator = null;
            }
            File f = (File)((Object)iterator);
            if (f != null) {
                String file = f.getCanonicalPath();
                this.loadWikiDescription(pkg, file);
            } else {
                ModelPackage$KotlinModel$508284e7.info("package " + pkg.getName() + " has no ReadMe.(html|md) in " + dir);
            }
        }
    }

    @NotNull
    public final String wikiConvert(@JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="linkRenderer") @NotNull LinkRenderer linkRenderer, @JetValueParameter(name="fileName", type="?") @Nullable String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)linkRenderer, (String)"linkRenderer");
        String string = this.markdownProcessor.markdownToHtml(text, linkRenderer);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Nullable
    public final String sourceLinkFor(@JetValueParameter(name="filePath") @NotNull String filePath, @JetValueParameter(name="sourceLine") int sourceLine, @JetValueParameter(name="lineLinkText") @NotNull String lineLinkText) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)lineLinkText, (String)"lineLinkText");
        String root = this.config.getSourceRootHref();
        if (root != null) {
            String rootDir = this.projectRootDir();
            String canonicalFile = new File(filePath).getCanonicalPath();
            String relativeFile = KotlinPackage.startsWith((String)canonicalFile, (String)rootDir) ? KotlinPackage.substring((String)canonicalFile, (int)KotlinPackage.length((String)rootDir)) : canonicalFile;
            String cleanRoot = KotlinPackage.trimTrailing((String)root, (String)"/");
            String cleanPath = KotlinPackage.trimLeading((String)relativeFile, (String)"/");
            return cleanRoot + "/" + cleanPath + lineLinkText + sourceLine;
        }
        return null;
    }

    public static String sourceLinkFor$default(KModel kModel, String string, int n, String string2, int n2) {
        if ((n2 & 4) != 0) {
            string2 = "#L";
        }
        return kModel.sourceLinkFor(string, n, string2);
    }

    public final void addFunctions(@JetValueParameter(name="owner") @NotNull KClassOrPackage owner, @JetValueParameter(name="scope") @NotNull JetScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        try {
            Collection descriptors = scope.getAllDescriptors();
            for (DeclarationDescriptor descriptor : descriptors) {
                KFunction function;
                if (descriptor instanceof PropertyDescriptor) {
                    String name = ((PropertyDescriptor)descriptor).getName().asString();
                    KType returnType = this.getType(((PropertyDescriptor)descriptor).getReturnType());
                    if (!(returnType != null)) continue;
                    ReceiverParameterDescriptor receiver = ((PropertyDescriptor)descriptor).getExtensionReceiverParameter();
                    KType extensionClass = receiver != null ? this.getType(receiver.getType()) : (KType)null;
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                    String string = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                    KType kType = extensionClass;
                    KProperty property = new KProperty(owner, propertyDescriptor, string, returnType, kType != null ? kType.getKlass() : null);
                    owner.getProperties().add(property);
                    continue;
                }
                if (!(descriptor instanceof CallableDescriptor) || !((function = this.createFunction(owner, (CallableDescriptor)descriptor)) != null)) continue;
                owner.getFunctions().add(function);
            }
        }
        catch (Throwable e) {
            ModelPackage$KotlinModel$508284e7.warning("Caught exception finding function declarations on " + owner + " " + e);
            e.printStackTrace();
        }
    }

    @Nullable
    protected final KFunction createFunction(@JetValueParameter(name="owner") @NotNull KClassOrPackage owner, @JetValueParameter(name="descriptor") @NotNull CallableDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        KType returnType = this.getType(descriptor.getReturnType());
        if (returnType != null) {
            String name = descriptor.getName().asString();
            ArrayList<KParameter> parameters = new ArrayList<KParameter>();
            List params = descriptor.getValueParameters();
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                ValueParameterDescriptor param;
                ValueParameterDescriptor valueParameterDescriptor = param = (ValueParameterDescriptor)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"param");
                KParameter p = this.createParameter(valueParameterDescriptor);
                if (!(p != null)) continue;
                parameters.add(p);
            }
            String string = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            KFunction function = new KFunction(descriptor, owner, string, returnType, parameters, null, null, null, null, null, null, 2016);
            List<KTypeParameter> list = function.getTypeParameters();
            List list2 = descriptor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"descriptor.getTypeParameters()");
            this.addTypeParameters(list, list2);
            this.configureComments(function, (DeclarationDescriptor)descriptor);
            ReceiverParameterDescriptor receiver = descriptor.getExtensionReceiverParameter();
            if (receiver != null) {
                KType receiverType = this.getType(receiver.getType());
                function.setReceiverType(receiverType);
                KType kType = receiverType;
                function.setExtensionClass(kType != null ? kType.getKlass() : null);
            }
            return function;
        }
        return null;
    }

    public final void addTypeParameters(@JetValueParameter(name="answer") @NotNull List<KTypeParameter> answer, @JetValueParameter(name="descriptors") @NotNull List<? extends TypeParameterDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(answer, (String)"answer");
        Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
        for (TypeParameterDescriptor typeParameterDescriptor : descriptors) {
            KTypeParameter p;
            if (!(typeParameterDescriptor != null) || !((p = this.createTypeParameter(typeParameterDescriptor)) != null)) continue;
            answer.add(p);
        }
    }

    @Nullable
    protected final KTypeParameter createTypeParameter(@JetValueParameter(name="descriptor") @NotNull TypeParameterDescriptor descriptor) {
        String name;
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        String string = name = descriptor.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        KTypeParameter answer = new KTypeParameter(string, descriptor, this, null, 8);
        this.configureComments(answer, (DeclarationDescriptor)descriptor);
        return answer;
    }

    @Nullable
    protected final KParameter createParameter(@JetValueParameter(name="descriptor") @NotNull ValueParameterDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        KType returnType = this.getType(descriptor.getReturnType());
        if (returnType != null) {
            String name;
            String string = name = descriptor.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            KParameter answer = new KParameter(descriptor, string, returnType);
            this.configureComments(answer, (DeclarationDescriptor)descriptor);
            return answer;
        }
        return null;
    }

    @Nullable
    public final DiagnosticUtils.LineAndColumn locationFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = this.getPsiElement(descriptor);
        if (psiElement != null) {
            Document document;
            PsiFile psiFile = psiElement.getContainingFile();
            Document document2 = document = psiFile != null && (psiFile = psiFile.getViewProvider()) != null ? psiFile.getDocument() : null;
            if (document != null) {
                int offset = psiElement.getTextOffset();
                return DiagnosticUtils.offsetToLineAndColumn((Document)document, (int)offset);
            }
        }
        return null;
    }

    @Nullable
    public final String fileFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = this.getPsiElement(descriptor);
        PsiElement psiElement2 = psiElement;
        return psiElement2 != null && (psiElement2 = psiElement2.getContainingFile()) != null ? psiElement2.getName() : null;
    }

    @Nullable
    public final String filePath(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement2 = psiElement = this.getPsiElement(descriptor);
        PsiFile file = psiElement2 != null ? psiElement2.getContainingFile() : null;
        return this.filePath((PsiFileSystemItem)file);
    }

    @Nullable
    public final PsiElement getPsiElement(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        try {
            psiElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)descriptor);
        }
        catch (Throwable e) {
            psiElement = null;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String commentsFor(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = this.getPsiElement(descriptor);
        if (psiElement != null) {
            ASTNode aSTNode = psiElement.getNode();
            ASTNode node = aSTNode != null ? aSTNode.getTreePrev() : null;
            while (true) {
                boolean bl;
                if (node != null) {
                    ASTNode aSTNode2 = node;
                    if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)JetTokens.WHITE_SPACE)) {
                        ASTNode aSTNode3 = node;
                        bl = Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)JetTokens.BLOCK_COMMENT);
                    } else {
                        bl = true;
                    }
                } else {
                    bl = false;
                }
                if (!bl) break;
                ASTNode aSTNode4 = node;
                node = aSTNode4 != null ? aSTNode4.getTreePrev() : null;
            }
            if (node == null) {
                return "";
            }
            ASTNode aSTNode5 = node;
            if (Intrinsics.areEqual((Object)(aSTNode5 != null ? aSTNode5.getElementType() : null), (Object)JetTokens.DOC_COMMENT) ^ true) {
                return "";
            }
            Object object = node;
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            Object nodeText = object;
            String[] lines = KotlinPackage.split((String)KotlinPackage.trim((String)nodeText), (String)"\\n");
            StringBuilder buffer = new StringBuilder();
            int last = KotlinPackage.getSize((Object[])lines) - 1;
            int n = 0;
            int n2 = last;
            if (n <= n2) {
                while (true) {
                    void i;
                    String text = lines[i];
                    text = KotlinPackage.trim((String)text);
                    if (i == false) {
                        text = KotlinPackage.trimLeading((String)KotlinPackage.trimLeading((String)text, (String)"/**"), (String)"/*");
                    } else {
                        buffer.append("\n");
                    }
                    if (i >= last) {
                        text = KotlinPackage.trimTrailing((String)text, (String)"*/");
                    } else if (i > false && Intrinsics.areEqual((Object)(text = KotlinPackage.trimLeading((String)text, (String)"* ")), (Object)"*")) {
                        text = "";
                    }
                    text = this.processMacros(text, psiElement);
                    buffer.append(text);
                    if (i == n2) break;
                    ++i;
                }
            }
            String string = buffer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
            return string;
        }
        return "";
    }

    @NotNull
    protected final String processMacros(@JetValueParameter(name="textWithWhitespace") @NotNull String textWithWhitespace, @JetValueParameter(name="psiElement") @NotNull PsiElement psiElement) {
        Intrinsics.checkParameterIsNotNull((Object)textWithWhitespace, (String)"textWithWhitespace");
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        String text = KotlinPackage.trim((String)textWithWhitespace);
        if (KotlinPackage.startsWith((String)text, (String)"@")) {
            String macro;
            String remaining = KotlinPackage.substring((String)text, (int)1);
            if (KotlinPackage.startsWith((String)remaining, (String)(macro = "includeFunctionBody"))) {
                String next = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)KotlinPackage.length((String)macro)));
                String[] words = KotlinPackage.split((String)next, (String)"\\s");
                if (KotlinPackage.getSize((Object[])words) > 1) {
                    String includeFile = words[0];
                    String fnName = words[1];
                    String content = this.findFunctionInclude(psiElement, includeFile, fnName);
                    if (content != null) {
                        return content;
                    }
                    ModelPackage$KotlinModel$508284e7.warning("could not find function " + fnName + " in file " + includeFile + " from source file " + psiElement.getContainingFile());
                }
            } else {
                ModelPackage$KotlinModel$508284e7.warning("Unknown kdoc macro @" + remaining);
            }
        }
        return textWithWhitespace;
    }

    @Nullable
    protected final String findFunctionInclude(@JetValueParameter(name="psiElement") @NotNull PsiElement psiElement, @JetValueParameter(name="includeFile") @NotNull String includeFile, @JetValueParameter(name="functionName") @NotNull String functionName) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        Intrinsics.checkParameterIsNotNull((Object)includeFile, (String)"includeFile");
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        PsiFile psiFile = psiElement.getContainingFile();
        PsiDirectory dir = psiFile != null ? psiFile.getParent() : null;
        if (dir != null) {
            int idx;
            String remaining;
            String content;
            Pattern regex;
            Matcher matcher;
            String text;
            PsiFile file;
            PsiDirectory psiDirectory = dir;
            if (psiDirectory == null) {
                Intrinsics.throwNpe();
            }
            if ((file = this.relativeFile(psiDirectory, includeFile)) != null && (text = file.getText()) != null && (matcher = (regex = KotlinPackage.toRegex$default((String)("fun" + "\\" + "s+" + functionName + "\\" + "(.*" + "\\" + ")"), (int)0, (int)1)).matcher(text)).find() && (content = this.extractBlock(remaining = KotlinPackage.substring((String)text, (int)(idx = matcher.end())))) != null) {
                String highlight = this.highlighter.highlight(content);
                String filePath = this.filePath((PsiFileSystemItem)file);
                String string = KotlinPackage.substring((String)text, (int)0, (int)idx);
                int n = 0;
                CharIterator charIterator = KotlinPackage.iterator((CharSequence)string);
                while (charIterator.hasNext()) {
                    char c = charIterator.nextChar();
                    char it = c;
                    if (!(it == '\n')) continue;
                    ++n;
                }
                int sourceLine = n + 1;
                String link = filePath != null ? KModel.sourceLinkFor$default(this, filePath, sourceLine, null, 4) : (String)null;
                return link != null ? "<div class=" + "\"" + "source-detail" + "\"" + "><a href=" + "\"" + link + "\"" + " target=" + "\"" + "_top" + "\"" + "  class=" + "\"" + "repoSourceCode" + "\"" + ">source</a></div>" + "\n" + highlight : highlight;
            }
        }
        return null;
    }

    @Nullable
    protected final String filePath(@JetValueParameter(name="file", type="?") @Nullable PsiFileSystemItem file) {
        PsiFileSystemItem dir;
        if (file != null && (dir = file.getParent()) != null) {
            String string = this.filePath(dir);
            if (string == null) {
                string = "";
            }
            String parentName = string;
            return parentName + "/" + file.getName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final String extractBlock(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        int idx = KotlinPackage.indexOf((String)text, (char)'{');
        if (idx >= 0) {
            String line22;
            int nidx;
            String remaining = KotlinPackage.substring((String)text, (int)(idx + 1));
            while ((nidx = KotlinPackage.indexOf((String)remaining, (char)'\n')) >= 0 && KotlinPackage.isEmpty((String)(line22 = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)0, (int)nidx))))) {
                remaining = KotlinPackage.substring((String)remaining, (int)(nidx + 1));
            }
            int count = 1;
            int line22 = 0;
            int n = KotlinPackage.getSize((String)remaining) - 1;
            if (line22 <= n) {
                while (true) {
                    void i;
                    char ch;
                    if ((ch = remaining.charAt((int)i)) == '{') {
                        ++count;
                    } else if (ch == '}' && --count <= 0) {
                        return KotlinPackage.substring((String)remaining, (int)0, (int)i);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            ModelPackage$KotlinModel$508284e7.warning("missing } in code block for " + remaining);
            return remaining;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final PsiFile relativeFile(@JetValueParameter(name="directory") @NotNull PsiDirectory directory, @JetValueParameter(name="relativeName") @NotNull String relativeName) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)relativeName, (String)"relativeName");
        PsiDirectory dir = directory;
        String[] paths = KotlinPackage.split((String)relativeName, (String)"/");
        int size = KotlinPackage.getSize((Object[])paths);
        int n = 0;
        int n2 = size - 2;
        if (n <= n2) {
            while (true) {
                void i;
                String path;
                if (!Intrinsics.areEqual((Object)(path = paths[i]), (Object)".")) {
                    if (Intrinsics.areEqual((Object)path, (Object)"..")) {
                        PsiDirectory psiDirectory = dir;
                        dir = psiDirectory != null ? psiDirectory.getParent() : null;
                    } else {
                        PsiDirectory psiDirectory = dir;
                        Object object = dir = psiDirectory != null ? psiDirectory.findSubdirectory(path) : null;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        String name = paths[size - 1];
        if (dir != null) {
            PsiDirectory psiDirectory = dir;
            Object file = psiDirectory != null ? psiDirectory.findFile(name) : null;
            if (file != null) {
                return file;
            }
            ModelPackage$KotlinModel$508284e7.warning("could not find file " + relativeName + " in " + dir + " with name " + name);
        }
        return null;
    }

    public final void configureComments(@JetValueParameter(name="annotated") @NotNull KAnnotated annotated, @JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)annotated, (String)"annotated");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        String detailedText = KotlinPackage.trim((String)this.commentsFor(descriptor));
        annotated.setWikiDescription(detailedText);
    }

    @Nullable
    public final KType getType(@JetValueParameter(name="aType", type="?") @Nullable JetType aType) {
        if (aType != null) {
            ClassifierDescriptor classifierDescriptor = aType.getConstructor().getDeclarationDescriptor();
            KClass klass = classifierDescriptor instanceof ClassDescriptor ? this.getClass((ClassDescriptor)classifierDescriptor) : (KClass)null;
            return new KType(aType, this, klass, null, 8);
        }
        return null;
    }

    @Nullable
    public final KClass getClass(@JetValueParameter(name="qualifiedName") @NotNull String qualifiedName) {
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        int idx = KotlinPackage.lastIndexOf((String)qualifiedName, (char)'.');
        String pkgName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)0, (int)idx) : "";
        KPackage pkg = this.getPackage(pkgName);
        if (pkg != null) {
            String simpleName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)(idx + 1)) : qualifiedName;
            return (KClass)pkg.getClassMap().get(simpleName);
        }
        return null;
    }

    @Nullable
    public final KClass getClass(@JetValueParameter(name="classElement") @NotNull ClassDescriptor classElement) {
        Intrinsics.checkParameterIsNotNull((Object)classElement, (String)"classElement");
        String name = classElement.getName().asString();
        DeclarationDescriptor dec = classElement.getContainingDeclaration();
        while (dec != null) {
            DeclarationDescriptor container = dec;
            if (container instanceof PackageFragmentDescriptor) {
                KPackage pkg = this.getOrCreatePackage((PackageFragmentDescriptor)container);
                return pkg.getClass(classElement);
            }
            DeclarationDescriptor declarationDescriptor = dec;
            dec = declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null;
        }
        ModelPackage$KotlinModel$508284e7.warning("no package found for class " + name);
        return null;
    }

    @Nullable
    public final KPackage previous(@JetValueParameter(name="pkg") @NotNull KPackage pkg) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        return null;
    }

    @Nullable
    public final KPackage next(@JetValueParameter(name="pkg") @NotNull KPackage pkg) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        return null;
    }

    @NotNull
    public final BindingContext getContext() {
        return this.context;
    }

    @NotNull
    public final KDocConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final List<File> getSourceDirs() {
        return this.sourceDirs;
    }

    @NotNull
    public final List<JetFile> getSources() {
        return this.sources;
    }

    /*
     * WARNING - void declaration
     */
    public KModel(@JetValueParameter(name="context") @NotNull BindingContext context, @JetValueParameter(name="config") @NotNull KDocConfig config, @JetValueParameter(name="sourceDirs") @NotNull List<? extends File> sourceDirs, @JetValueParameter(name="sources") @NotNull List<? extends JetFile> sources) {
        Iterable packageFragment;
        Object source;
        Object object;
        Object object2;
        Iterator iterator2;
        Object object3;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(sourceDirs, (String)"sourceDirs");
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        this.context = context;
        this.config = config;
        this.sourceDirs = sourceDirs;
        this.sources = sources;
        this.packageMap = KotlinPackage.sortedMapOf((Pair[])new Pair[0]);
        this.markdownProcessor = new PegDownProcessor(Extensions.ALL);
        this.highlighter = new SyntaxHighlighter();
        this._projectRootDir = null;
        this.packageDescriptionFiles = KotlinPackage.listOf((Object[])new String[]{"readme.md", "ReadMe.md, readme.html, ReadMe.html"});
        this.readMeDirsScanned = new HashSet();
        Iterable object4 = this.sourceDirs;
        Object object5 = object4;
        Iterable iterable = new ArrayList();
        Object object6 = object5.iterator();
        while (object6.hasNext()) {
            void file;
            object3 = object6.next();
            iterator2 = (File)object3;
            object2 = iterable;
            object = file.getCanonicalPath();
            object2.add(object);
        }
        List normalizedSourceDirs = (ArrayList)iterable;
        KModel$1 kModel$1 = new KModel$1(normalizedSourceDirs);
        object5 = this.sources;
        object2 = this;
        iterable = object5;
        object6 = new ArrayList();
        for (Iterator iterator2 : iterable) {
            JetFile jetFile = (JetFile)iterator2;
            object = object6;
            String relativePath = kModel$1.invoke((PsiFile)source);
            String htmlPath = KotlinPackage.replaceFirst((String)relativePath, (String)"\\.kt$", (String)"") + ".html";
            SourceInfo sourceInfo = new SourceInfo((JetFile)source, relativePath, htmlPath);
            object.add(sourceInfo);
        }
        ((KModel)object2).sourcesInfo = object = (List)((ArrayList)object6);
        this.sourceInfoByFile = DocPackage$collections$b8ec3894.toHashMapMappingToKey(this.sourcesInfo, KModel$sourceInfoByFile$1.INSTANCE$);
        HashSet<Iterable> allPackageFragments = new HashSet<Iterable>();
        for (JetFile jetFile : this.sources) {
            packageFragment = (PackageFragmentDescriptor)this.context.get((ReadOnlySlice)BindingContext.FILE_TO_PACKAGE_FRAGMENT, (Object)jetFile);
            if (packageFragment != null) {
                allPackageFragments.add(packageFragment);
                continue;
            }
            ModelPackage$KotlinModel$508284e7.warning("No PackageFragmentDescriptor for source " + jetFile);
        }
        packageFragment = allPackageFragments;
        object6 = packageFragment;
        object3 = new LinkedHashMap();
        iterator2 = object6.iterator();
        while (iterator2.hasNext()) {
            Object object7;
            Object object8 = object3;
            source = iterator2.next();
            PackageFragmentDescriptor it = (PackageFragmentDescriptor)source;
            String string = ModelPackage$KotlinModel$508284e7.qualifiedName((DeclarationDescriptor)it);
            if (object8.containsKey(string)) {
                object7 = object8.get(string);
            } else {
                ArrayList arrayList = new ArrayList();
                object8.put(string, arrayList);
                object7 = arrayList;
            }
            List list = (List)object7;
            list.add(source);
        }
        object5 = KotlinPackage.iterator((Map)object3);
        while (object5.hasNext()) {
            Map.Entry entry = (Map.Entry)object5.next();
            String name = (String)KotlinPackage.component1((Map.Entry)entry);
            List packageFragments = (List)KotlinPackage.component2((Map.Entry)entry);
            this.createPackage(packageFragments, name);
            for (PackageFragmentDescriptor packageFragment2 : packageFragments) {
                for (DeclarationDescriptor descriptor : packageFragment2.getMemberScope().getAllDescriptors()) {
                    if (!(descriptor instanceof ClassDescriptor)) continue;
                    this.getClass((ClassDescriptor)descriptor);
                }
            }
        }
    }

    @KotlinSyntheticClass(abiVersion=19, kind=KotlinSyntheticClass.Kind.LOCAL_FUNCTION)
    final class KModel$1
    extends FunctionImpl<String>
    implements Function1<PsiFile, String> {
        final /* synthetic */ List $normalizedSourceDirs;

        @NotNull
        public final String invoke(@JetValueParameter(name="psiFile") @NotNull PsiFile psiFile) {
            Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                throw new TypeCastException("com.intellij.openapi.vfs.VirtualFile! cannot be cast to com.intellij.openapi.vfs.local.CoreLocalVirtualFile");
            }
            String string = ((CoreLocalVirtualFile)virtualFile).getPath();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            File file = new File(string).getCanonicalFile();
            String filePath = file.getPath();
            for (String sourceDirPath : this.$normalizedSourceDirs) {
                boolean bl = KotlinPackage.startsWith((String)filePath, (String)sourceDirPath) ? KotlinPackage.length((String)filePath) > KotlinPackage.length((String)sourceDirPath) : false;
                if (!bl) continue;
                return KotlinPackage.substring((String)filePath, (int)(sourceDirPath.length() + 1));
            }
            throw (Throwable)new Exception(file + " is not a child of any source roots " + this.$normalizedSourceDirs);
        }

        KModel$1(List list) {
            this.$normalizedSourceDirs = list;
        }
    }
}

