/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.templates;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jet.Function1;
import jet.JetObject;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.ModelPackage$src$KotlinModel$db080bae;
import org.jetbrains.kotlin.doc.templates.PackageFrameTemplate$printClasses$classes$1;
import org.jetbrains.kotlin.doc.templates.PackageTemplateSupport;

@JetClass(signature="Lorg/jetbrains/kotlin/doc/templates/PackageTemplateSupport;", flags=16, abiVersion=6)
public final class PackageFrameTemplate
extends PackageTemplateSupport
implements JetObject {
    private final KModel model;

    @Override
    @JetMethod(flags=16, returnType="V")
    public void render() {
        this.println("<!DOCTYPE HTML PUBLIC " + "\"" + "-//W3C//DTD HTML 4.01 Transitional//EN" + "\"" + " " + "\"" + "http://www.w3.org/TR/html4/loose.dtd" + "\"" + ">" + "\n" + "<!--NewPage-->" + "\n" + "<HTML>" + "\n" + "<HEAD>" + "\n" + this.getGeneratedComment() + "\n" + "<META http-equiv=" + "\"" + "Content-Type" + "\"" + " content=" + "\"" + "text/html; charset=UTF-8" + "\"" + ">" + "\n" + "<TITLE>" + "\n" + this.getPkg().getName() + " (" + this.model.getTitle() + ")" + "\n" + "</TITLE>" + "\n" + "\n" + "<META NAME=" + "\"" + "date" + "\"" + " CONTENT=" + "\"" + "2012-01-09" + "\"" + ">" + "\n" + this.stylesheets() + "\n" + "\n" + "</HEAD>" + "\n" + "\n" + "<BODY BGCOLOR=" + "\"" + "white" + "\"" + ">" + "\n" + "<FONT size=" + "\"" + "+1" + "\"" + " CLASS=" + "\"" + "FrameTitleFont" + "\"" + ">" + "\n" + "<A HREF=" + "\"" + this.getPkg().getNameAsRelativePath() + this.getPkg().getNameAsPath() + "/package-summary.html" + "\"" + " target=" + "\"" + "classFrame" + "\"" + ">" + this.getPkg().getName() + "</A></FONT>");
        this.printClasses("trait", "Traits");
        this.printClasses("class", "Classes");
        this.printClasses("enum", "Enums");
        this.printClasses("annotation", "Annotations");
        this.printClasses("exception", "Exceptions");
        this.printPackageProperties();
        this.printFunctions();
        this.printExtensionFunctions();
        this.println("</BODY>\n</HTML>");
    }

    @JetMethod(flags=32, returnType="V")
    protected final void printClasses(@JetValueParameter(name="kind", type="Ljava/lang/String;") String kind, @JetValueParameter(name="description", type="Ljava/lang/String;") String description) {
        List classes2 = KotlinPackage.filter(this.getPkg().getClasses(), (Function1)((Function1)new PackageFrameTemplate$printClasses$classes$1(kind)));
        if (!classes2.isEmpty()) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">");
            this.print(description);
            this.println("</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            for (KClass c : classes2) {
                String formatted = Intrinsics.areEqual((Object)kind, (Object)"interface") ? "<I>" + c.getSimpleName() + "</I>" : c.getSimpleName();
                this.println("<A HREF=" + "\"" + c.getSimpleName() + ".html" + "\"" + " title=" + "\"" + kind + " in " + this.getPkg().getName() + "\"" + " target=" + "\"" + "classFrame" + "\"" + ">" + formatted + "</A>" + "\n" + "<BR>");
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    @JetMethod(flags=32, returnType="V")
    protected final void printFunctions() {
        Collection<KFunction> functions2 = ModelPackage$src$KotlinModel$db080bae.filterDuplicateNames((Collection<? extends KFunction>)this.getPkg().packageFunctions());
        if (!functions2.isEmpty()) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">Functions</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            String lastName = "";
            for (KFunction c : functions2) {
                if (Intrinsics.areEqual((Object)c.getName(), (Object)lastName) ^ true) {
                    this.println("<A HREF=" + "\"" + this.href(c) + "\"" + " title=" + "\"" + "function in " + this.getPkg().getName() + "\"" + " target=" + "\"" + "classFrame" + "\"" + "><I>" + c.getName() + "</I></A>" + "\n" + "    <BR>");
                }
                lastName = c.getName();
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    @JetMethod(flags=32, returnType="V")
    protected final void printExtensionFunctions() {
        Map<KClass, List<? extends KFunction>> map = ModelPackage$src$KotlinModel$db080bae.extensionFunctions((Collection<? extends KFunction>)((KClassOrPackage)this.getPkg()).getFunctions());
        if (!map.isEmpty()) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">Extensions</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            Iterator iterator = KotlinPackage.iterator(map);
            while (iterator.hasNext()) {
                Map.Entry e = (Map.Entry)iterator.next();
                KClass c = (KClass)KotlinPackage.getKey((Map.Entry)e);
                boolean bl = true;
                if (c == null) {
                    bl = false;
                }
                if (!bl) continue;
                this.println("<A HREF=" + "\"" + this.extensionsHref(this.getPkg(), c) + "\"" + " title=" + "\"" + "extensions functions on class " + c.getName() + " from " + this.getPkg().getName() + "\"" + " target=" + "\"" + "classFrame" + "\"" + "><I>" + c.getName() + "</I></A>" + "\n" + "<BR>");
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    @JetMethod(flags=32, returnType="V")
    protected final void printPackageProperties() {
        List<KProperty> list = this.getPkg().packageProperties();
        if (KotlinPackage.notEmpty((Collection)list)) {
            this.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" SUMMARY=\"\">\n<TR>\n<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">Properties</FONT>&nbsp;\n<FONT CLASS=\"FrameItemFont\">\n<BR>");
            for (KProperty c : list) {
                boolean bl = true;
                if (c == null) {
                    bl = false;
                }
                if (!bl) continue;
                this.println("<A HREF=" + "\"" + this.href(this.getPkg(), c) + "\"" + " title=" + "\"" + "property from " + this.getPkg().getName() + "\"" + " target=" + "\"" + "classFrame" + "\"" + "><I>" + c.getName() + "</I></A>" + "\n" + "<BR>");
            }
            this.println("</TR>\n</TABLE>");
        }
    }

    @JetMethod(flags=17, propertyType="Lorg/jetbrains/kotlin/doc/model/KModel;")
    public final KModel getModel() {
        return this.model;
    }

    @JetConstructor
    public PackageFrameTemplate(@JetValueParameter(name="model", type="Lorg/jetbrains/kotlin/doc/model/KModel;") KModel model, @JetValueParameter(name="p", type="Lorg/jetbrains/kotlin/doc/model/KPackage;") KPackage p) {
        super(p);
        this.model = model;
    }
}

