/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.templates;

import java.util.Collection;
import jet.JetObject;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.templates.ClassTemplate;

@JetClass(signature="Lorg/jetbrains/kotlin/doc/templates/ClassTemplate;", flags=16, abiVersion=6)
public final class ClassExtensionsTemplate
extends ClassTemplate
implements JetObject {
    private final Collection<? extends KFunction> functions;
    private final Collection<? extends KProperty> properties;

    @Override
    @JetMethod(flags=32, returnType="Ljava/lang/String;")
    protected String relativePrefix() {
        return this.getPkg().getNameAsRelativePath() + this.getKlass().getPkg().getNameAsRelativePath();
    }

    @Override
    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public String pageTitle() {
        return this.getKlass().getName() + " Extensions fom " + this.getPkg().getName() + " (" + this.getModel().getTitle() + ")";
    }

    @Override
    @JetMethod(flags=16, returnType="V")
    public void printBody() {
        this.println("<HR>" + "\n" + "<!-- ======== START OF CLASS EXTENSIONS DATA ======== -->" + "\n" + "<H2>" + "\n" + "<FONT SIZE=" + "\"" + "-1" + "\"" + ">" + "\n" + this.getPkg().getName() + "</FONT>" + "\n" + "<BR>" + "\n" + "Extensions on " + this.getKlass().getName() + "</H2>" + "\n" + "<DL>" + "\n" + "<DT>" + "\n" + "extension functions on class <A HREF=" + "\"" + this.sourceHref(this.getKlass()) + "\"" + this.getKlass().sourceTargetAttribute() + "><B>" + this.getKlass().getName() + "</B></A><DT>" + "\n" + "from package " + this.link(this.getPkg()) + "\n" + "</DL>" + "\n" + "</PRE>" + "\n" + "\n" + "<P>");
        this.printPropertySummary(this.properties);
        this.printFunctionSummary(this.functions);
        this.printFunctionDetail(this.functions);
        this.println("<!-- ========= END OF CLASS EXTENSIONS DATA ========= -->\n<HR>\n");
    }

    @Override
    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public String href(@JetValueParameter(name="f", type="Lorg/jetbrains/kotlin/doc/model/KFunction;") KFunction f2) {
        boolean bl = true;
        if (f2.getExtensionClass() == null) {
            bl = false;
        }
        return bl ? "#" + f2.getLink() : super.href(f2);
    }

    @Override
    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public String href(@JetValueParameter(name="f", type="Lorg/jetbrains/kotlin/doc/model/KProperty;") KProperty f2) {
        boolean bl = true;
        if (f2.getExtensionClass() == null) {
            bl = false;
        }
        return bl ? "#" + f2.getLink() : super.href(f2);
    }

    @JetMethod(flags=17, propertyType="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KFunction;>;")
    public final Collection<KFunction> getFunctions() {
        return this.functions;
    }

    @JetMethod(flags=17, propertyType="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KProperty;>;")
    public final Collection<KProperty> getProperties() {
        return this.properties;
    }

    @JetConstructor
    public ClassExtensionsTemplate(@JetValueParameter(name="m", type="Lorg/jetbrains/kotlin/doc/model/KModel;") KModel m, @JetValueParameter(name="p", type="Lorg/jetbrains/kotlin/doc/model/KPackage;") KPackage p, @JetValueParameter(name="k", type="Lorg/jetbrains/kotlin/doc/model/KClass;") KClass k, @JetValueParameter(name="functions", type="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KFunction;>;") Collection<? extends KFunction> functions2, @JetValueParameter(name="properties", type="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KProperty;>;") Collection<? extends KProperty> properties) {
        super(m, p, k);
        this.functions = functions2;
        this.properties = properties;
    }
}

