/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.Function0;
import jet.Function1;
import jet.FunctionImpl1;
import jet.JetObject;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.SharedVar;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.kotlin.doc.DocPackage$src$collections$ec9b8215;
import org.jetbrains.kotlin.doc.KDocConfig;
import org.jetbrains.kotlin.doc.highlighter.SyntaxHighligher;
import org.jetbrains.kotlin.doc.model.KAnnotated;
import org.jetbrains.kotlin.doc.model.KClass;
import org.jetbrains.kotlin.doc.model.KClassOrPackage;
import org.jetbrains.kotlin.doc.model.KFunction;
import org.jetbrains.kotlin.doc.model.KModel$1;
import org.jetbrains.kotlin.doc.model.KModel$classes$1;
import org.jetbrains.kotlin.doc.model.KModel$findFunctionInclude$sourceLine$1;
import org.jetbrains.kotlin.doc.model.KModel$getPackage$pkg$1;
import org.jetbrains.kotlin.doc.model.KModel$normalizedSourceDirs$1;
import org.jetbrains.kotlin.doc.model.KModel$packages$1;
import org.jetbrains.kotlin.doc.model.KModel$sourceInfoByFile$1;
import org.jetbrains.kotlin.doc.model.KModel$tryLoadReadMe$f$1;
import org.jetbrains.kotlin.doc.model.KModel$tryLoadReadMe$f$2;
import org.jetbrains.kotlin.doc.model.KPackage;
import org.jetbrains.kotlin.doc.model.KParameter;
import org.jetbrains.kotlin.doc.model.KProperty;
import org.jetbrains.kotlin.doc.model.KType;
import org.jetbrains.kotlin.doc.model.KTypeParameter;
import org.jetbrains.kotlin.doc.model.ModelPackage$src$KotlinModel$13dae9a8;
import org.jetbrains.kotlin.doc.model.SourceInfo;
import org.pegdown.Extensions;
import org.pegdown.LinkRenderer;
import org.pegdown.PegDownProcessor;

@JetClass(signature="Ljava/lang/Object;", flags=16, abiVersion=6)
public final class KModel
implements JetObject {
    private final SortedMap<String, KPackage> packageMap;
    private PegDownProcessor markdownProcessor;
    private SyntaxHighligher highlighter;
    private String _projectRootDir;
    private final ArrayList<String> packageDescriptionFiles;
    private final HashSet<String> readMeDirsScanned;
    private final List<? extends SourceInfo> sourcesInfo;
    private final Map<JetFile, ? extends SourceInfo> sourceInfoByFile;
    private final BindingContext context;
    private final KDocConfig config;
    private final List<? extends File> sourceDirs;
    private final List<? extends JetFile> sources;

    @JetMethod(flags=1, propertyType="Ljava/util/SortedMap<Ljava/lang/String;Lorg/jetbrains/kotlin/doc/model/KPackage;>;")
    public final SortedMap<String, KPackage> getPackageMap() {
        return this.packageMap;
    }

    @JetMethod(flags=1, propertyType="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KPackage;>;")
    public final Collection<KPackage> getAllPackages() {
        Collection<KPackage> collection = this.packageMap.values();
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        return collection;
    }

    @JetMethod(flags=1, propertyType="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KPackage;>;")
    public final Collection<KPackage> getPackages() {
        return KotlinPackage.filter(this.getAllPackages(), (Function1)((Function1)new KModel$packages$1(this)));
    }

    @JetMethod(flags=1, propertyType="Ljet/Collection<Lorg/jetbrains/kotlin/doc/model/KClass;>;")
    public final Collection<KClass> getClasses() {
        return KotlinPackage.flatMap(this.getPackages(), (Function1)((Function1)KModel$classes$1.instance$));
    }

    @JetMethod(flags=1, propertyType="Lorg/pegdown/PegDownProcessor;")
    public final PegDownProcessor getMarkdownProcessor() {
        return this.markdownProcessor;
    }

    @JetMethod(flags=1, propertyType="Lorg/pegdown/PegDownProcessor;")
    public final void setMarkdownProcessor(@JetValueParameter(name="<set-?>", type="Lorg/pegdown/PegDownProcessor;") PegDownProcessor pegDownProcessor) {
        this.markdownProcessor = pegDownProcessor;
    }

    @JetMethod(flags=1, propertyType="Lorg/jetbrains/kotlin/doc/highlighter/SyntaxHighligher;")
    public final SyntaxHighligher getHighlighter() {
        return this.highlighter;
    }

    @JetMethod(flags=1, propertyType="Lorg/jetbrains/kotlin/doc/highlighter/SyntaxHighligher;")
    public final void setHighlighter(@JetValueParameter(name="<set-?>", type="Lorg/jetbrains/kotlin/doc/highlighter/SyntaxHighligher;") SyntaxHighligher syntaxHighligher) {
        this.highlighter = syntaxHighligher;
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final String getTitle() {
        return this.config.getTitle();
    }

    @JetMethod(flags=1, propertyType="Ljava/lang/String;")
    public final String getVersion() {
        return this.config.getVersion();
    }

    @JetMethod(flags=9, propertyType="?Ljava/lang/String;")
    private final String get_projectRootDir() {
        return this._projectRootDir;
    }

    @JetMethod(flags=9, propertyType="?Ljava/lang/String;")
    private final void set_projectRootDir(@JetValueParameter(name="<set-?>", type="?Ljava/lang/String;") String string) {
        this._projectRootDir = string;
    }

    @JetMethod(flags=17, propertyType="Ljava/util/ArrayList<Ljava/lang/String;>;")
    public final ArrayList<String> getPackageDescriptionFiles() {
        return this.packageDescriptionFiles;
    }

    @JetMethod(flags=9, propertyType="Ljava/util/HashSet<Ljava/lang/String;>;")
    private final HashSet<String> getReadMeDirsScanned() {
        return this.readMeDirsScanned;
    }

    @JetMethod(flags=17, propertyType="Ljet/List<Lorg/jetbrains/kotlin/doc/model/SourceInfo;>;")
    public final List<SourceInfo> getSourcesInfo() {
        return this.sourcesInfo;
    }

    @JetMethod(flags=9, propertyType="Ljet/Map<Lorg/jetbrains/jet/lang/psi/JetFile;Lorg/jetbrains/kotlin/doc/model/SourceInfo;>;")
    private final Map<JetFile, SourceInfo> getSourceInfoByFile() {
        return this.sourceInfoByFile;
    }

    @JetMethod(flags=16, returnType="Lorg/jetbrains/kotlin/doc/model/SourceInfo;")
    public final SourceInfo sourceInfoByFile(@JetValueParameter(name="file", type="Lorg/jetbrains/jet/lang/psi/JetFile;") JetFile file) {
        SourceInfo sourceInfo = this.sourceInfoByFile.get(file);
        if (sourceInfo == null) {
            Intrinsics.throwNpe();
        }
        return sourceInfo;
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String projectRootDir() {
        String string;
        boolean bl = true;
        if (this._projectRootDir != null) {
            bl = false;
        }
        if (bl) {
            String string2;
            String rootDir = this.config.getProjectRootDir();
            boolean bl2 = true;
            if (rootDir != null) {
                bl2 = false;
            }
            if (bl2) {
                ModelPackage$src$KotlinModel$13dae9a8.warning("KDocConfig does not have a projectRootDir defined so we cannot generate relative source Hrefs");
                string2 = "";
            } else {
                string2 = new File(rootDir).getCanonicalPath();
                if (string2 == null) {
                    string2 = this._projectRootDir = "";
                }
            }
        }
        if ((string = this._projectRootDir) == null) {
            string = "";
        }
        return string;
    }

    @JetMethod(flags=16, returnType="?Lorg/jetbrains/kotlin/doc/model/KPackage;")
    public final KPackage getPackage(@JetValueParameter(name="name", type="Ljava/lang/String;") String name) {
        return (KPackage)this.packageMap.get(name);
    }

    @JetMethod(flags=16, returnType="Lorg/jetbrains/kotlin/doc/model/KPackage;")
    public final KPackage getPackage(@JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/NamespaceDescriptor;") NamespaceDescriptor descriptor) {
        String name = ModelPackage$src$KotlinModel$13dae9a8.qualifiedName((DeclarationDescriptor)descriptor);
        SharedVar.Boolean created = new SharedVar.Boolean();
        created.ref = 0;
        KPackage pkg2 = (KPackage)KotlinPackage.getOrPut((Map)this.packageMap, (Object)name, (Function0)((Function0)new KModel$getPackage$pkg$1(this, created, name, descriptor)));
        if (created.ref) {
            this.configureComments(pkg2, (DeclarationDescriptor)descriptor);
            JetScope scope = descriptor.getMemberScope();
            this.addFunctions(pkg2, scope);
            pkg2.setLocal(this.isLocal((DeclarationDescriptor)descriptor));
            pkg2.setUseExternalLink(KotlinPackage.notEmpty((String)((KAnnotated)pkg2).getModel().config.resolveLink(pkg2.getName(), false)));
            if (KotlinPackage.isEmpty((String)((KAnnotated)pkg2).getWikiDescription())) {
                String file = this.config.getPackageDescriptionFiles().get(name);
                this.loadWikiDescription(pkg2, file);
            }
        }
        return pkg2;
    }

    @JetMethod(flags=32, returnType="V")
    protected final void loadWikiDescription(@JetValueParameter(name="pkg", type="Lorg/jetbrains/kotlin/doc/model/KPackage;") KPackage pkg2, @JetValueParameter(name="file", type="?Ljava/lang/String;") String file) {
        boolean bl = true;
        if (file == null) {
            bl = false;
        }
        if (bl) {
            try {
                ((KAnnotated)pkg2).setWikiDescription(IoPackage.readText$default((File)new File(file), null, (int)1));
            }
            catch (Throwable throwable) {
                ModelPackage$src$KotlinModel$13dae9a8.warning("Failed to load package " + pkg2.getName() + " documentation file " + file + ". Reason " + throwable);
            }
        }
    }

    @JetMethod(flags=16, returnType="V")
    public final void tryLoadReadMe(@JetValueParameter(name="pkg", type="Lorg/jetbrains/kotlin/doc/model/KPackage;") KPackage pkg2, @JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/DeclarationDescriptor;") DeclarationDescriptor descriptor) {
        if (KotlinPackage.isEmpty((String)((KAnnotated)pkg2).getWikiDescription())) {
            String srcPath = ((KAnnotated)pkg2).getModel().filePath(descriptor);
            boolean bl = true;
            if (srcPath == null) {
                bl = false;
            }
            if (bl) {
                boolean bl2;
                File srcFile = new File(srcPath);
                File dir = srcFile.isDirectory() ? srcFile : srcFile.getParentFile();
                boolean bl3 = true;
                if (dir == null) {
                    bl3 = false;
                }
                if (bl3) {
                    String string = dir.getPath();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    bl2 = this.readMeDirsScanned.add(string);
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    File f2 = (File)KotlinPackage.find((Iterable)KotlinPackage.map((Collection)this.packageDescriptionFiles, (Function1)((Function1)new KModel$tryLoadReadMe$f$1(dir))), (Function1)((Function1)KModel$tryLoadReadMe$f$2.instance$));
                    boolean bl4 = true;
                    if (f2 == null) {
                        bl4 = false;
                    }
                    if (bl4) {
                        String file = f2.getCanonicalPath();
                        this.loadWikiDescription(pkg2, file);
                    } else {
                        ModelPackage$src$KotlinModel$13dae9a8.info("package " + pkg2.getName() + " has no ReadMe.(html|md) in " + dir);
                    }
                }
            }
        }
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String wikiConvert(@JetValueParameter(name="text", type="Ljava/lang/String;") String text2, @JetValueParameter(name="linkRenderer", type="Lorg/pegdown/LinkRenderer;") LinkRenderer linkRenderer, @JetValueParameter(name="fileName", type="?Ljava/lang/String;") String fileName) {
        String string = this.markdownProcessor.markdownToHtml(text2, linkRenderer);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @JetMethod(flags=16, returnType="?Ljava/lang/String;")
    public final String sourceLinkFor(@JetValueParameter(name="filePath", type="Ljava/lang/String;") String filePath, @JetValueParameter(name="sourceLine", type="I") int sourceLine2, @JetValueParameter(name="lineLinkText", hasDefaultValue=true, type="Ljava/lang/String;") String lineLinkText) {
        String root = this.config.getSourceRootHref();
        boolean bl = true;
        if (root == null) {
            bl = false;
        }
        if (bl) {
            String rootDir = this.projectRootDir();
            String string = new File(filePath).getCanonicalPath();
            if (string == null) {
                string = "";
            }
            String canonicalFile = string;
            String relativeFile = KotlinPackage.startsWith((String)canonicalFile, (String)rootDir) ? KotlinPackage.substring((String)canonicalFile, (int)KotlinPackage.length((String)rootDir)) : canonicalFile;
            String cleanRoot = KotlinPackage.trimTrailing((String)root, (String)"/");
            String cleanPath = KotlinPackage.trimLeading((String)relativeFile, (String)"/");
            return cleanRoot + "/" + cleanPath + lineLinkText + sourceLine2;
        }
        return null;
    }

    public static /* synthetic */ String sourceLinkFor$default(KModel kModel, String string, int n, String string2, int n2) {
        if ((n2 & 4) != 0) {
            string2 = "#L";
        }
        return kModel.sourceLinkFor(string, n, string2);
    }

    @JetMethod(flags=32, returnType="Z")
    protected final boolean isLocal(@JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/DeclarationDescriptor;") DeclarationDescriptor descriptor) {
        int n;
        if (descriptor instanceof ModuleDescriptor) {
            n = 1;
        } else {
            DeclarationDescriptor parent = descriptor.getContainingDeclaration();
            boolean bl = true;
            if (parent == null) {
                bl = false;
            }
            n = bl ? (int)(this.isLocal(parent) ? 1 : 0) : 0;
        }
        return n != 0;
    }

    @JetMethod(flags=16, returnType="V")
    public final void addFunctions(@JetValueParameter(name="owner", type="Lorg/jetbrains/kotlin/doc/model/KClassOrPackage;") KClassOrPackage owner, @JetValueParameter(name="scope", type="Lorg/jetbrains/jet/lang/resolve/scopes/JetScope;") JetScope scope) {
        try {
            Collection descriptors = scope.getAllDescriptors();
            for (DeclarationDescriptor descriptor : descriptors) {
                Unit unit;
                if (descriptor instanceof PropertyDescriptor) {
                    String name = ((PropertyDescriptor)descriptor).getName().asString();
                    KType returnType = this.getType(((PropertyDescriptor)descriptor).getReturnType());
                    boolean bl = true;
                    if (returnType == null) {
                        bl = false;
                    }
                    if (!bl) continue;
                    ReceiverParameterDescriptor receiver = ((PropertyDescriptor)descriptor).getReceiverParameter();
                    boolean bl2 = true;
                    if (receiver == null) {
                        bl2 = false;
                    }
                    KType extensionClass = bl2 ? this.getType(receiver.getType()) : (KType)null;
                    KType kType = extensionClass;
                    KProperty property = new KProperty(owner, (PropertyDescriptor)descriptor, name, returnType, kType != null ? kType.getKlass() : null);
                    owner.getProperties().add(property);
                    continue;
                }
                if (descriptor instanceof CallableDescriptor) {
                    KFunction function = this.createFunction(owner, (CallableDescriptor)descriptor);
                    boolean bl = true;
                    if (function == null) {
                        bl = false;
                    }
                    if (bl) {
                        owner.getFunctions().add(function);
                    }
                    unit = Unit.VALUE;
                    continue;
                }
                unit = Unit.VALUE;
            }
        }
        catch (Throwable throwable) {
            ModelPackage$src$KotlinModel$13dae9a8.warning("Caught exception finding function declarations on " + owner + " " + throwable);
            throwable.printStackTrace();
        }
    }

    @JetMethod(flags=32, returnType="?Lorg/jetbrains/kotlin/doc/model/KFunction;")
    protected final KFunction createFunction(@JetValueParameter(name="owner", type="Lorg/jetbrains/kotlin/doc/model/KClassOrPackage;") KClassOrPackage owner, @JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/CallableDescriptor;") CallableDescriptor descriptor) {
        KType returnType = this.getType(descriptor.getReturnType());
        boolean bl = true;
        if (returnType == null) {
            bl = false;
        }
        if (bl) {
            String name = descriptor.getName().asString();
            ArrayList<KParameter> parameters = new ArrayList<KParameter>();
            List params = descriptor.getValueParameters();
            for (ValueParameterDescriptor param : params) {
                boolean bl2 = true;
                if (param == null) {
                    bl2 = false;
                }
                if (!bl2) continue;
                KParameter p = this.createParameter(param);
                boolean bl3 = true;
                if (p == null) {
                    bl3 = false;
                }
                if (!bl3) continue;
                parameters.add(p);
            }
            KFunction function = new KFunction(descriptor, owner, name, returnType, parameters, null, null, null, null, null, null, 2016);
            this.addTypeParameters(function.getTypeParameters(), descriptor.getTypeParameters());
            this.configureComments(function, (DeclarationDescriptor)descriptor);
            ReceiverParameterDescriptor receiver = descriptor.getReceiverParameter();
            boolean bl4 = true;
            if (receiver == null) {
                bl4 = false;
            }
            if (bl4) {
                KType receiverType = this.getType(receiver.getType());
                function.setReceiverType(receiverType);
                KType kType = receiverType;
                function.setExtensionClass(kType != null ? kType.getKlass() : null);
            }
            return function;
        }
        return null;
    }

    @JetMethod(flags=16, returnType="V")
    public final void addTypeParameters(@JetValueParameter(name="answer", type="Ljet/MutableList<Lorg/jetbrains/kotlin/doc/model/KTypeParameter;>;") List<KTypeParameter> answer2, @JetValueParameter(name="descriptors", type="Ljet/List<?Lorg/jetbrains/jet/lang/descriptors/TypeParameterDescriptor;>;") List<? extends TypeParameterDescriptor> descriptors) {
        for (TypeParameterDescriptor typeParameterDescriptor : descriptors) {
            boolean bl = true;
            if (typeParameterDescriptor == null) {
                bl = false;
            }
            if (!bl) continue;
            KTypeParameter p = this.createTypeParameter(typeParameterDescriptor);
            boolean bl2 = true;
            if (p == null) {
                bl2 = false;
            }
            if (!bl2) continue;
            answer2.add(p);
        }
    }

    @JetMethod(flags=32, returnType="?Lorg/jetbrains/kotlin/doc/model/KTypeParameter;")
    protected final KTypeParameter createTypeParameter(@JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/TypeParameterDescriptor;") TypeParameterDescriptor descriptor) {
        String name = descriptor.getName().asString();
        KTypeParameter answer2 = new KTypeParameter(name, descriptor, this, null, 8);
        this.configureComments(answer2, (DeclarationDescriptor)descriptor);
        return answer2;
    }

    @JetMethod(flags=32, returnType="?Lorg/jetbrains/kotlin/doc/model/KParameter;")
    protected final KParameter createParameter(@JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/ValueParameterDescriptor;") ValueParameterDescriptor descriptor) {
        KType returnType = this.getType(descriptor.getReturnType());
        boolean bl = true;
        if (returnType == null) {
            bl = false;
        }
        if (bl) {
            String name = descriptor.getName().asString();
            KParameter answer2 = new KParameter(descriptor, name, returnType);
            this.configureComments(answer2, (DeclarationDescriptor)descriptor);
            return answer2;
        }
        return null;
    }

    @JetMethod(flags=16, returnType="?Lorg/jetbrains/jet/lang/diagnostics/DiagnosticUtils$LineAndColumn;")
    public final DiagnosticUtils.LineAndColumn locationFor(@JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/DeclarationDescriptor;") DeclarationDescriptor descriptor) {
        PsiElement psiElement = this.getPsiElement(descriptor);
        boolean bl = true;
        if (psiElement == null) {
            bl = false;
        }
        if (bl) {
            PsiFile psiFile = psiElement.getContainingFile();
            Object object = psiFile != null ? psiFile.getViewProvider() : null;
            Document document = object != null ? object.getDocument() : null;
            boolean bl2 = true;
            if (document == null) {
                bl2 = false;
            }
            if (bl2) {
                int offset = psiElement.getTextOffset();
                return DiagnosticUtils.offsetToLineAndColumn((Document)document, (int)offset);
            }
        }
        return null;
    }

    @JetMethod(flags=16, returnType="?Ljava/lang/String;")
    public final String fileFor(@JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/DeclarationDescriptor;") DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        PsiElement psiElement2 = psiElement = this.getPsiElement(descriptor);
        Object object = psiElement2 != null ? psiElement2.getContainingFile() : null;
        return object != null ? object.getName() : null;
    }

    @JetMethod(flags=16, returnType="?Ljava/lang/String;")
    public final String filePath(@JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/DeclarationDescriptor;") DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        PsiElement psiElement2 = psiElement = this.getPsiElement(descriptor);
        PsiFile file = psiElement2 != null ? psiElement2.getContainingFile() : null;
        return this.filePath((PsiFileSystemItem)file);
    }

    @JetMethod(flags=16, returnType="?Lcom/intellij/psi/PsiElement;")
    public final PsiElement getPsiElement(@JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/DeclarationDescriptor;") DeclarationDescriptor descriptor) {
        PsiElement psiElement;
        try {
            psiElement = BindingContextUtils.descriptorToDeclaration((BindingContext)this.context, (DeclarationDescriptor)descriptor);
        }
        catch (Throwable throwable) {
            psiElement = null;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    @JetMethod(flags=32, returnType="Ljava/lang/String;")
    protected final String commentsFor(@JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/DeclarationDescriptor;") DeclarationDescriptor descriptor) {
        PsiElement psiElement = this.getPsiElement(descriptor);
        boolean bl = true;
        if (psiElement == null) {
            bl = false;
        }
        if (bl) {
            String string;
            ASTNode aSTNode = psiElement.getNode();
            ASTNode node = aSTNode != null ? aSTNode.getTreePrev() : null;
            while (true) {
                boolean bl2;
                boolean bl3 = true;
                if (node == null) {
                    bl3 = false;
                }
                if (bl3) {
                    ASTNode aSTNode2 = node;
                    if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)JetTokens.WHITE_SPACE)) {
                        ASTNode aSTNode3 = node;
                        bl2 = Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)JetTokens.BLOCK_COMMENT);
                    } else {
                        bl2 = true;
                    }
                } else {
                    bl2 = false;
                }
                if (!bl2) break;
                ASTNode aSTNode4 = node;
                node = aSTNode4 != null ? aSTNode4.getTreePrev() : null;
            }
            boolean bl4 = true;
            if (node != null) {
                bl4 = false;
            }
            if (bl4) {
                return "";
            }
            ASTNode aSTNode5 = node;
            if (Intrinsics.areEqual((Object)(aSTNode5 != null ? aSTNode5.getElementType() : null), (Object)JetTokens.DOC_COMMENT) ^ true) {
                return "";
            }
            ASTNode aSTNode6 = node;
            String string2 = aSTNode6 != null ? aSTNode6.getText() : null;
            if (string2 == null) {
                string2 = "";
            }
            String text2 = string2;
            String[] lines = KotlinPackage.split((String)KotlinPackage.trim((String)text2), (String)"\\n");
            StringBuilder buffer = new StringBuilder();
            int last = lines.length - 1;
            int n = 0;
            int n2 = last;
            if (n <= n2) {
                while (true) {
                    Unit unit;
                    void i;
                    String string3;
                    if ((string3 = lines[i]) == null) {
                        string3 = "";
                    }
                    String text3 = string3;
                    text3 = KotlinPackage.trim((String)text3);
                    boolean bl5 = true;
                    if (i != false) {
                        bl5 = false;
                    }
                    if (bl5) {
                        text3 = KotlinPackage.trimLeading((String)KotlinPackage.trimLeading((String)text3, (String)"/**"), (String)"/*");
                    } else {
                        buffer.append("\n");
                    }
                    if (i >= last) {
                        text3 = KotlinPackage.trimTrailing((String)text3, (String)"*/");
                    } else if (i > false) {
                        if (Intrinsics.areEqual((Object)(text3 = KotlinPackage.trimLeading((String)text3, (String)"* ")), (Object)"*")) {
                            text3 = "";
                        }
                        unit = Unit.VALUE;
                    } else {
                        unit = Unit.VALUE;
                    }
                    text3 = this.processMacros(text3, psiElement);
                    buffer.append(text3);
                    if (i == n2) break;
                    ++i;
                }
            }
            if ((string = buffer.toString()) == null) {
                string = "";
            }
            return string;
        }
        return "";
    }

    @JetMethod(flags=32, returnType="Ljava/lang/String;")
    protected final String processMacros(@JetValueParameter(name="textWithWhitespace", type="Ljava/lang/String;") String textWithWhitespace, @JetValueParameter(name="psiElement", type="Lcom/intellij/psi/PsiElement;") PsiElement psiElement) {
        String text2 = KotlinPackage.trim((String)textWithWhitespace);
        if (KotlinPackage.startsWith((String)text2, (String)"@")) {
            String macro;
            String remaining = KotlinPackage.substring((String)text2, (int)1);
            if (KotlinPackage.startsWith((String)remaining, (String)(macro = "includeFunctionBody"))) {
                String next = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)KotlinPackage.length((String)macro)));
                String[] words = KotlinPackage.split((String)next, (String)"\\s");
                if (words.length > 1) {
                    String string = words[0];
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String includeFile = string;
                    String string2 = words[1];
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String fnName = string2;
                    String content = this.findFunctionInclude(psiElement, includeFile, fnName);
                    boolean bl = true;
                    if (content == null) {
                        bl = false;
                    }
                    if (bl) {
                        return content;
                    }
                    ModelPackage$src$KotlinModel$13dae9a8.warning("could not find function " + fnName + " in file " + includeFile + " from source file " + psiElement.getContainingFile());
                }
            } else {
                ModelPackage$src$KotlinModel$13dae9a8.warning("Unknown kdoc macro @" + remaining);
            }
        }
        return textWithWhitespace;
    }

    @JetMethod(flags=32, returnType="?Ljava/lang/String;")
    protected final String findFunctionInclude(@JetValueParameter(name="psiElement", type="Lcom/intellij/psi/PsiElement;") PsiElement psiElement, @JetValueParameter(name="includeFile", type="Ljava/lang/String;") String includeFile, @JetValueParameter(name="functionName", type="Ljava/lang/String;") String functionName) {
        PsiFile psiFile = psiElement.getContainingFile();
        PsiDirectory dir = psiFile != null ? psiFile.getParent() : null;
        boolean bl = true;
        if (dir == null) {
            bl = false;
        }
        if (bl) {
            PsiDirectory psiDirectory = dir;
            if (psiDirectory == null) {
                Intrinsics.throwNpe();
            }
            PsiFile file = this.relativeFile(psiDirectory, includeFile);
            boolean bl2 = true;
            if (file == null) {
                bl2 = false;
            }
            if (bl2) {
                String text2 = file.getText();
                boolean bl3 = true;
                if (text2 == null) {
                    bl3 = false;
                }
                if (bl3) {
                    Matcher matcher;
                    Pattern regex = KotlinPackage.toRegex$default((String)("fun" + "\\" + "s+" + functionName + "\\" + "(.*" + "\\" + ")"), (int)0, (int)1);
                    Matcher matcher2 = regex.matcher(text2);
                    if (matcher2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((matcher = matcher2).find()) {
                        int idx = matcher.end();
                        String remaining = KotlinPackage.substring((String)text2, (int)idx);
                        String content = this.extractBlock(remaining);
                        boolean bl4 = true;
                        if (content == null) {
                            bl4 = false;
                        }
                        if (bl4) {
                            String highlight = this.highlighter.highlight(content);
                            String filePath = this.filePath((PsiFileSystemItem)file);
                            int sourceLine2 = KotlinPackage.count((String)KotlinPackage.substring((String)text2, (int)0, (int)idx), (Function1)((Function1)KModel$findFunctionInclude$sourceLine$1.instance$)) + 1;
                            boolean bl5 = true;
                            if (filePath == null) {
                                bl5 = false;
                            }
                            String link = bl5 ? KModel.sourceLinkFor$default(this, filePath, sourceLine2, null, 4) : (String)null;
                            boolean bl6 = true;
                            if (link == null) {
                                bl6 = false;
                            }
                            return bl6 ? "<div class=" + "\"" + "source-detail" + "\"" + "><a href=" + "\"" + link + "\"" + " target=" + "\"" + "_top" + "\"" + "  class=" + "\"" + "repoSourceCode" + "\"" + ">source</a></div>" + "\n" + highlight : highlight;
                        }
                    }
                }
            }
        }
        return null;
    }

    @JetMethod(flags=32, returnType="?Ljava/lang/String;")
    protected final String filePath(@JetValueParameter(name="file", type="?Lcom/intellij/psi/PsiFileSystemItem;") PsiFileSystemItem file) {
        boolean bl = true;
        if (file == null) {
            bl = false;
        }
        if (bl) {
            PsiFileSystemItem dir = file.getParent();
            boolean bl2 = true;
            if (dir == null) {
                bl2 = false;
            }
            if (bl2) {
                String string = this.filePath(dir);
                if (string == null) {
                    string = "";
                }
                String parentName = string;
                return parentName + "/" + file.getName();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JetMethod(flags=32, returnType="?Ljava/lang/String;")
    protected final String extractBlock(@JetValueParameter(name="text", type="Ljava/lang/String;") String text2) {
        int idx = KotlinPackage.indexOf((String)text2, (char)'{');
        if (idx >= 0) {
            String line22;
            int nidx;
            String remaining = KotlinPackage.substring((String)text2, (int)(idx + 1));
            while ((nidx = KotlinPackage.indexOf((String)remaining, (char)'\n')) >= 0 && KotlinPackage.isEmpty((String)(line22 = KotlinPackage.trim((String)KotlinPackage.substring((String)remaining, (int)0, (int)nidx))))) {
                remaining = KotlinPackage.substring((String)remaining, (int)(nidx + 1));
            }
            int count = 1;
            int line22 = 0;
            int n = KotlinPackage.getSize((String)remaining) - 1;
            if (line22 <= n) {
                while (true) {
                    Integer n2;
                    void i;
                    char ch;
                    if ((ch = remaining.charAt((int)i)) == '{') {
                        n2 = count;
                        ++count;
                    } else if (ch == '}') {
                        if (--count <= 0) {
                            return KotlinPackage.substring((String)remaining, (int)0, (int)i);
                        }
                        n2 = Unit.VALUE;
                    } else {
                        n2 = Unit.VALUE;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            ModelPackage$src$KotlinModel$13dae9a8.warning("missing } in code block for " + remaining);
            return remaining;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JetMethod(flags=32, returnType="?Lcom/intellij/psi/PsiFile;")
    protected final PsiFile relativeFile(@JetValueParameter(name="directory", type="Lcom/intellij/psi/PsiDirectory;") PsiDirectory directory, @JetValueParameter(name="relativeName", type="Ljava/lang/String;") String relativeName) {
        PsiDirectory dir = directory;
        int n = 0;
        String[] paths = KotlinPackage.split((String)relativeName, (String)"/");
        int size = paths.length;
        int n2 = size - 2;
        if (n <= n2) {
            while (true) {
                void i;
                String path;
                if (!Intrinsics.areEqual((Object)(path = paths[i]), (Object)".")) {
                    Unit unit;
                    if (Intrinsics.areEqual((Object)path, (Object)"..")) {
                        PsiDirectory psiDirectory = dir;
                        dir = psiDirectory != null ? psiDirectory.getParent() : null;
                        unit = Unit.VALUE;
                    } else {
                        PsiDirectory psiDirectory = dir;
                        dir = psiDirectory != null ? psiDirectory.findSubdirectory(path) : null;
                        unit = Unit.VALUE;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        String name = paths[size - 1];
        boolean bl = true;
        if (dir == null) {
            bl = false;
        }
        if (bl) {
            PsiDirectory psiDirectory = dir;
            PsiFile file = psiDirectory != null ? psiDirectory.findFile(name) : null;
            boolean bl2 = true;
            if (file == null) {
                bl2 = false;
            }
            if (bl2) {
                return file;
            }
            ModelPackage$src$KotlinModel$13dae9a8.warning("could not find file " + relativeName + " in " + dir + " with name " + name);
        }
        return null;
    }

    @JetMethod(flags=16, returnType="V")
    public final void configureComments(@JetValueParameter(name="annotated", type="Lorg/jetbrains/kotlin/doc/model/KAnnotated;") KAnnotated annotated, @JetValueParameter(name="descriptor", type="Lorg/jetbrains/jet/lang/descriptors/DeclarationDescriptor;") DeclarationDescriptor descriptor) {
        String detailedText = KotlinPackage.trim((String)this.commentsFor(descriptor));
        annotated.setWikiDescription(detailedText);
    }

    @JetMethod(flags=16, returnType="?Lorg/jetbrains/kotlin/doc/model/KType;")
    public final KType getType(@JetValueParameter(name="aType", type="?Lorg/jetbrains/jet/lang/types/JetType;") JetType aType) {
        boolean bl = true;
        if (aType == null) {
            bl = false;
        }
        if (bl) {
            ClassifierDescriptor classifierDescriptor = aType.getConstructor().getDeclarationDescriptor();
            KClass klass2 = classifierDescriptor instanceof ClassDescriptor ? this.getClass((ClassDescriptor)classifierDescriptor) : (KClass)null;
            return new KType(aType, this, klass2, null, 8);
        }
        return null;
    }

    @JetMethod(flags=16, returnType="?Lorg/jetbrains/kotlin/doc/model/KClass;")
    public final KClass getClass(@JetValueParameter(name="qualifiedName", type="Ljava/lang/String;") String qualifiedName) {
        int idx = KotlinPackage.lastIndexOf((String)qualifiedName, (char)'.');
        String pkgName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)0, (int)idx) : "";
        KPackage pkg2 = this.getPackage(pkgName);
        boolean bl = true;
        if (pkg2 == null) {
            bl = false;
        }
        if (bl) {
            String simpleName = idx >= 0 ? KotlinPackage.substring((String)qualifiedName, (int)(idx + 1)) : qualifiedName;
            return (KClass)pkg2.getClassMap().get(simpleName);
        }
        return null;
    }

    @JetMethod(flags=16, returnType="?Lorg/jetbrains/kotlin/doc/model/KClass;")
    public final KClass getClass(@JetValueParameter(name="classElement", type="Lorg/jetbrains/jet/lang/descriptors/ClassDescriptor;") ClassDescriptor classElement) {
        String name = classElement.getName().asString();
        DeclarationDescriptor dec = classElement.getContainingDeclaration();
        while (true) {
            boolean bl = true;
            if (dec == null) {
                bl = false;
            }
            if (!bl) break;
            DeclarationDescriptor container = dec;
            if (container instanceof NamespaceDescriptor) {
                KPackage pkg2 = this.getPackage((NamespaceDescriptor)container);
                return pkg2.getClass(classElement);
            }
            DeclarationDescriptor declarationDescriptor = dec;
            dec = declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null;
        }
        ModelPackage$src$KotlinModel$13dae9a8.warning("no package found for class " + name);
        return null;
    }

    @JetMethod(flags=16, returnType="?Lorg/jetbrains/kotlin/doc/model/KPackage;")
    public final KPackage previous(@JetValueParameter(name="pkg", type="Lorg/jetbrains/kotlin/doc/model/KPackage;") KPackage pkg2) {
        return null;
    }

    @JetMethod(flags=16, returnType="?Lorg/jetbrains/kotlin/doc/model/KPackage;")
    public final KPackage next(@JetValueParameter(name="pkg", type="Lorg/jetbrains/kotlin/doc/model/KPackage;") KPackage pkg2) {
        return null;
    }

    @JetMethod(flags=17, propertyType="Lorg/jetbrains/jet/lang/resolve/BindingContext;")
    public final BindingContext getContext() {
        return this.context;
    }

    @JetMethod(flags=17, propertyType="Lorg/jetbrains/kotlin/doc/KDocConfig;")
    public final KDocConfig getConfig() {
        return this.config;
    }

    @JetMethod(flags=17, propertyType="Ljet/List<Ljava/io/File;>;")
    public final List<File> getSourceDirs() {
        return this.sourceDirs;
    }

    @JetMethod(flags=17, propertyType="Ljet/List<Lorg/jetbrains/jet/lang/psi/JetFile;>;")
    public final List<JetFile> getSources() {
        return this.sources;
    }

    @JetConstructor
    public KModel(@JetValueParameter(name="context", type="Lorg/jetbrains/jet/lang/resolve/BindingContext;") BindingContext context, @JetValueParameter(name="config", type="Lorg/jetbrains/kotlin/doc/KDocConfig;") KDocConfig config, @JetValueParameter(name="sourceDirs", type="Ljet/List<Ljava/io/File;>;") List<? extends File> sourceDirs2, @JetValueParameter(name="sources", type="Ljet/List<Lorg/jetbrains/jet/lang/psi/JetFile;>;") List<? extends JetFile> sources) {
        this.context = context;
        this.config = config;
        this.sourceDirs = sourceDirs2;
        this.sources = sources;
        this.packageMap = new TreeMap();
        this.markdownProcessor = new PegDownProcessor(Extensions.ALL);
        this.highlighter = new SyntaxHighligher();
        this.packageDescriptionFiles = KotlinPackage.arrayList((Object[])new String[]{"readme.md", "ReadMe.md, readme.html, ReadMe.html"});
        this.readMeDirsScanned = new HashSet();
        List normalizedSourceDirs2 = KotlinPackage.map((Collection)this.sourceDirs, (Function1)((Function1)KModel$normalizedSourceDirs$1.instance$));
        KModel$1 kModel$1 = new KModel$1(normalizedSourceDirs2);
        this.sourcesInfo = KotlinPackage.map((Collection)this.sources, (Function1)((Function1)new KModel$2(kModel$1)));
        this.sourceInfoByFile = DocPackage$src$collections$ec9b8215.toHashMapMappingToKey(this.sourcesInfo, (Function1)KModel$sourceInfoByFile$1.instance$);
        HashSet<NamespaceDescriptor> allNamespaces = new HashSet<NamespaceDescriptor>();
        for (JetFile jetFile : this.sources) {
            Boolean bl;
            NamespaceDescriptor namespaceDescriptor = BindingContextUtils.namespaceDescriptor((BindingContext)this.context, (JetFile)jetFile);
            boolean bl2 = true;
            if (namespaceDescriptor == null) {
                bl2 = false;
            }
            if (bl2) {
                bl = allNamespaces.add(namespaceDescriptor);
                continue;
            }
            ModelPackage$src$KotlinModel$13dae9a8.warning("No NamespaceDescriptor for source " + jetFile);
            bl = Unit.VALUE;
        }
        HashSet<KClass> hashSet = new HashSet<KClass>();
        for (NamespaceDescriptor namespace : allNamespaces) {
            this.getPackage(namespace);
            for (DeclarationDescriptor descriptor : namespace.getMemberScope().getAllDescriptors()) {
                if (descriptor instanceof ClassDescriptor) {
                    KClass klass2 = this.getClass((ClassDescriptor)descriptor);
                    boolean bl = true;
                    if (klass2 == null) {
                        bl = false;
                    }
                    if (!bl) continue;
                    hashSet.add(klass2);
                    continue;
                }
                Object object = descriptor instanceof NamespaceDescriptor ? this.getPackage((NamespaceDescriptor)descriptor) : Unit.VALUE;
            }
        }
    }

    final class KModel$2
    extends FunctionImpl1<? super JetFile, ? extends SourceInfo> {
        final /* synthetic */ KModel$1 $relativePath;

        public final SourceInfo invoke(JetFile source) {
            String relativePath = (String)((Function1)this.$relativePath).invoke((Object)source);
            String htmlPath = KotlinPackage.replaceFirst((String)relativePath, (String)"\\.kt$", (String)"") + ".html";
            return new SourceInfo(source, relativePath, htmlPath);
        }

        KModel$2(KModel$1 kModel$1) {
            this.$relativePath = kModel$1;
        }
    }
}

