/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doc.highlighter2;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import jet.Function0;
import jet.Function1;
import jet.JetObject;
import jet.TypeCastException;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.kotlin.doc.Doclet;
import org.jetbrains.kotlin.doc.KDocArguments;
import org.jetbrains.kotlin.doc.highlighter2.Highlighter2Package$src$ioUtils$2b85c397;
import org.jetbrains.kotlin.doc.highlighter2.Html2CompilerPlugin$generate$1;
import org.jetbrains.kotlin.doc.highlighter2.Html2CompilerPlugin$processFile$template$1$render$1;
import org.jetbrains.kotlin.doc.highlighter2.Html2CompilerPlugin$sourceDirPaths$1;
import org.jetbrains.kotlin.doc.highlighter2.Html2CompilerPlugin$sourceDirs$1;
import org.jetbrains.kotlin.doc.model.KModel;
import org.jetbrains.kotlin.doc.model.SourceInfo;
import org.jetbrains.kotlin.doc.names;

@JetClass(signature="Ljava/lang/Object;Lorg/jetbrains/kotlin/doc/Doclet;", flags=16, abiVersion=6)
public final class Html2CompilerPlugin
implements JetObject,
Doclet {
    private final File docOutputRoot;
    private final File srcOutputRoot;
    private final List<? extends File> sourceDirs;
    private final List<? extends String> sourceDirPaths;
    private final KDocArguments compilerArguments;

    @JetMethod(flags=9, propertyType="Ljava/io/File;")
    private final File getDocOutputRoot() {
        return this.docOutputRoot;
    }

    @JetMethod(flags=9, propertyType="Ljava/io/File;")
    private final File getSrcOutputRoot() {
        return this.srcOutputRoot;
    }

    @JetMethod(flags=9, propertyType="Ljet/List<Ljava/io/File;>;")
    private final List<File> getSourceDirs() {
        return this.sourceDirs;
    }

    @JetMethod(flags=9, propertyType="Ljet/List<Ljava/lang/String;>;")
    private final List<String> getSourceDirPaths() {
        return this.sourceDirPaths;
    }

    @JetMethod(flags=8, returnType="Ljava/lang/String;")
    private final String fileToWrite(@JetValueParameter(name="psiFile", type="Lcom/intellij/psi/PsiFile;") PsiFile psiFile) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            throw new TypeCastException("com.intellij.openapi.vfs.VirtualFile? cannot be cast to com.intellij.openapi.vfs.local.CoreLocalVirtualFile");
        }
        String string = ((CoreLocalVirtualFile)virtualFile).getPath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        File file = new File(string).getCanonicalFile();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        File file2 = file;
        String string2 = file2.getPath();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String filePath = string2;
        for (String string3 : this.sourceDirPaths) {
            boolean bl = KotlinPackage.startsWith((String)filePath, (String)string3) ? KotlinPackage.length((String)filePath) > KotlinPackage.length((String)string3) : false;
            if (!bl) continue;
            String relativePath = KotlinPackage.substring((String)filePath, (int)(string3.length() + 1));
            return relativePath;
        }
        throw (Throwable)new Exception(file2 + " is not a child of any source roots " + this.sourceDirPaths);
    }

    @Override
    @JetMethod(flags=16, returnType="V")
    public void generate(@JetValueParameter(name="model", type="Lorg/jetbrains/kotlin/doc/model/KModel;") KModel model, @JetValueParameter(name="outputDir", type="Ljava/io/File;") File outputDir) {
        this.srcOutputRoot.mkdirs();
        ClassLoader classLoader = Html2CompilerPlugin.class.getClassLoader();
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        InputStream inputStream = classLoader.getResourceAsStream("org/jetbrains/kotlin/doc/highlighter2/hightlight.css");
        if (inputStream == null) {
            Intrinsics.throwNpe();
        }
        InputStream css = inputStream;
        Highlighter2Package$src$ioUtils$2b85c397.write(new File(this.srcOutputRoot, "highlight.css"), (Function1<? super FileOutputStream, ? extends Unit>)((Function1)new Html2CompilerPlugin$generate$1(css)));
        for (SourceInfo sourceInfo : model.getSourcesInfo()) {
            this.processFile(sourceInfo);
        }
    }

    @JetMethod(flags=8, returnType="V")
    private final void processFile(@JetValueParameter(name="sourceInfo", type="Lorg/jetbrains/kotlin/doc/model/SourceInfo;") SourceInfo sourceInfo) {
        JetFile psiFile = sourceInfo.getPsi();
        String htmlPath = sourceInfo.getHtmlPath();
        File htmlFile = new File(this.srcOutputRoot, htmlPath);
        IoPackage.println((Object)("Generating " + htmlFile));
        File file = htmlFile.getParentFile();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        file.mkdirs();
        JetObject template2 = new JetObject(this, psiFile){
            final /* synthetic */ Html2CompilerPlugin this$0;
            final /* synthetic */ JetFile $psiFile;

            @JetMethod(flags=16, returnType="V")
            public void render() {
                this.html((Function0<? extends Unit>)((Function0)new Html2CompilerPlugin$processFile$template$1$render$1(this)));
            }
            {
                this.this$0 = $outer;
                this.$psiFile = $shared_var$1;
            }
        };
        template2.renderTo(htmlFile);
    }

    @JetMethod(flags=9, propertyType="Lorg/jetbrains/kotlin/doc/KDocArguments;")
    private final KDocArguments getCompilerArguments() {
        return this.compilerArguments;
    }

    @JetConstructor
    public Html2CompilerPlugin(@JetValueParameter(name="compilerArguments", type="Lorg/jetbrains/kotlin/doc/KDocArguments;") KDocArguments compilerArguments) {
        this.compilerArguments = compilerArguments;
        String docOutputDir = this.compilerArguments.getDocConfig().getDocOutputDir();
        if (KotlinPackage.isEmpty((String)docOutputDir)) {
            throw (Throwable)new IllegalArgumentException("empty doc output dir");
        }
        this.docOutputRoot = new File(docOutputDir);
        this.srcOutputRoot = new File(this.docOutputRoot, names.instance$.getHtmlSourceDirName());
        this.sourceDirs = KotlinPackage.map((Collection)KotlinPackage.requireNoNulls((List)KotlinPackage.orEmpty((List)this.compilerArguments.getSourceDirs())), (Function1)((Function1)Html2CompilerPlugin$sourceDirs$1.instance$));
        this.sourceDirPaths = KotlinPackage.map((Collection)this.sourceDirs, (Function1)((Function1)Html2CompilerPlugin$sourceDirPaths$1.instance$));
    }
}

