/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.fus.internal;

import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.fus.internal.Metric;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\nH\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/fus/internal/Metric;", "", "name", "", "projectHash", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getProjectHash", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "fus-statistics-gradle-plugin_common"})
public final class Metric
implements Comparable<Metric> {
    @NotNull
    private final String name;
    @Nullable
    private final String projectHash;

    public Metric(@NotNull String name, @Nullable String projectHash) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.projectHash = projectHash;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getProjectHash() {
        return this.projectHash;
    }

    @Override
    public int compareTo(@NotNull Metric other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE};
        return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
    }

    @NotNull
    public String toString() {
        String suffix = this.projectHash == null ? "" : '.' + this.projectHash;
        return this.name + suffix;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @Nullable
    public final String component2() {
        return this.projectHash;
    }

    @NotNull
    public final Metric copy(@NotNull String name, @Nullable String projectHash) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Metric(name, projectHash);
    }

    public static /* synthetic */ Metric copy$default(Metric metric, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = metric.name;
        }
        if ((n & 2) != 0) {
            string2 = metric.projectHash;
        }
        return metric.copy(string, string2);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + (this.projectHash == null ? 0 : this.projectHash.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Metric)) {
            return false;
        }
        Metric metric = (Metric)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)metric.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.projectHash, (Object)metric.projectHash);
    }
}

