/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.fus.internal;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.fus.GradleBuildFusStatisticsService;
import org.jetbrains.kotlin.gradle.fus.UsesGradleBuildFusStatisticsService;
import org.jetbrains.kotlin.gradle.fus.internal.DummyGradleBuildFusStatisticsService;
import org.jetbrains.kotlin.gradle.fus.internal.GradleBuildFusStatisticsBuildService;
import org.jetbrains.kotlin.gradle.fus.internal.InternalGradleBuildFusStatisticsService;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00062\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0002\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/fus/internal/GradleBuildFusStatisticsBuildService;", "Lorg/jetbrains/kotlin/gradle/fus/GradleBuildFusStatisticsService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/fus/internal/GradleBuildFusStatisticsBuildService$Parameters;", "Ljava/lang/AutoCloseable;", "()V", "Companion", "Parameters", "fus-statistics-gradle-plugin_common"})
public abstract class GradleBuildFusStatisticsBuildService
implements GradleBuildFusStatisticsService,
BuildService<Parameters>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean statisticsIsEnabled = true;
    @NotNull
    private static final String FUS_STATISTICS_PATH = "kotlin.session.logger.root.path";
    @NotNull
    private static final Class<GradleBuildFusStatisticsBuildService> serviceClass = GradleBuildFusStatisticsBuildService.class;
    @NotNull
    private static final String serviceName = serviceClass.getName() + '_' + serviceClass.getClassLoader().hashCode();
    private static final Logger log = Logging.getLogger(GradleBuildFusStatisticsService.class);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0013H\u0002J\u0018\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0015\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/fus/internal/GradleBuildFusStatisticsBuildService$Companion;", "", "()V", "FUS_STATISTICS_PATH", "", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "serviceClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/gradle/fus/internal/GradleBuildFusStatisticsBuildService;", "serviceName", "statisticsIsEnabled", "", "configureTasks", "", "project", "Lorg/gradle/api/Project;", "serviceProvider", "Lorg/gradle/api/provider/Provider;", "registerIfAbsent", "Lorg/jetbrains/kotlin/gradle/fus/GradleBuildFusStatisticsService;", "fus-statistics-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nGradleBuildFusStatisticsBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildFusStatisticsBuildService.kt\norg/jetbrains/kotlin/gradle/fus/internal/GradleBuildFusStatisticsBuildService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Provider<? extends GradleBuildFusStatisticsService> registerIfAbsent(@NotNull Project project) {
            Provider provider;
            Provider provider2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(serviceName);
            if (buildServiceRegistration != null) {
                BuildServiceRegistration it = buildServiceRegistration;
                boolean bl = false;
                Provider provider3 = it.getService();
                Intrinsics.checkNotNull((Object)provider3, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<org.jetbrains.kotlin.gradle.fus.GradleBuildFusStatisticsService>");
                return provider3;
            }
            String string = (String)project.getProviders().gradleProperty(GradleBuildFusStatisticsBuildService.FUS_STATISTICS_PATH).getOrNull();
            if (string == null) {
                String string2 = project.getGradle().getGradleUserHomeDir().getPath();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.gradle.gradleUserHomeDir.path");
            }
            String customPath = string;
            if (!statisticsIsEnabled || StringsKt.isBlank((CharSequence)customPath)) {
                log.info("Fus metrics wont be collected as statistic was " + (statisticsIsEnabled ? "enabled" : "disabled") + (StringsKt.isBlank((CharSequence)customPath) ? " and custom path is blank" : ""));
                provider2 = project.getGradle().getSharedServices().registerIfAbsent(serviceName, DummyGradleBuildFusStatisticsService.class, (Action)registerIfAbsent.2.INSTANCE);
            } else {
                provider2 = project.getGradle().getSharedServices().registerIfAbsent(serviceName, InternalGradleBuildFusStatisticsService.class, new Action(customPath){
                    final /* synthetic */ String $customPath;
                    {
                        this.$customPath = $customPath;
                    }

                    public final void execute(BuildServiceSpec<Parameters> it) {
                        ((Parameters)it.getParameters()).getFusStatisticsRootDirPath().set((Object)this.$customPath);
                        ((Parameters)it.getParameters()).getBuildId().set((Object)UUID.randomUUID().toString());
                    }
                });
            }
            Provider it = provider = provider2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Companion.configureTasks(project, (Provider<? extends GradleBuildFusStatisticsBuildService>)it);
            return provider;
        }

        private final void configureTasks(Project project, Provider<? extends GradleBuildFusStatisticsBuildService> serviceProvider) {
            project.getTasks().withType(UsesGradleBuildFusStatisticsService.class).configureEach(new Action(serviceProvider){
                final /* synthetic */ Provider<? extends GradleBuildFusStatisticsBuildService> $serviceProvider;
                {
                    this.$serviceProvider = $serviceProvider;
                }

                public final void execute(UsesGradleBuildFusStatisticsService task) {
                    task.getFusStatisticsBuildService().value(this.$serviceProvider).disallowChanges();
                    task.usesService(this.$serviceProvider);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/fus/internal/GradleBuildFusStatisticsBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "buildId", "Lorg/gradle/api/provider/Property;", "", "getBuildId", "()Lorg/gradle/api/provider/Property;", "fusStatisticsRootDirPath", "getFusStatisticsRootDirPath", "fus-statistics-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getFusStatisticsRootDirPath();

        @NotNull
        public Property<String> getBuildId();
    }
}

