/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.commonizer.core.VisibilityCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirDeclarationWithVisibility;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirFunctionOrProperty;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ir.CirFunctionOrPropertyKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/core/LoweringVisibilityCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/VisibilityCommonizer;", "allowPrivate", "", "(Z)V", "atLeastOneVirtualCallableMet", "atLeastTwoVisibilitiesMet", "canBeCommonized", "next", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/ir/CirDeclarationWithVisibility;", "getNext", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "current", "commonizer"})
final class LoweringVisibilityCommonizer
extends VisibilityCommonizer {
    private boolean atLeastOneVirtualCallableMet;
    private boolean atLeastTwoVisibilitiesMet;

    @Override
    protected boolean canBeCommonized(@NotNull CirDeclarationWithVisibility next) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        if (!this.atLeastOneVirtualCallableMet) {
            CirDeclarationWithVisibility cirDeclarationWithVisibility = next;
            if (!(cirDeclarationWithVisibility instanceof CirFunctionOrProperty)) {
                cirDeclarationWithVisibility = null;
            }
            CirFunctionOrProperty cirFunctionOrProperty = (CirFunctionOrProperty)cirDeclarationWithVisibility;
            this.atLeastOneVirtualCallableMet = cirFunctionOrProperty != null && CirFunctionOrPropertyKt.isVirtual(cirFunctionOrProperty);
        }
        return !this.atLeastOneVirtualCallableMet || !this.atLeastTwoVisibilitiesMet;
    }

    @Override
    @NotNull
    protected Visibility getNext(@NotNull Visibility current, @NotNull Visibility next) {
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        Integer n = Visibilities.compare((Visibility)current, (Visibility)next);
        if (n == null) {
            Visibility visibility = Visibilities.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.UNKNOWN");
            return visibility;
        }
        int comparisonResult = n;
        if (!this.atLeastTwoVisibilitiesMet) {
            boolean bl = this.atLeastTwoVisibilitiesMet = comparisonResult != 0;
        }
        if (this.atLeastOneVirtualCallableMet && this.atLeastTwoVisibilitiesMet) {
            Visibility visibility = Visibilities.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.UNKNOWN");
            return visibility;
        }
        return comparisonResult <= 0 ? current : next;
    }

    public LoweringVisibilityCommonizer(boolean allowPrivate) {
        super(allowPrivate);
    }
}

