/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0003*\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"DEPRECATED_ANNOTATION_FQN", "Lorg/jetbrains/kotlin/name/FqName;", "isBlacklistedDarwinFunction", "", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "isKniBridgeFunction", "commonizer"})
public final class BlacklistKt {
    private static final FqName DEPRECATED_ANNOTATION_FQN = new FqName(Deprecated.class.getName());

    public static final boolean isKniBridgeFunction(@NotNull SimpleFunctionDescriptor $this$isKniBridgeFunction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isKniBridgeFunction, (String)"$this$isKniBridgeFunction");
        String string = $this$isKniBridgeFunction.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.asString()");
        return StringsKt.startsWith$default((String)string, (String)"kniBridge", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBlacklistedDarwinFunction(@NotNull SimpleFunctionDescriptor $this$isBlacklistedDarwinFunction) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isBlacklistedDarwinFunction, (String)"$this$isBlacklistedDarwinFunction");
        DeclarationDescriptor declarationDescriptor = $this$isBlacklistedDarwinFunction.getContainingDeclaration();
        if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) {
            declarationDescriptor = null;
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor;
        PackageFragmentDescriptor packageFragmentDescriptor2 = packageFragmentDescriptor;
        if (packageFragmentDescriptor == null) return false;
        FqName fqName2 = packageFragmentDescriptor2.getFqName();
        packageFragmentDescriptor2 = fqName2;
        if (fqName2 == null) return false;
        if (!UtilsKt.isUnderDarwinPackage((FqName)packageFragmentDescriptor2)) {
            return false;
        }
        String string = $this$isBlacklistedDarwinFunction.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.asString()");
        String name = string;
        if (!StringsKt.startsWith$default((String)name, (String)"simd_", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"__", (boolean)false, (int)2, null)) {
            return false;
        }
        if ($this$isBlacklistedDarwinFunction.getAnnotations().hasAnnotation(DEPRECATED_ANNOTATION_FQN)) {
            return true;
        }
        List list = $this$isBlacklistedDarwinFunction.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"valueParameters");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            KotlinType type2;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)element$iv;
            boolean bl2 = false;
            ValueParameterDescriptor valueParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameter");
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor.getType(), (String)"parameter.type");
            SimpleType abbreviationType = SpecialTypesKt.getAbbreviation((KotlinType)type2);
            if (abbreviationType != null) {
                KotlinType $this$declarationDescriptor$iv = (KotlinType)abbreviationType;
                boolean $i$f$getDeclarationDescriptor = false;
                ClassifierDescriptor classifierDescriptor = $this$declarationDescriptor$iv.getConstructor().getDeclarationDescriptor();
                if (classifierDescriptor == null) {
                    String string2 = "No declaration descriptor found for " + $this$declarationDescriptor$iv.getConstructor();
                    boolean bl3 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                String string3 = classifierDescriptor.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"abbreviationType.declara\u2026escriptor.name.asString()");
                if (StringsKt.startsWith$default((String)string3, (String)"simd_", (boolean)false, (int)2, null)) {
                    $this$declarationDescriptor$iv = type2;
                    $i$f$getDeclarationDescriptor = false;
                    ClassifierDescriptor classifierDescriptor2 = $this$declarationDescriptor$iv.getConstructor().getDeclarationDescriptor();
                    if (classifierDescriptor2 == null) {
                        String string4 = "No declaration descriptor found for " + $this$declarationDescriptor$iv.getConstructor();
                        boolean bl4 = false;
                        throw (Throwable)new IllegalStateException(string4.toString());
                    }
                    if (Intrinsics.areEqual((Object)classifierDescriptor2.getName().asString(), (Object)"Vector128")) {
                        return true;
                    }
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }
}

