/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.projectStructure;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaModuleBase;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.AnalysisApiKtTestModuleStructureProviderKt;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KaLibraryModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.LibraryByRoots;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.WasmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.platform.wasm.WasmTarget;
import org.jetbrains.kotlin.test.frontend.fir.TestFirJsSessionFactoryKt;
import org.jetbrains.kotlin.test.frontend.fir.TestFirNativeSessionFactoryKt;
import org.jetbrains.kotlin.test.frontend.fir.TestFirWasmSessionFactoryKt;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilationStage;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TargetPlatformProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.wasm.config.WasmTargetKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0007H\u0002J\n\u0010$\u001a\u0004\u0018\u00010#H\u0002J\u001c\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00072\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0007H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001f\u0010\u0012R'\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00078VX\u0096\u0084\u0002\u00a2\u0006\u0012\n\u0004\b)\u0010!\u0012\u0004\b&\u0010'\u001a\u0004\b(\u0010\u0012R!\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010!\u001a\u0004\b+\u0010\u0012R\u0012\u0010-\u001a\u00020\u001eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u00104\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtModuleByCompilerConfiguration;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KaModuleBase;", "project", "Lcom/intellij/openapi/project/Project;", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "psiFiles", "", "Lcom/intellij/psi/PsiFile;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/test/model/TestModule;Ljava/util/List;Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTestModule", "()Lorg/jetbrains/kotlin/test/model/TestModule;", "getPsiFiles", "()Ljava/util/List;", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "compilerConfigurationProvider", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "name", "", "getName", "()Ljava/lang/String;", "directRegularDependencies", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "getDirectRegularDependencies", "directRegularDependencies$delegate", "Lkotlin/Lazy;", "computeLibraryDependencies", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "createJdkFromConfiguration", "directDependsOnDependencies", "getDirectDependsOnDependencies$annotations", "()V", "getDirectDependsOnDependencies", "directDependsOnDependencies$delegate", "directFriendDependencies", "getDirectFriendDependencies", "directFriendDependencies$delegate", "ktModule", "getKtModule", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "librariesByRoots", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/LibraryByRoots;", "roots", "Ljava/nio/file/Path;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "analysis-test-framework_testFixtures"})
@SourceDebugExtension(value={"SMAP\nKaSourceModuleByCompilerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaSourceModuleByCompilerConfiguration.kt\norg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtModuleByCompilerConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1586#2:223\n1661#2,3:224\n1586#2:227\n1661#2,3:228\n1586#2:231\n1661#2,3:232\n1586#2:235\n1661#2,3:236\n1586#2:239\n1661#2,3:240\n1586#2:243\n1661#2,3:244\n1661#2,3:247\n1586#2:250\n1661#2,3:251\n1661#2,3:254\n1586#2:257\n1661#2,3:258\n*S KotlinDebug\n*F\n+ 1 KaSourceModuleByCompilerConfiguration.kt\norg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtModuleByCompilerConfiguration\n*L\n65#1:223\n65#1:224,3\n68#1:227\n68#1:228,3\n71#1:231\n71#1:232,3\n75#1:235\n75#1:236,3\n76#1:239\n76#1:240,3\n122#1:243\n122#1:244,3\n56#1:247,3\n108#1:250\n108#1:251,3\n113#1:254,3\n115#1:257\n115#1:258,3\n*E\n"})
public abstract class KtModuleByCompilerConfiguration
extends KaModuleBase {
    @NotNull
    private final Project project;
    @NotNull
    private final TestModule testModule;
    @NotNull
    private final List<PsiFile> psiFiles;
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final CompilerConfigurationProvider compilerConfigurationProvider;
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final Lazy directRegularDependencies$delegate;
    @NotNull
    private final Lazy directDependsOnDependencies$delegate;
    @NotNull
    private final Lazy directFriendDependencies$delegate;

    public KtModuleByCompilerConfiguration(@NotNull Project project, @NotNull TestModule testModule, @NotNull List<? extends PsiFile> psiFiles, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter(psiFiles, (String)"psiFiles");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.project = project;
        this.testModule = testModule;
        this.psiFiles = psiFiles;
        this.testServices = testServices;
        this.compilerConfigurationProvider = CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)this.testServices);
        this.configuration = this.compilerConfigurationProvider.getCompilerConfiguration(this.testModule, CompilationStage.FIRST);
        this.directRegularDependencies$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KtModuleByCompilerConfiguration.directRegularDependencies_delegate$lambda$0(this));
        this.directDependsOnDependencies$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KtModuleByCompilerConfiguration.directDependsOnDependencies_delegate$lambda$0(this));
        this.directFriendDependencies$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KtModuleByCompilerConfiguration.directFriendDependencies_delegate$lambda$0(this));
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final TestModule getTestModule() {
        return this.testModule;
    }

    @NotNull
    public final List<PsiFile> getPsiFiles() {
        return this.psiFiles;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @NotNull
    public final String getName() {
        return this.testModule.getName();
    }

    @NotNull
    public List<KaModule> getDirectRegularDependencies() {
        Lazy lazy = this.directRegularDependencies$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<KaLibraryModule> computeLibraryDependencies() {
        List list;
        TargetPlatform targetPlatform = TargetPlatformProviderKt.targetPlatform((TestModule)this.testModule, (TestServices)this.testServices);
        if (NativePlatformKt.isNative((TargetPlatform)targetPlatform)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = TestFirNativeSessionFactoryKt.getAllNativeDependenciesPaths((TestModule)this.testModule, (TestServices)this.testServices);
            KtModuleByCompilerConfiguration ktModuleByCompilerConfiguration = this;
            boolean $i$f$map = false;
            void var4_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Paths.get((String)it, new String[0]));
            }
            list = ktModuleByCompilerConfiguration.librariesByRoots((List)destination$iv$iv);
        } else if (WasmPlatformKt.isWasm((TargetPlatform)targetPlatform)) {
            Iterable $this$map$iv = TestFirWasmSessionFactoryKt.getAllWasmDependenciesPaths((TestModule)this.testModule, (TestServices)this.testServices, (WasmTarget)WasmTargetKt.getWasmTarget((CompilerConfiguration)this.configuration));
            KtModuleByCompilerConfiguration ktModuleByCompilerConfiguration = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Paths.get(it, new String[0]));
            }
            list = ktModuleByCompilerConfiguration.librariesByRoots((List)destination$iv$iv);
        } else if (JsPlatformKt.isJs((TargetPlatform)targetPlatform)) {
            Iterable $this$map$iv = TestFirJsSessionFactoryKt.getAllJsDependenciesPaths((TestModule)this.testModule, (TestServices)this.testServices);
            KtModuleByCompilerConfiguration ktModuleByCompilerConfiguration = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Paths.get(it, new String[0]));
            }
            list = ktModuleByCompilerConfiguration.librariesByRoots((List)destination$iv$iv);
        } else {
            File p0;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            List list2;
            List list3;
            List $this$computeLibraryDependencies_u24lambda_u243 = list3 = kotlin.collections.CollectionsKt.createListBuilder();
            boolean bl = false;
            List $this$computeLibraryDependencies_u24lambda_u243_u240 = list2 = kotlin.collections.CollectionsKt.createListBuilder();
            boolean bl2 = false;
            Iterable item$iv$iv = JvmContentRootsKt.getJvmModularRoots((CompilerConfiguration)this.configuration);
            List list4 = $this$computeLibraryDependencies_u24lambda_u243_u240;
            boolean $i$f$map = false;
            void var11_44 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                File file = (File)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(p0.toPath());
            }
            list4.addAll((List)destination$iv$iv);
            $this$map$iv = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)this.configuration);
            list4 = $this$computeLibraryDependencies_u24lambda_u243_u240;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                p0 = (File)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(p0.toPath());
            }
            list4.addAll((List)destination$iv$iv);
            List roots = kotlin.collections.CollectionsKt.build((List)list2);
            $this$computeLibraryDependencies_u24lambda_u243.addAll((Collection)this.librariesByRoots(roots));
            CollectionsKt.addIfNotNull((Collection)$this$computeLibraryDependencies_u24lambda_u243, (Object)this.createJdkFromConfiguration());
            list = kotlin.collections.CollectionsKt.build((List)list3);
        }
        return list;
    }

    private final KaLibraryModule createJdkFromConfiguration() {
        KaLibraryModuleImpl kaLibraryModuleImpl;
        File file = (File)this.configuration.get(JVMConfigurationKeys.JDK_HOME);
        if (file != null) {
            File jdkHome = file;
            boolean bl = false;
            List jdkHomePaths = StandaloneProjectFactory.INSTANCE.getDefaultJdkModulePaths(this.getProject(), jdkHome.toPath());
            GlobalSearchScope scope = StandaloneProjectFactory.INSTANCE.createLibraryModuleSearchScope((Collection)jdkHomePaths, (Collection)kotlin.collections.CollectionsKt.emptyList(), (CoreApplicationEnvironment)AnalysisApiEnvironmentManagerKt.getEnvironmentManager(this.testServices).getApplicationEnvironment(), this.getProject());
            kaLibraryModuleImpl = new KaLibraryModuleImpl("jdk", JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), scope, this.getProject(), jdkHomePaths, null, true);
        } else {
            kaLibraryModuleImpl = null;
        }
        return kaLibraryModuleImpl;
    }

    @NotNull
    public List<KaModule> getDirectDependsOnDependencies() {
        Lazy lazy = this.directDependsOnDependencies$delegate;
        return (List)lazy.getValue();
    }

    public static /* synthetic */ void getDirectDependsOnDependencies$annotations() {
    }

    @NotNull
    public List<KaModule> getDirectFriendDependencies() {
        Lazy lazy = this.directFriendDependencies$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    protected abstract KaModule getKtModule();

    /*
     * WARNING - void declaration
     */
    private final List<LibraryByRoots> librariesByRoots(List<? extends Path> roots) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = roots;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LibraryByRoots(kotlin.collections.CollectionsKt.listOf((Object)it), this.getKtModule(), this.getProject(), this.testServices));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.testModule.getLanguageVersionSettings();
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return TargetPlatformProviderKt.targetPlatform((TestModule)this.testModule, (TestServices)this.testServices);
    }

    /*
     * WARNING - void declaration
     */
    private static final List directRegularDependencies_delegate$lambda$0(KtModuleByCompilerConfiguration this$0) {
        void $this$mapTo$iv;
        List list;
        List $this$directRegularDependencies_delegate_u24lambda_u240_u240 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = this$0.testModule.getAllDependencies();
        Collection destination$iv = $this$directRegularDependencies_delegate_u24lambda_u240_u240;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            DependencyDescription dependencyDescription = (DependencyDescription)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            collection.add(AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(this$0.testServices).getKtTestModule(it.getDependencyModule().getName()).getKtModule());
        }
        $this$directRegularDependencies_delegate_u24lambda_u240_u240.addAll((Collection)this$0.computeLibraryDependencies());
        return kotlin.collections.CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private static final List directDependsOnDependencies_delegate$lambda$0(KtModuleByCompilerConfiguration this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.testModule.getDependsOnDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(this$0.testServices).getKtTestModule(it.getDependencyModule().getName()).getKtModule());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List directFriendDependencies_delegate$lambda$0(KtModuleByCompilerConfiguration this$0) {
        Collection<Path> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection2;
        Iterable $this$mapTo$iv;
        List list;
        List $this$directFriendDependencies_delegate_u24lambda_u240_u240 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = this$0.testModule.getFriendDependencies();
        Collection destination$iv = $this$directFriendDependencies_delegate_u24lambda_u240_u240;
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            DependencyDescription dependencyDescription = (DependencyDescription)item$iv;
            collection2 = destination$iv;
            boolean bl2 = false;
            collection2.add(AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(this$0.testServices).getKtTestModule(it.getDependencyModule().getName()).getKtModule());
        }
        List list2 = (List)this$0.configuration.get(JVMConfigurationKeys.FRIEND_PATHS);
        if (list2 == null) {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        }
        $this$mapTo$iv = list2;
        KtModuleByCompilerConfiguration ktModuleByCompilerConfiguration = this$0;
        collection2 = $this$directFriendDependencies_delegate_u24lambda_u240_u240;
        boolean $i$f$map = false;
        void $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(Paths.get((String)p0, new String[0]));
        }
        collection = (List)destination$iv$iv;
        collection2.addAll((Collection)ktModuleByCompilerConfiguration.librariesByRoots((List<? extends Path>)collection));
        return kotlin.collections.CollectionsKt.build((List)list);
    }
}

