/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CliTestModuleCompiler;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.JvmJarTestModuleCompiler;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.test.MockLibraryUtil;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J4\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0014J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/JvmJarTestModuleCompiler;", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CliTestModuleCompiler;", "<init>", "()V", "libraryOutputPath", "Ljava/nio/file/Path;", "inputPath", "libraryName", "", "buildPlatformCompilerOptions", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "doCompile", "", "sourcesPath", "options", "extraClasspath", "buildPlatformExtraClasspath", "analysis-test-framework_testFixtures"})
public final class JvmJarTestModuleCompiler
extends CliTestModuleCompiler {
    @NotNull
    public static final JvmJarTestModuleCompiler INSTANCE = new JvmJarTestModuleCompiler();

    private JvmJarTestModuleCompiler() {
    }

    @Override
    @NotNull
    protected Path libraryOutputPath(@NotNull Path inputPath, @NotNull String libraryName) {
        Intrinsics.checkNotNullParameter((Object)inputPath, (String)"inputPath");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Path path = inputPath.resolve(libraryName + ".jar");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Override
    @NotNull
    protected List<String> buildPlatformCompilerOptions(@NotNull TestModule module, @NotNull TestServices testServices) {
        List list;
        block8: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
            List $this$buildPlatformCompilerOptions_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            JvmTarget jvmTarget = (JvmTarget)CollectionsKt.firstOrNull((List)module.getDirectives().get(JvmEnvironmentConfigurationDirectives.INSTANCE.getJVM_TARGET()));
            if (jvmTarget == null) break block8;
            JvmTarget jvmTarget2 = jvmTarget;
            boolean bl2 = false;
            Object[] objectArray = new String[]{ArgumentUtilsKt.getCliArgument((KProperty1)((KProperty1)buildPlatformCompilerOptions.1.1.1.INSTANCE)), jvmTarget2.getDescription()};
            $this$buildPlatformCompilerOptions_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
            if (jvmTarget2.compareTo((Enum)JvmTarget.JVM_1_8) <= 0) {
                object = KtTestUtil.getJdk8Home();
            } else if (jvmTarget2.compareTo((Enum)JvmTarget.JVM_11) <= 0) {
                object = KtTestUtil.getJdk11Home();
            } else if (jvmTarget2.compareTo((Enum)JvmTarget.JVM_17) <= 0) {
                object = KtTestUtil.getJdk17Home();
            } else if (jvmTarget2.compareTo((Enum)JvmTarget.JVM_21) <= 0) {
                object = KtTestUtil.getJdk21Home();
            } else {
                throw new IllegalStateException(("JDK for " + jvmTarget2 + " is not found").toString());
            }
            Object[] objectArray2 = object;
            Intrinsics.checkNotNull((Object)objectArray2);
            Object[] jdkHome = objectArray2;
            objectArray2 = new String[2];
            objectArray2[0] = ArgumentUtilsKt.getCliArgument((KProperty1)((KProperty1)buildPlatformCompilerOptions.1.1.2.INSTANCE));
            Intrinsics.checkNotNullExpressionValue((Object)jdkHome.toString(), (String)"toString(...)");
            $this$buildPlatformCompilerOptions_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray2));
        }
        return CollectionsKt.build((List)list);
    }

    @Override
    protected void doCompile(@NotNull Path sourcesPath, @NotNull List<String> options, @NotNull Path libraryOutputPath, @NotNull List<String> extraClasspath) {
        List list;
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)libraryOutputPath, (String)"libraryOutputPath");
        Intrinsics.checkNotNullParameter(extraClasspath, (String)"extraClasspath");
        String string = ((Object)sourcesPath.toAbsolutePath()).toString();
        File file = sourcesPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File file2 = file;
        String string2 = PathsKt.getNameWithoutExtension((Path)libraryOutputPath);
        List $this$doCompile_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$doCompile_u24lambda_u240.addAll((Collection)options);
        List list2 = CollectionsKt.build((List)list);
        MockLibraryUtil.compileLibraryToJar$default((String)string, (File)file2, (String)string2, (boolean)false, (boolean)false, (List)list2, extraClasspath, null, (boolean)true, (int)152, null);
    }

    @Override
    @NotNull
    protected List<String> buildPlatformExtraClasspath(@NotNull TestModule module, @NotNull TestServices testServices) {
        List list;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        List $this$buildPlatformExtraClasspath_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CompilerConfiguration compilerConfiguration = CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)testServices).getCompilerConfiguration(module);
        for (File file : JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)compilerConfiguration)) {
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            $this$buildPlatformExtraClasspath_u24lambda_u240.add(string);
        }
        return CollectionsKt.build((List)list);
    }
}

