/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.test.framework.services.TargetPlatformEnum;
import org.jetbrains.kotlin.test.directives.model.DirectiveApplicability;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ6\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH&J&\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler;", "Lorg/jetbrains/kotlin/test/services/TestService;", "<init>", "()V", "compileTestModuleToLibrary", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler$CompilationResult;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "dependencyBinaryRoots", "", "Ljava/nio/file/Path;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "compile", "tmpDir", "libraryName", "", "compileSources", "files", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "CompilationResult", "Directives", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nTestModuleCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestModuleCompiler.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1491#2:76\n1516#2,3:77\n1519#2,3:87\n1869#2:90\n1869#2,2:92\n1870#2:94\n382#3,7:80\n1#4:91\n*S KotlinDebug\n*F\n+ 1 TestModuleCompiler.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler\n*L\n29#1:76\n29#1:77,3\n29#1:87,3\n32#1:90\n34#1:92,2\n32#1:94\n29#1:80,7\n*E\n"})
public abstract class TestModuleCompiler
implements TestService {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilationResult compileTestModuleToLibrary(@NotNull TestModule module, @NotNull Collection<? extends Path> dependencyBinaryRoots, @NotNull TestServices testServices) {
        Object object;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(dependencyBinaryRoots, (String)"dependencyBinaryRoots");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Iterable $this$groupBy$iv = module.getFiles();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            TestFile it = (TestFile)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = (String)CollectionsKt.singleOrNull((List)it.getDirectives().get(Directives.INSTANCE.getBINARY_ROOT()));
            object = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map byRoot = destination$iv$iv;
        List binary = new ArrayList();
        List sources = new ArrayList();
        Iterable $this$forEach$iv = byRoot.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String binaryRootName = (String)entry.getKey();
            List files = (List)entry.getValue();
            Path it = KtTestUtil.tmpDir((String)"testSourcesToCompile").toPath();
            boolean bl3 = false;
            if (binaryRootName != null) {
                Intrinsics.checkNotNull((Object)it);
                Path path2 = it.resolve(binaryRootName);
                path = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            } else {
                path = it;
            }
            Path tmpDir = path;
            Iterable $this$forEach$iv2 = files;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Path tmpSourceFile;
                Path path3;
                Path filePath;
                TestFile testFile = (TestFile)element$iv2;
                boolean bl4 = false;
                String text2 = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile(testFile);
                Intrinsics.checkNotNull((Object)tmpDir);
                Intrinsics.checkNotNullExpressionValue((Object)tmpDir.resolve(testFile.getRelativePath()), (String)"resolve(...)");
                Intrinsics.checkNotNullExpressionValue((Object)filePath.getParent(), (String)"getParent(...)");
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(filePath, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createFile(...)");
                PathsKt.writeText$default((Path)tmpSourceFile, (CharSequence)text2, null, (OpenOption[])new OpenOption[0], (int)2, null);
            }
            Object $this$compileTestModuleToLibrary_u24lambda_u241_u242 = object = new StringBuilder();
            boolean bl5 = false;
            ((StringBuilder)$this$compileTestModuleToLibrary_u24lambda_u241_u242).append(module.getName());
            if (binaryRootName != null) {
                ((StringBuilder)$this$compileTestModuleToLibrary_u24lambda_u241_u242).append("-");
                ((StringBuilder)$this$compileTestModuleToLibrary_u24lambda_u241_u242).append(binaryRootName);
            }
            String libraryName = ((StringBuilder)object).toString();
            Intrinsics.checkNotNull((Object)tmpDir);
            binary.add(this.compile(tmpDir, module, libraryName, dependencyBinaryRoots, testServices));
            sources.add(this.compileSources(files, module, testServices));
        }
        return new CompilationResult(binary, sources);
    }

    @NotNull
    public abstract Path compile(@NotNull Path var1, @NotNull TestModule var2, @NotNull String var3, @NotNull Collection<? extends Path> var4, @NotNull TestServices var5);

    @NotNull
    public abstract Path compileSources(@NotNull List<TestFile> var1, @NotNull TestModule var2, @NotNull TestServices var3);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler$CompilationResult;", "", "binaries", "", "Ljava/nio/file/Path;", "sources", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getBinaries", "()Ljava/util/List;", "getSources", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "analysis-test-framework_test"})
    public static final class CompilationResult {
        @NotNull
        private final List<Path> binaries;
        @NotNull
        private final List<Path> sources;

        public CompilationResult(@NotNull List<? extends Path> binaries, @NotNull List<? extends Path> sources) {
            Intrinsics.checkNotNullParameter(binaries, (String)"binaries");
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            this.binaries = binaries;
            this.sources = sources;
        }

        @NotNull
        public final List<Path> getBinaries() {
            return this.binaries;
        }

        @NotNull
        public final List<Path> getSources() {
            return this.sources;
        }

        @NotNull
        public final List<Path> component1() {
            return this.binaries;
        }

        @NotNull
        public final List<Path> component2() {
            return this.sources;
        }

        @NotNull
        public final CompilationResult copy(@NotNull List<? extends Path> binaries, @NotNull List<? extends Path> sources) {
            Intrinsics.checkNotNullParameter(binaries, (String)"binaries");
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            return new CompilationResult(binaries, sources);
        }

        public static /* synthetic */ CompilationResult copy$default(CompilationResult compilationResult, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = compilationResult.binaries;
            }
            if ((n & 2) != 0) {
                list2 = compilationResult.sources;
            }
            return compilationResult.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "CompilationResult(binaries=" + this.binaries + ", sources=" + this.sources + ')';
        }

        public int hashCode() {
            int result = ((Object)this.binaries).hashCode();
            result = result * 31 + ((Object)this.sources).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompilationResult)) {
                return false;
            }
            CompilationResult compilationResult = (CompilationResult)other;
            if (!Intrinsics.areEqual(this.binaries, compilationResult.binaries)) {
                return false;
            }
            return Intrinsics.areEqual(this.sources, compilationResult.sources);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\t\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\t\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler$Directives;", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirectivesContainer;", "<init>", "()V", "COMPILER_ARGUMENTS", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "getCOMPILER_ARGUMENTS", "()Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "COMPILER_ARGUMENTS$delegate", "Lkotlin/properties/ReadOnlyProperty;", "COMPILATION_ERRORS", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "getCOMPILATION_ERRORS", "()Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "COMPILATION_ERRORS$delegate", "LIBRARY_PLATFORMS", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "Lorg/jetbrains/kotlin/analysis/test/framework/services/TargetPlatformEnum;", "getLIBRARY_PLATFORMS", "()Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "LIBRARY_PLATFORMS$delegate", "BINARY_ROOT", "getBINARY_ROOT", "BINARY_ROOT$delegate", "analysis-test-framework_test"})
    @SourceDebugExtension(value={"SMAP\nTestModuleCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestModuleCompiler.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler$Directives\n+ 2 DirectivesContainer.kt\norg/jetbrains/kotlin/test/directives/model/SimpleDirectivesContainer\n*L\n1#1,75:1\n38#2,8:76\n*S KotlinDebug\n*F\n+ 1 TestModuleCompiler.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler$Directives\n*L\n-1#1:76,8\n*E\n"})
    public static final class Directives
    extends SimpleDirectivesContainer {
        @NotNull
        public static final Directives INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final ReadOnlyProperty COMPILER_ARGUMENTS$delegate;
        @NotNull
        private static final ReadOnlyProperty COMPILATION_ERRORS$delegate;
        @NotNull
        private static final ReadOnlyProperty LIBRARY_PLATFORMS$delegate;
        @NotNull
        private static final ReadOnlyProperty BINARY_ROOT$delegate;

        private Directives() {
        }

        @NotNull
        public final StringDirective getCOMPILER_ARGUMENTS() {
            return (StringDirective)COMPILER_ARGUMENTS$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        @NotNull
        public final SimpleDirective getCOMPILATION_ERRORS() {
            return (SimpleDirective)COMPILATION_ERRORS$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        @NotNull
        public final ValueDirective<TargetPlatformEnum> getLIBRARY_PLATFORMS() {
            return (ValueDirective)LIBRARY_PLATFORMS$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        @NotNull
        public final StringDirective getBINARY_ROOT() {
            return (StringDirective)BINARY_ROOT$delegate.getValue((Object)this, $$delegatedProperties[3]);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$iv;
            SimpleDirectivesContainer simpleDirectivesContainer = new SimpleDirectivesContainer[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Directives.class, "COMPILER_ARGUMENTS", "getCOMPILER_ARGUMENTS()Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Directives.class, "COMPILATION_ERRORS", "getCOMPILATION_ERRORS()Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Directives.class, "LIBRARY_PLATFORMS", "getLIBRARY_PLATFORMS()Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Directives.class, "BINARY_ROOT", "getBINARY_ROOT()Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", 0)))};
            $$delegatedProperties = simpleDirectivesContainer;
            INSTANCE = new Directives();
            COMPILER_ARGUMENTS$delegate = SimpleDirectivesContainer.stringDirective$default((SimpleDirectivesContainer)INSTANCE, (String)"List of additional compiler arguments", null, (boolean)false, (int)6, null).provideDelegate((SimpleDirectivesContainer)INSTANCE, $$delegatedProperties[0]);
            COMPILATION_ERRORS$delegate = SimpleDirectivesContainer.directive$default((SimpleDirectivesContainer)INSTANCE, (String)"Is compilation errors expected in the file", null, (int)2, null).provideDelegate((SimpleDirectivesContainer)INSTANCE, $$delegatedProperties[1]);
            simpleDirectivesContainer = INSTANCE;
            String description$iv = "Target platforms allowed for library compilation";
            DirectiveApplicability applicability$iv = DirectiveApplicability.Global;
            Function1 additionalParser$iv = null;
            boolean $i$f$enumDirective = false;
            Enum[] possibleValues$iv = TargetPlatformEnum.values();
            Function1 parser$iv = (Function1)new Function1<String, TargetPlatformEnum>(possibleValues$iv, additionalParser$iv){
                final /* synthetic */ Enum[] $possibleValues;
                final /* synthetic */ Function1 $additionalParser;
                {
                    this.$possibleValues = $possibleValues;
                    this.$additionalParser = $additionalParser;
                }

                public final TargetPlatformEnum invoke(String value) {
                    Enum enum_;
                    Enum enum_2;
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        Enum[] $this$firstOrNull$iv = this.$possibleValues;
                        boolean $i$f$firstOrNull = false;
                        int n = $this$firstOrNull$iv.length;
                        for (int i = 0; i < n; ++i) {
                            Enum element$iv;
                            Enum it = element$iv = $this$firstOrNull$iv[i];
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.name(), (Object)value)) continue;
                            enum_2 = element$iv;
                            break block2;
                        }
                        enum_2 = enum_ = null;
                    }
                    if (enum_2 == null) {
                        Function1 function1 = this.$additionalParser;
                        enum_ = function1 != null ? (Enum)function1.invoke((Object)value) : null;
                    }
                    return enum_;
                }
            };
            LIBRARY_PLATFORMS$delegate = new SimpleDirectivesContainer.DirectiveDelegateProvider((SimpleDirectivesContainer)$this$iv, (Function1)new Function1<String, ValueDirective<TargetPlatformEnum>>(description$iv, applicability$iv, parser$iv){
                final /* synthetic */ String $description;
                final /* synthetic */ DirectiveApplicability $applicability;
                final /* synthetic */ Function1 $parser;
                {
                    this.$description = $description;
                    this.$applicability = $applicability;
                    this.$parser = $parser;
                }

                public final ValueDirective<TargetPlatformEnum> invoke(String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new ValueDirective(it, this.$description, this.$applicability, this.$parser);
                }
            }).provideDelegate((SimpleDirectivesContainer)INSTANCE, $$delegatedProperties[2]);
            BINARY_ROOT$delegate = SimpleDirectivesContainer.stringDirective$default((SimpleDirectivesContainer)INSTANCE, (String)"A library root to which a file will be compiled", (DirectiveApplicability)DirectiveApplicability.File, (boolean)false, (int)4, null).provideDelegate((SimpleDirectivesContainer)INSTANCE, $$delegatedProperties[3]);
        }
    }
}

