/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostic.compiler.based;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.modification.UtilsKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLResolutionFacadeService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLResolutionFacade;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostic.compiler.based.AbstractLLPartialDiagnosticsTestKt;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.AnalysisApiKtTestModuleStructureProviderKt;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphRenderOptions;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphRendererKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.testFramework.UtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostic/compiler/based/ControlFlowGraphConsistencyChecker;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "check", "", "failedAssertions", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "renderControlFlowGraph", "", "forceAnalysis", "", "low-level-api-fir_test"})
@SourceDebugExtension(value={"SMAP\nAbstractLLPartialDiagnosticsTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractLLPartialDiagnosticsTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostic/compiler/based/ControlFlowGraphConsistencyChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1563#2:224\n1634#2,3:225\n*S KotlinDebug\n*F\n+ 1 AbstractLLPartialDiagnosticsTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostic/compiler/based/ControlFlowGraphConsistencyChecker\n*L\n199#1:224\n199#1:225,3\n*E\n"})
final class ControlFlowGraphConsistencyChecker
extends AfterAnalysisChecker {
    public ControlFlowGraphConsistencyChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (!((Collection)failedAssertions).isEmpty()) {
            return;
        }
        String partialAnalysisControlFlowGraphText = this.renderControlFlowGraph(false);
        UtilKt.runWriteAction(() -> ControlFlowGraphConsistencyChecker.check$lambda$0(this));
        String fullAnalysisControlFlowGraphText = this.renderControlFlowGraph(true);
        AssertionsKt.assertEquals$default((Object)fullAnalysisControlFlowGraphText, (Object)partialAnalysisControlFlowGraphText, null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderControlFlowGraph(boolean forceAnalysis) {
        StringBuilder builder = new StringBuilder();
        Project project = AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(this.getTestServices()).getProject();
        ControlFlowGraphRenderOptions renderOptions = new ControlFlowGraphRenderOptions(true, true, null, 4, null);
        for (KtTestModule testModule : AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(this.getTestServices()).getMainModules()) {
            void $this$mapTo$iv$iv;
            KaModule module = testModule.getKtModule();
            String moduleName = testModule.getName();
            LLResolutionFacade resolutionFacade = LLResolutionFacadeService.Companion.getInstance(project).getResolutionFacade(module);
            Iterable $this$map$iv = testModule.getKtFiles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LowLevelFirApiFacadeKt.getOrBuildFirFile((KtFile)it, (LLResolutionFacade)resolutionFacade));
            }
            List firFiles = (List)destination$iv$iv;
            if (forceAnalysis) {
                for (FirDeclaration declaration : AbstractLLPartialDiagnosticsTestKt.access$getDeclarationsToResolve(firFiles)) {
                    FirLazyDeclarationResolverKt.lazyResolveToPhase((FirElementWithResolveState)((FirElementWithResolveState)declaration), (FirResolvePhase)FirResolvePhase.BODY_RESOLVE);
                }
            }
            for (FirFile firFile : firFiles) {
                String fileName = firFile.getName();
                StringBuilder stringBuilder = builder.append(fileName).append(" from module ").append(moduleName);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                stringBuilder.append('\n');
                StringBuilder stringBuilder2 = builder.append(StringsKt.repeat((CharSequence)"-", (int)fileName.length()));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                stringBuilder2.append('\n').append('\n');
                ControlFlowGraphRendererKt.renderControlFlowGraphTo((FirElement)((FirElement)firFile), (StringBuilder)builder, (ControlFlowGraphRenderOptions)renderOptions);
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit check$lambda$0(ControlFlowGraphConsistencyChecker this$0) {
        UtilsKt.publishGlobalSourceOutOfBlockModificationEvent((Project)AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(this$0.getTestServices()).getProject());
        return Unit.INSTANCE;
    }
}

