/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractContextCollectorSourceTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/low-level-api-fir/testData/contextCollector")
@TestDataPath(value="$PROJECT_ROOT")
public class ContextCollectorSourceTestGenerated
extends AbstractContextCollectorSourceTest {
    @Test
    public void testAllFilesPresentInContextCollector() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/contextCollector"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
    }

    @Test
    @TestMetadata(value="classFunction.kt")
    public void testClassFunction() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/classFunction.kt");
    }

    @Test
    @TestMetadata(value="classProperty.kt")
    public void testClassProperty() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/classProperty.kt");
    }

    @Test
    @TestMetadata(value="contextReceivers.kt")
    public void testContextReceivers() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextReceivers.kt");
    }

    @Test
    @TestMetadata(value="contextReceiversClass.kt")
    public void testContextReceiversClass() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextReceiversClass.kt");
    }

    @Test
    @TestMetadata(value="enumValueFunction.kt")
    public void testEnumValueFunction() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/enumValueFunction.kt");
    }

    @Test
    @TestMetadata(value="enumValuePropertyAccessor.kt")
    public void testEnumValuePropertyAccessor() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/enumValuePropertyAccessor.kt");
    }

    @Test
    @TestMetadata(value="errorPrimaryConstructor.kt")
    public void testErrorPrimaryConstructor() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/errorPrimaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="errorProperty.kt")
    public void testErrorProperty() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/errorProperty.kt");
    }

    @Test
    @TestMetadata(value="extensionFunction.kt")
    public void testExtensionFunction() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/extensionFunction.kt");
    }

    @Test
    @TestMetadata(value="extensionLambdas.kt")
    public void testExtensionLambdas() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/extensionLambdas.kt");
    }

    @Test
    @TestMetadata(value="file.kt")
    public void testFile() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/file.kt");
    }

    @Test
    @TestMetadata(value="fileImport.kt")
    public void testFileImport() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/fileImport.kt");
    }

    @Test
    @TestMetadata(value="fileImportInside.kt")
    public void testFileImportInside() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/fileImportInside.kt");
    }

    @Test
    @TestMetadata(value="filePackage.kt")
    public void testFilePackage() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/filePackage.kt");
    }

    @Test
    @TestMetadata(value="forLoopVariable.kt")
    public void testForLoopVariable() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/forLoopVariable.kt");
    }

    @Test
    @TestMetadata(value="innerClasses.kt")
    public void testInnerClasses() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/innerClasses.kt");
    }

    @Test
    @TestMetadata(value="KT-61728.kt")
    public void testKT_61728() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/KT-61728.kt");
    }

    @Test
    @TestMetadata(value="lambdaArguments.kt")
    public void testLambdaArguments() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/lambdaArguments.kt");
    }

    @Test
    @TestMetadata(value="localClass.kt")
    public void testLocalClass() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/localClass.kt");
    }

    @Test
    @TestMetadata(value="localClassFunction.kt")
    public void testLocalClassFunction() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/localClassFunction.kt");
    }

    @Test
    @TestMetadata(value="localFunction.kt")
    public void testLocalFunction() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/localFunction.kt");
    }

    @Test
    @TestMetadata(value="localFunctionExpression.kt")
    public void testLocalFunctionExpression() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/localFunctionExpression.kt");
    }

    @Test
    @TestMetadata(value="nestedClass.kt")
    public void testNestedClass() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/nestedClass.kt");
    }

    @Test
    @TestMetadata(value="nestedClassFunction.kt")
    public void testNestedClassFunction() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/nestedClassFunction.kt");
    }

    @Test
    @TestMetadata(value="parameter.kt")
    public void testParameter() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/parameter.kt");
    }

    @Test
    @TestMetadata(value="primaryConstructor.kt")
    public void testPrimaryConstructor() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/primaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="primaryConstructorParameter.kt")
    public void testPrimaryConstructorParameter() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/primaryConstructorParameter.kt");
    }

    @Test
    @TestMetadata(value="primaryConstructorProperty.kt")
    public void testPrimaryConstructorProperty() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/primaryConstructorProperty.kt");
    }

    @Test
    @TestMetadata(value="propertyAccessor.kt")
    public void testPropertyAccessor() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/propertyAccessor.kt");
    }

    @Test
    @TestMetadata(value="propertyDelegateInitializer.kt")
    public void testPropertyDelegateInitializer() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/propertyDelegateInitializer.kt");
    }

    @Test
    @TestMetadata(value="secondaryConstructor_superCallArgument.kt")
    public void testSecondaryConstructor_superCallArgument() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/secondaryConstructor_superCallArgument.kt");
    }

    @Test
    @TestMetadata(value="simple.kt")
    public void testSimple() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/simple.kt");
    }

    @Test
    @TestMetadata(value="topLevelFunction.kt")
    public void testTopLevelFunction() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/topLevelFunction.kt");
    }

    @Test
    @TestMetadata(value="topLevelProperty.kt")
    public void testTopLevelProperty() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/topLevelProperty.kt");
    }

    @Test
    @TestMetadata(value="typeAlias.kt")
    public void testTypeAlias() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeAlias.kt");
    }

    @Test
    @TestMetadata(value="typeAliasInitializer.kt")
    public void testTypeAliasInitializer() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeAliasInitializer.kt");
    }

    @Test
    @TestMetadata(value="typeParameter.kt")
    public void testTypeParameter() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameter.kt");
    }

    @Test
    @TestMetadata(value="wholeDeclaration_class.kt")
    public void testWholeDeclaration_class() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/wholeDeclaration_class.kt");
    }

    @Test
    @TestMetadata(value="wholeDeclaration_fun.kt")
    public void testWholeDeclaration_fun() {
        this.runTest("analysis/low-level-api-fir/testData/contextCollector/wholeDeclaration_fun.kt");
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled")
    @TestDataPath(value="$PROJECT_ROOT")
    public class WithTestCompilerPluginEnabled {
        @Test
        public void testAllFilesPresentInWithTestCompilerPluginEnabled() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="callShapeBasedInjector.kt")
        public void testCallShapeBasedInjector() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector.kt");
        }

        @Test
        @TestMetadata(value="callShapeBasedInjector_asReceiver.kt")
        public void testCallShapeBasedInjector_asReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_asReceiver.kt");
        }

        @Test
        @TestMetadata(value="callShapeBasedInjector_delegate.kt")
        public void testCallShapeBasedInjector_delegate() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_delegate.kt");
        }

        @Test
        @TestMetadata(value="callShapeBasedInjector_extraCall.kt")
        public void testCallShapeBasedInjector_extraCall() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_extraCall.kt");
        }

        @Test
        @TestMetadata(value="callShapeBasedInjector_extraSafeCall.kt")
        public void testCallShapeBasedInjector_extraSafeCall() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_extraSafeCall.kt");
        }

        @Test
        @TestMetadata(value="callShapeBasedInjector_notNullCheck.kt")
        public void testCallShapeBasedInjector_notNullCheck() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_notNullCheck.kt");
        }

        @Test
        @TestMetadata(value="callShapeBasedInjector_safeCall.kt")
        public void testCallShapeBasedInjector_safeCall() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_safeCall.kt");
        }

        @Test
        @TestMetadata(value="receiverInjection.kt")
        public void testReceiverInjection() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/receiverInjection.kt");
        }

        @Test
        @TestMetadata(value="receiverInjection_before.kt")
        public void testReceiverInjection_before() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/receiverInjection_before.kt");
        }

        @Test
        @TestMetadata(value="receiverInjection_extraCall.kt")
        public void testReceiverInjection_extraCall() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/receiverInjection_extraCall.kt");
        }

        @Test
        @TestMetadata(value="receiverInjection_wrongScope.kt")
        public void testReceiverInjection_wrongScope() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/receiverInjection_wrongScope.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/contextCollector/typeParameters")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeParameters {
        @Test
        public void testAllFilesPresentInTypeParameters() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/contextCollector/typeParameters"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="anonymousFunctionLocalVarType.kt")
        public void testAnonymousFunctionLocalVarType() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/anonymousFunctionLocalVarType.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionParameterType.kt")
        public void testAnonymousFunctionParameterType() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/anonymousFunctionParameterType.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionTypeParameter.kt")
        public void testAnonymousFunctionTypeParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/anonymousFunctionTypeParameter.kt");
        }

        @Test
        @TestMetadata(value="declaredInClass_fromContextReceiver.kt")
        public void testDeclaredInClass_fromContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="declaredInClass_fromInner_typeBound.kt")
        public void testDeclaredInClass_fromInner_typeBound() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromInner_typeBound.kt");
        }

        @Test
        @TestMetadata(value="declaredInClass_fromInner_typeRefInMember.kt")
        public void testDeclaredInClass_fromInner_typeRefInMember() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromInner_typeRefInMember.kt");
        }

        @Test
        @TestMetadata(value="declaredInClass_fromNested_typeBound.kt")
        public void testDeclaredInClass_fromNested_typeBound() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromNested_typeBound.kt");
        }

        @Test
        @TestMetadata(value="declaredInClass_fromNested_typeRefInMember.kt")
        public void testDeclaredInClass_fromNested_typeRefInMember() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromNested_typeRefInMember.kt");
        }

        @Test
        @TestMetadata(value="declaredInClass_fromSuperType.kt")
        public void testDeclaredInClass_fromSuperType() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromSuperType.kt");
        }

        @Test
        @TestMetadata(value="declaredInClass_fromTypeBound.kt")
        public void testDeclaredInClass_fromTypeBound() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromTypeBound.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/contextCollector/smartCasts")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SmartCasts {
        @Test
        @TestMetadata(value="afterIf.kt")
        public void testAfterIf() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/afterIf.kt");
        }

        @Test
        @TestMetadata(value="afterLoop.kt")
        public void testAfterLoop() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/afterLoop.kt");
        }

        @Test
        public void testAllFilesPresentInSmartCasts() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/contextCollector/smartCasts"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="andRight.kt")
        public void testAndRight() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/andRight.kt");
        }

        @Test
        @TestMetadata(value="argument.kt")
        public void testArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/argument.kt");
        }

        @Test
        @TestMetadata(value="argumentAsReceiver.kt")
        public void testArgumentAsReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/argumentAsReceiver.kt");
        }

        @Test
        @TestMetadata(value="beforeIf.kt")
        public void testBeforeIf() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/beforeIf.kt");
        }

        @Test
        @TestMetadata(value="beforeLoop.kt")
        public void testBeforeLoop() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/beforeLoop.kt");
        }

        @Test
        @TestMetadata(value="dispatchReceiver.kt")
        public void testDispatchReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/dispatchReceiver.kt");
        }

        @Test
        @TestMetadata(value="extensionReceiver.kt")
        public void testExtensionReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/extensionReceiver.kt");
        }

        @Test
        @TestMetadata(value="insideLetOnNullableReceiver.kt")
        public void testInsideLetOnNullableReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/insideLetOnNullableReceiver.kt");
        }

        @Test
        @TestMetadata(value="insideLoop.kt")
        public void testInsideLoop() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/insideLoop.kt");
        }

        @Test
        @TestMetadata(value="onLabel.kt")
        public void testOnLabel() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/onLabel.kt");
        }

        @Test
        @TestMetadata(value="onReference.kt")
        public void testOnReference() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/onReference.kt");
        }

        @Test
        @TestMetadata(value="onSmartCastExpression.kt")
        public void testOnSmartCastExpression() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/onSmartCastExpression.kt");
        }

        @Test
        @TestMetadata(value="onType.kt")
        public void testOnType() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/onType.kt");
        }

        @Test
        @TestMetadata(value="orRight.kt")
        public void testOrRight() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/orRight.kt");
        }

        @Test
        @TestMetadata(value="plainCheck.kt")
        public void testPlainCheck() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/plainCheck.kt");
        }

        @Test
        @TestMetadata(value="require.kt")
        public void testRequire() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/require.kt");
        }

        @Test
        @TestMetadata(value="when.kt")
        public void testWhen() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/when.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/contextCollector/scripts")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Scripts {
        @Test
        public void testAllFilesPresentInScripts() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/contextCollector/scripts"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/contextCollector/error")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Error {
        @Test
        public void testAllFilesPresentInError() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/contextCollector/error"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="InvalidInitializer.kt")
        public void testInvalidInitializer() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/error/InvalidInitializer.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/contextCollector/danglingModifiers")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DanglingModifiers {
        @Test
        public void testAllFilesPresentInDanglingModifiers() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="classLevel.kt")
        public void testClassLevel() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/classLevel.kt");
        }

        @Test
        @TestMetadata(value="classLevelAnnotation.kt")
        public void testClassLevelAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/classLevelAnnotation.kt");
        }

        @Test
        @TestMetadata(value="enumEntryLevel.kt")
        public void testEnumEntryLevel() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/enumEntryLevel.kt");
        }

        @Test
        @TestMetadata(value="fileLevel.kt")
        public void testFileLevel() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/fileLevel.kt");
        }

        @Test
        @TestMetadata(value="fileLevelAnnotation.kt")
        public void testFileLevelAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/fileLevelAnnotation.kt");
        }

        @Test
        @TestMetadata(value="functionInsideClassLevel.kt")
        public void testFunctionInsideClassLevel() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/functionInsideClassLevel.kt");
        }

        @Test
        @TestMetadata(value="functionInsideClassLevel2.kt")
        public void testFunctionInsideClassLevel2() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/functionInsideClassLevel2.kt");
        }

        @Test
        @TestMetadata(value="functionInsideFileLevel.kt")
        public void testFunctionInsideFileLevel() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/functionInsideFileLevel.kt");
        }

        @Test
        @TestMetadata(value="functionInsideFileLevel2.kt")
        public void testFunctionInsideFileLevel2() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/functionInsideFileLevel2.kt");
        }

        @Test
        @TestMetadata(value="localClass.kt")
        public void testLocalClass() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/localClass.kt");
        }

        @Test
        @TestMetadata(value="wholeClassLevel.kt")
        public void testWholeClassLevel() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/wholeClassLevel.kt");
        }

        @Test
        @TestMetadata(value="wholeFileLevel.kt")
        public void testWholeFileLevel() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/danglingModifiers/wholeFileLevel.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/contextCollector/contextParameters")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ContextParameters {
        @Test
        @TestMetadata(value="afterContextReceiverSmartCast.kt")
        public void testAfterContextReceiverSmartCast() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/afterContextReceiverSmartCast.kt");
        }

        @Test
        @TestMetadata(value="afterSmartCastFunction.kt")
        public void testAfterSmartCastFunction() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/afterSmartCastFunction.kt");
        }

        @Test
        @TestMetadata(value="afterSmartCastProperty.kt")
        public void testAfterSmartCastProperty() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/afterSmartCastProperty.kt");
        }

        @Test
        public void testAllFilesPresentInContextParameters() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/contextCollector/contextParameters"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="anonymousFunctionContextParameter.kt")
        public void testAnonymousFunctionContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionContextParameter.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionContextReceiver.kt")
        public void testAnonymousFunctionContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionContextReceiver2.kt")
        public void testAnonymousFunctionContextReceiver2() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionContextReceiver2.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionContextReceiver3.kt")
        public void testAnonymousFunctionContextReceiver3() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionContextReceiver3.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionContextReceiverExpression.kt")
        public void testAnonymousFunctionContextReceiverExpression() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionContextReceiverExpression.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionReceiverParameterWithContextParameter.kt")
        public void testAnonymousFunctionReceiverParameterWithContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionReceiverParameterWithContextParameter.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionReceiverParameterWithContextReceiver.kt")
        public void testAnonymousFunctionReceiverParameterWithContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionReceiverParameterWithContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionTypeParameterWithContextParameter.kt")
        public void testAnonymousFunctionTypeParameterWithContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionTypeParameterWithContextParameter.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionTypeParameterWithContextReceiver.kt")
        public void testAnonymousFunctionTypeParameterWithContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionTypeParameterWithContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionValueParameterWithContextParameter.kt")
        public void testAnonymousFunctionValueParameterWithContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionValueParameterWithContextParameter.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionValueParameterWithContextParameterWithDefaultValue.kt")
        public void testAnonymousFunctionValueParameterWithContextParameterWithDefaultValue() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionValueParameterWithContextParameterWithDefaultValue.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionValueParameterWithContextReceiver.kt")
        public void testAnonymousFunctionValueParameterWithContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionValueParameterWithContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="anonymousFunctionValueParameterWithContextReceiverWithDefaultValue.kt")
        public void testAnonymousFunctionValueParameterWithContextReceiverWithDefaultValue() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/anonymousFunctionValueParameterWithContextReceiverWithDefaultValue.kt");
        }

        @Test
        @TestMetadata(value="contextParameterAnonymousFunction.kt")
        public void testContextParameterAnonymousFunction() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/contextParameterAnonymousFunction.kt");
        }

        @Test
        @TestMetadata(value="contextParameterFunction.kt")
        public void testContextParameterFunction() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/contextParameterFunction.kt");
        }

        @Test
        @TestMetadata(value="contextParameterProperty.kt")
        public void testContextParameterProperty() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/contextParameterProperty.kt");
        }

        @Test
        @TestMetadata(value="contextReceiverSmartCast.kt")
        public void testContextReceiverSmartCast() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/contextReceiverSmartCast.kt");
        }

        @Test
        @TestMetadata(value="functionContextParameter.kt")
        public void testFunctionContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionContextParameter.kt");
        }

        @Test
        @TestMetadata(value="functionContextReceiver.kt")
        public void testFunctionContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="functionReceiverParameterWithContextParameter.kt")
        public void testFunctionReceiverParameterWithContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionReceiverParameterWithContextParameter.kt");
        }

        @Test
        @TestMetadata(value="functionReceiverParameterWithContextReceiver.kt")
        public void testFunctionReceiverParameterWithContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionReceiverParameterWithContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="functionTypeParameterWithContextParameter.kt")
        public void testFunctionTypeParameterWithContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionTypeParameterWithContextParameter.kt");
        }

        @Test
        @TestMetadata(value="functionTypeParameterWithContextReceiver.kt")
        public void testFunctionTypeParameterWithContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionTypeParameterWithContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="functionValueParameterWithContextParameter.kt")
        public void testFunctionValueParameterWithContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionValueParameterWithContextParameter.kt");
        }

        @Test
        @TestMetadata(value="functionValueParameterWithContextParameterWithDefaultValue.kt")
        public void testFunctionValueParameterWithContextParameterWithDefaultValue() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionValueParameterWithContextParameterWithDefaultValue.kt");
        }

        @Test
        @TestMetadata(value="functionValueParameterWithContextReceiver.kt")
        public void testFunctionValueParameterWithContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionValueParameterWithContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="functionValueParameterWithContextReceiverWithDefaultValue.kt")
        public void testFunctionValueParameterWithContextReceiverWithDefaultValue() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionValueParameterWithContextReceiverWithDefaultValue.kt");
        }

        @Test
        @TestMetadata(value="functionWithContextParameter.kt")
        public void testFunctionWithContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionWithContextParameter.kt");
        }

        @Test
        @TestMetadata(value="functionWithContextReceiver.kt")
        public void testFunctionWithContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/functionWithContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="memberLevelFunction.kt")
        public void testMemberLevelFunction() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/memberLevelFunction.kt");
        }

        @Test
        @TestMetadata(value="memberLevelFunction2.kt")
        public void testMemberLevelFunction2() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/memberLevelFunction2.kt");
        }

        @Test
        @TestMetadata(value="memberLevelFunctionContextReceiver.kt")
        public void testMemberLevelFunctionContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/memberLevelFunctionContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="memberLevelProperty.kt")
        public void testMemberLevelProperty() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/memberLevelProperty.kt");
        }

        @Test
        @TestMetadata(value="memberLevelProperty2.kt")
        public void testMemberLevelProperty2() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/memberLevelProperty2.kt");
        }

        @Test
        @TestMetadata(value="memberLevelPropertyAccessor.kt")
        public void testMemberLevelPropertyAccessor() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/memberLevelPropertyAccessor.kt");
        }

        @Test
        @TestMetadata(value="memberLevelPropertyAccessorContextReceiver.kt")
        public void testMemberLevelPropertyAccessorContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/memberLevelPropertyAccessorContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="memberLevelPropertyContextReceiver.kt")
        public void testMemberLevelPropertyContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/memberLevelPropertyContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="namedAnonymousFunction.kt")
        public void testNamedAnonymousFunction() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/namedAnonymousFunction.kt");
        }

        @Test
        @TestMetadata(value="namedAnonymousFunction2.kt")
        public void testNamedAnonymousFunction2() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/namedAnonymousFunction2.kt");
        }

        @Test
        @TestMetadata(value="namedAnonymousFunction3.kt")
        public void testNamedAnonymousFunction3() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/namedAnonymousFunction3.kt");
        }

        @Test
        @TestMetadata(value="namedAnonymousFunctionExpression.kt")
        public void testNamedAnonymousFunctionExpression() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/namedAnonymousFunctionExpression.kt");
        }

        @Test
        @TestMetadata(value="namedFunctionContextParameter.kt")
        public void testNamedFunctionContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/namedFunctionContextParameter.kt");
        }

        @Test
        @TestMetadata(value="namedPropertyContextParameter.kt")
        public void testNamedPropertyContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/namedPropertyContextParameter.kt");
        }

        @Test
        @TestMetadata(value="namedPropertyContextParameterWithDefaultAccessor.kt")
        public void testNamedPropertyContextParameterWithDefaultAccessor() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/namedPropertyContextParameterWithDefaultAccessor.kt");
        }

        @Test
        @TestMetadata(value="nestedContextParameter.kt")
        public void testNestedContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/nestedContextParameter.kt");
        }

        @Test
        @TestMetadata(value="nestedContextParameterAfter.kt")
        public void testNestedContextParameterAfter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/nestedContextParameterAfter.kt");
        }

        @Test
        @TestMetadata(value="propertyContextParameter.kt")
        public void testPropertyContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/propertyContextParameter.kt");
        }

        @Test
        @TestMetadata(value="propertyContextReceiver.kt")
        public void testPropertyContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/propertyContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="propertyContextReceiverWithDefaultAccessor.kt")
        public void testPropertyContextReceiverWithDefaultAccessor() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/propertyContextReceiverWithDefaultAccessor.kt");
        }

        @Test
        @TestMetadata(value="propertyReceiverParameterWithContextParameter.kt")
        public void testPropertyReceiverParameterWithContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/propertyReceiverParameterWithContextParameter.kt");
        }

        @Test
        @TestMetadata(value="propertyReceiverParameterWithContextReceiver.kt")
        public void testPropertyReceiverParameterWithContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/propertyReceiverParameterWithContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="propertyTypeParameterWithContextParameter.kt")
        public void testPropertyTypeParameterWithContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/propertyTypeParameterWithContextParameter.kt");
        }

        @Test
        @TestMetadata(value="propertyTypeParameterWithContextReceiver.kt")
        public void testPropertyTypeParameterWithContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/propertyTypeParameterWithContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="propertyWithContextParameter.kt")
        public void testPropertyWithContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/propertyWithContextParameter.kt");
        }

        @Test
        @TestMetadata(value="propertyWithContextParameterWithDefaultAccessor.kt")
        public void testPropertyWithContextParameterWithDefaultAccessor() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/propertyWithContextParameterWithDefaultAccessor.kt");
        }

        @Test
        @TestMetadata(value="propertyWithContextReceiver.kt")
        public void testPropertyWithContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/propertyWithContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="propertyWithContextReceiverWithDefaultAccessor.kt")
        public void testPropertyWithContextReceiverWithDefaultAccessor() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/propertyWithContextReceiverWithDefaultAccessor.kt");
        }

        @Test
        @TestMetadata(value="smartCastFunction.kt")
        public void testSmartCastFunction() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/smartCastFunction.kt");
        }

        @Test
        @TestMetadata(value="smartCastProperty.kt")
        public void testSmartCastProperty() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/smartCastProperty.kt");
        }

        @Test
        @TestMetadata(value="topLevelFunction.kt")
        public void testTopLevelFunction() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/topLevelFunction.kt");
        }

        @Test
        @TestMetadata(value="topLevelFunction2.kt")
        public void testTopLevelFunction2() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/topLevelFunction2.kt");
        }

        @Test
        @TestMetadata(value="topLevelFunctionContextReceiver.kt")
        public void testTopLevelFunctionContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/topLevelFunctionContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="topLevelProperty.kt")
        public void testTopLevelProperty() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/topLevelProperty.kt");
        }

        @Test
        @TestMetadata(value="topLevelProperty2.kt")
        public void testTopLevelProperty2() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/topLevelProperty2.kt");
        }

        @Test
        @TestMetadata(value="topLevelPropertyContextReceiver.kt")
        public void testTopLevelPropertyContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/topLevelPropertyContextReceiver.kt");
        }

        @Test
        @TestMetadata(value="unnamedAnonymousFunction.kt")
        public void testUnnamedAnonymousFunction() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/unnamedAnonymousFunction.kt");
        }

        @Test
        @TestMetadata(value="unnamedAnonymousFunction2.kt")
        public void testUnnamedAnonymousFunction2() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/unnamedAnonymousFunction2.kt");
        }

        @Test
        @TestMetadata(value="unnamedAnonymousFunction3.kt")
        public void testUnnamedAnonymousFunction3() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/unnamedAnonymousFunction3.kt");
        }

        @Test
        @TestMetadata(value="unnamedAnonymousFunctionExpression.kt")
        public void testUnnamedAnonymousFunctionExpression() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/unnamedAnonymousFunctionExpression.kt");
        }

        @Test
        @TestMetadata(value="unnamedFunctionContextParameter.kt")
        public void testUnnamedFunctionContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/unnamedFunctionContextParameter.kt");
        }

        @Test
        @TestMetadata(value="unnamedPropertyContextParameter.kt")
        public void testUnnamedPropertyContextParameter() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/unnamedPropertyContextParameter.kt");
        }

        @Test
        @TestMetadata(value="unnamedPropertyContextParameterWithDefaultAccessor.kt")
        public void testUnnamedPropertyContextParameterWithDefaultAccessor() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/contextParameters/unnamedPropertyContextParameterWithDefaultAccessor.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ClassHeaderPositions {
        @Test
        public void testAllFilesPresentInClassHeaderPositions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="contextReceiver.kt")
        public void testContextReceiver() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/contextReceiver.kt");
        }

        @Test
        @TestMetadata(value="innerClass.kt")
        public void testInnerClass() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/innerClass.kt");
        }

        @Test
        @TestMetadata(value="nestedClass.kt")
        public void testNestedClass() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/nestedClass.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructorParameter_initializerExpression.kt")
        public void testPrimaryConstructorParameter_initializerExpression() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/primaryConstructorParameter_initializerExpression.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructorParameter_typeRef.kt")
        public void testPrimaryConstructorParameter_typeRef() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/primaryConstructorParameter_typeRef.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallArgumentsExpression.kt")
        public void testSuperTypeCallArgumentsExpression() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCallArgumentsExpression.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallArgumentsExpressionInnerClass.kt")
        public void testSuperTypeCallArgumentsExpressionInnerClass() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCallArgumentsExpressionInnerClass.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallArgumentsExpression_objectLiteral.kt")
        public void testSuperTypeCallArgumentsExpression_objectLiteral() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCallArgumentsExpression_objectLiteral.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallArgumentsTypeRef.kt")
        public void testSuperTypeCallArgumentsTypeRef() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCallArgumentsTypeRef.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallee.kt")
        public void testSuperTypeCallee() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCallee.kt");
        }

        @Test
        @TestMetadata(value="superTypeCalleeGenerics.kt")
        public void testSuperTypeCalleeGenerics() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCalleeGenerics.kt");
        }

        @Test
        @TestMetadata(value="superTypeCallee_objectLiteral.kt")
        public void testSuperTypeCallee_objectLiteral() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCallee_objectLiteral.kt");
        }

        @Test
        @TestMetadata(value="superTypeDelegatedExpression.kt")
        public void testSuperTypeDelegatedExpression() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeDelegatedExpression.kt");
        }

        @Test
        @TestMetadata(value="superTypeDelegatedToCompanion.kt")
        public void testSuperTypeDelegatedToCompanion() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeDelegatedToCompanion.kt");
        }

        @Test
        @TestMetadata(value="superTypeDelegatedToPrimaryConstructorParam.kt")
        public void testSuperTypeDelegatedToPrimaryConstructorParam() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeDelegatedToPrimaryConstructorParam.kt");
        }

        @Test
        @TestMetadata(value="superTypeDelegatedTypeRef.kt")
        public void testSuperTypeDelegatedTypeRef() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeDelegatedTypeRef.kt");
        }

        @Test
        @TestMetadata(value="superTypeRef.kt")
        public void testSuperTypeRef() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeRef.kt");
        }

        @Test
        @TestMetadata(value="superTypeRefGenerics.kt")
        public void testSuperTypeRefGenerics() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeRefGenerics.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/contextCollector/annotations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Annotations {
        @Test
        public void testAllFilesPresentInAnnotations() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/contextCollector/annotations"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="classAnnotation.kt")
        public void testClassAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/classAnnotation.kt");
        }

        @Test
        @TestMetadata(value="classAnnotation2.kt")
        public void testClassAnnotation2() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/classAnnotation2.kt");
        }

        @Test
        @TestMetadata(value="classAnnotationArgument.kt")
        public void testClassAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/classAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="classAnnotationArgument2.kt")
        public void testClassAnnotationArgument2() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/classAnnotationArgument2.kt");
        }

        @Test
        @TestMetadata(value="enumEntryAnnotation.kt")
        public void testEnumEntryAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/enumEntryAnnotation.kt");
        }

        @Test
        @TestMetadata(value="enumEntryAnnotationArgument.kt")
        public void testEnumEntryAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/enumEntryAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="fileAnnotation.kt")
        public void testFileAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/fileAnnotation.kt");
        }

        @Test
        @TestMetadata(value="fileAnnotationArgument.kt")
        public void testFileAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/fileAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="functionAnnotation.kt")
        public void testFunctionAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/functionAnnotation.kt");
        }

        @Test
        @TestMetadata(value="functionAnnotationArgument.kt")
        public void testFunctionAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/functionAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="initAnnotation.kt")
        public void testInitAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/initAnnotation.kt");
        }

        @Test
        @TestMetadata(value="initAnnotationArgument.kt")
        public void testInitAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/initAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="innerClassAnnotation.kt")
        public void testInnerClassAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/innerClassAnnotation.kt");
        }

        @Test
        @TestMetadata(value="innerClassAnnotationArgument.kt")
        public void testInnerClassAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/innerClassAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructorAnnotation.kt")
        public void testPrimaryConstructorAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/primaryConstructorAnnotation.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructorAnnotationArgument.kt")
        public void testPrimaryConstructorAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/primaryConstructorAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="propertyAnnotation.kt")
        public void testPropertyAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/propertyAnnotation.kt");
        }

        @Test
        @TestMetadata(value="propertyAnnotationArgument.kt")
        public void testPropertyAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/propertyAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="propertyExplicitSetterAnnotation.kt")
        public void testPropertyExplicitSetterAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/propertyExplicitSetterAnnotation.kt");
        }

        @Test
        @TestMetadata(value="propertyExplicitSetterAnnotationArgument.kt")
        public void testPropertyExplicitSetterAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/propertyExplicitSetterAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="propertyGetterAnnotation.kt")
        public void testPropertyGetterAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/propertyGetterAnnotation.kt");
        }

        @Test
        @TestMetadata(value="propertyGetterAnnotationArgument.kt")
        public void testPropertyGetterAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/propertyGetterAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructorAnnotation.kt")
        public void testSecondaryConstructorAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/secondaryConstructorAnnotation.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructorAnnotationArgument.kt")
        public void testSecondaryConstructorAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/secondaryConstructorAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="typealiasAnnotation.kt")
        public void testTypealiasAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/typealiasAnnotation.kt");
        }

        @Test
        @TestMetadata(value="typealiasAnnotationArgument.kt")
        public void testTypealiasAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/typealiasAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="valueParameterAnnotation.kt")
        public void testValueParameterAnnotation() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/valueParameterAnnotation.kt");
        }

        @Test
        @TestMetadata(value="valueParameterAnnotationArgument.kt")
        public void testValueParameterAnnotationArgument() {
            ContextCollectorSourceTestGenerated.this.runTest("analysis/low-level-api-fir/testData/contextCollector/annotations/valueParameterAnnotationArgument.kt");
        }
    }
}

