/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.files;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConstantReference;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtValueParameterReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0013\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\n\u001a\u00020\u00022\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u000e\u001a\u00020\u00022\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0011\u001a\u00020\u00022\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0014\u001a\u00020\u00022\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0017\u001a\u00020\u00022\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u001a\u001a\u00020\u00022\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001c2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u001d\u001a\u00020\u00022\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010 \u001a\u00020\u00022\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\"2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010#\u001a\u00020\u00022\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030%2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/KotlinContractRenderer;", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "", "", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeBean;", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "<init>", "(Ljava/lang/StringBuilder;)V", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "data", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/contracts/description/KtCallsEffectDeclaration;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/contracts/description/KtLogicalNot;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsNullPredicate;", "visitConstantDescriptor", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/KtConstantReference;", "visitValueParameterReference", "valueParameterReference", "Lorg/jetbrains/kotlin/contracts/description/KtValueParameterReference;", "decompiler-to-file-stubs_test"})
public final class KotlinContractRenderer
extends KtContractDescriptionVisitor {
    @NotNull
    private final StringBuilder buffer;

    public KotlinContractRenderer(@NotNull StringBuilder buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
    }

    public void visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration conditionalEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)conditionalEffect, (String)"conditionalEffect");
        conditionalEffect.getEffect().accept((KtContractDescriptionVisitor)this, (Object)data);
        this.buffer.append(" -> ");
        conditionalEffect.getCondition().accept((KtContractDescriptionVisitor)this, (Object)data);
    }

    public void visitReturnsEffectDeclaration(@NotNull KtReturnsEffectDeclaration returnsEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)returnsEffect, (String)"returnsEffect");
        this.buffer.append("Returns(");
        returnsEffect.getValue().accept((KtContractDescriptionVisitor)this, (Object)data);
        this.buffer.append(")");
    }

    public void visitCallsEffectDeclaration(@NotNull KtCallsEffectDeclaration callsEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)callsEffect, (String)"callsEffect");
        this.buffer.append("CallsInPlace(");
        callsEffect.getValueParameterReference().accept((KtContractDescriptionVisitor)this, (Object)data);
        this.buffer.append(", " + callsEffect.getKind() + ')');
    }

    public void visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression binaryLogicExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
        binaryLogicExpression.getLeft().accept((KtContractDescriptionVisitor)this, (Object)data);
        this.buffer.append(' ' + binaryLogicExpression.getKind().getToken() + ' ');
        binaryLogicExpression.getRight().accept((KtContractDescriptionVisitor)this, (Object)data);
    }

    public void visitLogicalNot(@NotNull KtLogicalNot logicalNot, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)logicalNot, (String)"logicalNot");
        logicalNot.getArg().accept((KtContractDescriptionVisitor)this, (Object)data);
    }

    public void visitIsInstancePredicate(@NotNull KtIsInstancePredicate isInstancePredicate, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)isInstancePredicate, (String)"isInstancePredicate");
        isInstancePredicate.getArg().accept((KtContractDescriptionVisitor)this, (Object)data);
        this.buffer.append(' ' + (isInstancePredicate.isNegated() ? "!" : "") + "is " + isInstancePredicate.getType());
    }

    public void visitIsNullPredicate(@NotNull KtIsNullPredicate isNullPredicate, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)isNullPredicate, (String)"isNullPredicate");
        isNullPredicate.getArg().accept((KtContractDescriptionVisitor)this, (Object)data);
        this.buffer.append(' ' + (isNullPredicate.isNegated() ? "!=" : "==") + " null");
    }

    public void visitConstantDescriptor(@NotNull KtConstantReference constantReference, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)constantReference, (String)"constantReference");
        this.buffer.append(constantReference.getName());
    }

    public void visitValueParameterReference(@NotNull KtValueParameterReference valueParameterReference, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)valueParameterReference, (String)"valueParameterReference");
        this.buffer.append("param(").append(valueParameterReference.getParameterIndex()).append(")");
    }
}

