/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test.cases.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationEventKind;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiBasedTest;
import org.jetbrains.kotlin.analysis.test.framework.directives.ModificationEventDirectivesKt;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.AnalysisApiKtTestModuleStructureProviderKt;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH$\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001dH\u0002J\u001e\u0010\u001f\u001a\u00020\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\"\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010$\u001a\u00020\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010%\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u0004\u0018\u00010\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/cases/session/AbstractSessionInvalidationTest;", "SESSION", "Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest;", "<init>", "()V", "modificationEventKind", "Lorg/jetbrains/kotlin/analysis/api/platform/modification/KotlinModificationEventKind;", "getModificationEventKind", "()Lorg/jetbrains/kotlin/analysis/api/platform/modification/KotlinModificationEventKind;", "resultFileSuffix", "", "getResultFileSuffix", "()Ljava/lang/String;", "getSession", "ktModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Ljava/lang/Object;", "getSessionKtModule", "session", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "isSessionValid", "", "(Ljava/lang/Object;)Z", "shouldSkipValidityCheck", "doTest", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "getSessions", "", "modules", "checkInvalidatedModules", "invalidatedSessions", "", "checkSessionValidityBeforeModification", "sessions", "checkSessionsMarkedInvalid", "checkUntouchedSessionValidity", "analysis-api-impl-base_test"})
@SourceDebugExtension(value={"SMAP\nAbstractSessionInvalidationTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSessionInvalidationTest.kt\norg/jetbrains/kotlin/analysis/api/impl/base/test/cases/session/AbstractSessionInvalidationTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1563#2:133\n1634#2,3:134\n1563#2:137\n1634#2,3:138\n1563#2:141\n1634#2,3:142\n1869#2,2:145\n1869#2,2:147\n1869#2,2:149\n1869#2,2:151\n*S KotlinDebug\n*F\n+ 1 AbstractSessionInvalidationTest.kt\norg/jetbrains/kotlin/analysis/api/impl/base/test/cases/session/AbstractSessionInvalidationTest\n*L\n49#1:133\n49#1:134,3\n69#1:137\n69#1:138,3\n76#1:141\n76#1:142,3\n82#1:145,2\n101#1:147,2\n112#1:149,2\n125#1:151,2\n*E\n"})
public abstract class AbstractSessionInvalidationTest<SESSION>
extends AbstractAnalysisApiBasedTest {
    @NotNull
    protected abstract KotlinModificationEventKind getModificationEventKind();

    @Nullable
    protected abstract String getResultFileSuffix();

    protected abstract SESSION getSession(@NotNull KaModule var1);

    @NotNull
    protected abstract KaModule getSessionKtModule(SESSION var1);

    protected abstract boolean isSessionValid(SESSION var1);

    protected boolean shouldSkipValidityCheck(SESSION session) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doTest(@NotNull TestServices testServices) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Iterable $this$map$iv = AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(testServices).getMainModules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtTestModule ktTestModule = (KtTestModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKtModule());
        }
        List ktModules = (List)destination$iv$iv;
        List<SESSION> sessionsBeforeModification = this.getSessions(ktModules);
        this.checkSessionValidityBeforeModification(sessionsBeforeModification, testServices);
        ModificationEventDirectivesKt.publishWildcardModificationEventsByDirective(AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(testServices), this.getModificationEventKind());
        List<SESSION> sessionsAfterModification = this.getSessions(ktModules);
        Collection $this$doTest_u24lambda_u241 = destination$iv$iv = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$doTest_u24lambda_u241.addAll((Collection)sessionsBeforeModification);
        $this$doTest_u24lambda_u241.removeAll((Collection)sessionsAfterModification);
        Set invalidatedSessions = SetsKt.build((Set)destination$iv$iv);
        this.checkInvalidatedModules(invalidatedSessions, testServices);
        this.checkSessionsMarkedInvalid(invalidatedSessions, testServices);
        Set untouchedSessions = CollectionsKt.intersect((Iterable)sessionsBeforeModification, (Iterable)sessionsAfterModification);
        this.checkUntouchedSessionValidity(untouchedSessions, testServices);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SESSION> getSessions(List<? extends KaModule> modules) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = modules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KaModule kaModule = (KaModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getSession((KaModule)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkInvalidatedModules(Set<? extends SESSION> invalidatedSessions, TestServices testServices) {
        StringBuilder stringBuilder;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = invalidatedSessions;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getSessionKtModule(it).toString());
        }
        List invalidatedModuleDescriptions = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        StringBuilder $this$checkInvalidatedModules_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$checkInvalidatedModules_u24lambda_u244.append("Module names of invalidated sessions:").append('\n');
        Iterable $this$forEach$iv = invalidatedModuleDescriptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$checkInvalidatedModules_u24lambda_u244.append(it).append('\n');
        }
        String actualText2 = stringBuilder.toString();
        AssertionsService assertionsService = AssertionsKt.getAssertions((TestServices)testServices);
        StringBuilder stringBuilder2 = new StringBuilder().append('.');
        String string = this.getModificationEventKind().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.assertEqualsToTestDataFileSibling(assertionsService, actualText2, stringBuilder2.append(string).append(".txt").toString(), this.getResultFileSuffix());
    }

    private final void checkSessionValidityBeforeModification(List<? extends SESSION> sessions, TestServices testServices) {
        Iterable $this$forEach$iv = sessions;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object session = element$iv = iterator.next();
            boolean bl = false;
            AssertionsKt.getAssertions((TestServices)testServices).assertTrue(this.isSessionValid(session), () -> AbstractSessionInvalidationTest.checkSessionValidityBeforeModification$lambda$6$lambda$5(session));
        }
    }

    private final void checkSessionsMarkedInvalid(Set<? extends SESSION> invalidatedSessions, TestServices testServices) {
        Iterable $this$forEach$iv = invalidatedSessions;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object session = element$iv = iterator.next();
            boolean bl = false;
            if (this.shouldSkipValidityCheck(session)) continue;
            AssertionsKt.getAssertions((TestServices)testServices).assertFalse(this.isSessionValid(session), () -> AbstractSessionInvalidationTest.checkSessionsMarkedInvalid$lambda$8$lambda$7(session));
        }
    }

    private final void checkUntouchedSessionValidity(Set<? extends SESSION> sessions, TestServices testServices) {
        Iterable $this$forEach$iv = sessions;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object session = element$iv = iterator.next();
            boolean bl = false;
            AssertionsKt.getAssertions((TestServices)testServices).assertTrue(this.isSessionValid(session), () -> AbstractSessionInvalidationTest.checkUntouchedSessionValidity$lambda$10$lambda$9(session));
        }
    }

    private static final String checkSessionValidityBeforeModification$lambda$6$lambda$5(Object $session) {
        return "The session `" + $session + "` should be valid before invalidation is triggered.";
    }

    private static final String checkSessionsMarkedInvalid$lambda$8$lambda$7(Object $session) {
        return "The invalidated session `" + $session + "` should have been marked invalid.";
    }

    private static final String checkUntouchedSessionValidity$lambda$10$lambda$9(Object $session) {
        return "The session `" + $session + "` has not been evicted from the session cache and should still be valid.";
    }
}

