/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test.cases.annotations;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotation;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationList;
import org.jetbrains.kotlin.analysis.api.symbols.DebugSymbolRenderer;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.test.framework.utils.CommonTestUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ8\u0010\u000b\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/cases/annotations/TestAnnotationRenderer;", "", "<init>", "()V", "renderAnnotations", "", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "annotations", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList;", "renderAnnotationsWithMeta", "renderAnnotationsRecursive", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "currentMetaAnnotations", "", "Lorg/jetbrains/kotlin/name/ClassId;", "indent", "", "analysis-api-impl-base_test"})
@SourceDebugExtension(value={"SMAP\nTestAnnotationRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestAnnotationRenderer.kt\norg/jetbrains/kotlin/analysis/api/impl/base/test/cases/annotations/TestAnnotationRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class TestAnnotationRenderer {
    @NotNull
    public static final TestAnnotationRenderer INSTANCE = new TestAnnotationRenderer();

    private TestAnnotationRenderer() {
    }

    @NotNull
    public final String renderAnnotations(@NotNull KaSession analysisSession, @NotNull KaAnnotationList annotations) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        StringBuilder $this$renderAnnotations_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.renderAnnotationsRecursive($this$renderAnnotations_u24lambda_u240, analysisSession, annotations, null, 0);
        return stringBuilder.toString();
    }

    @NotNull
    public final String renderAnnotationsWithMeta(@NotNull KaSession analysisSession, @NotNull KaAnnotationList annotations) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        StringBuilder $this$renderAnnotationsWithMeta_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.renderAnnotationsRecursive($this$renderAnnotationsWithMeta_u24lambda_u241, analysisSession, annotations, SetsKt.emptySet(), 0);
        return stringBuilder.toString();
    }

    private final void renderAnnotationsRecursive(StringBuilder $this$renderAnnotationsRecursive, KaSession analysisSession, KaAnnotationList annotations, Set<ClassId> currentMetaAnnotations, int indent) {
        $this$renderAnnotationsRecursive.append(CommonTestUtilsKt.indented("annotations: [", indent)).append('\n');
        for (KaAnnotation annotation : annotations) {
            ClassId classId;
            $this$renderAnnotationsRecursive.append(CommonTestUtilsKt.indented(new DebugSymbolRenderer(false, false, false, 7, null).renderAnnotationApplication(analysisSession, annotation), indent + 2)).append('\n');
            if (currentMetaAnnotations == null || annotation.getClassId() == null) continue;
            if (currentMetaAnnotations.contains(classId)) {
                $this$renderAnnotationsRecursive.append(CommonTestUtilsKt.indented("<recursive meta-annotation " + classId + '>', indent + 4)).append('\n');
                continue;
            }
            KaSession $this$renderAnnotationsRecursive_u24lambda_u242 = analysisSession;
            boolean bl = false;
            KaClassSymbol kaClassSymbol = $this$renderAnnotationsRecursive_u24lambda_u242.findClass(classId);
            Object metaAnnotations = kaClassSymbol != null ? kaClassSymbol.getAnnotations() : null;
            if (metaAnnotations != null) {
                this.renderAnnotationsRecursive($this$renderAnnotationsRecursive, analysisSession, (KaAnnotationList)metaAnnotations, SetsKt.plus(currentMetaAnnotations, (Object)classId), indent + 4);
                continue;
            }
            $this$renderAnnotationsRecursive.append(CommonTestUtilsKt.indented("<unknown meta-annotation " + classId + '>', indent + 4)).append('\n');
        }
        $this$renderAnnotationsRecursive.append(CommonTestUtilsKt.indented("]", indent)).append('\n');
    }
}

