/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.files;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.AbstractDecompiledClassTest;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.AbstractStubBuilderTestKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.TestData;
import org.jetbrains.kotlin.test.KotlinTestUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u000fH$\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractStubBuilderTest;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractDecompiledClassTest;", "<init>", "()V", "runTest", "", "testDirectory", "", "doTest", "testData", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData;", "useStringTable", "", "testClsStubsForFile", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getStubToTest", "Lcom/intellij/psi/stubs/PsiFileStub;", "decompiler-to-file-stubs_test"})
public abstract class AbstractStubBuilderTest
extends AbstractDecompiledClassTest {
    public final void runTest(@NotNull String testDirectory) {
        Intrinsics.checkNotNullParameter((Object)testDirectory, (String)"testDirectory");
        Path testDirectoryPath = Paths.get(testDirectory, new String[0]);
        Intrinsics.checkNotNull((Object)testDirectoryPath);
        TestData testData = TestData.Companion.createFromDirectory(testDirectoryPath);
        testData.withFirIgnoreDirective(() -> AbstractStubBuilderTest.runTest$lambda$0(this, testData));
    }

    private final void doTest(TestData testData, boolean useStringTable) {
        VirtualFile classFile = this.getClassFileToDecompile$decompiler_to_file_stubs_test(testData, useStringTable);
        this.testClsStubsForFile(classFile, testData);
    }

    private final void testClsStubsForFile(VirtualFile classFile, TestData testData) {
        PsiFileStub<?> stub = this.getStubToTest(classFile);
        KotlinTestUtils.assertEqualsToFile((Path)testData.getExpectedFile(this.getUseK2ToCompileCode()), (String)AbstractStubBuilderTestKt.serializeToString((StubElement<? extends PsiElement>)((StubElement)stub)));
        testData.checkIfIdentical(this.getUseK2ToCompileCode());
    }

    @NotNull
    protected abstract PsiFileStub<?> getStubToTest(@NotNull VirtualFile var1);

    private static final Unit runTest$lambda$0(AbstractStubBuilderTest this$0, TestData $testData) {
        this$0.doTest($testData, true);
        this$0.doTest($testData, false);
        return Unit.INSTANCE;
    }
}

