/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KaLibraryModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModuleFactory;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompiledLibraryProviderKt;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H$J8\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtLibraryBinaryTestModuleFactoryBase;", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModuleFactory;", "<init>", "()V", "testModuleKind", "Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/TestModuleKind;", "getTestModuleKind", "()Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/TestModuleKind;", "decompileToPsiFiles", "", "Lcom/intellij/psi/PsiFile;", "binaryRoot", "Ljava/nio/file/Path;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "project", "Lcom/intellij/openapi/project/Project;", "createModule", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "contextModule", "dependencyBinaryRoots", "", "analysis-test-framework_test"})
public abstract class KtLibraryBinaryTestModuleFactoryBase
implements KtTestModuleFactory {
    @NotNull
    protected abstract TestModuleKind getTestModuleKind();

    @NotNull
    protected abstract List<PsiFile> decompileToPsiFiles(@NotNull Path var1, @NotNull TestServices var2, @NotNull Project var3);

    @Override
    @NotNull
    public KtTestModule createModule(@NotNull TestModule testModule, @Nullable KtTestModule contextModule, @NotNull Collection<? extends Path> dependencyBinaryRoots, @NotNull TestServices testServices, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter(dependencyBinaryRoots, (String)"dependencyBinaryRoots");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path binaryRoot = CompiledLibraryProviderKt.getCompiledLibraryProvider(testServices).compileToLibrary(testModule, dependencyBinaryRoots).getArtifact();
        List<PsiFile> decompiledFiles = this.decompileToPsiFiles(binaryRoot, testServices, project);
        return new KtTestModule(this.getTestModuleKind(), testModule, (KaModule)new KaLibraryModuleImpl(testModule.getName(), testModule.getTargetPlatform(), StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots((Collection)CollectionsKt.listOf((Object)binaryRoot), AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getProjectEnvironment()), project, CollectionsKt.listOf((Object)binaryRoot), null, false), decompiledFiles);
    }
}

