/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.KtBinaryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModuleUtilsKt;
import org.jetbrains.kotlin.analysis.project.structure.KtSdkModule;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtTestModuleStructureProviderKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtJdkModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.LibraryByRoots;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.test.frontend.fir.TestFirNativeSessionFactoryKt;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0007H\u0002J\n\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u001c\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00072\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001f\u0010\u0012R'\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00078FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010!\u0012\u0004\b'\u0010(\u001a\u0004\b)\u0010\u0012R!\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010!\u001a\u0004\b,\u0010\u0012R!\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010!\u001a\u0004\b/\u0010\u0012R\u0012\u00101\u001a\u00020\u001eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u00108\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtModuleByCompilerConfiguration;", "", "project", "Lcom/intellij/openapi/project/Project;", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "psiFiles", "", "Lcom/intellij/psi/PsiFile;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/test/model/TestModule;Ljava/util/List;Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTestModule", "()Lorg/jetbrains/kotlin/test/model/TestModule;", "getPsiFiles", "()Ljava/util/List;", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "compilerConfigurationProvider", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "moduleName", "", "getModuleName", "()Ljava/lang/String;", "directRegularDependencies", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getDirectRegularDependencies", "directRegularDependencies$delegate", "Lkotlin/Lazy;", "computeLibraryDependencies", "Lorg/jetbrains/kotlin/analysis/project/structure/KtBinaryModule;", "createJdkFromConfiguration", "Lorg/jetbrains/kotlin/analysis/project/structure/KtSdkModule;", "directDependsOnDependencies", "getDirectDependsOnDependencies$annotations", "()V", "getDirectDependsOnDependencies", "directDependsOnDependencies$delegate", "transitiveDependsOnDependencies", "getTransitiveDependsOnDependencies", "transitiveDependsOnDependencies$delegate", "directFriendDependencies", "getDirectFriendDependencies", "directFriendDependencies$delegate", "ktModule", "getKtModule", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "librariesByRoots", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/LibraryByRoots;", "roots", "Ljava/nio/file/Path;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nKtSourceModuleByCompilerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtSourceModuleByCompilerConfiguration.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/KtModuleByCompilerConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1557#2:197\n1628#2,3:198\n1557#2:201\n1628#2,3:202\n1557#2:205\n1628#2,3:206\n1557#2:209\n1628#2,3:210\n1628#2,3:213\n1557#2:216\n1628#2,3:217\n1628#2,3:220\n1557#2:223\n1628#2,3:224\n*S KotlinDebug\n*F\n+ 1 KtSourceModuleByCompilerConfiguration.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/KtModuleByCompilerConfiguration\n*L\n54#1:197\n54#1:198,3\n58#1:201\n58#1:202,3\n59#1:205\n59#1:206,3\n102#1:209\n102#1:210,3\n45#1:213,3\n86#1:216\n86#1:217,3\n93#1:220,3\n95#1:223\n95#1:224,3\n*E\n"})
public abstract class KtModuleByCompilerConfiguration {
    @NotNull
    private final Project project;
    @NotNull
    private final TestModule testModule;
    @NotNull
    private final List<PsiFile> psiFiles;
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final CompilerConfigurationProvider compilerConfigurationProvider;
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final Lazy directRegularDependencies$delegate;
    @NotNull
    private final Lazy directDependsOnDependencies$delegate;
    @NotNull
    private final Lazy transitiveDependsOnDependencies$delegate;
    @NotNull
    private final Lazy directFriendDependencies$delegate;

    public KtModuleByCompilerConfiguration(@NotNull Project project, @NotNull TestModule testModule, @NotNull List<? extends PsiFile> psiFiles, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter(psiFiles, (String)"psiFiles");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.project = project;
        this.testModule = testModule;
        this.psiFiles = psiFiles;
        this.testServices = testServices;
        this.compilerConfigurationProvider = CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)this.testServices);
        this.configuration = this.compilerConfigurationProvider.getCompilerConfiguration(this.testModule);
        this.directRegularDependencies$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KtModuleByCompilerConfiguration.directRegularDependencies_delegate$lambda$2(this));
        this.directDependsOnDependencies$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KtModuleByCompilerConfiguration.directDependsOnDependencies_delegate$lambda$9(this));
        this.transitiveDependsOnDependencies$delegate = LazyKt.lazy(() -> KtModuleByCompilerConfiguration.transitiveDependsOnDependencies_delegate$lambda$10(this));
        this.directFriendDependencies$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KtModuleByCompilerConfiguration.directFriendDependencies_delegate$lambda$13(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TestModule getTestModule() {
        return this.testModule;
    }

    @NotNull
    public final List<PsiFile> getPsiFiles() {
        return this.psiFiles;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @NotNull
    public final String getModuleName() {
        return this.testModule.getName();
    }

    @NotNull
    public final List<KtModule> getDirectRegularDependencies() {
        Lazy lazy = this.directRegularDependencies$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtBinaryModule> computeLibraryDependencies() {
        List list;
        TargetPlatform targetPlatform = this.testModule.getTargetPlatform();
        if (NativePlatformKt.isNative((TargetPlatform)targetPlatform)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = TestFirNativeSessionFactoryKt.getAllNativeDependenciesPaths((TestModule)this.testModule, (TestServices)this.testServices);
            KtModuleByCompilerConfiguration ktModuleByCompilerConfiguration = this;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Paths.get((String)it, new String[0]));
            }
            list = ktModuleByCompilerConfiguration.librariesByRoots((List)destination$iv$iv);
        } else {
            File p0;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            List list2;
            List list3;
            List $this$computeLibraryDependencies_u24lambda_u246 = list3 = kotlin.collections.CollectionsKt.createListBuilder();
            boolean bl = false;
            List $this$computeLibraryDependencies_u24lambda_u246_u24lambda_u245 = list2 = kotlin.collections.CollectionsKt.createListBuilder();
            boolean bl2 = false;
            Iterable item$iv$iv = JvmContentRootsKt.getJvmModularRoots((CompilerConfiguration)this.configuration);
            List list4 = $this$computeLibraryDependencies_u24lambda_u246_u24lambda_u245;
            boolean $i$f$map = false;
            void var11_22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                File file = (File)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(p0.toPath());
            }
            list4.addAll((List)destination$iv$iv);
            $this$map$iv = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)this.configuration);
            list4 = $this$computeLibraryDependencies_u24lambda_u246_u24lambda_u245;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                p0 = (File)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(p0.toPath());
            }
            list4.addAll((List)destination$iv$iv);
            List roots = kotlin.collections.CollectionsKt.build((List)list2);
            $this$computeLibraryDependencies_u24lambda_u246.addAll((Collection)this.librariesByRoots(roots));
            CollectionsKt.addIfNotNull((Collection)$this$computeLibraryDependencies_u24lambda_u246, (Object)this.createJdkFromConfiguration());
            list = kotlin.collections.CollectionsKt.build((List)list3);
        }
        return list;
    }

    private final KtSdkModule createJdkFromConfiguration() {
        KtJdkModuleImpl ktJdkModuleImpl;
        File file = (File)this.configuration.get(JVMConfigurationKeys.JDK_HOME);
        if (file != null) {
            File jdkHome = file;
            boolean bl = false;
            List jdkHomePaths = StandaloneProjectFactory.INSTANCE.getDefaultJdkModulePaths(this.project, jdkHome.toPath());
            GlobalSearchScope scope = StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots((Collection)jdkHomePaths, AnalysisApiEnvironmentManagerKt.getEnvironmentManager(this.testServices).getProjectEnvironment());
            ktJdkModuleImpl = new KtJdkModuleImpl("jdk", JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), scope, this.project, jdkHomePaths);
        } else {
            ktJdkModuleImpl = null;
        }
        return ktJdkModuleImpl;
    }

    @NotNull
    public final List<KtModule> getDirectDependsOnDependencies() {
        Lazy lazy = this.directDependsOnDependencies$delegate;
        return (List)lazy.getValue();
    }

    public static /* synthetic */ void getDirectDependsOnDependencies$annotations() {
    }

    @NotNull
    public final List<KtModule> getTransitiveDependsOnDependencies() {
        Lazy lazy = this.transitiveDependsOnDependencies$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<KtModule> getDirectFriendDependencies() {
        Lazy lazy = this.directFriendDependencies$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    protected abstract KtModule getKtModule();

    /*
     * WARNING - void declaration
     */
    private final List<LibraryByRoots> librariesByRoots(List<? extends Path> roots) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = roots;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LibraryByRoots(kotlin.collections.CollectionsKt.listOf((Object)it), this.getKtModule(), this.project, this.testServices));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.testModule.getLanguageVersionSettings();
    }

    @NotNull
    public final TargetPlatform getPlatform() {
        return this.testModule.getTargetPlatform();
    }

    /*
     * WARNING - void declaration
     */
    private static final List directRegularDependencies_delegate$lambda$2(KtModuleByCompilerConfiguration this$0) {
        List list;
        List $this$directRegularDependencies_delegate_u24lambda_u242_u24lambda_u241 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$mapTo$iv = this$0.testModule.getAllDependencies();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            DependencyDescription dependencyDescription = (DependencyDescription)item$iv;
            Collection collection = $this$directRegularDependencies_delegate_u24lambda_u242_u24lambda_u241;
            boolean bl2 = false;
            collection.add(AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(this$0.testServices).getKtTestModule(it.getModuleName()).getKtModule());
        }
        $this$directRegularDependencies_delegate_u24lambda_u242_u24lambda_u241.addAll((Collection)this$0.computeLibraryDependencies());
        return kotlin.collections.CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private static final List directDependsOnDependencies_delegate$lambda$9(KtModuleByCompilerConfiguration this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.testModule.getDependsOnDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(this$0.testServices).getKtTestModule(it.getModuleName()).getKtModule());
        }
        return (List)destination$iv$iv;
    }

    private static final List transitiveDependsOnDependencies_delegate$lambda$10(KtModuleByCompilerConfiguration this$0) {
        return KtModuleUtilsKt.computeTransitiveDependsOnDependencies(this$0.getDirectDependsOnDependencies());
    }

    /*
     * WARNING - void declaration
     */
    private static final List directFriendDependencies_delegate$lambda$13(KtModuleByCompilerConfiguration this$0) {
        Collection<Path> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection2;
        List list;
        List $this$directFriendDependencies_delegate_u24lambda_u2413_u24lambda_u2412 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$mapTo$iv = this$0.testModule.getFriendDependencies();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            DependencyDescription dependencyDescription = (DependencyDescription)item$iv;
            collection2 = $this$directFriendDependencies_delegate_u24lambda_u2413_u24lambda_u2412;
            boolean bl2 = false;
            collection2.add(AnalysisApiKtTestModuleStructureProviderKt.getKtTestModuleStructure(this$0.testServices).getKtTestModule(it.getModuleName()).getKtModule());
        }
        List list2 = (List)this$0.configuration.get(JVMConfigurationKeys.FRIEND_PATHS);
        if (list2 == null) {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        }
        $this$mapTo$iv = list2;
        KtModuleByCompilerConfiguration ktModuleByCompilerConfiguration = this$0;
        collection2 = $this$directFriendDependencies_delegate_u24lambda_u2413_u24lambda_u2412;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(Paths.get((String)p0, new String[0]));
        }
        collection = (List)destination$iv$iv;
        collection2.addAll((Collection)ktModuleByCompilerConfiguration.librariesByRoots((List<? extends Path>)collection));
        return kotlin.collections.CollectionsKt.build((List)list);
    }
}

