/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.files;

import com.intellij.psi.stubs.StubElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.KotlinContractRenderer;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationEntryStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFlexibleTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinParameterStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeArgumentBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeParameterTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinUserTypeStubImpl;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a-\u0010\u0004\u001a\u00020\u00052\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\n\u0010\u0006\u001a\u00060\bj\u0002`\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a!\u0010\f\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\bj\u0002`\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"extractAdditionalStubInfo", "", "stub", "Lcom/intellij/psi/stubs/StubElement;", "extractAdditionInfo", "", "builder", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "level", "", "(Lcom/intellij/psi/stubs/StubElement;Ljava/lang/StringBuilder;I)V", "appendFlexibleTypeInfo", "typeBean", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeBean;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeBean;)V", "decompiler-to-file-stubs_test"})
@SourceDebugExtension(value={"SMAP\nAdditionalStubInfoExtraction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdditionalStubInfoExtraction.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/files/AdditionalStubInfoExtractionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1#2:152\n1872#3,3:153\n*S KotlinDebug\n*F\n+ 1 AdditionalStubInfoExtraction.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/files/AdditionalStubInfoExtractionKt\n*L\n71#1:153,3\n*E\n"})
public final class AdditionalStubInfoExtractionKt {
    @NotNull
    public static final String extractAdditionalStubInfo(@NotNull StubElement<?> stub) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        StringBuilder builder = new StringBuilder();
        AdditionalStubInfoExtractionKt.extractAdditionInfo(stub, builder, 0);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void extractAdditionInfo(StubElement<?> stub, StringBuilder builder, int level) {
        builder.append(stub.toString());
        StubElement<?> stubElement = stub;
        if (stubElement instanceof KotlinUserTypeStubImpl) {
            KotlinTypeBean upperBound = ((KotlinUserTypeStubImpl)stub).getUpperBound();
            if (upperBound != null) {
                builder.append("    ft: ");
                AdditionalStubInfoExtractionKt.appendFlexibleTypeInfo(builder, upperBound);
            }
        } else if (stubElement instanceof KotlinFunctionStubImpl) {
            List contract = ((KotlinFunctionStubImpl)stub).getContract();
            if (contract != null) {
                for (KtContractDescriptionElement element : contract) {
                    builder.append('\n' + StringsKt.repeat((CharSequence)"  ", (int)level)).append("effect:");
                    element.accept((KtContractDescriptionVisitor)new KotlinContractRenderer(builder), null);
                }
            }
        } else if (stubElement instanceof KotlinPropertyStubImpl) {
            ConstantValue initializer = ((KotlinPropertyStubImpl)stub).getConstantInitializer();
            if (initializer != null) {
                builder.append("\n").append(StringsKt.repeat((CharSequence)"  ", (int)level)).append("initializer: " + initializer.getValue());
            }
        } else if (stubElement instanceof KotlinAnnotationEntryStubImpl) {
            Map arguments = ((KotlinAnnotationEntryStubImpl)stub).getValueArguments();
            if (arguments != null) {
                builder.append("\n").append(StringsKt.repeat((CharSequence)"  ", (int)level)).append("valueArguments: ").append(CollectionsKt.joinToString$default((Iterable)arguments.entrySet(), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, AdditionalStubInfoExtractionKt::extractAdditionInfo$lambda$0, (int)24, null));
            }
        } else if (stubElement instanceof KotlinParameterStubImpl) {
            String string = ((KotlinParameterStubImpl)stub).getFunctionTypeParameterName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                builder.append("   paramNameByAnnotation: ").append(it);
            }
        }
        for (StubElement child : stub.getChildrenStubs()) {
            builder.append("\n").append(StringsKt.repeat((CharSequence)"  ", (int)level));
            Intrinsics.checkNotNull((Object)child);
            AdditionalStubInfoExtractionKt.extractAdditionInfo(child, builder, level + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendFlexibleTypeInfo(StringBuilder builder, KotlinTypeBean typeBean) {
        KotlinTypeBean kotlinTypeBean = typeBean;
        if (kotlinTypeBean instanceof KotlinClassTypeBean) {
            builder.append(((KotlinClassTypeBean)typeBean).getClassId().asFqNameString());
            List arguments = ((KotlinClassTypeBean)typeBean).getArguments();
            if (!((Collection)arguments).isEmpty()) {
                builder.append("<");
                Iterable $this$forEachIndexed$iv = arguments;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void arg;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    KotlinTypeArgumentBean kotlinTypeArgumentBean = (KotlinTypeArgumentBean)item$iv;
                    int index = n;
                    boolean bl = false;
                    if (index > 0) {
                        builder.append(", ");
                    }
                    if (arg.getProjectionKind() != KtProjectionKind.NONE) {
                        builder.append(arg.getProjectionKind().name());
                    }
                    if (arg.getProjectionKind() == KtProjectionKind.STAR) continue;
                    KotlinTypeBean kotlinTypeBean2 = arg.getType();
                    Intrinsics.checkNotNull((Object)kotlinTypeBean2);
                    AdditionalStubInfoExtractionKt.appendFlexibleTypeInfo(builder, kotlinTypeBean2);
                }
                builder.append(">");
            }
            if (((KotlinClassTypeBean)typeBean).getNullable()) {
                builder.append("?");
            }
        } else if (kotlinTypeBean instanceof KotlinTypeParameterTypeBean) {
            builder.append(((KotlinTypeParameterTypeBean)typeBean).getTypeParameterName());
            if (((KotlinTypeParameterTypeBean)typeBean).getNullable()) {
                builder.append("?");
            }
            if (((KotlinTypeParameterTypeBean)typeBean).getDefinitelyNotNull()) {
                builder.append(" & Any");
            }
        } else if (kotlinTypeBean instanceof KotlinFlexibleTypeBean) {
            AdditionalStubInfoExtractionKt.appendFlexibleTypeInfo(builder, ((KotlinFlexibleTypeBean)typeBean).getLowerBound());
            builder.append(" .. ");
            AdditionalStubInfoExtractionKt.appendFlexibleTypeInfo(builder, ((KotlinFlexibleTypeBean)typeBean).getUpperBound());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final CharSequence extractAdditionInfo$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Name)it.getKey()).asString() + " = " + it.getValue();
    }
}

