/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.files;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.AbstractDecompiledClassTestKt;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\b\u0018\u0000 *2\u00020\u0001:\u0002*+B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007J%\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0015J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u00c6\u0003JA\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData;", "", "directory", "Ljava/nio/file/Path;", "mainKotlinFile", "expectedFile", "jvmFileName", "", "additionalCompilerOptions", "", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;Ljava/util/List;)V", "getDirectory", "()Ljava/nio/file/Path;", "getMainKotlinFile", "getExpectedFile", "getJvmFileName", "()Ljava/lang/String;", "getAdditionalCompilerOptions", "()Ljava/util/List;", "containsDirective", "", "directive", "withFirIgnoreDirective", "R", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "useK2", "checkIfIdentical", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "IdenticalCheckerHelper", "decompiler-to-file-stubs_test"})
@SourceDebugExtension(value={"SMAP\nAbstractDecompiledClassTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDecompiledClassTest.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
public final class TestData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path directory;
    @NotNull
    private final Path mainKotlinFile;
    @NotNull
    private final Path expectedFile;
    @NotNull
    private final String jvmFileName;
    @NotNull
    private final List<String> additionalCompilerOptions;

    public TestData(@NotNull Path directory, @NotNull Path mainKotlinFile, @NotNull Path expectedFile, @NotNull String jvmFileName, @NotNull List<String> additionalCompilerOptions) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)mainKotlinFile, (String)"mainKotlinFile");
        Intrinsics.checkNotNullParameter((Object)expectedFile, (String)"expectedFile");
        Intrinsics.checkNotNullParameter((Object)jvmFileName, (String)"jvmFileName");
        Intrinsics.checkNotNullParameter(additionalCompilerOptions, (String)"additionalCompilerOptions");
        this.directory = directory;
        this.mainKotlinFile = mainKotlinFile;
        this.expectedFile = expectedFile;
        this.jvmFileName = jvmFileName;
        this.additionalCompilerOptions = additionalCompilerOptions;
    }

    @NotNull
    public final Path getDirectory() {
        return this.directory;
    }

    @NotNull
    public final Path getMainKotlinFile() {
        return this.mainKotlinFile;
    }

    @NotNull
    public final Path getExpectedFile() {
        return this.expectedFile;
    }

    @NotNull
    public final String getJvmFileName() {
        return this.jvmFileName;
    }

    @NotNull
    public final List<String> getAdditionalCompilerOptions() {
        return this.additionalCompilerOptions;
    }

    public final boolean containsDirective(@NotNull String directive) {
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        return InTextDirectivesUtils.isDirectiveDefined((String)PathsKt.readText$default((Path)this.mainKotlinFile, null, (int)1, null), (String)("// " + directive));
    }

    @Nullable
    public final <R> R withFirIgnoreDirective(@NotNull Function0<? extends R> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        String directive = "FIR_IGNORE";
        if (this.containsDirective(directive)) {
            return null;
        }
        return (R)action.invoke();
    }

    @NotNull
    public final Path getExpectedFile(boolean useK2) {
        if (useK2) {
            File file;
            File file2;
            File file3 = this.expectedFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
            File it = file2 = IdenticalCheckerHelper.INSTANCE.getFirFileToCompare(file3);
            boolean bl = false;
            File file4 = file = it.exists() ? file2 : null;
            if (file != null) {
                it = file;
                boolean bl2 = false;
                Path path = it.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                return path;
            }
        }
        return this.expectedFile;
    }

    public final void checkIfIdentical(boolean useK2) {
        if (this.containsDirective(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL().getName())) {
            return;
        }
        if (useK2) {
            FirIdenticalCheckerHelper firIdenticalCheckerHelper = IdenticalCheckerHelper.INSTANCE;
            File file = this.expectedFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            if (FirIdenticalCheckerHelper.firAndClassicContentsAreEquals$default((FirIdenticalCheckerHelper)firIdenticalCheckerHelper, (File)file, (boolean)false, (int)2, null)) {
                File file2 = this.expectedFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                IdenticalCheckerHelper.INSTANCE.deleteFirFile(file2);
                FirIdenticalCheckerHelper firIdenticalCheckerHelper2 = IdenticalCheckerHelper.INSTANCE;
                File file3 = this.mainKotlinFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
                FirIdenticalCheckerHelper.addDirectiveToClassicFileAndAssert$default((FirIdenticalCheckerHelper)firIdenticalCheckerHelper2, (File)file3, null, (int)2, null);
            }
        }
    }

    @NotNull
    public final Path component1() {
        return this.directory;
    }

    @NotNull
    public final Path component2() {
        return this.mainKotlinFile;
    }

    @NotNull
    public final Path component3() {
        return this.expectedFile;
    }

    @NotNull
    public final String component4() {
        return this.jvmFileName;
    }

    @NotNull
    public final List<String> component5() {
        return this.additionalCompilerOptions;
    }

    @NotNull
    public final TestData copy(@NotNull Path directory, @NotNull Path mainKotlinFile, @NotNull Path expectedFile, @NotNull String jvmFileName, @NotNull List<String> additionalCompilerOptions) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)mainKotlinFile, (String)"mainKotlinFile");
        Intrinsics.checkNotNullParameter((Object)expectedFile, (String)"expectedFile");
        Intrinsics.checkNotNullParameter((Object)jvmFileName, (String)"jvmFileName");
        Intrinsics.checkNotNullParameter(additionalCompilerOptions, (String)"additionalCompilerOptions");
        return new TestData(directory, mainKotlinFile, expectedFile, jvmFileName, additionalCompilerOptions);
    }

    public static /* synthetic */ TestData copy$default(TestData testData, Path path, Path path2, Path path3, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            path = testData.directory;
        }
        if ((n & 2) != 0) {
            path2 = testData.mainKotlinFile;
        }
        if ((n & 4) != 0) {
            path3 = testData.expectedFile;
        }
        if ((n & 8) != 0) {
            string = testData.jvmFileName;
        }
        if ((n & 0x10) != 0) {
            list = testData.additionalCompilerOptions;
        }
        return testData.copy(path, path2, path3, string, list);
    }

    @NotNull
    public String toString() {
        return "TestData(directory=" + this.directory + ", mainKotlinFile=" + this.mainKotlinFile + ", expectedFile=" + this.expectedFile + ", jvmFileName=" + this.jvmFileName + ", additionalCompilerOptions=" + this.additionalCompilerOptions + ')';
    }

    public int hashCode() {
        int result = ((Object)this.directory).hashCode();
        result = result * 31 + ((Object)this.mainKotlinFile).hashCode();
        result = result * 31 + ((Object)this.expectedFile).hashCode();
        result = result * 31 + this.jvmFileName.hashCode();
        result = result * 31 + ((Object)this.additionalCompilerOptions).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TestData)) {
            return false;
        }
        TestData testData = (TestData)other;
        if (!Intrinsics.areEqual((Object)this.directory, (Object)testData.directory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mainKotlinFile, (Object)testData.mainKotlinFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.expectedFile, (Object)testData.expectedFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jvmFileName, (Object)testData.jvmFileName)) {
            return false;
        }
        return Intrinsics.areEqual(this.additionalCompilerOptions, testData.additionalCompilerOptions);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData$Companion;", "", "<init>", "()V", "createFromDirectory", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData;", "directory", "Ljava/nio/file/Path;", "decompiler-to-file-stubs_test"})
    @SourceDebugExtension(value={"SMAP\nAbstractDecompiledClassTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDecompiledClassTest.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1557#2:190\n1628#2,3:191\n626#2,12:194\n*S KotlinDebug\n*F\n+ 1 AbstractDecompiledClassTest.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData$Companion\n*L\n153#1:190\n153#1:191,3\n157#1:194,12\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TestData createFromDirectory(@NotNull Path directory) {
            Object var19_22;
            void $this$single$iv;
            Path it;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            List allFiles = Files.list(directory).collect(Collectors.toList());
            Path mainKotlinFile = AbstractDecompiledClassTestKt.findMainTestKotlinFile(directory);
            String fileText = PathsKt.readText$default((Path)mainKotlinFile, null, (int)1, null);
            String[] stringArray = new String[]{"JVM_FILE_NAME:"};
            String string = InTextDirectivesUtils.findStringWithPrefixes((String)fileText, (String[])stringArray);
            if (string == null) {
                string = PathsKt.getName((Path)directory);
            }
            String jvmFileName = string;
            String[] stringArray2 = new String[]{"// !LANGUAGE: "};
            List list = InTextDirectivesUtils.findListWithPrefixes((String)fileText, (String[])stringArray2);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findListWithPrefixes(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add("-XXLanguage:" + (String)((Object)it));
            }
            List additionalCompilerOptions = (List)destination$iv$iv;
            Intrinsics.checkNotNull(allFiles);
            Iterable $i$f$map22 = allFiles;
            Path path = mainKotlinFile;
            Path path2 = directory;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                it = (Path)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Object)it.getFileName()).toString(), (Object)(PathsKt.getName((Path)directory) + ".txt"))) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object v2 = var19_22 = single$iv;
            Intrinsics.checkNotNullExpressionValue(v2, (String)"single(...)");
            List list2 = additionalCompilerOptions;
            String string3 = jvmFileName;
            Path path3 = v2;
            Path path4 = path;
            Path path5 = path2;
            return new TestData(path5, path4, path3, string3, list2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData$IdenticalCheckerHelper;", "Lorg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper;", "<init>", "()V", "getClassicFileToCompare", "Ljava/io/File;", "testDataFile", "getFirFileToCompare", "decompiler-to-file-stubs_test"})
    private static final class IdenticalCheckerHelper
    extends FirIdenticalCheckerHelper {
        @NotNull
        public static final IdenticalCheckerHelper INSTANCE = new IdenticalCheckerHelper();

        /*
         * WARNING - void declaration
         */
        private IdenticalCheckerHelper() {
            void $this$_init__u24lambda_u240;
            TestServices testServices;
            TestServices testServices2 = testServices = new TestServices();
            IdenticalCheckerHelper identicalCheckerHelper = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.register(Reflection.getOrCreateKotlinClass(AssertionsService.class), (TestService)JUnit5Assertions.INSTANCE);
            super(testServices);
        }

        @NotNull
        public File getClassicFileToCompare(@NotNull File testDataFile) {
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            Path path = testDataFile.toPath();
            String fileNameWithoutExtension = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)((Object)path.getFileName()).toString(), (CharSequence)".k2.txt"), (CharSequence)".txt");
            File file = path.getParent().resolve(fileNameWithoutExtension + ".txt").toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        @NotNull
        public File getFirFileToCompare(@NotNull File testDataFile) {
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            Path path = testDataFile.toPath();
            String fileNameWithoutExtension = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)((Object)path.getFileName()).toString(), (CharSequence)".k2.txt"), (CharSequence)".txt");
            File file = path.getParent().resolve(fileNameWithoutExtension + ".k2.txt").toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }
    }
}

