/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompiledLibrary;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompiledLibraryProviderKt;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompiledLibraryProvider;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "libraries", "", "", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompiledLibrary;", "compileToLibrary", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "dependencyBinaryRoots", "", "Ljava/nio/file/Path;", "getCompiledLibrary", "moduleName", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nCompiledLibraryProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompiledLibraryProvider.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompiledLibraryProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class CompiledLibraryProvider
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Map<String, CompiledLibrary> libraries;

    public CompiledLibraryProvider(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.testServices = testServices;
        this.libraries = new LinkedHashMap();
    }

    @NotNull
    public final CompiledLibrary compileToLibrary(@NotNull TestModule module, @NotNull Collection<? extends Path> dependencyBinaryRoots) {
        CompiledLibrary compiledLibrary;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(dependencyBinaryRoots, (String)"dependencyBinaryRoots");
        if (this.libraries.containsKey(module.getName())) {
            throw new IllegalStateException(("Library for module " + module.getName() + " is already compiled").toString());
        }
        Path libraryJar = CompiledLibraryProviderKt.getTestModuleCompiler(this.testServices).compileTestModuleToLibrary(module, dependencyBinaryRoots, this.testServices);
        Path librarySourcesJar = CompiledLibraryProviderKt.getTestModuleCompiler(this.testServices).compileTestModuleToLibrarySources(module, this.testServices);
        CompiledLibrary it = compiledLibrary = new CompiledLibrary(libraryJar, librarySourcesJar);
        boolean bl = false;
        this.libraries.put(module.getName(), it);
        return compiledLibrary;
    }

    @Nullable
    public final CompiledLibrary getCompiledLibrary(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return this.libraries.get(moduleName);
    }
}

