/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtStaticProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.KtBuiltinsModule;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtTestModuleProjectStructure;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManager;
import org.jetbrains.kotlin.analysis.test.framework.services.KtTestProjectStructureProvider;
import org.jetbrains.kotlin.analysis.test.framework.services.TestDisposableProvderKt;
import org.jetbrains.kotlin.analysis.test.framework.services.TestDisposableProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironmentMode;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.test.TestSetupUtilsKt;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/AnalysisApiEnvironmentManagerImpl;", "Lorg/jetbrains/kotlin/analysis/test/framework/services/AnalysisApiEnvironmentManager;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "testRootDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lcom/intellij/openapi/Disposable;)V", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "getTestRootDisposable", "()Lcom/intellij/openapi/Disposable;", "_projectEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "get_projectEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "_projectEnvironment$delegate", "Lkotlin/Lazy;", "initializeEnvironment", "", "initializeProjectStructure", "getProjectEnvironment", "getApplicationEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreApplicationEnvironment;", "analysis-test-framework_test"})
public final class AnalysisApiEnvironmentManagerImpl
extends AnalysisApiEnvironmentManager {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Disposable testRootDisposable;
    @NotNull
    private final Lazy _projectEnvironment$delegate;

    public AnalysisApiEnvironmentManagerImpl(@NotNull TestServices testServices, @NotNull Disposable testRootDisposable) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)testRootDisposable, (String)"testRootDisposable");
        this.testServices = testServices;
        this.testRootDisposable = testRootDisposable;
        this._projectEnvironment$delegate = LazyKt.lazy(() -> AnalysisApiEnvironmentManagerImpl._projectEnvironment_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public Disposable getTestRootDisposable() {
        return this.testRootDisposable;
    }

    private final KotlinCoreProjectEnvironment get_projectEnvironment() {
        Lazy lazy = this._projectEnvironment$delegate;
        return (KotlinCoreProjectEnvironment)lazy.getValue();
    }

    @Override
    public void initializeEnvironment() {
        TestDisposableProvider testDisposableProvider = TestDisposableProvderKt.getDisposableProvider(this.getTestServices());
        Disposable disposable = this.get_projectEnvironment().getParentDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getParentDisposable(...)");
        Disposable disposable2 = this.get_projectEnvironment().getEnvironment().getParentDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"getParentDisposable(...)");
        testDisposableProvider.registerDisposables(disposable, disposable2);
    }

    @Override
    public void initializeProjectStructure() {
        KtTestModuleProjectStructure ktTestModuleProjectStructure = AnalysisApiKtModuleProviderImplKt.getKtModuleProvider(this.getTestServices()).getModuleStructure();
        TestModule useSiteModule = (TestModule)CollectionsKt.first((List)TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getModules());
        CompilerConfiguration useSiteCompilerConfiguration = CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)this.getTestServices()).getCompilerConfiguration(useSiteModule);
        KtBuiltinsModule builtinsModule = new KtBuiltinsModule(useSiteModule.getTargetPlatform(), TestSetupUtilsKt.getAnalyzerServices((TargetPlatform)useSiteModule.getTargetPlatform()), this.getProject());
        LanguageVersionSettings globalLanguageVersionSettings = useSiteModule.getLanguageVersionSettings();
        File file = (File)useSiteCompilerConfiguration.get(JVMConfigurationKeys.JDK_HOME);
        StandaloneProjectFactory.INSTANCE.registerServicesForProjectEnvironment(this.get_projectEnvironment(), (KtStaticProjectStructureProvider)new KtTestProjectStructureProvider(globalLanguageVersionSettings, builtinsModule, ktTestModuleProjectStructure), CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)useSiteCompilerConfiguration), file != null ? file.toPath() : null);
        CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)this.getTestServices()).registerCompilerExtensions(this.getProject(), useSiteModule, useSiteCompilerConfiguration);
    }

    @Override
    @NotNull
    public KotlinCoreProjectEnvironment getProjectEnvironment() {
        return this.get_projectEnvironment();
    }

    @Override
    @NotNull
    public KotlinCoreApplicationEnvironment getApplicationEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.get_projectEnvironment().getEnvironment();
        Intrinsics.checkNotNull((Object)coreApplicationEnvironment, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment");
        return (KotlinCoreApplicationEnvironment)coreApplicationEnvironment;
    }

    private static final KotlinCoreProjectEnvironment _projectEnvironment_delegate$lambda$0(AnalysisApiEnvironmentManagerImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return StandaloneProjectFactory.createProjectEnvironment$default((StandaloneProjectFactory)StandaloneProjectFactory.INSTANCE, (Disposable)this$0.getTestRootDisposable(), (KotlinCoreApplicationEnvironmentMode)((KotlinCoreApplicationEnvironmentMode)KotlinCoreApplicationEnvironmentMode.UnitTest.INSTANCE), null, null, (int)12, null);
    }
}

