/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.typeInfoProvider;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtSymbolDeclarationRendererMixIn;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.typeInfoProvider.AbstractIsDenotableTest;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiBasedTest;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.builders.RegisteredDirectivesBuilder;
import org.jetbrains.kotlin.test.builders.TestConfigurationBuilder;
import org.jetbrains.kotlin.test.directives.ConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/cases/components/typeInfoProvider/AbstractIsDenotableTest;", "Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest;", "<init>", "()V", "denotableName", "Lorg/jetbrains/kotlin/name/Name;", "getDenotableName", "()Lorg/jetbrains/kotlin/name/Name;", "undenotableName", "getUndenotableName", "doTestByMainModuleAndOptionalMainFile", "", "mainFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "mainModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "configureTest", "builder", "Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "TestHelperProvider", "analysis-api-impl-base_test"})
public abstract class AbstractIsDenotableTest
extends AbstractAnalysisApiBasedTest {
    @NotNull
    private final Name denotableName;
    @NotNull
    private final Name undenotableName;

    public AbstractIsDenotableTest() {
        Name name = Name.identifier((String)"Denotable");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        this.denotableName = name;
        Name name2 = Name.identifier((String)"Nondenotable");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        this.undenotableName = name2;
    }

    @NotNull
    public final Name getDenotableName() {
        return this.denotableName;
    }

    @NotNull
    public final Name getUndenotableName() {
        return this.undenotableName;
    }

    @Override
    protected void doTestByMainModuleAndOptionalMainFile(@Nullable KtFile mainFile, @NotNull TestModule mainModule, @NotNull TestServices testServices) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        KtFile ktFile = mainFile;
        if (ktFile == null) {
            ktFile = (KtFile)CollectionsKt.first(AnalysisApiKtModuleProviderImplKt.getKtFiles(AnalysisApiKtModuleProviderImplKt.getKtModuleProvider(testServices), mainModule));
        }
        KtFile ktFile2 = ktFile;
        StringBuilder $this$doTestByMainModuleAndOptionalMainFile_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ktFile2.accept((PsiElementVisitor)new KtTreeVisitorVoid($this$doTestByMainModuleAndOptionalMainFile_u24lambda_u240, this){
            final /* synthetic */ StringBuilder $this_buildString;
            final /* synthetic */ AbstractIsDenotableTest this$0;
            {
                this.$this_buildString = $receiver;
                this.this$0 = $receiver2;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof LeafPsiElement) {
                    this.$this_buildString.append(((LeafPsiElement)element).getText());
                }
                super.visitElement(element);
            }

            /*
             * WARNING - void declaration
             */
            public void visitAnnotatedExpression(KtAnnotatedExpression expression) {
                KtExpression base;
                block9: {
                    block8: {
                        boolean bl;
                        block7: {
                            void $this$none$iv;
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            base = expression.getBaseExpression();
                            if (base == null) break block8;
                            List list = expression.getAnnotationEntries();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
                            Iterable iterable = list;
                            AbstractIsDenotableTest abstractIsDenotableTest = this.this$0;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                                    boolean bl2 = false;
                                    if (!(Intrinsics.areEqual((Object)it.getShortName(), (Object)abstractIsDenotableTest.getDenotableName()) || Intrinsics.areEqual((Object)it.getShortName(), (Object)abstractIsDenotableTest.getUndenotableName()))) continue;
                                    bl = false;
                                    break block7;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) break block9;
                    }
                    super.visitAnnotatedExpression(expression);
                    return;
                }
                AbstractIsDenotableTest.access$analyseForTest(this.this$0, (KtElement)expression, (arg_0, arg_1) -> doTestByMainModuleAndOptionalMainFile.actualText.1.1.visitAnnotatedExpression$lambda$1(expression, base, this.$this_buildString, arg_0, arg_1));
            }

            private static final StringBuilder visitAnnotatedExpression$lambda$1(KtAnnotatedExpression $expression, KtExpression $base, StringBuilder $this_buildString, KtAnalysisSession $this$analyseForTest, KtElement it) {
                StringBuilder stringBuilder;
                boolean actualHasDenotableType;
                KtType ktType;
                Intrinsics.checkNotNullParameter((Object)$expression, (String)"$expression");
                Intrinsics.checkNotNullParameter((Object)$this_buildString, (String)"$this_buildString");
                Intrinsics.checkNotNullParameter((Object)$this$analyseForTest, (String)"$this$analyseForTest");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PsiElement $this$parentOfType_u24default$iv = (PsiElement)$expression;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                KtQualifiedExpression parent = (KtQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtQualifiedExpression.class, (boolean)true);
                KtType ktType2 = ktType = parent != null && Intrinsics.areEqual((Object)KtPsiUtil.deparenthesize((KtExpression)parent.getReceiverExpression()), (Object)KtPsiUtil.deparenthesize((KtExpression)$base)) ? $this$analyseForTest.getKtType(parent.getReceiverExpression()) : $this$analyseForTest.getKtType((KtExpression)$expression);
                if (ktType2 == null) {
                    throw new IllegalStateException(($base.getText() + " does not have a type.").toString());
                }
                boolean bl = actualHasDenotableType = $this$analyseForTest.isDenotable(ktType2);
                if (bl) {
                    stringBuilder = $this_buildString.append("@Denotable");
                } else if (!bl) {
                    stringBuilder = $this_buildString.append("@Nondenotable");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                $this_buildString.append("(\"" + KtSymbolDeclarationRendererMixIn.render$default((KtSymbolDeclarationRendererMixIn)((KtSymbolDeclarationRendererMixIn)$this$analyseForTest), (KtType)ktType, null, (Variance)Variance.INVARIANT, (int)1, null) + "\") ");
                return $this_buildString.append($base.getText());
            }
        });
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String actualText2 = string;
        Assertions.assertEqualsToFile$default((Assertions)((Assertions)AssertionsKt.getAssertions((TestServices)testServices)), (Path)this.getTestDataPath(), (String)actualText2, null, (int)4, null);
    }

    @Override
    protected void configureTest(@NotNull TestConfigurationBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.configureTest(builder);
        Function1[] function1Array = new Function1[]{configureTest.1.INSTANCE};
        builder.useAdditionalSourceProviders(function1Array);
        builder.defaultDirectives(AbstractIsDenotableTest::configureTest$lambda$1);
    }

    private static final Unit configureTest$lambda$1(RegisteredDirectivesBuilder $this$defaultDirectives) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultDirectives, (String)"$this$defaultDirectives");
        $this$defaultDirectives.unaryPlus(ConfigurationDirectives.INSTANCE.getWITH_STDLIB());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$analyseForTest(AbstractIsDenotableTest $this, KtElement contextElement, Function2 action) {
        return $this.analyseForTest(contextElement, action);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/cases/components/typeInfoProvider/AbstractIsDenotableTest$TestHelperProvider;", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "produceAdditionalFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "globalDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "analysis-api-impl-base_test"})
    private static final class TestHelperProvider
    extends AdditionalSourceProvider {
        public TestHelperProvider(@NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
            super(testServices);
        }

        @NotNull
        public List<TestFile> produceAdditionalFiles(@NotNull RegisteredDirectives globalDirectives, @NotNull TestModule module) {
            Intrinsics.checkNotNullParameter((Object)globalDirectives, (String)"globalDirectives");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return CollectionsKt.listOf((Object)AdditionalSourceProvider.toTestFile$default((AdditionalSourceProvider)this, (File)new File("analysis/analysis-api/testData/helpers/isDenotable/helpers.kt"), null, (int)1, null));
        }
    }
}

