/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleWithFiles;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtLibraryModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtModuleFactory;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompiledLibraryProviderKt;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.TestModuleDecompilerKt;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtLibraryBinaryModuleFactory;", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtModuleFactory;", "<init>", "()V", "createModule", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleWithFiles;", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "contextModule", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "project", "Lcom/intellij/openapi/project/Project;", "analysis-test-framework_test"})
public final class KtLibraryBinaryModuleFactory
implements KtModuleFactory {
    @NotNull
    public static final KtLibraryBinaryModuleFactory INSTANCE = new KtLibraryBinaryModuleFactory();

    private KtLibraryBinaryModuleFactory() {
    }

    @Override
    @NotNull
    public KtModuleWithFiles createModule(@NotNull TestModule testModule, @Nullable KtModuleWithFiles contextModule, @NotNull TestServices testServices, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path library = CompiledLibraryProviderKt.getCompiledLibraryProvider(testServices).compileToLibrary(testModule).getArtifact();
        List<PsiFile> decompiledFiles = TestModuleDecompilerKt.getTestModuleDecompiler(testServices).getAllPsiFilesFromLibrary(library, project);
        return new KtModuleWithFiles((KtModule)new KtLibraryModuleImpl(testModule.getName(), testModule.getTargetPlatform(), StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots((Collection)CollectionsKt.listOf((Object)library), AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getProjectEnvironment()), project, CollectionsKt.listOf((Object)library), null), decompiledFiles);
    }
}

