/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleWithFiles;
import org.jetbrains.kotlin.analysis.project.structure.DanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.impl.KtDanglingFileModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiTestCodeFragmentDirectives;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.CodeFragmentKind;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtModuleFactory;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkersSourceFilePreprocessorKt;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtCodeFragmentModuleFactory;", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtModuleFactory;", "<init>", "()V", "createModule", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleWithFiles;", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "contextModule", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "project", "Lcom/intellij/openapi/project/Project;", "findContextElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nKtCodeFragmentModuleFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtCodeFragmentModuleFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/KtCodeFragmentModuleFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,93:1\n1#2:94\n798#3,11:95\n125#4:106\n*S KotlinDebug\n*F\n+ 1 KtCodeFragmentModuleFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/KtCodeFragmentModuleFactory\n*L\n55#1:95,11\n75#1:106\n*E\n"})
public final class KtCodeFragmentModuleFactory
implements KtModuleFactory {
    @NotNull
    public static final KtCodeFragmentModuleFactory INSTANCE = new KtCodeFragmentModuleFactory();

    private KtCodeFragmentModuleFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KtModuleWithFiles createModule(@NotNull TestModule testModule, @Nullable KtModuleWithFiles contextModule, @NotNull TestServices testServices, @NotNull Project project) {
        KtCodeFragment ktCodeFragment;
        KtElement ktElement;
        String codeFragmentImports;
        CodeFragmentKind codeFragmentKind;
        String fileText;
        String fileName;
        block11: {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
            Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (contextModule == null) {
                boolean $i$a$-requireNotNull-KtCodeFragmentModuleFactory$createModule$22 = false;
                String $i$a$-requireNotNull-KtCodeFragmentModuleFactory$createModule$22 = "Code fragment requires a context module";
                throw new IllegalArgumentException($i$a$-requireNotNull-KtCodeFragmentModuleFactory$createModule$22.toString());
            }
            TestFile testFile = (TestFile)CollectionsKt.singleOrNull((List)testModule.getFiles());
            if (testFile == null) {
                throw new IllegalStateException("A single file is expected for a code fragment module".toString());
            }
            TestFile testFile2 = testFile;
            fileName = testFile2.getName();
            fileText = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile(testFile2);
            CodeFragmentKind codeFragmentKind2 = (CodeFragmentKind)((Object)DirectiveKt.singleOrZeroValue((RegisteredDirectives)testFile2.getDirectives(), AnalysisApiTestCodeFragmentDirectives.INSTANCE.getCODE_FRAGMENT_KIND()));
            if (codeFragmentKind2 == null) {
                codeFragmentKind2 = CodeFragmentKind.BLOCK;
            }
            codeFragmentKind = codeFragmentKind2;
            String string = CollectionsKt.joinToString$default((Iterable)testFile2.getDirectives().get(AnalysisApiTestCodeFragmentDirectives.INSTANCE.getCODE_FRAGMENT_IMPORT()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            Object it = string;
            boolean bl = false;
            String string2 = codeFragmentImports = ((CharSequence)it).length() > 0 ? string : null;
            if (codeFragmentKind == CodeFragmentKind.TYPE && codeFragmentImports != null) {
                throw new IllegalStateException("Imports cannot be configured for type code fragments".toString());
            }
            it = contextModule.getFiles();
            boolean $i$f$filterIsInstance = false;
            KtElement ktElement2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (KtFile it2 : (Iterable)((List)destination$iv$iv)) {
                boolean bl2 = false;
                ktElement2 = INSTANCE.findContextElement(it2, testServices);
                if (ktElement2 == null) continue;
                ktElement = ktElement2;
                break block11;
            }
            ktElement = null;
        }
        KtElement contextElement = ktElement;
        switch (WhenMappings.$EnumSwitchMapping$0[codeFragmentKind.ordinal()]) {
            case 1: {
                ktCodeFragment = (KtCodeFragment)new KtExpressionCodeFragment(project, fileName, (CharSequence)fileText, codeFragmentImports, (PsiElement)contextElement);
                break;
            }
            case 2: {
                ktCodeFragment = (KtCodeFragment)new KtBlockCodeFragment(project, fileName, (CharSequence)fileText, codeFragmentImports, (PsiElement)contextElement);
                break;
            }
            case 3: {
                ktCodeFragment = (KtCodeFragment)new KtTypeCodeFragment(project, fileName, (CharSequence)fileText, (PsiElement)contextElement);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KtCodeFragment codeFragment = ktCodeFragment;
        KtDanglingFileModuleImpl module = new KtDanglingFileModuleImpl((KtFile)codeFragment, contextModule.getKtModule(), DanglingFileResolutionMode.PREFER_SELF);
        return new KtModuleWithFiles((KtModule)module, CollectionsKt.listOf((Object)codeFragment));
    }

    /*
     * WARNING - void declaration
     */
    private final KtElement findContextElement(KtFile file, TestServices testServices) {
        KtElement ktElement;
        Integer n = ExpressionMarkersSourceFilePreprocessorKt.getExpressionMarkerProvider(testServices).getCaretPositionOrNull((PsiFile)file, "context");
        if (n == null) {
            return null;
        }
        int offset = n;
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement != null) {
            void $this$getParentOfType$iv;
            PsiElement psiElement2 = psiElement;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            ktElement = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtElement.class, (boolean)strict$iv);
        } else {
            ktElement = null;
        }
        return ktElement;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CodeFragmentKind.values().length];
            try {
                nArray[CodeFragmentKind.EXPRESSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentKind.BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentKind.TYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

