/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler;", "Lorg/jetbrains/kotlin/test/services/TestService;", "<init>", "()V", "compileTestModuleToLibrary", "Ljava/nio/file/Path;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "compile", "tmpDir", "compileTestModuleToLibrarySources", "Directives", "analysis-test-framework_test"})
public abstract class TestModuleCompiler
implements TestService {
    @NotNull
    public final Path compileTestModuleToLibrary(@NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Path tmpDir = KtTestUtil.tmpDir((String)"testSourcesToCompile").toPath();
        for (TestFile testFile : module.getFiles()) {
            Path tmpSourceFile;
            String text2 = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile(testFile);
            Intrinsics.checkNotNull((Object)tmpDir);
            Path path = tmpDir.resolve(testFile.getName());
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
            PathsKt.writeText$default((Path)tmpSourceFile, (CharSequence)text2, null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
        Intrinsics.checkNotNull((Object)tmpDir);
        return this.compile(tmpDir, module, testServices);
    }

    @NotNull
    public abstract Path compile(@NotNull Path var1, @NotNull TestModule var2, @NotNull TestServices var3);

    @Nullable
    public abstract Path compileTestModuleToLibrarySources(@NotNull TestModule var1, @NotNull TestServices var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/TestModuleCompiler$Directives;", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirectivesContainer;", "<init>", "()V", "COMPILER_ARGUMENTS", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "getCOMPILER_ARGUMENTS", "()Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "COMPILER_ARGUMENTS$delegate", "Lkotlin/properties/ReadOnlyProperty;", "COMPILATION_ERRORS", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "getCOMPILATION_ERRORS", "()Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "COMPILATION_ERRORS$delegate", "analysis-test-framework_test"})
    public static final class Directives
    extends SimpleDirectivesContainer {
        @NotNull
        public static final Directives INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final ReadOnlyProperty COMPILER_ARGUMENTS$delegate;
        @NotNull
        private static final ReadOnlyProperty COMPILATION_ERRORS$delegate;

        private Directives() {
        }

        @NotNull
        public final StringDirective getCOMPILER_ARGUMENTS() {
            return (StringDirective)COMPILER_ARGUMENTS$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        @NotNull
        public final SimpleDirective getCOMPILATION_ERRORS() {
            return (SimpleDirective)COMPILATION_ERRORS$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Directives.class), "COMPILER_ARGUMENTS", "getCOMPILER_ARGUMENTS()Lorg/jetbrains/kotlin/test/directives/model/StringDirective;"))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Directives.class), "COMPILATION_ERRORS", "getCOMPILATION_ERRORS()Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;")))};
            $$delegatedProperties = kPropertyArray;
            INSTANCE = new Directives();
            COMPILER_ARGUMENTS$delegate = SimpleDirectivesContainer.stringDirective$default((SimpleDirectivesContainer)INSTANCE, (String)"List of additional compiler arguments", null, (boolean)false, (int)6, null).provideDelegate((SimpleDirectivesContainer)INSTANCE, $$delegatedProperties[0]);
            COMPILATION_ERRORS$delegate = SimpleDirectivesContainer.directive$default((SimpleDirectivesContainer)INSTANCE, (String)"Is compilation errors expected in the file", null, (int)2, null).provideDelegate((SimpleDirectivesContainer)INSTANCE, $$delegatedProperties[1]);
        }
    }
}

