/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.KtBinaryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModuleUtilsKt;
import org.jetbrains.kotlin.analysis.project.structure.KtSdkModule;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProvider;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtJdkModuleImpl;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.LibraryByRoots;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.test.TestSetupUtilsKt;
import org.jetbrains.kotlin.test.frontend.fir.TestFirNativeSessionFactoryKt;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0007H\u0002J\n\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u001c\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00072\f\u00108\u001a\b\u0012\u0004\u0012\u0002090\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b!\u0010\u0012R'\u0010(\u001a\b\u0012\u0004\u0012\u00020 0\u00078FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b,\u0010#\u0012\u0004\b)\u0010*\u001a\u0004\b+\u0010\u0012R!\u0010-\u001a\b\u0012\u0004\u0012\u00020 0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010#\u001a\u0004\b.\u0010\u0012R!\u00100\u001a\b\u0012\u0004\u0012\u00020 0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010#\u001a\u0004\b1\u0010\u0012R\u0012\u00103\u001a\u00020 X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u0010:\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0011\u0010B\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtModuleByCompilerConfiguration;", "", "project", "Lcom/intellij/openapi/project/Project;", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "psiFiles", "", "Lcom/intellij/psi/PsiFile;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/test/model/TestModule;Ljava/util/List;Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTestModule", "()Lorg/jetbrains/kotlin/test/model/TestModule;", "getPsiFiles", "()Ljava/util/List;", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "moduleProvider", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/AnalysisApiKtModuleProvider;", "compilerConfigurationProvider", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "moduleName", "", "getModuleName", "()Ljava/lang/String;", "directRegularDependencies", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getDirectRegularDependencies", "directRegularDependencies$delegate", "Lkotlin/Lazy;", "computeLibraryDependencies", "Lorg/jetbrains/kotlin/analysis/project/structure/KtBinaryModule;", "createJdkFromConfiguration", "Lorg/jetbrains/kotlin/analysis/project/structure/KtSdkModule;", "directDependsOnDependencies", "getDirectDependsOnDependencies$annotations", "()V", "getDirectDependsOnDependencies", "directDependsOnDependencies$delegate", "transitiveDependsOnDependencies", "getTransitiveDependsOnDependencies", "transitiveDependsOnDependencies$delegate", "directFriendDependencies", "getDirectFriendDependencies", "directFriendDependencies$delegate", "ktModule", "getKtModule", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "librariesByRoots", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/LibraryByRoots;", "roots", "Ljava/nio/file/Path;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nKtSourceModuleByCompilerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtSourceModuleByCompilerConfiguration.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/KtModuleByCompilerConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n1547#2:206\n1618#2,3:207\n1547#2:210\n1618#2,3:211\n1547#2:214\n1618#2,3:215\n1547#2:218\n1618#2,3:219\n*S KotlinDebug\n*F\n+ 1 KtSourceModuleByCompilerConfiguration.kt\norg/jetbrains/kotlin/analysis/test/framework/project/structure/KtModuleByCompilerConfiguration\n*L\n59#1:206\n59#1:207,3\n63#1:210\n63#1:211,3\n64#1:214\n64#1:215,3\n107#1:218\n107#1:219,3\n*E\n"})
public abstract class KtModuleByCompilerConfiguration {
    @NotNull
    private final Project project;
    @NotNull
    private final TestModule testModule;
    @NotNull
    private final List<PsiFile> psiFiles;
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final AnalysisApiKtModuleProvider moduleProvider;
    @NotNull
    private final CompilerConfigurationProvider compilerConfigurationProvider;
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final Lazy directRegularDependencies$delegate;
    @NotNull
    private final Lazy directDependsOnDependencies$delegate;
    @NotNull
    private final Lazy transitiveDependsOnDependencies$delegate;
    @NotNull
    private final Lazy directFriendDependencies$delegate;

    public KtModuleByCompilerConfiguration(@NotNull Project project, @NotNull TestModule testModule, @NotNull List<? extends PsiFile> psiFiles, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter(psiFiles, (String)"psiFiles");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.project = project;
        this.testModule = testModule;
        this.psiFiles = psiFiles;
        this.testServices = testServices;
        this.moduleProvider = AnalysisApiKtModuleProviderImplKt.getKtModuleProvider(this.testServices);
        this.compilerConfigurationProvider = CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)this.testServices);
        this.configuration = this.compilerConfigurationProvider.getCompilerConfiguration(this.testModule);
        this.directRegularDependencies$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<List<? extends KtModule>>(this){
            final /* synthetic */ KtModuleByCompilerConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final List<KtModule> invoke() {
                List list;
                KtModuleByCompilerConfiguration ktModuleByCompilerConfiguration = this.this$0;
                List $this$invoke_u24lambda_u241 = list = kotlin.collections.CollectionsKt.createListBuilder();
                boolean bl = false;
                Iterable $this$mapTo$iv = ktModuleByCompilerConfiguration.getTestModule().getAllDependencies();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    DependencyDescription dependencyDescription = (DependencyDescription)item$iv;
                    Collection collection = $this$invoke_u24lambda_u241;
                    boolean bl2 = false;
                    collection.add(KtModuleByCompilerConfiguration.access$getModuleProvider$p(ktModuleByCompilerConfiguration).getModule(it.getModuleName()));
                }
                Collection cfr_ignored_0 = (Collection)$this$invoke_u24lambda_u241;
                $this$invoke_u24lambda_u241.addAll(KtModuleByCompilerConfiguration.access$computeLibraryDependencies(ktModuleByCompilerConfiguration));
                return kotlin.collections.CollectionsKt.build((List)list);
            }
        }));
        this.directDependsOnDependencies$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<List<? extends KtModule>>(this){
            final /* synthetic */ KtModuleByCompilerConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final List<KtModule> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.this$0.getTestModule().getDependsOnDependencies();
                KtModuleByCompilerConfiguration ktModuleByCompilerConfiguration = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(KtModuleByCompilerConfiguration.access$getModuleProvider$p(ktModuleByCompilerConfiguration).getModule(it.getModuleName()));
                }
                return (List)destination$iv$iv;
            }
        }));
        this.transitiveDependsOnDependencies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends KtModule>>(this){
            final /* synthetic */ KtModuleByCompilerConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<KtModule> invoke() {
                return KtModuleUtilsKt.computeTransitiveDependsOnDependencies(this.this$0.getDirectDependsOnDependencies());
            }
        }));
        this.directFriendDependencies$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<List<? extends KtModule>>(this){
            final /* synthetic */ KtModuleByCompilerConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final List<KtModule> invoke() {
                Collection<Path> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Collection collection2;
                List list;
                KtModuleByCompilerConfiguration ktModuleByCompilerConfiguration = this.this$0;
                List $this$invoke_u24lambda_u241 = list = kotlin.collections.CollectionsKt.createListBuilder();
                boolean bl = false;
                Iterable $this$mapTo$iv = ktModuleByCompilerConfiguration.getTestModule().getFriendDependencies();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    DependencyDescription dependencyDescription = (DependencyDescription)item$iv;
                    collection2 = $this$invoke_u24lambda_u241;
                    boolean bl2 = false;
                    collection2.add(KtModuleByCompilerConfiguration.access$getModuleProvider$p(ktModuleByCompilerConfiguration).getModule(it.getModuleName()));
                }
                Collection cfr_ignored_0 = (Collection)$this$invoke_u24lambda_u241;
                List list2 = (List)KtModuleByCompilerConfiguration.access$getConfiguration$p(ktModuleByCompilerConfiguration).get(JVMConfigurationKeys.FRIEND_PATHS);
                if (list2 == null) {
                    list2 = kotlin.collections.CollectionsKt.emptyList();
                }
                $this$mapTo$iv = list2;
                KtModuleByCompilerConfiguration ktModuleByCompilerConfiguration2 = ktModuleByCompilerConfiguration;
                collection2 = $this$invoke_u24lambda_u241;
                boolean $i$f$map = false;
                Iterator<T> iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(Paths.get((String)p0, new String[0]));
                }
                collection = (List)destination$iv$iv;
                collection2.addAll(KtModuleByCompilerConfiguration.access$librariesByRoots(ktModuleByCompilerConfiguration2, (List)collection));
                return kotlin.collections.CollectionsKt.build((List)list);
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TestModule getTestModule() {
        return this.testModule;
    }

    @NotNull
    public final List<PsiFile> getPsiFiles() {
        return this.psiFiles;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @NotNull
    public final String getModuleName() {
        return this.testModule.getName();
    }

    @NotNull
    public final List<KtModule> getDirectRegularDependencies() {
        Lazy lazy = this.directRegularDependencies$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtBinaryModule> computeLibraryDependencies() {
        List list;
        TargetPlatform targetPlatform = this.testModule.getTargetPlatform();
        if (NativePlatformKt.isNative((TargetPlatform)targetPlatform)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = TestFirNativeSessionFactoryKt.getAllNativeDependenciesPaths((TestModule)this.testModule, (TestServices)this.testServices);
            KtModuleByCompilerConfiguration ktModuleByCompilerConfiguration = this;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Paths.get((String)it, new String[0]));
            }
            list = ktModuleByCompilerConfiguration.librariesByRoots((List)destination$iv$iv);
        } else {
            File p0;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            List list2;
            List list3;
            List $this$computeLibraryDependencies_u24lambda_u243 = list3 = kotlin.collections.CollectionsKt.createListBuilder();
            boolean bl = false;
            List $this$computeLibraryDependencies_u24lambda_u243_u24lambda_u242 = list2 = kotlin.collections.CollectionsKt.createListBuilder();
            boolean bl2 = false;
            Iterable item$iv$iv = JvmContentRootsKt.getJvmModularRoots((CompilerConfiguration)this.configuration);
            List list4 = $this$computeLibraryDependencies_u24lambda_u243_u24lambda_u242;
            boolean $i$f$map = false;
            void var11_22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                File file = (File)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(p0.toPath());
            }
            list4.addAll((List)destination$iv$iv);
            $this$map$iv = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)this.configuration);
            list4 = $this$computeLibraryDependencies_u24lambda_u243_u24lambda_u242;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                p0 = (File)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(p0.toPath());
            }
            list4.addAll((List)destination$iv$iv);
            List roots = kotlin.collections.CollectionsKt.build((List)list2);
            $this$computeLibraryDependencies_u24lambda_u243.addAll((Collection)this.librariesByRoots(roots));
            CollectionsKt.addIfNotNull((Collection)$this$computeLibraryDependencies_u24lambda_u243, (Object)this.createJdkFromConfiguration());
            list = kotlin.collections.CollectionsKt.build((List)list3);
        }
        return list;
    }

    private final KtSdkModule createJdkFromConfiguration() {
        KtJdkModuleImpl ktJdkModuleImpl;
        File file = (File)this.configuration.get(JVMConfigurationKeys.JDK_HOME);
        if (file != null) {
            File jdkHome = file;
            boolean bl = false;
            List jdkHomePaths = StandaloneProjectFactory.INSTANCE.getDefaultJdkModulePaths(this.project, jdkHome.toPath());
            GlobalSearchScope scope = StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots((Collection)jdkHomePaths, AnalysisApiEnvironmentManagerKt.getEnvironmentManager(this.testServices).getProjectEnvironment());
            ktJdkModuleImpl = new KtJdkModuleImpl("jdk", JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), scope, this.project, jdkHomePaths);
        } else {
            ktJdkModuleImpl = null;
        }
        return ktJdkModuleImpl;
    }

    @NotNull
    public final List<KtModule> getDirectDependsOnDependencies() {
        Lazy lazy = this.directDependsOnDependencies$delegate;
        return (List)lazy.getValue();
    }

    public static /* synthetic */ void getDirectDependsOnDependencies$annotations() {
    }

    @NotNull
    public final List<KtModule> getTransitiveDependsOnDependencies() {
        Lazy lazy = this.transitiveDependsOnDependencies$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<KtModule> getDirectFriendDependencies() {
        Lazy lazy = this.directFriendDependencies$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    protected abstract KtModule getKtModule();

    /*
     * WARNING - void declaration
     */
    private final List<LibraryByRoots> librariesByRoots(List<? extends Path> roots) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = roots;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LibraryByRoots(kotlin.collections.CollectionsKt.listOf((Object)it), this.getKtModule(), this.project, this.testServices));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.testModule.getLanguageVersionSettings();
    }

    @NotNull
    public final TargetPlatform getPlatform() {
        return this.testModule.getTargetPlatform();
    }

    @NotNull
    public final PlatformDependentAnalyzerServices getAnalyzerServices() {
        return TestSetupUtilsKt.getAnalyzerServices((TargetPlatform)this.testModule.getTargetPlatform());
    }

    public static final /* synthetic */ AnalysisApiKtModuleProvider access$getModuleProvider$p(KtModuleByCompilerConfiguration $this) {
        return $this.moduleProvider;
    }

    public static final /* synthetic */ List access$computeLibraryDependencies(KtModuleByCompilerConfiguration $this) {
        return $this.computeLibraryDependencies();
    }

    public static final /* synthetic */ List access$librariesByRoots(KtModuleByCompilerConfiguration $this, List roots) {
        return $this.librariesByRoots(roots);
    }

    public static final /* synthetic */ CompilerConfiguration access$getConfiguration$p(KtModuleByCompilerConfiguration $this) {
        return $this.configuration;
    }
}

