/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleProjectStructure;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleWithFiles;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProvider;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/AnalysisApiKtModuleProviderImpl;", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/AnalysisApiKtModuleProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "modulesStructure", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleProjectStructure;", "modulesByName", "", "", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleWithFiles;", "getModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "moduleName", "getModuleFiles", "", "Lcom/intellij/psi/PsiFile;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "registerProjectStructure", "", "modules", "getModuleStructure", "analysis-test-framework_test"})
public final class AnalysisApiKtModuleProviderImpl
extends AnalysisApiKtModuleProvider {
    @NotNull
    private final TestServices testServices;
    private KtModuleProjectStructure modulesStructure;
    private Map<String, KtModuleWithFiles> modulesByName;

    public AnalysisApiKtModuleProviderImpl(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.testServices = testServices;
    }

    @Override
    @NotNull
    protected TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public KtModule getModule(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Map<String, KtModuleWithFiles> map = this.modulesByName;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modulesByName");
            map = null;
        }
        return ((KtModuleWithFiles)MapsKt.getValue(map, (Object)moduleName)).getKtModule();
    }

    @Override
    @NotNull
    public List<PsiFile> getModuleFiles(@NotNull TestModule module) {
        KtModuleWithFiles ktModuleWithFiles;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<String, KtModuleWithFiles> map = this.modulesByName;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modulesByName");
            map = null;
        }
        if ((ktModuleWithFiles = map.get(module.getName())) == null) {
            Map<String, KtModuleWithFiles> map2 = this.modulesByName;
            if (map2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"modulesByName");
                map2 = null;
            }
            ktModuleWithFiles = (KtModuleWithFiles)MapsKt.getValue(map2, (Object)((TestFile)CollectionsKt.single((List)module.getFiles())).getName());
        }
        return ktModuleWithFiles.getFiles();
    }

    @Override
    public void registerProjectStructure(@NotNull KtModuleProjectStructure modules) {
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        if (!(this.modulesStructure == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.modulesByName == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.modulesStructure = modules;
        KtModuleProjectStructure ktModuleProjectStructure = this.modulesStructure;
        if (ktModuleProjectStructure == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modulesStructure");
            ktModuleProjectStructure = null;
        }
        this.modulesByName = AnalysisApiKtModuleProviderImplKt.associateByName(ktModuleProjectStructure.getMainModules());
    }

    @Override
    @NotNull
    public KtModuleProjectStructure getModuleStructure() {
        KtModuleProjectStructure ktModuleProjectStructure = this.modulesStructure;
        if (ktModuleProjectStructure == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modulesStructure");
            ktModuleProjectStructure = null;
        }
        return ktModuleProjectStructure;
    }
}

