/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FileTreeWalk;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.LibraryWasNotCompiledDueToExpectedCompilationError;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.test.MockLibraryUtil;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor;", "", "<init>", "()V", "compileLibrary", "Ljava/nio/file/Path;", "sourcesPath", "options", "", "", "compilationErrorExpected", "", "parseCompilerOptionsFromTestdata", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Directives", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nCompilerExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerExecutor.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,83:1\n1155#2,3:84\n*S KotlinDebug\n*F\n+ 1 CompilerExecutor.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor\n*L\n27#1:84,3\n*E\n"})
public final class CompilerExecutor {
    @NotNull
    public static final CompilerExecutor INSTANCE = new CompilerExecutor();

    private CompilerExecutor() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path compileLibrary(@NotNull Path sourcesPath, @NotNull List<String> options, boolean compilationErrorExpected) {
        Path library;
        block5: {
            List list;
            Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
            Intrinsics.checkNotNullParameter(options, (String)"options");
            Path path = sourcesPath.resolve("library.jar");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            library = path;
            File file = sourcesPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FileTreeWalk sourceFiles = FilesKt.walkBottomUp((File)file);
            List $this$compileLibrary_u24lambda_u241 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            Sequence $this$mapTo$iv = (Sequence)sourceFiles;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                File file2 = (File)item$iv;
                Collection collection = $this$compileLibrary_u24lambda_u241;
                boolean bl2 = false;
                collection.add(it.getAbsolutePath());
            }
            $this$compileLibrary_u24lambda_u241.addAll((Collection)options);
            $this$compileLibrary_u24lambda_u241.add("-d");
            $this$compileLibrary_u24lambda_u241.add(((Object)library.toAbsolutePath()).toString());
            $this$compileLibrary_u24lambda_u241.add("-XXLanguage:-SkipStandaloneScriptsInSourceRoots");
            List commands = CollectionsKt.build((List)list);
            try {
                MockLibraryUtil.INSTANCE.runJvmCompiler(commands);
            }
            catch (Throwable e) {
                if (compilationErrorExpected) break block5;
                throw new IllegalStateException("Unexpected compilation error while compiling library", e);
            }
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(library, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && compilationErrorExpected) {
            throw new IllegalStateException("Compilation error expected but, code was compiled successfully".toString());
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.notExists(library, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            throw new LibraryWasNotCompiledDueToExpectedCompilationError();
        }
        return library;
    }

    @NotNull
    public final List<String> parseCompilerOptionsFromTestdata(@NotNull TestModule module) {
        Object[] objectArray;
        List list;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List $this$parseCompilerOptionsFromTestdata_u24lambda_u245 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ApiVersion apiVersion = (ApiVersion)CollectionsKt.firstOrNull((List)module.getDirectives().get(LanguageSettingsDirectives.INSTANCE.getAPI_VERSION()));
        if (apiVersion != null) {
            ApiVersion apiVersion2 = apiVersion;
            boolean bl2 = false;
            objectArray = new String[]{"-api-version", apiVersion2.getVersionString()};
            $this$parseCompilerOptionsFromTestdata_u24lambda_u245.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        String string = (String)CollectionsKt.firstOrNull((List)module.getDirectives().get(LanguageSettingsDirectives.INSTANCE.getLANGUAGE()));
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            $this$parseCompilerOptionsFromTestdata_u24lambda_u245.add("-XXLanguage:" + it);
        }
        JvmTarget jvmTarget = (JvmTarget)CollectionsKt.firstOrNull((List)module.getDirectives().get(JvmEnvironmentConfigurationDirectives.INSTANCE.getJVM_TARGET()));
        if (jvmTarget != null) {
            File file;
            JvmTarget jvmTarget2 = jvmTarget;
            boolean bl4 = false;
            objectArray = new String[]{"-jvm-target", jvmTarget2.getDescription()};
            $this$parseCompilerOptionsFromTestdata_u24lambda_u245.addAll(CollectionsKt.listOf((Object[])objectArray));
            if (jvmTarget2.compareTo((Enum)JvmTarget.JVM_1_8) <= 0) {
                file = KtTestUtil.getJdk8Home();
            } else if (jvmTarget2.compareTo((Enum)JvmTarget.JVM_11) <= 0) {
                file = KtTestUtil.getJdk11Home();
            } else if (jvmTarget2.compareTo((Enum)JvmTarget.JVM_17) <= 0) {
                file = KtTestUtil.getJdk17Home();
            } else if (jvmTarget2.compareTo((Enum)JvmTarget.JVM_21) <= 0) {
                file = KtTestUtil.getJdk21Home();
            } else {
                throw new IllegalStateException(("JDK for " + jvmTarget2 + " is not found").toString());
            }
            File jdkHome = file;
            Object[] objectArray2 = new String[]{"-jdk-home", jdkHome.toString()};
            $this$parseCompilerOptionsFromTestdata_u24lambda_u245.addAll(CollectionsKt.listOf((Object[])objectArray2));
        }
        $this$parseCompilerOptionsFromTestdata_u24lambda_u245.addAll(module.getDirectives().get(Directives.INSTANCE.getCOMPILER_ARGUMENTS()));
        return CollectionsKt.build((List)list);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor$Directives;", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirectivesContainer;", "<init>", "()V", "COMPILER_ARGUMENTS", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "getCOMPILER_ARGUMENTS", "()Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "COMPILER_ARGUMENTS$delegate", "Lkotlin/properties/ReadOnlyProperty;", "COMPILATION_ERRORS", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "getCOMPILATION_ERRORS", "()Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "COMPILATION_ERRORS$delegate", "analysis-test-framework_test"})
    public static final class Directives
    extends SimpleDirectivesContainer {
        @NotNull
        public static final Directives INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final ReadOnlyProperty COMPILER_ARGUMENTS$delegate;
        @NotNull
        private static final ReadOnlyProperty COMPILATION_ERRORS$delegate;

        private Directives() {
        }

        @NotNull
        public final StringDirective getCOMPILER_ARGUMENTS() {
            return (StringDirective)COMPILER_ARGUMENTS$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        @NotNull
        public final SimpleDirective getCOMPILATION_ERRORS() {
            return (SimpleDirective)COMPILATION_ERRORS$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Directives.class), "COMPILER_ARGUMENTS", "getCOMPILER_ARGUMENTS()Lorg/jetbrains/kotlin/test/directives/model/StringDirective;"))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Directives.class), "COMPILATION_ERRORS", "getCOMPILATION_ERRORS()Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;")))};
            $$delegatedProperties = kPropertyArray;
            INSTANCE = new Directives();
            COMPILER_ARGUMENTS$delegate = SimpleDirectivesContainer.stringDirective$default((SimpleDirectivesContainer)INSTANCE, (String)"List of additional compiler arguments", null, (boolean)false, (int)6, null).provideDelegate((SimpleDirectivesContainer)INSTANCE, $$delegatedProperties[0]);
            COMPILATION_ERRORS$delegate = SimpleDirectivesContainer.directive$default((SimpleDirectivesContainer)INSTANCE, (String)"Is compilation errors expected in the file", null, (int)2, null).provideDelegate((SimpleDirectivesContainer)INSTANCE, $$delegatedProperties[1]);
        }
    }
}

