/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractFirSourceLazyDeclarationResolveTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve")
@TestDataPath(value="$PROJECT_ROOT")
public class FirSourceLazyDeclarationResolveTestGenerated
extends AbstractFirSourceLazyDeclarationResolveTest {
    @Test
    public void testAllFilesPresentInLazyResolve() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
    }

    @Test
    @TestMetadata(value="annotationArgumentsMix.kt")
    public void testAnnotationArgumentsMix() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationArgumentsMix.kt");
    }

    @Test
    @TestMetadata(value="annotationClassWithJavaTarget.kt")
    public void testAnnotationClassWithJavaTarget() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationClassWithJavaTarget.kt");
    }

    @Test
    @TestMetadata(value="annotationFromImplicitJavaType.kt")
    public void testAnnotationFromImplicitJavaType() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationFromImplicitJavaType.kt");
    }

    @Test
    @TestMetadata(value="annotationFromImplicitJavaTypeWithJavaAnnotation.kt")
    public void testAnnotationFromImplicitJavaTypeWithJavaAnnotation() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationFromImplicitJavaTypeWithJavaAnnotation.kt");
    }

    @Test
    @TestMetadata(value="annotationInsideWhereFunction.kt")
    public void testAnnotationInsideWhereFunction() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationInsideWhereFunction.kt");
    }

    @Test
    @TestMetadata(value="annotationInsideWhereProperty.kt")
    public void testAnnotationInsideWhereProperty() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationInsideWhereProperty.kt");
    }

    @Test
    @TestMetadata(value="annotationOnLocalClass.kt")
    public void testAnnotationOnLocalClass() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationOnLocalClass.kt");
    }

    @Test
    @TestMetadata(value="annotationParameters.kt")
    public void testAnnotationParameters() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationParameters.kt");
    }

    @Test
    @TestMetadata(value="annotationWithTypeArgument.kt")
    public void testAnnotationWithTypeArgument() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotationWithTypeArgument.kt");
    }

    @Test
    @TestMetadata(value="annotations.kt")
    public void testAnnotations() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/annotations.kt");
    }

    @Test
    @TestMetadata(value="anonymousFunctionWithAnnotatedParameter.kt")
    public void testAnonymousFunctionWithAnnotatedParameter() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameter.kt");
    }

    @Test
    @TestMetadata(value="anonymousFunctionWithAnnotatedParameter2.kt")
    public void testAnonymousFunctionWithAnnotatedParameter2() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameter2.kt");
    }

    @Test
    @TestMetadata(value="anonymousFunctionWithAnnotatedParameterOnImplicitTypePhase.kt")
    public void testAnonymousFunctionWithAnnotatedParameterOnImplicitTypePhase() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/anonymousFunctionWithAnnotatedParameterOnImplicitTypePhase.kt");
    }

    @Test
    @TestMetadata(value="classMembers.kt")
    public void testClassMembers() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classMembers.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationOnLocalClass.kt")
    public void testCompilerRequiredAnnotationOnLocalClass() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationOnLocalClass.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnConstructor.kt")
    public void testCompilerRequiredAnnotationsOnConstructor() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnConstructor.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnConstructorProperty.kt")
    public void testCompilerRequiredAnnotationsOnConstructorProperty() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnConstructorProperty.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnFunction.kt")
    public void testCompilerRequiredAnnotationsOnFunction() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnFunction.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnProperty.kt")
    public void testCompilerRequiredAnnotationsOnProperty() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnProperty.kt");
    }

    @Test
    @TestMetadata(value="compilerRequiredAnnotationsOnPropertyDelegate.kt")
    public void testCompilerRequiredAnnotationsOnPropertyDelegate() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/compilerRequiredAnnotationsOnPropertyDelegate.kt");
    }

    @Test
    @TestMetadata(value="complexLocalHierarchy.kt")
    public void testComplexLocalHierarchy() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/complexLocalHierarchy.kt");
    }

    @Test
    @TestMetadata(value="complexRedeclaration.kt")
    public void testComplexRedeclaration() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/complexRedeclaration.kt");
    }

    @Test
    @TestMetadata(value="cyclicHierarchy.kt")
    public void testCyclicHierarchy() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchy.kt");
    }

    @Test
    @TestMetadata(value="cyclicHierarchy2.kt")
    public void testCyclicHierarchy2() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchy2.kt");
    }

    @Test
    @TestMetadata(value="cyclicHierarchy3.kt")
    public void testCyclicHierarchy3() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicHierarchy3.kt");
    }

    @Test
    @TestMetadata(value="cyclicNestedHierarchy.kt")
    public void testCyclicNestedHierarchy() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicNestedHierarchy.kt");
    }

    @Test
    @TestMetadata(value="cyclicNestedHierarchy2.kt")
    public void testCyclicNestedHierarchy2() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/cyclicNestedHierarchy2.kt");
    }

    @Test
    @TestMetadata(value="dataClassCopy.kt")
    public void testDataClassCopy() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/dataClassCopy.kt");
    }

    @Test
    @TestMetadata(value="dataComponent2.kt")
    public void testDataComponent2() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/dataComponent2.kt");
    }

    @Test
    @TestMetadata(value="delegateWithImplicitType.kt")
    public void testDelegateWithImplicitType() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegateWithImplicitType.kt");
    }

    @Test
    @TestMetadata(value="delegateWithImplicitTypeInDifferentModules.kt")
    public void testDelegateWithImplicitTypeInDifferentModules() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegateWithImplicitTypeInDifferentModules.kt");
    }

    @Test
    @TestMetadata(value="delegatedField.kt")
    public void testDelegatedField() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegatedField.kt");
    }

    @Test
    @TestMetadata(value="delegates.kt")
    public void testDelegates() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/delegates.kt");
    }

    @Test
    @TestMetadata(value="enumEntries.kt")
    public void testEnumEntries() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumEntries.kt");
    }

    @Test
    @TestMetadata(value="enumEntry.kt")
    public void testEnumEntry() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumEntry.kt");
    }

    @Test
    @TestMetadata(value="enumValueOf.kt")
    public void testEnumValueOf() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumValueOf.kt");
    }

    @Test
    @TestMetadata(value="enumValues.kt")
    public void testEnumValues() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/enumValues.kt");
    }

    @Test
    @TestMetadata(value="expectClass.kt")
    public void testExpectClass() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/expectClass.kt");
    }

    @Test
    @TestMetadata(value="fakeOverride.kt")
    public void testFakeOverride() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fakeOverride.kt");
    }

    @Test
    @TestMetadata(value="fakePrimaryConstructor.kt")
    public void testFakePrimaryConstructor() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fakePrimaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="fileAnnotations.kt")
    public void testFileAnnotations() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fileAnnotations.kt");
    }

    @Test
    @TestMetadata(value="fileElements.kt")
    public void testFileElements() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fileElements.kt");
    }

    @Test
    @TestMetadata(value="fromLocalHierarchyToOuter.kt")
    public void testFromLocalHierarchyToOuter() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/fromLocalHierarchyToOuter.kt");
    }

    @Test
    @TestMetadata(value="functionWithImplicitTypeAndAnnotations.kt")
    public void testFunctionWithImplicitTypeAndAnnotations() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithImplicitTypeAndAnnotations.kt");
    }

    @Test
    @TestMetadata(value="functionWithImplicitTypeAndStringTemplateAsDefaultValue.kt")
    public void testFunctionWithImplicitTypeAndStringTemplateAsDefaultValue() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithImplicitTypeAndStringTemplateAsDefaultValue.kt");
    }

    @Test
    @TestMetadata(value="functionWithParameter.kt")
    public void testFunctionWithParameter() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithParameter.kt");
    }

    @Test
    @TestMetadata(value="functionWithWhere.kt")
    public void testFunctionWithWhere() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functionWithWhere.kt");
    }

    @Test
    @TestMetadata(value="implicitTypeOnFunctionWithRawContract.kt")
    public void testImplicitTypeOnFunctionWithRawContract() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitTypeOnFunctionWithRawContract.kt");
    }

    @Test
    @TestMetadata(value="implicitTypeOnFunctionWithUnresolvedRawContract.kt")
    public void testImplicitTypeOnFunctionWithUnresolvedRawContract() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitTypeOnFunctionWithUnresolvedRawContract.kt");
    }

    @Test
    @TestMetadata(value="implicitTypeOnFunctionWithWrongRawContract.kt")
    public void testImplicitTypeOnFunctionWithWrongRawContract() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/implicitTypeOnFunctionWithWrongRawContract.kt");
    }

    @Test
    @TestMetadata(value="lambdaAsSAMInterface.kt")
    public void testLambdaAsSAMInterface() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/lambdaAsSAMInterface.kt");
    }

    @Test
    @TestMetadata(value="lazyProperty.kt")
    public void testLazyProperty() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/lazyProperty.kt");
    }

    @Test
    @TestMetadata(value="localConstructor.kt")
    public void testLocalConstructor() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localConstructor.kt");
    }

    @Test
    @TestMetadata(value="localFunctionInsideAnnotationCall.kt")
    public void testLocalFunctionInsideAnnotationCall() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideAnnotationCall.kt");
    }

    @Test
    @TestMetadata(value="localFunctionInsideFunctionLiteral.kt")
    public void testLocalFunctionInsideFunctionLiteral() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideFunctionLiteral.kt");
    }

    @Test
    @TestMetadata(value="localFunctionInsideLambdaCallInsideStringTemplate.kt")
    public void testLocalFunctionInsideLambdaCallInsideStringTemplate() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideLambdaCallInsideStringTemplate.kt");
    }

    @Test
    @TestMetadata(value="localFunctionInsideStringTemplate.kt")
    public void testLocalFunctionInsideStringTemplate() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideStringTemplate.kt");
    }

    @Test
    @TestMetadata(value="localFunctionInsideSuperEntryCall.kt")
    public void testLocalFunctionInsideSuperEntryCall() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localFunctionInsideSuperEntryCall.kt");
    }

    @Test
    @TestMetadata(value="localNestedClass.kt")
    public void testLocalNestedClass() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localNestedClass.kt");
    }

    @Test
    @TestMetadata(value="localParameterInsideSuperEntryCall.kt")
    public void testLocalParameterInsideSuperEntryCall() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/localParameterInsideSuperEntryCall.kt");
    }

    @Test
    @TestMetadata(value="nestedCompilerRequiredAnnotations.kt")
    public void testNestedCompilerRequiredAnnotations() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotations.kt");
    }

    @Test
    @TestMetadata(value="nestedCompilerRequiredAnnotationsForMember.kt")
    public void testNestedCompilerRequiredAnnotationsForMember() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotationsForMember.kt");
    }

    @Test
    @TestMetadata(value="nestedCompilerRequiredAnnotationsInsideBody.kt")
    public void testNestedCompilerRequiredAnnotationsInsideBody() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedCompilerRequiredAnnotationsInsideBody.kt");
    }

    @Test
    @TestMetadata(value="nestedTypeAlias.kt")
    public void testNestedTypeAlias() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedTypeAlias.kt");
    }

    @Test
    @TestMetadata(value="nestedTypeAlias2.kt")
    public void testNestedTypeAlias2() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/nestedTypeAlias2.kt");
    }

    @Test
    @TestMetadata(value="parameterOfNonLocalSetter.kt")
    public void testParameterOfNonLocalSetter() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/parameterOfNonLocalSetter.kt");
    }

    @Test
    @TestMetadata(value="parameterOfTopSetter.kt")
    public void testParameterOfTopSetter() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/parameterOfTopSetter.kt");
    }

    @Test
    @TestMetadata(value="primaryConstructor.kt")
    public void testPrimaryConstructor() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="primaryConstructorParameter.kt")
    public void testPrimaryConstructorParameter() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructorParameter.kt");
    }

    @Test
    @TestMetadata(value="primaryConstructorProperty.kt")
    public void testPrimaryConstructorProperty() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/primaryConstructorProperty.kt");
    }

    @Test
    @TestMetadata(value="propertyWithGetter.kt")
    public void testPropertyWithGetter() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithGetter.kt");
    }

    @Test
    @TestMetadata(value="propertyWithGetterAndSetter.kt")
    public void testPropertyWithGetterAndSetter() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithGetterAndSetter.kt");
    }

    @Test
    @TestMetadata(value="propertyWithImplicitTypeAndAnnotations.kt")
    public void testPropertyWithImplicitTypeAndAnnotations() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithImplicitTypeAndAnnotations.kt");
    }

    @Test
    @TestMetadata(value="propertyWithImplicitTypeAndFieldAnnotations.kt")
    public void testPropertyWithImplicitTypeAndFieldAnnotations() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithImplicitTypeAndFieldAnnotations.kt");
    }

    @Test
    @TestMetadata(value="propertyWithInitializer.kt")
    public void testPropertyWithInitializer() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithInitializer.kt");
    }

    @Test
    @TestMetadata(value="propertyWithWhere.kt")
    public void testPropertyWithWhere() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/propertyWithWhere.kt");
    }

    @Test
    @TestMetadata(value="redeclaration.kt")
    public void testRedeclaration() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/redeclaration.kt");
    }

    @Test
    @TestMetadata(value="resolveSuperTypeFromLocalClass.kt")
    public void testResolveSuperTypeFromLocalClass() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveSuperTypeFromLocalClass.kt");
    }

    @Test
    @TestMetadata(value="resolveTypeFromLocalClassConstructor.kt")
    public void testResolveTypeFromLocalClassConstructor() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveTypeFromLocalClassConstructor.kt");
    }

    @Test
    @TestMetadata(value="resolveTypeFromLocalFunction.kt")
    public void testResolveTypeFromLocalFunction() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/resolveTypeFromLocalFunction.kt");
    }

    @Test
    @TestMetadata(value="secondaryConstructor.kt")
    public void testSecondaryConstructor() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/secondaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="secondaryConstructorParameter.kt")
    public void testSecondaryConstructorParameter() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/secondaryConstructorParameter.kt");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverride.kt")
    public void testSubstitutionFakeOverride() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverride.kt");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideInDifferentModules.kt")
    public void testSubstitutionFakeOverrideInDifferentModules() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideInDifferentModules.kt");
    }

    @Test
    @TestMetadata(value="substitutionFakeOverrideWithImplicitType.kt")
    public void testSubstitutionFakeOverrideWithImplicitType() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/substitutionFakeOverrideWithImplicitType.kt");
    }

    @Test
    @TestMetadata(value="superTypes.kt")
    public void testSuperTypes() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/superTypes.kt");
    }

    @Test
    @TestMetadata(value="superTypesLoop.kt")
    public void testSuperTypesLoop() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/superTypesLoop.kt");
    }

    @Test
    @TestMetadata(value="topLevelFunctions.kt")
    public void testTopLevelFunctions() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctions.kt");
    }

    @Test
    @TestMetadata(value="topLevelFunctionsWithExpressionBodyAndExplicitType.kt")
    public void testTopLevelFunctionsWithExpressionBodyAndExplicitType() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctionsWithExpressionBodyAndExplicitType.kt");
    }

    @Test
    @TestMetadata(value="topLevelFunctionsWithImplicitType.kt")
    public void testTopLevelFunctionsWithImplicitType() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/topLevelFunctionsWithImplicitType.kt");
    }

    @Test
    @TestMetadata(value="typeParameterBounds.kt")
    public void testTypeParameterBounds() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterBounds.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfClass.kt")
    public void testTypeParameterOfClass() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfClass.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfClass2.kt")
    public void testTypeParameterOfClass2() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfClass2.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfNonLocalFunction.kt")
    public void testTypeParameterOfNonLocalFunction() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfNonLocalFunction.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfTopFunction.kt")
    public void testTypeParameterOfTopFunction() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTopFunction.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfTopSetter.kt")
    public void testTypeParameterOfTopSetter() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTopSetter.kt");
    }

    @Test
    @TestMetadata(value="typeParameterOfTypeAlias.kt")
    public void testTypeParameterOfTypeAlias() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeParameterOfTypeAlias.kt");
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/typeAliases")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeAliases {
        @Test
        public void testAllFilesPresentInTypeAliases() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/typeAliases"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="typeAliasWithTypeParameters.kt")
        public void testTypeAliasWithTypeParameters() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/typeAliasWithTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="unresolvedAnnotationOnTypeAlias.kt")
        public void testUnresolvedAnnotationOnTypeAlias() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/typeAliases/unresolvedAnnotationOnTypeAlias.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SyntheticProperties {
        @Test
        public void testAllFilesPresentInSyntheticProperties() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="explicitReturnType.kt")
        public void testExplicitReturnType() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/explicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="explicitReturnTypeAndAnnotations.kt")
        public void testExplicitReturnTypeAndAnnotations() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/explicitReturnTypeAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="implicitReturnType.kt")
        public void testImplicitReturnType() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/implicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="implicitReturnTypeAndAnnotations.kt")
        public void testImplicitReturnTypeAndAnnotations() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/implicitReturnTypeAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="implicitReturnTypeAndAnnotationsAsGetter.kt")
        public void testImplicitReturnTypeAndAnnotationsAsGetter() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/implicitReturnTypeAndAnnotationsAsGetter.kt");
        }

        @Test
        @TestMetadata(value="secondGenerationOverride.kt")
        public void testSecondGenerationOverride() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/secondGenerationOverride.kt");
        }

        @Test
        @TestMetadata(value="setterAndExplicitReturnType.kt")
        public void testSetterAndExplicitReturnType() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnType.kt");
        }

        @Test
        @TestMetadata(value="setterAndExplicitReturnTypeAndAnnotations.kt")
        public void testSetterAndExplicitReturnTypeAndAnnotations() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnTypeAndAnnotations.kt");
        }

        @Test
        @TestMetadata(value="setterAndExplicitReturnTypeAndAnnotationsAsGetter.kt")
        public void testSetterAndExplicitReturnTypeAndAnnotationsAsGetter() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnTypeAndAnnotationsAsGetter.kt");
        }

        @Test
        @TestMetadata(value="setterAndExplicitReturnTypeAndAnnotationsAsSetter.kt")
        public void testSetterAndExplicitReturnTypeAndAnnotationsAsSetter() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/syntheticProperties/setterAndExplicitReturnTypeAndAnnotationsAsSetter.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/properties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Properties {
        @Test
        public void testAllFilesPresentInProperties() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/properties"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="constructorParameter.kt")
        public void testConstructorParameter() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constructorParameter.kt");
        }

        @Test
        @TestMetadata(value="constructorParameterWithImplicitParameterAnnotation.kt")
        public void testConstructorParameterWithImplicitParameterAnnotation() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/constructorParameterWithImplicitParameterAnnotation.kt");
        }

        @Test
        @TestMetadata(value="delegateWithAnnotationOnAccessor.kt")
        public void testDelegateWithAnnotationOnAccessor() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/delegateWithAnnotationOnAccessor.kt");
        }

        @Test
        @TestMetadata(value="delegateWithAnnotationOnAccessorWithExplicitType.kt")
        public void testDelegateWithAnnotationOnAccessorWithExplicitType() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/delegateWithAnnotationOnAccessorWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="generatedPropertyFromParameter.kt")
        public void testGeneratedPropertyFromParameter() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/generatedPropertyFromParameter.kt");
        }

        @Test
        @TestMetadata(value="generatedPropertyFromParameterWithImplicitAnnotation.kt")
        public void testGeneratedPropertyFromParameterWithImplicitAnnotation() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/generatedPropertyFromParameterWithImplicitAnnotation.kt");
        }

        @Test
        @TestMetadata(value="getterWithDelegation.kt")
        public void testGetterWithDelegation() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/getterWithDelegation.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverride.kt")
        public void testHierarchyWithOverride() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverride.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass.kt")
        public void testHierarchyWithOverrideAndNestedClass() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass2.kt")
        public void testHierarchyWithOverrideAndNestedClass2() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass2.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass3.kt")
        public void testHierarchyWithOverrideAndNestedClass3() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass3.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass4.kt")
        public void testHierarchyWithOverrideAndNestedClass4() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/hierarchyWithOverrideAndNestedClass4.kt");
        }

        @Test
        @TestMetadata(value="propertyGetterWithExplicitType.kt")
        public void testPropertyGetterWithExplicitType() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithExplicitType.kt");
        }

        @Test
        @TestMetadata(value="propertyGetterWithExplicitTypeAndBody.kt")
        public void testPropertyGetterWithExplicitTypeAndBody() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithExplicitTypeAndBody.kt");
        }

        @Test
        @TestMetadata(value="propertyGetterWithImplicitType.kt")
        public void testPropertyGetterWithImplicitType() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyGetterWithImplicitType.kt");
        }

        @Test
        @TestMetadata(value="propertySetter.kt")
        public void testPropertySetter() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertySetter.kt");
        }

        @Test
        @TestMetadata(value="propertyWithTypeParameters.kt")
        public void testPropertyWithTypeParameters() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/propertyWithTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride.kt")
        public void testSimpleLoopInOverride() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/simpleLoopInOverride.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride2.kt")
        public void testSimpleLoopInOverride2() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/simpleLoopInOverride2.kt");
        }

        @Test
        @TestMetadata(value="unresolvedAnnotationOnPropertyType.kt")
        public void testUnresolvedAnnotationOnPropertyType() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/properties/unresolvedAnnotationOnPropertyType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/noRuntime")
    @TestDataPath(value="$PROJECT_ROOT")
    public class NoRuntime {
        @Test
        public void testAllFilesPresentInNoRuntime() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/noRuntime"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="arrayOfCall.kt")
        public void testArrayOfCall() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/noRuntime/arrayOfCall.kt");
        }

        @Test
        @TestMetadata(value="integerLiteralCall.kt")
        public void testIntegerLiteralCall() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/noRuntime/integerLiteralCall.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/functions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Functions {
        @Test
        public void testAllFilesPresentInFunctions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/functions"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="contract.kt")
        public void testContract() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/contract.kt");
        }

        @Test
        @TestMetadata(value="functionCallWithGenericResult.kt")
        public void testFunctionCallWithGenericResult() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionCallWithGenericResult.kt");
        }

        @Test
        @TestMetadata(value="functionParameter.kt")
        public void testFunctionParameter() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionParameter.kt");
        }

        @Test
        @TestMetadata(value="functionWithGenericExpectedTypeInside.kt")
        public void testFunctionWithGenericExpectedTypeInside() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionWithGenericExpectedTypeInside.kt");
        }

        @Test
        @TestMetadata(value="functionWithTypeParameters.kt")
        public void testFunctionWithTypeParameters() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/functionWithTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverride.kt")
        public void testHierarchyWithOverride() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverride.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass.kt")
        public void testHierarchyWithOverrideAndNestedClass() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClass.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass2.kt")
        public void testHierarchyWithOverrideAndNestedClass2() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClass2.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass3.kt")
        public void testHierarchyWithOverrideAndNestedClass3() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/hierarchyWithOverrideAndNestedClass3.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride.kt")
        public void testSimpleLoopInOverride() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/simpleLoopInOverride.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride2.kt")
        public void testSimpleLoopInOverride2() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/simpleLoopInOverride2.kt");
        }

        @Test
        @TestMetadata(value="typeArgumentInAnnotation.kt")
        public void testTypeArgumentInAnnotation() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/typeArgumentInAnnotation.kt");
        }

        @Test
        @TestMetadata(value="unresolvedAnnotationOnFunctionType.kt")
        public void testUnresolvedAnnotationOnFunctionType() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/functions/unresolvedAnnotationOnFunctionType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/errors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Errors {
        @Test
        public void testAllFilesPresentInErrors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/errors"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="annotationWithNamedFunctionArgument.kt")
        public void testAnnotationWithNamedFunctionArgument() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/annotationWithNamedFunctionArgument.kt");
        }

        @Test
        @TestMetadata(value="anonymousObjectInInvalidPosition.kt")
        public void testAnonymousObjectInInvalidPosition() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/errors/anonymousObjectInInvalidPosition.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/lazyResolve/classes")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Classes {
        @Test
        @TestMetadata(value="actual.kt")
        public void testActual() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/actual.kt");
        }

        @Test
        public void testAllFilesPresentInClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/lazyResolve/classes"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="annotationWithArgumentInsideSuperTypeCall.kt")
        public void testAnnotationWithArgumentInsideSuperTypeCall() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithArgumentInsideSuperTypeCall.kt");
        }

        @Test
        @TestMetadata(value="annotationWithArgumentInsideSuperTypeCallUnresolved.kt")
        public void testAnnotationWithArgumentInsideSuperTypeCallUnresolved() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithArgumentInsideSuperTypeCallUnresolved.kt");
        }

        @Test
        @TestMetadata(value="annotationWithConstantFromNestedClass.kt")
        public void testAnnotationWithConstantFromNestedClass() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithConstantFromNestedClass.kt");
        }

        @Test
        @TestMetadata(value="annotationWithTarget.kt")
        public void testAnnotationWithTarget() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/annotationWithTarget.kt");
        }

        @Test
        @TestMetadata(value="classDelegatedInCommonCode.kt")
        public void testClassDelegatedInCommonCode() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/classDelegatedInCommonCode.kt");
        }

        @Test
        @TestMetadata(value="classWithTypeParameters.kt")
        public void testClassWithTypeParameters() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/classWithTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="compilerRequiredAnnotationConflict.kt")
        public void testCompilerRequiredAnnotationConflict() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/compilerRequiredAnnotationConflict.kt");
        }

        @Test
        @TestMetadata(value="compilerRequiredAnnotationConflict2.kt")
        public void testCompilerRequiredAnnotationConflict2() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/compilerRequiredAnnotationConflict2.kt");
        }

        @Test
        @TestMetadata(value="functionInValueClass.kt")
        public void testFunctionInValueClass() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/functionInValueClass.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverride.kt")
        public void testHierarchyWithOverride() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverride.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass.kt")
        public void testHierarchyWithOverrideAndNestedClass() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass2.kt")
        public void testHierarchyWithOverrideAndNestedClass2() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass2.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass3.kt")
        public void testHierarchyWithOverrideAndNestedClass3() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass3.kt");
        }

        @Test
        @TestMetadata(value="hierarchyWithOverrideAndNestedClass4.kt")
        public void testHierarchyWithOverrideAndNestedClass4() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/hierarchyWithOverrideAndNestedClass4.kt");
        }

        @Test
        @TestMetadata(value="nestedClass.kt")
        public void testNestedClass() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nestedClass.kt");
        }

        @Test
        @TestMetadata(value="nestedClassAsAnnotationArgument.kt")
        public void testNestedClassAsAnnotationArgument() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nestedClassAsAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="nestedClassAsAnnotationArgument2.kt")
        public void testNestedClassAsAnnotationArgument2() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nestedClassAsAnnotationArgument2.kt");
        }

        @Test
        @TestMetadata(value="nestedClassWithPropertiesOverrides.kt")
        public void testNestedClassWithPropertiesOverrides() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/nestedClassWithPropertiesOverrides.kt");
        }

        @Test
        @TestMetadata(value="qualifiedNestedClassAsAnnotationArgument.kt")
        public void testQualifiedNestedClassAsAnnotationArgument() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/qualifiedNestedClassAsAnnotationArgument.kt");
        }

        @Test
        @TestMetadata(value="qualifiedNestedClassAsAnnotationArgument2.kt")
        public void testQualifiedNestedClassAsAnnotationArgument2() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/qualifiedNestedClassAsAnnotationArgument2.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride.kt")
        public void testSimpleLoopInOverride() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/simpleLoopInOverride.kt");
        }

        @Test
        @TestMetadata(value="simpleLoopInOverride2.kt")
        public void testSimpleLoopInOverride2() throws Exception {
            FirSourceLazyDeclarationResolveTestGenerated.this.runTest("analysis/low-level-api-fir/testData/lazyResolve/classes/simpleLoopInOverride2.kt");
        }
    }
}

