/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.typeInfoProvider;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtSymbolDeclarationRendererMixIn;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.typeInfoProvider.AbstractIsDenotableTest;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiSingleFileTest;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.builders.TestConfigurationBuilder;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/cases/components/typeInfoProvider/AbstractIsDenotableTest;", "Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiSingleFileTest;", "()V", "denotableName", "Lorg/jetbrains/kotlin/name/Name;", "getDenotableName", "()Lorg/jetbrains/kotlin/name/Name;", "undenotableName", "getUndenotableName", "configureTest", "", "builder", "Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "doTestByFileStructure", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "TestHelperProvider", "analysis-api-impl-base_test"})
public abstract class AbstractIsDenotableTest
extends AbstractAnalysisApiSingleFileTest {
    @NotNull
    private final Name denotableName;
    @NotNull
    private final Name undenotableName;

    public AbstractIsDenotableTest() {
        Name name = Name.identifier((String)"Denotable");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"Denotable\")");
        this.denotableName = name;
        Name name2 = Name.identifier((String)"Nondenotable");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"Nondenotable\")");
        this.undenotableName = name2;
    }

    @NotNull
    public final Name getDenotableName() {
        return this.denotableName;
    }

    @NotNull
    public final Name getUndenotableName() {
        return this.undenotableName;
    }

    @Override
    protected void doTestByFileStructure(@NotNull KtFile ktFile, @NotNull TestModule module, @NotNull TestServices testServices) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        StringBuilder $this$doTestByFileStructure_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ktFile.accept((PsiElementVisitor)new KtTreeVisitorVoid($this$doTestByFileStructure_u24lambda_u240, this){
            final /* synthetic */ StringBuilder $this_buildString;
            final /* synthetic */ AbstractIsDenotableTest this$0;
            {
                this.$this_buildString = $receiver;
                this.this$0 = $receiver2;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof LeafPsiElement) {
                    this.$this_buildString.append(((LeafPsiElement)element).getText());
                }
                super.visitElement(element);
            }

            /*
             * WARNING - void declaration
             */
            public void visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2) {
                KtExpression base;
                block9: {
                    block8: {
                        boolean bl;
                        block7: {
                            void $this$none$iv;
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            base = expression2.getBaseExpression();
                            if (base == null) break block8;
                            List list = expression2.getAnnotationEntries();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expression.annotationEntries");
                            Iterable iterable = list;
                            AbstractIsDenotableTest abstractIsDenotableTest = this.this$0;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                                    boolean bl2 = false;
                                    if (!(Intrinsics.areEqual((Object)it.getShortName(), (Object)abstractIsDenotableTest.getDenotableName()) || Intrinsics.areEqual((Object)it.getShortName(), (Object)abstractIsDenotableTest.getUndenotableName()))) continue;
                                    bl = false;
                                    break block7;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) break block9;
                    }
                    super.visitAnnotatedExpression(expression2);
                    return;
                }
                AbstractIsDenotableTest.access$analyseForTest(this.this$0, (KtElement)expression2, (Function2)new Function2<KtAnalysisSession, KtElement, StringBuilder>(expression2, base, this.$this_buildString){
                    final /* synthetic */ KtAnnotatedExpression $expression;
                    final /* synthetic */ KtExpression $base;
                    final /* synthetic */ StringBuilder $this_buildString;
                    {
                        this.$expression = $expression;
                        this.$base = $base;
                        this.$this_buildString = $receiver;
                        super(2);
                    }

                    public final StringBuilder invoke(@NotNull KtAnalysisSession $this$analyseForTest, @NotNull KtElement it) {
                        boolean actualHasDenotableType;
                        KtType ktType;
                        Intrinsics.checkNotNullParameter((Object)$this$analyseForTest, (String)"$this$analyseForTest");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PsiElement $this$parentOfType_u24default$iv = (PsiElement)this.$expression;
                        boolean withSelf$iv = false;
                        boolean $i$f$parentOfType = false;
                        KtQualifiedExpression parent = (KtQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtQualifiedExpression.class, (boolean)true);
                        KtType ktType2 = ktType = parent != null && Intrinsics.areEqual((Object)KtPsiUtil.deparenthesize((KtExpression)parent.getReceiverExpression()), (Object)KtPsiUtil.deparenthesize((KtExpression)this.$base)) ? $this$analyseForTest.getKtType(parent.getReceiverExpression()) : $this$analyseForTest.getKtType((KtExpression)this.$expression);
                        if (ktType2 == null) {
                            throw new IllegalStateException((this.$base.getText() + " does not have a type.").toString());
                        }
                        boolean bl = actualHasDenotableType = $this$analyseForTest.isDenotable(ktType2);
                        if (bl) {
                            this.$this_buildString.append("@Denotable");
                        } else if (!bl) {
                            this.$this_buildString.append("@Nondenotable");
                        }
                        this.$this_buildString.append("(\"" + KtSymbolDeclarationRendererMixIn.render$default((KtSymbolDeclarationRendererMixIn)((KtSymbolDeclarationRendererMixIn)$this$analyseForTest), (KtType)ktType, null, (Variance)Variance.INVARIANT, (int)1, null) + "\") ");
                        return this.$this_buildString.append(this.$base.getText());
                    }
                });
            }
        });
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String actualText2 = string;
        Assertions.assertEqualsToFile$default((Assertions)((Assertions)AssertionsKt.getAssertions((TestServices)testServices)), (Path)this.getTestDataPath(), (String)actualText2, null, (int)4, null);
    }

    @Override
    protected void configureTest(@NotNull TestConfigurationBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.configureTest(builder);
        Function1[] function1Array = new Function1[]{configureTest.1.INSTANCE};
        builder.useAdditionalSourceProviders(function1Array);
        builder.defaultDirectives((Function1)configureTest.2.INSTANCE);
    }

    public static final /* synthetic */ Object access$analyseForTest(AbstractIsDenotableTest $this, KtElement contextElement, Function2 action) {
        return $this.analyseForTest(contextElement, action);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/cases/components/typeInfoProvider/AbstractIsDenotableTest$TestHelperProvider;", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "produceAdditionalFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "globalDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "analysis-api-impl-base_test"})
    private static final class TestHelperProvider
    extends AdditionalSourceProvider {
        public TestHelperProvider(@NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
            super(testServices);
        }

        @NotNull
        public List<TestFile> produceAdditionalFiles(@NotNull RegisteredDirectives globalDirectives, @NotNull TestModule module) {
            Intrinsics.checkNotNullParameter((Object)globalDirectives, (String)"globalDirectives");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return CollectionsKt.listOf((Object)AdditionalSourceProvider.toTestFile$default((AdditionalSourceProvider)this, (File)new File("analysis/analysis-api/testData/helpers/isDenotable/helpers.kt"), null, (int)1, null));
        }
    }
}

