/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.files;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.AbstractDecompiledClassTest;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.KotlinContractRenderer;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.TestData;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFlexibleTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeArgumentBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeParameterTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinUserTypeStubImpl;
import org.jetbrains.kotlin.test.KotlinTestUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\n\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractAdditionalStubInfoTest;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractDecompiledClassTest;", "()V", "appendFlexibleTypeInfo", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "typeBean", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeBean;", "extractAdditionInfo", "stub", "Lcom/intellij/psi/stubs/StubElement;", "level", "", "runTest", "testDirectory", "", "decompiler-to-file-stubs_test"})
@SourceDebugExtension(value={"SMAP\nAbstractAdditionalStubInfoTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAdditionalStubInfoTest.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractAdditionalStubInfoTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1864#2,3:142\n*S KotlinDebug\n*F\n+ 1 AbstractAdditionalStubInfoTest.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractAdditionalStubInfoTest\n*L\n60#1:142,3\n*E\n"})
public abstract class AbstractAdditionalStubInfoTest
extends AbstractDecompiledClassTest {
    public final void runTest(@NotNull String testDirectory) {
        Intrinsics.checkNotNullParameter((Object)testDirectory, (String)"testDirectory");
        Path testDirectoryPath = Paths.get(testDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)testDirectoryPath, (String)"testDirectoryPath");
        TestData testData = TestData.Companion.createFromDirectory(testDirectoryPath);
        KotlinClsStubBuilder kotlinClsStubBuilder = new KotlinClsStubBuilder();
        FileContent fileContent = FileContentImpl.createByFile((VirtualFile)this.getClassFileToDecompile$decompiler_to_file_stubs_test(testData, false));
        Intrinsics.checkNotNullExpressionValue((Object)fileContent, (String)"createByFile(getClassFil\u2026compile(testData, false))");
        PsiFileStub psiFileStub = kotlinClsStubBuilder.buildFileStub(fileContent);
        Intrinsics.checkNotNull((Object)psiFileStub);
        PsiFileStub stub = psiFileStub;
        StringBuilder builder = new StringBuilder();
        this.extractAdditionInfo((StubElement)stub, builder, 0);
        KotlinTestUtils.assertEqualsToFile((Path)testData.getExpectedFile(), (String)builder.toString());
    }

    private final void extractAdditionInfo(StubElement<?> stub, StringBuilder builder, int level) {
        List contract;
        builder.append(stub.toString());
        StubElement<?> stubElement = stub;
        if (stubElement instanceof KotlinUserTypeStubImpl) {
            KotlinTypeBean upperBound = ((KotlinUserTypeStubImpl)stub).getUpperBound();
            if (upperBound != null) {
                builder.append("    ft: ");
                this.appendFlexibleTypeInfo(builder, upperBound);
            }
        } else if (stubElement instanceof KotlinFunctionStubImpl && (contract = ((KotlinFunctionStubImpl)stub).getContract()) != null) {
            for (KtContractDescriptionElement element : contract) {
                builder.append('\n' + StringsKt.repeat((CharSequence)"  ", (int)level)).append("effect:");
                element.accept((KtContractDescriptionVisitor)new KotlinContractRenderer(builder), null);
            }
        }
        for (StubElement child : stub.getChildrenStubs()) {
            builder.append("\n").append(StringsKt.repeat((CharSequence)"  ", (int)level));
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            this.extractAdditionInfo(child, builder, level + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendFlexibleTypeInfo(StringBuilder builder, KotlinTypeBean typeBean) {
        KotlinTypeBean kotlinTypeBean = typeBean;
        if (kotlinTypeBean instanceof KotlinClassTypeBean) {
            builder.append(((KotlinClassTypeBean)typeBean).getClassId().asFqNameString());
            List arguments = ((KotlinClassTypeBean)typeBean).getArguments();
            if (!((Collection)arguments).isEmpty()) {
                builder.append("<");
                Iterable $this$forEachIndexed$iv = arguments;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void arg;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    KotlinTypeArgumentBean kotlinTypeArgumentBean = (KotlinTypeArgumentBean)item$iv;
                    int index = n;
                    boolean bl = false;
                    if (index > 0) {
                        builder.append(", ");
                    }
                    if (arg.getProjectionKind() != KtProjectionKind.NONE) {
                        builder.append(arg.getProjectionKind().name());
                    }
                    if (arg.getProjectionKind() == KtProjectionKind.STAR) continue;
                    KotlinTypeBean kotlinTypeBean2 = arg.getType();
                    Intrinsics.checkNotNull((Object)kotlinTypeBean2);
                    this.appendFlexibleTypeInfo(builder, kotlinTypeBean2);
                }
                builder.append(">");
            }
            if (typeBean.getNullable()) {
                builder.append("?");
            }
        } else if (kotlinTypeBean instanceof KotlinTypeParameterTypeBean) {
            builder.append(((KotlinTypeParameterTypeBean)typeBean).getTypeParameterName());
            if (typeBean.getNullable()) {
                builder.append("?");
            }
            if (((KotlinTypeParameterTypeBean)typeBean).getDefinitelyNotNull()) {
                builder.append(" & Any");
            }
        } else if (kotlinTypeBean instanceof KotlinFlexibleTypeBean) {
            this.appendFlexibleTypeInfo(builder, ((KotlinFlexibleTypeBean)typeBean).getLowerBound());
            builder.append(" .. ");
            this.appendFlexibleTypeInfo(builder, ((KotlinFlexibleTypeBean)typeBean).getUpperBound());
        }
    }
}

