/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractFirLazyBodiesCalculatorTest;
import org.jetbrains.kotlin.analysis.low.level.api.fir.FirTestUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirResolveStateServiceKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.FirLazyBodiesCalculator;
import org.jetbrains.kotlin.analysis.low.level.api.fir.test.base.AbstractLowLevelApiSingleFileTest;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProviderKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.builder.BodyBuildingMode;
import org.jetbrains.kotlin.fir.builder.RawFirBuilder;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.impl.FirLazyBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirLazyExpression;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000+\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AbstractFirLazyBodiesCalculatorTest;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/test/base/AbstractLowLevelApiSingleFileTest;", "()V", "lazyChecker", "org/jetbrains/kotlin/analysis/low/level/api/fir/AbstractFirLazyBodiesCalculatorTest$lazyChecker$1", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AbstractFirLazyBodiesCalculatorTest$lazyChecker$1;", "doTestByFileStructure", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "low-level-api-fir_test"})
@SourceDebugExtension(value={"SMAP\nAbstractFirLazyBodiesCalculatorTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFirLazyBodiesCalculatorTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/AbstractFirLazyBodiesCalculatorTest\n+ 2 firTestUtils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/FirTestUtilsKt\n*L\n1#1,58:1\n37#2,8:59\n*S KotlinDebug\n*F\n+ 1 AbstractFirLazyBodiesCalculatorTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/AbstractFirLazyBodiesCalculatorTest\n*L\n33#1:59,8\n*E\n"})
public abstract class AbstractFirLazyBodiesCalculatorTest
extends AbstractLowLevelApiSingleFileTest {
    @NotNull
    private final lazyChecker.1 lazyChecker = new FirVisitorVoid(){

        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            TestCase.assertFalse((String)(Reflection.getOrCreateKotlinClass(FirLazyBlock.class).getQualifiedName() + " should not present in the tree"), (boolean)(element instanceof FirLazyBlock));
            TestCase.assertFalse((String)(Reflection.getOrCreateKotlinClass(FirLazyExpression.class).getQualifiedName() + " should not present in the tree"), (boolean)(element instanceof FirLazyExpression));
            element.acceptChildren((FirVisitorVoid)this);
        }
    };

    @Override
    public void doTestByFileStructure(@NotNull KtFile ktFile, @NotNull TestModuleStructure moduleStructure, @NotNull TestServices testServices) {
        LLFirResolveSession firResolveSession$iv;
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Function1 configureSession$iv = FirTestUtilsKt.resolveWithClearCaches.1.INSTANCE;
        boolean $i$f$resolveWithClearCaches = false;
        Project project = ((KtElement)ktFile).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
        Project project$iv = project;
        LLFirResolveSession firResolveSession = firResolveSession$iv = LLFirResolveStateServiceKt.createFirResolveSessionForNoCaching((KtModule)ProjectStructureProviderKt.getKtModule((PsiElement)((PsiElement)((KtElement)ktFile)), (Project)project$iv), (Project)project$iv, (Function1)configureSession$iv);
        boolean bl = false;
        FirSession session = firResolveSession.getUseSiteFirSession();
        FirKotlinScopeProvider provider = FirKotlinScopeProviderKt.getKotlinScopeProvider((FirSession)session);
        FirFile laziedFirFile = new RawFirBuilder(session, (FirScopeProvider)provider, BodyBuildingMode.LAZY_BODIES).buildFirFile(ktFile);
        FirLazyBodiesCalculator.INSTANCE.calculateLazyBodies(laziedFirFile);
        laziedFirFile.accept((FirVisitorVoid)this.lazyChecker);
        FirFile fullFirFile = new RawFirBuilder(session, (FirScopeProvider)provider, BodyBuildingMode.NORMAL).buildFirFile(ktFile);
        String laziedFirFileDump = new FirRenderer(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Short.MAX_VALUE, null).renderElementAsString((FirElement)laziedFirFile);
        String fullFirFileDump = new FirRenderer(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Short.MAX_VALUE, null).renderElementAsString((FirElement)fullFirFile);
        TestCase.assertEquals((String)laziedFirFileDump, (String)fullFirFileDump);
    }
}

