/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleProjectStructure;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtStaticModuleProvider;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.KtBuiltinsModule;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManager;
import org.jetbrains.kotlin.analysis.test.framework.services.TestDisposableProvderKt;
import org.jetbrains.kotlin.analysis.test.framework.services.TestDisposableProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.test.TestSetupUtilsKt;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.ApplicationDisposableProviderKt;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/AnalysisApiEnvironmentManagerImpl;", "Lorg/jetbrains/kotlin/analysis/test/framework/services/AnalysisApiEnvironmentManager;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "testRootDisposable", "Lcom/intellij/openapi/Disposable;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lcom/intellij/openapi/Disposable;)V", "_projectEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "get_projectEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "_projectEnvironment$delegate", "Lkotlin/Lazy;", "getTestRootDisposable", "()Lcom/intellij/openapi/Disposable;", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "getApplicationEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreApplicationEnvironment;", "getProjectEnvironment", "initializeEnvironment", "", "initializeProjectStructure", "analysis-test-framework_test"})
public final class AnalysisApiEnvironmentManagerImpl
extends AnalysisApiEnvironmentManager {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Disposable testRootDisposable;
    @NotNull
    private final Lazy _projectEnvironment$delegate;

    public AnalysisApiEnvironmentManagerImpl(@NotNull TestServices testServices, @NotNull Disposable testRootDisposable) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)testRootDisposable, (String)"testRootDisposable");
        this.testServices = testServices;
        this.testRootDisposable = testRootDisposable;
        this._projectEnvironment$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KotlinCoreProjectEnvironment>(this){
            final /* synthetic */ AnalysisApiEnvironmentManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KotlinCoreProjectEnvironment invoke() {
                return StandaloneProjectFactory.createProjectEnvironment$default((StandaloneProjectFactory)StandaloneProjectFactory.INSTANCE, (Disposable)this.this$0.getTestRootDisposable(), (Disposable)ApplicationDisposableProviderKt.getApplicationDisposableProvider((TestServices)this.this$0.getTestServices()).getApplicationRootDisposable(), null, (int)4, null);
            }
        }));
    }

    @Override
    @NotNull
    public TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public Disposable getTestRootDisposable() {
        return this.testRootDisposable;
    }

    private final KotlinCoreProjectEnvironment get_projectEnvironment() {
        Lazy lazy = this._projectEnvironment$delegate;
        return (KotlinCoreProjectEnvironment)lazy.getValue();
    }

    @Override
    public void initializeEnvironment() {
        TestDisposableProvider testDisposableProvider = TestDisposableProvderKt.getDisposableProvider(this.getTestServices());
        Disposable disposable = this.get_projectEnvironment().getParentDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"_projectEnvironment.parentDisposable");
        Disposable disposable2 = this.get_projectEnvironment().getEnvironment().getParentDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"_projectEnvironment.environment.parentDisposable");
        testDisposableProvider.registerDisposables(disposable, disposable2);
    }

    @Override
    public void initializeProjectStructure() {
        KtModuleProjectStructure ktModuleProjectStructure = AnalysisApiKtModuleProviderImplKt.getKtModuleProvider(this.getTestServices()).getModuleStructure();
        TestModule useSiteModule = (TestModule)CollectionsKt.first((List)TestModuleStructureKt.getModuleStructure((TestServices)this.getTestServices()).getModules());
        CompilerConfiguration useSiteCompilerConfiguration = CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)this.getTestServices()).getCompilerConfiguration(useSiteModule);
        KtBuiltinsModule builtinsModule = new KtBuiltinsModule(useSiteModule.getTargetPlatform(), TestSetupUtilsKt.getAnalyzerServices((TargetPlatform)useSiteModule.getTargetPlatform()), this.getProject());
        File file = (File)useSiteCompilerConfiguration.get(JVMConfigurationKeys.JDK_HOME);
        StandaloneProjectFactory.INSTANCE.registerServicesForProjectEnvironment(this.get_projectEnvironment(), (ProjectStructureProvider)new KtStaticModuleProvider(builtinsModule, ktModuleProjectStructure), ktModuleProjectStructure.allKtModules(), ktModuleProjectStructure.allSourceFiles(), CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)useSiteCompilerConfiguration), file != null ? file.toPath() : null);
        CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)this.getTestServices()).registerCompilerExtensions(this.getProject(), useSiteModule, useSiteCompilerConfiguration);
    }

    @Override
    @NotNull
    public KotlinCoreProjectEnvironment getProjectEnvironment() {
        return this.get_projectEnvironment();
    }

    @Override
    @NotNull
    public KotlinCoreApplicationEnvironment getApplicationEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.get_projectEnvironment().getEnvironment();
        Intrinsics.checkNotNull((Object)coreApplicationEnvironment, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment");
        return (KotlinCoreApplicationEnvironment)coreApplicationEnvironment;
    }
}

