/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.base;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import junit.framework.ComparisonFailure;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.test.framework.AnalysisApiTestDirectives;
import org.jetbrains.kotlin.analysis.test.framework.TestWithDisposable;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiBasedTest;
import org.jetbrains.kotlin.analysis.test.framework.base.RegisterBaseTestServicesKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkerProvider;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompilerExecutor;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.utils.SkipTestException;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TestConfiguration;
import org.jetbrains.kotlin.test.builders.TestConfigurationBuilder;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.runners.AbstractKotlinCompilerTest;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.PreAnalysisHandler;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManager;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H\u00170\b\u00a2\u0006\u0002\b\u000bH\u0004\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\tH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\u0018\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H$J\u001a\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010(H\u0004J\u0010\u0010*\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020+H\u0007J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020-H\u0002J\u0010\u00100\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020(H\u0004J*\u00103\u001a\u00020\n*\u0002042\u0006\u00105\u001a\u00020(2\b\b\u0002\u0010'\u001a\u00020(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010(H\u0004R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R%\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0002R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0084.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest;", "Lorg/jetbrains/kotlin/analysis/test/framework/TestWithDisposable;", "()V", "configurator", "Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;", "getConfigurator", "()Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;", "configure", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "", "Lkotlin/ExtensionFunctionType;", "getConfigure$annotations", "<set-?>", "Ljava/nio/file/Path;", "testDataPath", "getTestDataPath", "()Ljava/nio/file/Path;", "testInfo", "Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "analyseForTest", "R", "contextElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "action", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "configureTest", "builder", "createModuleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "testConfiguration", "Lorg/jetbrains/kotlin/test/TestConfiguration;", "createTestConfiguration", "doTestByModuleStructure", "moduleStructure", "getTestDataFileSiblingPath", "extension", "", "testPrefix", "initTestInfo", "Lorg/junit/jupiter/api/TestInfo;", "isDependentModeDisabledForTheTest", "", "isFe10DisabledForTheTest", "isFirDisabledForTheTest", "prepareToTheAnalysis", "runTest", "path", "assertEqualsToTestDataFileSibling", "Lorg/jetbrains/kotlin/test/services/AssertionsService;", "actual", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nAbstractAnalysisApiBasedTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAnalysisApiBasedTest.kt\norg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest\n+ 2 TestConfigurationBuilder.kt\norg/jetbrains/kotlin/test/builders/TestConfigurationBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 5 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n*L\n1#1,202:1\n301#2:203\n1855#3,2:204\n1855#3,2:206\n1855#3,2:208\n61#4,8:210\n32#4,7:234\n43#5:218\n42#5,7:219\n77#5,8:226\n57#5:241\n56#5,3:242\n77#5,8:245\n*S KotlinDebug\n*F\n+ 1 AbstractAnalysisApiBasedTest.kt\norg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest\n*L\n149#1:203\n162#1:204,2\n163#1:206,2\n165#1:208,2\n184#1:210,8\n190#1:234,7\n184#1:218\n184#1:219,7\n184#1:226,8\n190#1:241\n190#1:242,3\n190#1:245,8\n*E\n"})
public abstract class AbstractAnalysisApiBasedTest
extends TestWithDisposable {
    private KotlinTestInfo testInfo;
    private Path testDataPath;
    private TestServices testServices;
    @NotNull
    private final Function1<TestConfigurationBuilder, Unit> configure = (Function1)new Function1<TestConfigurationBuilder, Unit>(this){
        final /* synthetic */ AbstractAnalysisApiBasedTest this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        public final void invoke(@NotNull TestConfigurationBuilder $this$null) {
            DirectivesContainer[] this_$iv;
            Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
            $this$null.globalDefaults((Function1)configure.1.INSTANCE);
            $this$null.setAssertions((AssertionsService)JUnit5Assertions.INSTANCE);
            DirectivesContainer[] directivesContainerArray = $this$null;
            Function1 serviceConstructor$iv = configure.2.INSTANCE;
            boolean $i$f$useAdditionalService = false;
            ServiceRegistrationData[] serviceRegistrationDataArray = new ServiceRegistrationData[1];
            boolean $i$f$service = false;
            serviceRegistrationDataArray[0] = new ServiceRegistrationData(Reflection.getOrCreateKotlinClass(TemporaryDirectoryManager.class), serviceConstructor$iv);
            this_$iv.useAdditionalServices(serviceRegistrationDataArray);
            Collection $this$toTypedArray$iv = AbstractKotlinCompilerTest.Companion.getDefaultDirectiveContainers();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this_$iv = thisCollection$iv.toArray(new SimpleDirectivesContainer[0]);
            $this$null.useDirectives((DirectivesContainer[])Arrays.copyOf(this_$iv, this_$iv.length));
            this_$iv = new DirectivesContainer[]{JvmEnvironmentConfigurationDirectives.INSTANCE};
            $this$null.useDirectives(this_$iv);
            this_$iv = new DirectivesContainer[]{CompilerExecutor.Directives.INSTANCE};
            $this$null.useDirectives(this_$iv);
            this_$iv = new Function1[]{configure.3.INSTANCE};
            TestConfigurationBuilder.useSourcePreprocessor$default((TestConfigurationBuilder)$this$null, (Function1[])this_$iv, (boolean)false, (int)2, null);
            this_$iv = $this$null;
            serviceConstructor$iv = configure.4.INSTANCE;
            $i$f$useAdditionalService = false;
            serviceRegistrationDataArray = new ServiceRegistrationData[1];
            $i$f$service = false;
            serviceRegistrationDataArray[0] = new ServiceRegistrationData(Reflection.getOrCreateKotlinClass(ExpressionMarkerProvider.class), serviceConstructor$iv);
            this_$iv.useAdditionalServices(serviceRegistrationDataArray);
            RegisterBaseTestServicesKt.registerAnalysisApiBaseTestServices((TestConfigurationBuilder)$this$null, AbstractAnalysisApiBasedTest.access$getDisposable(this.this$0), this.this$0.getConfigurator());
            this.this$0.configureTest((TestConfigurationBuilder)$this$null);
            $this$null.setStartingArtifactFactory((Function1)configure.5.INSTANCE);
            KotlinTestInfo kotlinTestInfo = AbstractAnalysisApiBasedTest.access$getTestInfo$p(this.this$0);
            if (kotlinTestInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testInfo");
                kotlinTestInfo = null;
            }
            $this$null.setTestInfo(kotlinTestInfo);
        }
    };

    @NotNull
    public abstract AnalysisApiTestConfigurator getConfigurator();

    @NotNull
    protected final Path getTestDataPath() {
        Path path = this.testDataPath;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testDataPath");
        return null;
    }

    protected void configureTest(@NotNull TestConfigurationBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.getConfigurator().configureTest(builder, this.getDisposable());
    }

    protected abstract void doTestByModuleStructure(@NotNull TestModuleStructure var1, @NotNull TestServices var2);

    protected final void assertEqualsToTestDataFileSibling(@NotNull AssertionsService $this$assertEqualsToTestDataFileSibling, @NotNull String actual2, @NotNull String extension, @Nullable String testPrefix) {
        Path expectedFileWithoutPrefix;
        Intrinsics.checkNotNullParameter((Object)$this$assertEqualsToTestDataFileSibling, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actual2, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Path expectedFile = this.getTestDataFileSiblingPath(extension, testPrefix);
        Assertions.assertEqualsToFile$default((Assertions)((Assertions)$this$assertEqualsToTestDataFileSibling), (Path)expectedFile, (String)actual2, null, (int)4, null);
        if (testPrefix != null && !Intrinsics.areEqual((Object)expectedFile, (Object)(expectedFileWithoutPrefix = this.getTestDataFileSiblingPath(extension, null)))) {
            try {
                Assertions.assertEqualsToFile$default((Assertions)((Assertions)$this$assertEqualsToTestDataFileSibling), (Path)expectedFileWithoutPrefix, (String)actual2, null, (int)4, null);
            }
            catch (ComparisonFailure ignored) {
                return;
            }
            throw new AssertionError((Object)("" + '\"' + expectedFile + "\" has the same content as \"" + expectedFileWithoutPrefix + "\". Delete the prefixed file."));
        }
    }

    public static /* synthetic */ void assertEqualsToTestDataFileSibling$default(AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest, AssertionsService assertionsService, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertEqualsToTestDataFileSibling");
        }
        if ((n & 2) != 0) {
            string2 = ".txt";
        }
        if ((n & 4) != 0) {
            string3 = abstractAnalysisApiBasedTest.getConfigurator().getTestPrefix();
        }
        abstractAnalysisApiBasedTest.assertEqualsToTestDataFileSibling(assertionsService, string, string2, string3);
    }

    @NotNull
    protected final Path getTestDataFileSiblingPath(@NotNull String extension, @Nullable String testPrefix) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String extensionWithDot = '.' + StringsKt.removePrefix((String)extension, (CharSequence)".");
        String baseName = PathsKt.getNameWithoutExtension((Path)this.getTestDataPath());
        if (testPrefix != null) {
            Path prefixedFile = this.getTestDataPath().resolveSibling(baseName + '.' + testPrefix + extensionWithDot);
            Intrinsics.checkNotNullExpressionValue((Object)prefixedFile, (String)"prefixedFile");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(prefixedFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return prefixedFile;
            }
        }
        Path path = this.getTestDataPath().resolveSibling(baseName + extensionWithDot);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"testDataPath.resolveSibl\u2026eName + extensionWithDot)");
        return path;
    }

    private static /* synthetic */ void getConfigure$annotations() {
    }

    protected final void runTest(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        AnalysisApiTestConfigurator analysisApiTestConfigurator = this.getConfigurator();
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        this.testDataPath = analysisApiTestConfigurator.preprocessTestDataPath(path2);
        TestConfiguration testConfiguration = this.createTestConfiguration();
        this.testServices = testConfiguration.getTestServices();
        TestModuleStructure moduleStructure = this.createModuleStructure(testConfiguration);
        try {
            this.prepareToTheAnalysis(testConfiguration);
        }
        catch (SkipTestException ignored) {
            return;
        }
        if (this.getConfigurator().getAnalyseInDependentSession() && this.isDependentModeDisabledForTheTest()) {
            return;
        }
        if (this.getConfigurator().getFrontendKind() == FrontendKind.Fe10 && this.isFe10DisabledForTheTest() || this.getConfigurator().getFrontendKind() == FrontendKind.Fir && this.isFirDisabledForTheTest()) {
            return;
        }
        TestServices testServices = this.testServices;
        if (testServices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testServices");
            testServices = null;
        }
        this.doTestByModuleStructure(moduleStructure, testServices);
    }

    /*
     * WARNING - void declaration
     */
    private final TestConfiguration createTestConfiguration() {
        void testDataPath$iv;
        String string = ((Object)this.getTestDataPath()).toString();
        Function1<TestConfigurationBuilder, Unit> init$iv = this.configure;
        boolean $i$f$testConfiguration = false;
        TestConfigurationBuilder testConfigurationBuilder = new TestConfigurationBuilder();
        init$iv.invoke((Object)testConfigurationBuilder);
        TestConfiguration testConfiguration = testConfigurationBuilder.build((String)testDataPath$iv);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)testConfiguration.getRootDisposable());
        return testConfiguration;
    }

    private final TestModuleStructure createModuleStructure(TestConfiguration testConfiguration) {
        TestModuleStructure moduleStructure = testConfiguration.getModuleStructureExtractor().splitTestDataByModules(((Object)this.getTestDataPath()).toString(), testConfiguration.getDirectives());
        TestServices testServices = this.testServices;
        if (testServices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testServices");
            testServices = null;
        }
        testServices.register(Reflection.getOrCreateKotlinClass(TestModuleStructure.class), (TestService)moduleStructure);
        return moduleStructure;
    }

    private final void prepareToTheAnalysis(TestConfiguration testConfiguration) {
        PreAnalysisHandler preprocessor;
        TestServices testServices = this.testServices;
        if (testServices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testServices");
            testServices = null;
        }
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure((TestServices)testServices);
        Iterable $this$forEach$iv = testConfiguration.getPreAnalysisHandlers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl = false;
            preprocessor.preprocessModuleStructure(moduleStructure);
        }
        $this$forEach$iv = testConfiguration.getPreAnalysisHandlers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl = false;
            preprocessor.prepareSealedClassInheritors(moduleStructure);
        }
        $this$forEach$iv = moduleStructure.getModules();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestModule module = (TestModule)element$iv;
            boolean bl = false;
            TestServices testServices2 = this.testServices;
            if (testServices2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testServices");
                testServices2 = null;
            }
            List<PsiFile> files = AnalysisApiKtModuleProviderImplKt.getKtModuleProvider(testServices2).getModuleFiles(module);
            AnalysisApiTestConfigurator analysisApiTestConfigurator = this.getConfigurator();
            TestServices testServices3 = this.testServices;
            if (testServices3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testServices");
                testServices3 = null;
            }
            analysisApiTestConfigurator.prepareFilesInModule(files, module, testServices3);
        }
    }

    private final boolean isDependentModeDisabledForTheTest() {
        TestServices testServices = this.testServices;
        if (testServices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testServices");
            testServices = null;
        }
        return TestModuleStructureKt.getModuleStructure((TestServices)testServices).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getDISABLE_DEPENDED_MODE());
    }

    private final boolean isFe10DisabledForTheTest() {
        TestServices testServices = this.testServices;
        if (testServices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testServices");
            testServices = null;
        }
        return TestModuleStructureKt.getModuleStructure((TestServices)testServices).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getIGNORE_FE10());
    }

    private final boolean isFirDisabledForTheTest() {
        TestServices testServices = this.testServices;
        if (testServices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testServices");
            testServices = null;
        }
        return TestModuleStructureKt.getModuleStructure((TestServices)testServices).getAllDirectives().contains((Directive)AnalysisApiTestDirectives.INSTANCE.getIGNORE_FIR());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final <R> R analyseForTest(@NotNull KtElement contextElement, @NotNull Function1<? super KtAnalysisSession, ? extends R> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (this.getConfigurator().getAnalyseInDependentSession()) {
            Object object2;
            void elementToReanalyze$iv;
            void this_$iv$iv2;
            KtFile ktFile = contextElement.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"contextElement.containingKtFile");
            KtFile originalContainingFile = ktFile;
            PsiElement psiElement = originalContainingFile.copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            KtFile fileCopy = (KtFile)psiElement;
            PsiElement psiElement2 = PsiTreeUtil.findSameElementInCopy((PsiElement)((PsiElement)contextElement), (PsiFile)((PsiFile)fileCopy));
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"findSameElementInCopy(contextElement, fileCopy)");
            KtElement ktElement = (KtElement)psiElement2;
            Object nonDefaultLifetimeTokenFactory$iv = null;
            boolean $i$f$analyzeInDependedAnalysisSession = false;
            Project project = originalContainingFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"originalFile.project");
            KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project);
            boolean $i$f$analyseInDependedAnalysisSession = false;
            KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv2.getProject()).getDefaultLifetimeTokenFactory();
            KtAnalysisSession originalAnalysisSession$iv$iv = this_$iv$iv2.getAnalysisSession((KtElement)originalContainingFile, factory$iv$iv);
            KtAnalysisSession dependedAnalysisSession$iv$iv = originalAnalysisSession$iv$iv.createContextDependentCopy(originalContainingFile, (KtElement)elementToReanalyze$iv);
            void this_$iv$iv$iv = this_$iv$iv2;
            boolean $i$f$analyse = false;
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
            factory$iv$iv.beforeEnteringAnalysisContext(dependedAnalysisSession$iv$iv.getToken());
            try {
                object2 = action.invoke((Object)dependedAnalysisSession$iv$iv);
            }
            finally {
                factory$iv$iv.afterLeavingAnalysisContext(dependedAnalysisSession$iv$iv.getToken());
                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
            }
            object = object2;
        } else {
            Object object3;
            void this_$iv$iv$iv;
            void this_$iv$iv;
            Object nonDefaultLifetimeTokenFactory$iv = null;
            boolean $i$f$analyze = false;
            Project project = contextElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"useSiteKtElement.project");
            KtAnalysisSessionProvider elementToReanalyze$iv = KtAnalysisSessionProvider.Companion.getInstance(project);
            boolean $i$f$analyse = false;
            KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
            void this_$iv$iv2 = this_$iv$iv;
            KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession(contextElement, factory$iv$iv);
            boolean $i$f$analyse2 = false;
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
            factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
            try {
                object3 = action.invoke((Object)analysisSession$iv$iv$iv);
            }
            finally {
                factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
            }
            object = object3;
        }
        return (R)object;
    }

    @BeforeEach
    public final void initTestInfo(@NotNull TestInfo testInfo) {
        Intrinsics.checkNotNullParameter((Object)testInfo, (String)"testInfo");
        Class clazz = (Class)testInfo.getTestClass().orElseGet(null);
        String string = clazz != null ? clazz.getName() : null;
        if (string == null) {
            string = "_undefined_";
        }
        Method method = (Method)testInfo.getTestMethod().orElseGet(null);
        String string2 = method != null ? method.getName() : null;
        if (string2 == null) {
            string2 = "_testUndefined_";
        }
        Set set = testInfo.getTags();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"testInfo.tags");
        this.testInfo = new KotlinTestInfo(string, string2, set);
    }

    public static final /* synthetic */ Disposable access$getDisposable(AbstractAnalysisApiBasedTest $this) {
        return $this.getDisposable();
    }

    public static final /* synthetic */ KotlinTestInfo access$getTestInfo$p(AbstractAnalysisApiBasedTest $this) {
        return $this.testInfo;
    }
}

